/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist.toolbar;

import chemaxon.marvin.util.codeassist.CodeAssistDataProvider;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.CompletableDisplayHelper;
import chemaxon.marvin.util.codeassist.CompletionItemCellRenderer;
import chemaxon.marvin.util.codeassist.DefaultCompletable;
import chemaxon.marvin.util.codeassist.UserDefinedCompletable;
import chemaxon.marvin.util.codeassist.toolbar.AbstractFilterListModel;
import chemaxon.marvin.util.codeassist.toolbar.CodeAssistFavoritesHelper;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FavoritesManagerPanel
extends JPanel {
    private static final long serialVersionUID = -6944466646372603931L;
    private static final String EMPTY_FAVORITES = "You have no favorites selected.\nYou can select functions from\nthe list on the left to your\nfavorites for recent usage.";
    private static final String EMPTY_AVAILABLES = "There is no function matches\nthe filters. Select another category,\nor choose All functions.";
    private static final String ALL_FUNCTIONS = "All functions";
    private static final String USER_DEFINED = "User-defined";
    private static final ListCellRenderer listCellRenderer = new CompletionItemCellRenderer();
    private JScrollPane availableScroll = null;
    private JScrollPane favoritesScroll = null;
    private JScrollPane infoScroll = null;
    private JEditorPane infoText = null;
    private JList availableList = null;
    private JList favoritesList = null;
    private JButton addButton = null;
    private JButton removeButton = null;
    private JComboBox categoryCombo = null;
    private JButton acceptButton = null;
    private JButton cancelButton = null;
    private final Action ACCEPT_ACTION;
    private final Action CANCEL_ACTION;
    private final CodeAssistFavoritesHelper helper;
    private boolean expertMode = false;
    private AbstractFilterListModel listModel = new AbstractFilterListModel(){
        private static final long serialVersionUID = -6791893180981140160L;

        @Override
        protected boolean filter(Object element) {
            if (FavoritesManagerPanel.this.getCategoryCombo().getSelectedItem() != null && element instanceof Completable) {
                Completable item = (Completable)element;
                if (FavoritesManagerPanel.this.getCategoryCombo().getSelectedItem().equals(FavoritesManagerPanel.ALL_FUNCTIONS)) {
                    return !FavoritesManagerPanel.this.inFavorites(item);
                }
                boolean catMatch = false;
                if (item instanceof DefaultCompletable) {
                    catMatch = ((DefaultCompletable)item).matchCategory((String)FavoritesManagerPanel.this.getCategoryCombo().getSelectedItem());
                } else if (item instanceof UserDefinedCompletable) {
                    catMatch = FavoritesManagerPanel.this.getCategoryCombo().getSelectedItem().equals(FavoritesManagerPanel.USER_DEFINED);
                }
                return catMatch && !FavoritesManagerPanel.this.inFavorites(item);
            }
            return true;
        }
    };
    private Action ADD_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -2570064417950887690L;

        @Override
        public void actionPerformed(ActionEvent e) {
            FavoritesManagerPanel.this.helper.addToFavorites((Completable)FavoritesManagerPanel.this.getAvailableList().getSelectedValue());
            ((DefaultListModel)FavoritesManagerPanel.this.getFavoritesList().getModel()).addElement(FavoritesManagerPanel.this.getAvailableList().getSelectedValue());
            FavoritesManagerPanel.this.listModel.filter();
            FavoritesManagerPanel.this.getAvailableList().repaint();
        }
    };
    private Action REMOVE_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 4309802813433705870L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = FavoritesManagerPanel.this.getFavoritesList().getSelectedValue();
            FavoritesManagerPanel.this.helper.removeFromFavorites((Completable)obj);
            ((DefaultListModel)FavoritesManagerPanel.this.getFavoritesList().getModel()).removeElement(obj);
            FavoritesManagerPanel.this.listModel.filter();
            FavoritesManagerPanel.this.getAvailableList().repaint();
        }
    };
    private ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object obj = ((JList)e.getSource()).getSelectedValue();
                if (obj != null) {
                    if (e.getSource() == FavoritesManagerPanel.this.getFavoritesList()) {
                        FavoritesManagerPanel.this.getAvailableList().clearSelection();
                    } else {
                        FavoritesManagerPanel.this.getFavoritesList().clearSelection();
                    }
                    FavoritesManagerPanel.this.refreshHelp((Completable)obj);
                } else {
                    FavoritesManagerPanel.this.getInfoText().setText("");
                }
                FavoritesManagerPanel.this.ADD_ACTION.setEnabled(FavoritesManagerPanel.this.getAvailableList().getSelectedIndex() != -1);
                FavoritesManagerPanel.this.REMOVE_ACTION.setEnabled(FavoritesManagerPanel.this.getFavoritesList().getSelectedIndex() != -1);
            }
        }
    };

    public FavoritesManagerPanel(CodeAssistFavoritesHelper helper, Action acceptAction, Action cancelAction) {
        this.helper = helper;
        this.ACCEPT_ACTION = acceptAction;
        this.CANCEL_ACTION = cancelAction;
        this.initialize();
    }

    private void initialize() {
        FormLayout layout = new FormLayout("4dlu, pref, 2dlu, pref, fill:pref:grow, 4dlu, fill:pref, 4dlu, fill:pref:grow, pref, 2dlu, pref, 4dlu", "4dlu, pref, 2dlu, pref, 2dlu, pref, fill:pref:grow, 2dlu, pref, 2dlu, fill:pref:grow, 4dlu, pref, 4dlu");
        layout.setColumnGroups((int[][])new int[][]{{2, 4, 10, 12}});
        layout.setRowGroups((int[][])new int[][]{{7, 11}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        this.add((Component)new JLabel("Available functions"), cc.xywh(2, 2, 4, 1));
        this.add((Component)new JLabel("Favorites"), cc.xywh(9, 2, 4, 1));
        this.add((Component)new JLabel("Category: "), cc.xy(2, 4));
        this.add((Component)this.getCategoryCombo(), cc.xywh(4, 4, 2, 1));
        this.add((Component)this.getAvailableScroll(), cc.xywh(2, 5, 4, 4));
        this.add((Component)this.getFavoritesScroll(), cc.xywh(9, 4, 4, 6));
        this.add((Component)this.getAddButton(), cc.xy(7, 4));
        this.add((Component)this.getRemoveButton(), cc.xy(7, 6));
        this.add((Component)this.getInfoScroll(), cc.xyw(2, 11, 11));
        this.add((Component)this.getAcceptButton(), cc.xy(10, 13));
        this.add((Component)this.getCancelButton(), cc.xy(12, 13));
        this.setMaximumSize(new Dimension(800, 600));
    }

    private JScrollPane getAvailableScroll() {
        if (this.availableScroll == null) {
            this.availableScroll = new JScrollPane();
            this.availableScroll.setVerticalScrollBarPolicy(22);
            this.availableScroll.setHorizontalScrollBarPolicy(30);
            this.availableScroll.setViewportView(this.getAvailableList());
        }
        return this.availableScroll;
    }

    private JScrollPane getFavoritesScroll() {
        if (this.favoritesScroll == null) {
            this.favoritesScroll = new JScrollPane();
            this.favoritesScroll.setVerticalScrollBarPolicy(22);
            this.favoritesScroll.setHorizontalScrollBarPolicy(30);
            this.favoritesScroll.setViewportView(this.getFavoritesList());
        }
        return this.favoritesScroll;
    }

    private JList getAvailableList() {
        if (this.availableList == null) {
            this.availableList = new JList(this.listModel){
                private static final long serialVersionUID = 2096892340979093228L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (FavoritesManagerPanel.this.availableList.getModel().getSize() == 0) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        String[] text = FavoritesManagerPanel.EMPTY_AVAILABLES.split("\n");
                        float height = this.getFontMetrics(this.getFont()).getLineMetrics(FavoritesManagerPanel.EMPTY_AVAILABLES, g2).getHeight() + 5.0f;
                        float top = ((float)this.getHeight() - (float)text.length * height) / 2.0f;
                        for (int i = 0; i < text.length; ++i) {
                            float left = (this.getWidth() - this.getFontMetrics(this.getFont()).stringWidth(text[i])) / 2;
                            g2.drawString(text[i], left, top + (float)i * height);
                        }
                        g2.dispose();
                    }
                }

                @Override
                public String getToolTipText(MouseEvent event) {
                    int index = this.locationToIndex(event.getPoint());
                    if (index > -1) {
                        return "<html>" + ((Completable)this.getModel().getElementAt(index)).getDescription() + "</html>";
                    }
                    return null;
                }
            };
            this.availableList.setCellRenderer(listCellRenderer);
            this.availableList.addListSelectionListener(this.listSelectionListener);
            this.availableList.setPrototypeCellValue(new DefaultCompletable("prototype", Completable.CompletableType.FUNCTION, null, "prototype"));
        }
        return this.availableList;
    }

    private JList getFavoritesList() {
        if (this.favoritesList == null) {
            this.favoritesList = new JList(new DefaultListModel()){
                private static final long serialVersionUID = 2096892340979093228L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (FavoritesManagerPanel.this.favoritesList.getModel().getSize() == 0) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        String[] text = FavoritesManagerPanel.EMPTY_FAVORITES.split("\n");
                        float height = this.getFontMetrics(this.getFont()).getLineMetrics(FavoritesManagerPanel.EMPTY_FAVORITES, g2).getHeight() + 5.0f;
                        float top = ((float)this.getHeight() - (float)text.length * height) / 2.0f;
                        for (int i = 0; i < text.length; ++i) {
                            float left = (this.getWidth() - this.getFontMetrics(this.getFont()).stringWidth(text[i])) / 2;
                            g2.drawString(text[i], left, top + (float)i * height);
                        }
                        g2.dispose();
                    }
                }

                @Override
                public String getToolTipText(MouseEvent event) {
                    int index = this.locationToIndex(event.getPoint());
                    if (index > -1) {
                        return "<html>" + ((Completable)this.getModel().getElementAt(index)).getDescription() + "</html>";
                    }
                    return null;
                }
            };
            this.favoritesList.setCellRenderer(listCellRenderer);
            this.favoritesList.addListSelectionListener(this.listSelectionListener);
        }
        return this.favoritesList;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton(this.ADD_ACTION);
            this.addButton.setText("Add >");
        }
        return this.addButton;
    }

    private JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = new JButton(this.REMOVE_ACTION);
            this.removeButton.setText("< Remove");
        }
        return this.removeButton;
    }

    private JComboBox getCategoryCombo() {
        if (this.categoryCombo == null) {
            this.categoryCombo = new JComboBox();
            this.categoryCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FavoritesManagerPanel.this.listModel.filter();
                }
            });
        }
        return this.categoryCombo;
    }

    private JButton getAcceptButton() {
        if (this.acceptButton == null) {
            this.acceptButton = new JButton(this.ACCEPT_ACTION);
            this.acceptButton.setText("Ok");
        }
        return this.acceptButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(this.CANCEL_ACTION);
            this.cancelButton.setText("Cancel");
        }
        return this.cancelButton;
    }

    public void updateFunctions(CodeAssistDataProvider provider) {
        HashSet<Completable> tmpSet = new HashSet<Completable>();
        ArrayList<Completable> functions = new ArrayList<Completable>();
        this.listModel.clear();
        Iterator<Completable> it = provider.getItemIterator();
        while (it.hasNext()) {
            Completable item = it.next();
            if (item.getType() == Completable.CompletableType.CONSTANT) continue;
            tmpSet.add(item);
        }
        functions.addAll(tmpSet);
        Collections.sort(functions);
        for (Completable item : functions) {
            this.listModel.addElement(item);
        }
        this.listModel.filter();
        ArrayList<String> categoryList = new ArrayList<String>();
        Iterator<String> it2 = provider.getCategoryIterator();
        while (it2.hasNext()) {
            categoryList.add(it2.next());
        }
        categoryList.add(USER_DEFINED);
        categoryList.add(ALL_FUNCTIONS);
        Collections.sort(categoryList);
        ((DefaultComboBoxModel)this.getCategoryCombo().getModel()).removeAllElements();
        for (int i = 0; i < categoryList.size(); ++i) {
            ((DefaultComboBoxModel)this.getCategoryCombo().getModel()).addElement(categoryList.get(i));
        }
    }

    private boolean inFavorites(Completable item) {
        for (int i = 0; i < this.getFavoritesList().getModel().getSize(); ++i) {
            if (!this.getFavoritesList().getModel().getElementAt(i).equals(item)) continue;
            return true;
        }
        return false;
    }

    public void updateFavorites() {
        ((DefaultListModel)this.getFavoritesList().getModel()).clear();
        HashSet<Completable> favorites = new HashSet<Completable>();
        Iterator<Completable> it = this.helper.getFavorites().iterator();
        while (it.hasNext()) {
            favorites.add(it.next());
        }
        ArrayList list = new ArrayList(favorites);
        for (Completable item : list) {
            int index = this.listModel.getUnfilteredIndexOf(item);
            if (index == -1) continue;
            ((DefaultListModel)this.getFavoritesList().getModel()).addElement(this.listModel.getUnfilteredElementAt(index));
        }
        this.listModel.filter();
    }

    private JScrollPane getInfoScroll() {
        if (this.infoScroll == null) {
            this.infoScroll = new JScrollPane();
            this.infoScroll.setViewportView(this.getInfoText());
        }
        return this.infoScroll;
    }

    private JEditorPane getInfoText() {
        if (this.infoText == null) {
            this.infoText = CompletableDisplayHelper.createDescriptionField();
        }
        return this.infoText;
    }

    private void refreshHelp(Completable item) {
        this.getInfoText().setText(CompletableDisplayHelper.getFullDescription(item, this.expertMode));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FavoritesManagerPanel.this.getInfoText().scrollRectToVisible(new Rectangle(0, 0));
            }
        });
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }
}

