/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.codeassist.toolbar;

import chemaxon.jep.UserParam;
import chemaxon.marvin.util.codeassist.CodeAssistDataProvider;
import chemaxon.marvin.util.codeassist.Completable;
import chemaxon.marvin.util.codeassist.CompletableDisplayHelper;
import chemaxon.marvin.util.codeassist.CompletionItemCellRenderer;
import chemaxon.marvin.util.codeassist.DefaultCompletable;
import chemaxon.marvin.util.codeassist.UserDefinedCompletable;
import chemaxon.marvin.util.codeassist.toolbar.AbstractFilterListModel;
import chemaxon.marvin.util.codeassist.toolbar.CodeAssistFavoritesHelper;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FunctionSelectorPanel
extends JPanel {
    private static final long serialVersionUID = 1249420531113851182L;
    private static final String EMPTY_FUNCTIONS = "There is no function matches\nthe filters. Select another category,\nor choose All functions.";
    private static final String NO_FUNCTION_SELECTED = "<html><b>No selected function</b></html>";
    private static final String FUNCTION_PANEL = "FunctionPanel";
    private static final String ARGUMENT_PANEL = "ArgumentPanel";
    private static final String ALL_FUNCTIONS = "All functions";
    private static final String USER_DEFINED = "User-defined";
    private static final String FAVORITES = "Favorites";
    private JTextPane associatedTextPane = null;
    private JPanel functionListPanel = null;
    private JPanel argumentListPanel = null;
    private JPanel argumentComponentPanel = null;
    private JScrollPane argumentPane = null;
    private JScrollPane argumentDescScroll = null;
    private CardLayout layout = new CardLayout();
    private JScrollPane functionScroll = null;
    private JScrollPane descScroll = null;
    private JList functionList = null;
    private JTextPane searchText = null;
    private JScrollPane searchScroll = null;
    private JButton searchButton = null;
    private JComboBox categoryCombo = null;
    private JEditorPane descText = null;
    private JEditorPane argDescText = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private JButton okArgumentsButton = null;
    private JButton cancelArgumentsButton = null;
    private boolean searching = false;
    private boolean expertMode = false;
    private final Action ACCEPT_ACTION;
    private final Action CANCEL_ACTION;
    private final CodeAssistFavoritesHelper favoritesHelper;
    private JLabel[] argLabel;
    private JTextField[] argField;
    private Action ACCEPT_FUNCTION_ACTION = new AbstractAction(){
        private static final long serialVersionUID = -2543173272799109526L;

        @Override
        public void actionPerformed(final ActionEvent e) {
            Completable completable = (Completable)FunctionSelectorPanel.this.getFunctionList().getSelectedValue();
            if (completable != null) {
                if (completable instanceof DefaultCompletable) {
                    UserParam[] args = ((DefaultCompletable)completable).getParameters();
                    if (args == null || args.length == 0) {
                        FunctionSelectorPanel.this.ACCEPT_ACTION.actionPerformed(e);
                    } else {
                        FunctionSelectorPanel.this.refreshArgComponents(args);
                        FunctionSelectorPanel.this.layout.show(FunctionSelectorPanel.this, FunctionSelectorPanel.ARGUMENT_PANEL);
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FunctionSelectorPanel.this.ACCEPT_ACTION.actionPerformed(e);
                        }
                    });
                }
            }
        }
    };
    private Action CANCEL_FUNCTION_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 3237982719199267837L;

        @Override
        public void actionPerformed(ActionEvent e) {
            FunctionSelectorPanel.this.layout.show(FunctionSelectorPanel.this, FunctionSelectorPanel.FUNCTION_PANEL);
        }
    };
    private Action SEARCH_ACTION = new AbstractAction(){
        private static final long serialVersionUID = 1651765312675258149L;

        @Override
        public void actionPerformed(ActionEvent e) {
            FunctionSelectorPanel.this.searching = true;
            FunctionSelectorPanel.this.listModel.filter();
            FunctionSelectorPanel.this.searching = false;
        }
    };
    private AbstractFilterListModel listModel = new AbstractFilterListModel(){
        private static final long serialVersionUID = -6791893180981140160L;

        @Override
        protected boolean filter(Object element) {
            if (FunctionSelectorPanel.this.getCategoryCombo().getSelectedItem() != null && element instanceof Completable) {
                Completable item = (Completable)element;
                if (FunctionSelectorPanel.this.searching) {
                    String[] needle = FunctionSelectorPanel.this.getSearchText().getText().toLowerCase().split(" ");
                    String haystack = (item.getName() + " " + item.getDescription()).toLowerCase();
                    for (int i = 0; i < needle.length; ++i) {
                        if (!haystack.contains(needle[i])) continue;
                        return true;
                    }
                    return false;
                }
                if (FunctionSelectorPanel.this.getCategoryCombo().getSelectedItem().equals(FunctionSelectorPanel.FAVORITES) && FunctionSelectorPanel.this.inFavorites(item)) {
                    return true;
                }
                if (FunctionSelectorPanel.this.getCategoryCombo().getSelectedItem().equals(FunctionSelectorPanel.ALL_FUNCTIONS)) {
                    return true;
                }
                boolean catMatch = false;
                if (item instanceof DefaultCompletable) {
                    catMatch = ((DefaultCompletable)item).matchCategory((String)FunctionSelectorPanel.this.getCategoryCombo().getSelectedItem());
                } else if (item instanceof UserDefinedCompletable) {
                    catMatch = FunctionSelectorPanel.this.getCategoryCombo().getSelectedItem().equals(FunctionSelectorPanel.USER_DEFINED);
                }
                return catMatch;
            }
            return true;
        }
    };
    private ListSelectionListener listSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Completable item = (Completable)FunctionSelectorPanel.this.getFunctionList().getSelectedValue();
                if (item != null) {
                    FunctionSelectorPanel.this.getDescText().setText("<b>" + item.getName() + "</b><br>" + CompletableDisplayHelper.getFullDescription(item, FunctionSelectorPanel.this.expertMode));
                    String argDesc = "";
                    if (item instanceof DefaultCompletable) {
                        argDesc = "<b>Parameters:</b><br>" + ((DefaultCompletable)item).getParameterDescription() + "<br><br>";
                    }
                    FunctionSelectorPanel.this.getArgDescText().setText(argDesc + item.getExample());
                } else {
                    FunctionSelectorPanel.this.getDescText().setText("<b><html><b>No selected function</b></html></b>");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FunctionSelectorPanel.this.getDescText().scrollRectToVisible(new Rectangle(0, 0));
                        FunctionSelectorPanel.this.getArgDescText().scrollRectToVisible(new Rectangle(0, 0));
                    }
                });
                FunctionSelectorPanel.this.updateActions();
            }
        }
    };

    public FunctionSelectorPanel(CodeAssistFavoritesHelper helper, Action acceptAction, Action cancelAction) {
        this.ACCEPT_ACTION = acceptAction;
        this.CANCEL_ACTION = cancelAction;
        this.favoritesHelper = helper;
        this.initialize();
        this.updateActions();
    }

    private void initialize() {
        this.setLayout(this.layout);
        this.add((Component)this.getArgumentListPanel(), ARGUMENT_PANEL);
        this.add((Component)this.getFunctionListPanel(), FUNCTION_PANEL);
        this.layout.show(this, FUNCTION_PANEL);
    }

    private JPanel getFunctionListPanel() {
        if (this.functionListPanel == null) {
            this.functionListPanel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, 4dlu, pref, 2dlu, fill:pref:grow, 2dlu, pref, 2dlu, pref, 4dlu", "4dlu, pref, 4dlu, pref, 2dlu, pref, 8dlu, pref, 4dlu, fill:pref:grow, 2dlu, fill:pref, 4dlu, pref, 4dlu");
            layout.setColumnGroups((int[][])new int[][]{{7, 9}});
            this.functionListPanel.setLayout((LayoutManager)layout);
            CellConstraints cc = new CellConstraints();
            this.functionListPanel.add((Component)new JLabel("Search for a function"), cc.xywh(2, 2, 8, 1));
            this.functionListPanel.add((Component)this.getSearchScroll(), cc.xywh(3, 4, 5, 1));
            this.functionListPanel.add((Component)this.getSearchButton(), cc.xy(9, 4, "default, top"));
            this.functionListPanel.add((Component)new JLabel("Or select a category: "), cc.xy(3, 6));
            this.functionListPanel.add((Component)this.getCategoryCombo(), cc.xywh(5, 6, 3, 1));
            this.functionListPanel.add((Component)new JLabel("Select a function"), cc.xywh(2, 8, 8, 1));
            this.functionListPanel.add((Component)this.getFunctionScroll(), cc.xywh(3, 10, 7, 1));
            this.functionListPanel.add((Component)this.getDescScroll(), cc.xyw(3, 12, 7));
            this.functionListPanel.add((Component)this.getOkButton(), cc.xy(7, 14));
            this.functionListPanel.add((Component)this.getCancelButton(), cc.xy(9, 14));
        }
        return this.functionListPanel;
    }

    private JPanel getArgumentListPanel() {
        if (this.argumentListPanel == null) {
            this.argumentListPanel = new JPanel();
            FormLayout layout = new FormLayout("4dlu, fill:pref:grow, pref, 2dlu, pref, 4dlu", "4dlu, fill:pref:grow, 2dlu, fill:pref, 2dlu, pref, 4dlu");
            layout.setColumnGroups((int[][])new int[][]{{3, 5}});
            this.argumentListPanel.setLayout((LayoutManager)layout);
            CellConstraints cc = new CellConstraints();
            this.argumentListPanel.add((Component)this.getArgumentPane(), cc.xyw(2, 2, 4));
            this.argumentListPanel.add((Component)this.getArgumentDescScroll(), cc.xyw(2, 4, 4));
            this.argumentListPanel.add((Component)this.getOkAgrumentsButton(), cc.xy(3, 6));
            this.argumentListPanel.add((Component)this.getCancelAgrumentsButton(), cc.xy(5, 6));
        }
        return this.argumentListPanel;
    }

    private JScrollPane getArgumentPane() {
        if (this.argumentPane == null) {
            this.argumentPane = new JScrollPane();
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.getArgumentComponentPanel(), "North");
            this.argumentPane.setViewportView(panel);
        }
        return this.argumentPane;
    }

    private JPanel getArgumentComponentPanel() {
        if (this.argumentComponentPanel == null) {
            this.argumentComponentPanel = new JPanel();
            this.argumentComponentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.argumentComponentPanel;
    }

    private JScrollPane getArgumentDescScroll() {
        if (this.argumentDescScroll == null) {
            this.argumentDescScroll = new JScrollPane();
            this.argumentDescScroll.setHorizontalScrollBarPolicy(31);
            this.argumentDescScroll.setVerticalScrollBarPolicy(20);
            this.argumentDescScroll.setPreferredSize(new Dimension(0, 100));
            this.argumentDescScroll.setViewportView(this.getArgDescText());
        }
        return this.argumentDescScroll;
    }

    private JScrollPane getFunctionScroll() {
        if (this.functionScroll == null) {
            this.functionScroll = new JScrollPane();
            this.functionScroll.setHorizontalScrollBarPolicy(31);
            this.functionScroll.setVerticalScrollBarPolicy(20);
            this.functionScroll.setViewportView(this.getFunctionList());
        }
        return this.functionScroll;
    }

    private JScrollPane getDescScroll() {
        if (this.descScroll == null) {
            this.descScroll = new JScrollPane();
            this.descScroll.setHorizontalScrollBarPolicy(31);
            this.descScroll.setVerticalScrollBarPolicy(20);
            this.descScroll.setPreferredSize(new Dimension(0, 100));
            this.descScroll.setViewportView(this.getDescText());
        }
        return this.descScroll;
    }

    private JScrollPane getSearchScroll() {
        if (this.searchScroll == null) {
            this.searchScroll = new JScrollPane();
            this.searchScroll.setViewportView(this.getSearchText());
            this.searchScroll.setVerticalScrollBarPolicy(21);
            this.searchScroll.setHorizontalScrollBarPolicy(31);
        }
        return this.searchScroll;
    }

    private JList getFunctionList() {
        if (this.functionList == null) {
            this.functionList = new JList(this.listModel){
                private static final long serialVersionUID = -6192223935345831587L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (FunctionSelectorPanel.this.functionList.getModel().getSize() == 0) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        String[] text = FunctionSelectorPanel.EMPTY_FUNCTIONS.split("\n");
                        float height = this.getFontMetrics(this.getFont()).getLineMetrics(FunctionSelectorPanel.EMPTY_FUNCTIONS, g2).getHeight() + 5.0f;
                        float top = ((float)this.getHeight() - (float)text.length * height) / 2.0f;
                        for (int i = 0; i < text.length; ++i) {
                            float left = (this.getWidth() - this.getFontMetrics(this.getFont()).stringWidth(text[i])) / 2;
                            g2.drawString(text[i], left, top + (float)i * height);
                        }
                        g2.dispose();
                    }
                }

                @Override
                public String getToolTipText(MouseEvent event) {
                    int index = this.locationToIndex(event.getPoint());
                    if (index > -1) {
                        return "<html>" + ((Completable)this.getModel().getElementAt(index)).getDescription() + "</html>";
                    }
                    return null;
                }
            };
            this.functionList.setCellRenderer(new CompletionItemCellRenderer());
            this.functionList.addListSelectionListener(this.listSelectionListener);
        }
        return this.functionList;
    }

    private JTextPane getSearchText() {
        if (this.searchText == null) {
            String text = " Type some keywords and then click Search ";
            this.searchText = new JTextPane(){
                private static final long serialVersionUID = 7477509280790937426L;

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (FunctionSelectorPanel.this.searchText.getText().length() == 0) {
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setColor(Color.GRAY);
                        Font font = FunctionSelectorPanel.this.searchText.getFont();
                        float height = FunctionSelectorPanel.this.searchText.getFontMetrics(font).getLineMetrics(" Type some keywords and then click Search ", g2).getHeight();
                        float top = ((float)FunctionSelectorPanel.this.searchText.getHeight() - height) / 2.0f;
                        float left = (FunctionSelectorPanel.this.searchText.getWidth() - FunctionSelectorPanel.this.searchText.getFontMetrics(font).stringWidth(" Type some keywords and then click Search ")) / 2;
                        g2.drawString(" Type some keywords and then click Search ", left, top + height - 4.0f);
                        g2.dispose();
                    }
                }
            };
            this.searchText.setPreferredSize(new Dimension(this.searchText.getFontMetrics(this.searchText.getFont()).stringWidth(" Type some keywords and then click Search "), this.searchText.getPreferredSize().height));
        }
        return this.searchText;
    }

    private JButton getSearchButton() {
        if (this.searchButton == null) {
            this.searchButton = new JButton(this.SEARCH_ACTION);
            this.searchButton.setText("Search");
        }
        return this.searchButton;
    }

    private JComboBox getCategoryCombo() {
        if (this.categoryCombo == null) {
            this.categoryCombo = new JComboBox();
            this.categoryCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FunctionSelectorPanel.this.listModel.filter();
                }
            });
        }
        return this.categoryCombo;
    }

    private JEditorPane getDescText() {
        if (this.descText == null) {
            this.descText = CompletableDisplayHelper.createDescriptionField();
            this.descText.setText("<b><html><b>No selected function</b></html></b>");
        }
        return this.descText;
    }

    private JEditorPane getArgDescText() {
        if (this.argDescText == null) {
            this.argDescText = CompletableDisplayHelper.createDescriptionField();
            this.argDescText.setText("<b><html><b>No selected function</b></html></b>");
        }
        return this.argDescText;
    }

    private JButton getOkAgrumentsButton() {
        if (this.okArgumentsButton == null) {
            this.okArgumentsButton = new JButton(this.ACCEPT_ACTION);
            this.okArgumentsButton.setText("Ok");
        }
        return this.okArgumentsButton;
    }

    private JButton getCancelAgrumentsButton() {
        if (this.cancelArgumentsButton == null) {
            this.cancelArgumentsButton = new JButton(this.CANCEL_FUNCTION_ACTION);
            this.cancelArgumentsButton.setText("Cancel");
        }
        return this.cancelArgumentsButton;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(this.ACCEPT_FUNCTION_ACTION);
            this.okButton.setText("Ok");
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(this.CANCEL_ACTION);
            this.cancelButton.setText("Cancel");
        }
        return this.cancelButton;
    }

    public void setTextPane(JTextPane textPane) {
        this.associatedTextPane = textPane;
    }

    public JTextPane getTextPane() {
        return this.associatedTextPane;
    }

    public void updateFunctions(CodeAssistDataProvider provider) {
        this.listModel.removeAllElements();
        HashSet<Completable> tmpSet = new HashSet<Completable>();
        ArrayList<Completable> functions = new ArrayList<Completable>();
        Iterator<Completable> it = provider.getItemIterator();
        while (it.hasNext()) {
            Completable item = it.next();
            if (item.getType() == Completable.CompletableType.CONSTANT) continue;
            tmpSet.add(item);
        }
        functions.addAll(tmpSet);
        Collections.sort(functions);
        for (Completable item : functions) {
            this.listModel.addElement(item);
        }
        ArrayList<String> categoryList = new ArrayList<String>();
        Iterator<String> it2 = provider.getCategoryIterator();
        while (it2.hasNext()) {
            categoryList.add(it2.next());
        }
        categoryList.add(FAVORITES);
        categoryList.add(USER_DEFINED);
        categoryList.add(ALL_FUNCTIONS);
        Collections.sort(categoryList);
        ((DefaultComboBoxModel)this.getCategoryCombo().getModel()).removeAllElements();
        for (int i = 0; i < categoryList.size(); ++i) {
            ((DefaultComboBoxModel)this.getCategoryCombo().getModel()).addElement(categoryList.get(i));
        }
    }

    private boolean inFavorites(Completable item) {
        List<Completable> favorites = this.favoritesHelper.getFavorites();
        for (int i = 0; i < favorites.size(); ++i) {
            if (!favorites.get(i).equals(item)) continue;
            return true;
        }
        return false;
    }

    private void updateActions() {
        this.ACCEPT_FUNCTION_ACTION.setEnabled(this.getFunctionList().getSelectedIndex() != -1);
    }

    private void refreshArgComponents(UserParam[] args) {
        int i;
        if (this.argLabel != null) {
            for (i = 0; i < this.argLabel.length; ++i) {
                this.getArgumentComponentPanel().remove(this.argLabel[i]);
            }
            this.argLabel = null;
        }
        if (this.argField != null) {
            for (i = 0; i < this.argField.length; ++i) {
                this.getArgumentComponentPanel().remove(this.argField[i]);
            }
            this.argField = null;
        }
        this.getArgumentComponentPanel().setLayout(new GridLayout(args.length, 2, 10, 5));
        this.argLabel = new JLabel[args.length];
        this.argField = new JTextField[args.length];
        for (i = 0; i < args.length; ++i) {
            this.argLabel[i] = new JLabel("<html><b>" + args[i].getName().substring(0, 1).toUpperCase() + args[i].getName().substring(1).toLowerCase() + "</b></html>");
            if (i == 0 && args[0].getName().equalsIgnoreCase("target")) {
                this.argField[0] = CompletableDisplayHelper.createTipOnEmptyTextField("Only for Reaction Context");
            } else {
                this.argField[i] = new JTextField();
            }
            this.getArgumentComponentPanel().add(this.argLabel[i]);
            this.getArgumentComponentPanel().add(this.argField[i]);
        }
    }

    public String getFunctionText() {
        Completable completable = (Completable)this.getFunctionList().getSelectedValue();
        if (completable != null) {
            if (completable instanceof DefaultCompletable) {
                StringBuffer buffer = new StringBuffer(completable.getName());
                buffer.append("(");
                boolean commaNeeded = false;
                for (int i = 0; i < this.argField.length; ++i) {
                    String arg = this.argField[i].getText().replaceAll("\\\"", "").trim();
                    if (((DefaultCompletable)completable).getParameters()[i].isMultiple()) {
                        arg = arg.replaceAll("[ ]*,[ ]*", "\", \"");
                    }
                    if (arg.length() <= 0) continue;
                    if (commaNeeded) {
                        buffer.append(", ");
                    }
                    arg = "\"" + arg + "\"";
                    buffer.append(arg);
                    commaNeeded = true;
                }
                buffer.append(")");
                return buffer.toString();
            }
            if (completable instanceof UserDefinedCompletable) {
                return ((UserDefinedCompletable)completable).getMacro();
            }
        }
        return "";
    }

    public void reset() {
        this.layout.show(this, FUNCTION_PANEL);
        this.getSearchText().setText("");
        this.listModel.filter();
    }

    public void set(Completable completable) {
        this.getSearchText().setText("");
        this.listModel.filter();
        this.getFunctionList().setSelectedValue(completable, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FunctionSelectorPanel.this.ACCEPT_FUNCTION_ACTION.actionPerformed(new ActionEvent(this, 0, "fake"));
            }
        });
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }
}

