/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.util.text;

import java.util.Hashtable;

public class StringTree {
    public static final int DEFAULT_GROUP_SIZE = 16;
    private int criticalSize = 16;
    private String head;
    private int elementCount;
    private Object[] elements;

    public StringTree(String h, int n) {
        this.head = h;
        this.criticalSize = n;
        this.elementCount = 0;
        this.elements = new Object[n];
    }

    public StringTree(String[] objs, int n) {
        this("", n);
        boolean[] v = new boolean[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            String sLC = null;
            int k = -1;
            for (int j = 0; j < objs.length; ++j) {
                if (v[j]) continue;
                String name = objs[j];
                String nameLC = StringTree.removePrefix(name);
                int pl = name.length() - nameLC.length();
                nameLC = nameLC.toLowerCase();
                if (pl != 0) {
                    String prefix = name.substring(0, pl);
                    nameLC = nameLC.concat("%%%%").concat(prefix);
                }
                if (sLC != null && sLC.compareTo(nameLC) <= 0) continue;
                sLC = nameLC;
                k = j;
            }
            this.addElement(objs[k]);
            v[k] = true;
        }
        this.groupElements();
        this.ungroupSomeGroups();
    }

    public String getLabel() {
        return this.head;
    }

    public String toString() {
        return this.getLabel();
    }

    public int length() {
        return this.elementCount;
    }

    public Object get(int i) {
        return this.elements[i];
    }

    private void groupElements() {
        if (this.length() > this.criticalSize) {
            int i;
            Hashtable<String, StringTree> hash = new Hashtable<String, StringTree>();
            for (i = this.length() - 1; i >= 0; --i) {
                String elem0 = (String)this.get(i);
                String elem = StringTree.removePrefix(elem0);
                if (elem.length() < this.head.length() + 1) continue;
                this.removeElement(i);
                String s = elem.substring(0, this.head.length() + 1);
                s = s.toUpperCase();
                StringTree t = (StringTree)hash.get(s);
                if (t == null) {
                    t = new StringTree(s, this.criticalSize);
                    hash.put(s, t);
                    this.insertElementAt(t, i);
                }
                t.insertElementAt(elem0, 0);
            }
            for (i = 0; i < this.length(); ++i) {
                Object o = this.get(i);
                if (!(o instanceof StringTree)) continue;
                StringTree t = (StringTree)o;
                if (t.length() > 1) {
                    t.groupElements();
                    t.ungroupSomeGroups();
                }
                if (t.length() != 1) continue;
                this.ungroup(i);
            }
        }
        this.head = this.findLargestCommonString();
    }

    private void ungroupSomeGroups() {
        int size;
        while ((size = this.findSmallestGroupSize()) != Integer.MAX_VALUE) {
            StringTree t;
            Object o;
            int i;
            int n = 0;
            for (i = 0; i < this.length(); ++i) {
                o = this.get(i);
                if (!(o instanceof StringTree) || (t = (StringTree)o).length() != size) continue;
                ++n;
            }
            if (this.length() + (size - 1) * n > this.criticalSize) {
                return;
            }
            for (i = this.length() - 1; i >= 0; --i) {
                o = this.get(i);
                if (!(o instanceof StringTree)) continue;
                t = (StringTree)o;
                if (t.length() == size) {
                    this.ungroup(i);
                    continue;
                }
                t.ungroupSomeGroups();
            }
        }
    }

    private void ungroup(int i) {
        Object o = this.get(i);
        if (o instanceof StringTree) {
            StringTree t = (StringTree)o;
            this.removeElement(i);
            for (int j = t.length() - 1; j >= 0; --j) {
                this.insertElementAt(t.get(j), i);
            }
        }
        if (this.length() == 1) {
            this.ungroup(0);
        }
    }

    private String findLargestCommonString() {
        String largest = null;
        for (int i = 0; i < this.length(); ++i) {
            Object o = this.get(i);
            String name = o instanceof StringTree ? ((StringTree)o).head : StringTree.removePrefix((String)o);
            if (largest == null) {
                largest = name;
            }
            while (!name.toLowerCase().startsWith(largest.toLowerCase())) {
                largest = largest.substring(0, largest.length() - 1);
            }
        }
        return largest == null ? "" : largest;
    }

    public static String removePrefix(String s) {
        char c;
        if (s.length() > 2 && s.charAt(1) == '-' && (c = s.charAt(2)) >= 'A' && c <= 'Z' && (c = s.charAt(0)) >= 'a' && c <= 'z') {
            return s.substring(2);
        }
        return s;
    }

    private int findSmallestGroupSize() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.length(); ++i) {
            StringTree t;
            Object o = this.get(i);
            if (!(o instanceof StringTree) || (t = (StringTree)o).length() >= n) continue;
            n = t.length();
        }
        return n;
    }

    private void removeElement(int k) {
        System.arraycopy(this.elements, k + 1, this.elements, k, this.elementCount - k - 1);
        --this.elementCount;
    }

    private void insertElementAt(Object o, int k) {
        Object[] arr = this.elements;
        if (this.elementCount == arr.length) {
            Object[] t = new Object[2 * arr.length];
            System.arraycopy(arr, 0, t, 0, k);
            System.arraycopy(arr, k, t, k + 1, this.elementCount - k);
            arr = t;
            this.elements = t;
        } else {
            System.arraycopy(arr, k, arr, k + 1, this.elementCount - k);
        }
        arr[k] = o;
        ++this.elementCount;
    }

    private void addElement(Object o) {
        Object[] arr = this.elements;
        if (this.elementCount == arr.length) {
            Object[] t = new Object[2 * arr.length];
            System.arraycopy(arr, 0, t, 0, this.elementCount);
            this.elements = arr = t;
        }
        arr[this.elementCount] = o;
        ++this.elementCount;
    }
}

