/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.modules;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.paint.DispOptConsts;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MolLoader;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class RasMolScripter
extends MarvinModule
implements Runnable,
DispOptConsts {
    private URL baseURL = null;
    private static Hashtable styles = new Hashtable();
    private Vector scriptCode = new Vector();
    private Vector nestedScriptNames = new Vector();
    private Integer indexObject = null;
    private CallbackIface molPanel;
    private MolPainter painter = null;
    private Thread thread = null;

    @Override
    public Object modfunc(Object arg) {
        if (arg instanceof URL) {
            this.baseURL = (URL)arg;
        } else if (arg instanceof Vector) {
            this.scriptCode = (Vector)arg;
        } else if (arg instanceof InputStream) {
            this.scriptCode.removeAllElements();
            this.nestedScriptNames.removeAllElements();
            try {
                this.loadScript((InputStream)arg);
            }
            catch (Exception ex) {
                this.scriptCode.removeAllElements();
                return ex;
            }
        } else if (arg instanceof Integer) {
            this.indexObject = (Integer)arg;
        } else if (arg instanceof CallbackIface) {
            this.molPanel = (CallbackIface)arg;
        } else if (arg instanceof MolPainter) {
            this.painter = (MolPainter)arg;
            this.thread = new Thread(this);
            this.thread.start();
        }
        return null;
    }

    @Override
    public void run() {
        this.execScript();
    }

    private void execScript() {
        Thread currentThread = Thread.currentThread();
        CTransform3D T = this.painter.getRTransform();
        CTransform3D U2 = new CTransform3D();
        double scale0 = U2.getScale();
        Enumeration en = this.scriptCode.elements();
        DPoint3 rotO = new DPoint3();
        Object[] args = new Object[2];
        args[0] = this.indexObject;
        rotO = new DPoint3();
        args[1] = rotO;
        this.molPanel.callback("rasmol_getCenter", args);
        T.transform(rotO);
        while (en.hasMoreElements() && this.thread == currentThread) {
            String cmd = (String)en.nextElement();
            if (cmd.equals("echo")) {
                System.out.println((String)en.nextElement());
                continue;
            }
            if (cmd.equals("load")) {
                Molecule[] mols;
                args[1] = mols = (Molecule[])en.nextElement();
                this.molPanel.callback("rasmol_load", args);
                continue;
            }
            if (cmd.equals("delay")) {
                int t = (Integer)en.nextElement();
                this.painter.setRTransform(T);
                this.molPanel.callback("rasmol_repaint", args);
                try {
                    Thread.sleep(t);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            if (cmd.equals("zap")) {
                T.setIdentity();
                this.molPanel.callback("rasmol_zap", args);
                continue;
            }
            if (cmd.equals("reset")) {
                T.setIdentity();
                continue;
            }
            if (cmd.equals("refresh")) {
                this.painter.setRTransform(T);
                this.molPanel.callback("rasmol_repaint", args);
                continue;
            }
            Integer styleObj = (Integer)styles.get(cmd);
            if (styleObj != null) {
                int style = styleObj;
                Object next = en.nextElement();
                if (!(next instanceof Boolean) || !((Boolean)next).booleanValue()) continue;
                MolPainterCommon common = this.painter.getCommon();
                common.setDispopts(style << 17, 917504);
                continue;
            }
            if (cmd.equals("rotate")) {
                double[] axis = (double[])en.nextElement();
                double phi = (Double)en.nextElement();
                U2.setIdentity();
                U2.setRotation(axis[0], axis[1], axis[2], phi);
                U2.setRotationCenter(rotO);
                U2.mul(T);
                T.set(U2);
                continue;
            }
            if (cmd.equals("zoom")) {
                double factor = (Double)en.nextElement();
                U2.setIdentity();
                U2.setScale(factor * scale0 / T.getScale());
                U2.setRotationCenter(rotO);
                U2.mul(T);
                T.set(U2);
                continue;
            }
            if (!cmd.equals("center")) continue;
            Molecule mol = (Molecule)this.molPanel.callback("rasmol_getM", args);
            Object next = en.nextElement();
            if (next instanceof Integer) {
                int atomIndex = (Integer)next - 1;
                rotO = mol.getAtom(atomIndex).getLocation();
            } else {
                rotO = mol.calcCenter();
                if (next instanceof DPoint3) {
                    DPoint3 p = (DPoint3)next;
                    rotO.x += p.x;
                    rotO.y += p.y;
                    rotO.z += p.z;
                }
            }
            args[1] = rotO;
            this.painter.setRTransform(T);
            this.molPanel.callback("rasmol_setCenter", args);
            T.transform(rotO);
        }
        this.painter.setRTransform(T);
        this.molPanel.callback("rasmol_repaint", args);
    }

    private boolean loadScript(InputStream istream) throws IOException {
        int tt;
        StreamTokenizer st = new StreamTokenizer(istream);
        st.eolIsSignificant(true);
        st.commentChar(35);
        while ((tt = st.nextToken()) != -1) {
            String cmd = st.sval;
            if (cmd == null) continue;
            if ((cmd = cmd.toLowerCase()).equals("quit")) {
                return false;
            }
            if (cmd.equals("exit")) break;
            if (cmd.equals("reset") || cmd.equals("zap") || cmd.equals("refresh")) {
                this.scriptCode.addElement(cmd);
                continue;
            }
            if (cmd.equals("source") || cmd.equals("script")) {
                tt = st.nextToken();
                String s = st.sval;
                if (this.nestedScriptNames.contains(s)) {
                    throw new IOException("Recursive nesting of scripts (\"" + s + "\")");
                }
                this.nestedScriptNames.addElement(s);
                URL u = new URL(this.baseURL, s);
                URLConnection conn = u.openConnection();
                InputStream is = conn.getInputStream();
                if (this.loadScript(is)) continue;
                return false;
            }
            if (cmd.equals("load")) {
                tt = st.nextToken();
                URL u = new URL(this.baseURL, st.sval);
                URLConnection conn = u.openConnection();
                InputStream is = conn.getInputStream();
                MolInputStream mis = new MolInputStream(is);
                Vector<RgMolecule> v = new Vector<RgMolecule>();
                MRecordImporter mri = MolLoader.createImporter(mis, null);
                Molecule mol = new RgMolecule();
                try {
                    while ((mol = mri.readMol(null)) != null) {
                        v.addElement((RgMolecule)mol);
                    }
                }
                catch (MRecordParseException ex) {
                    throw new MolFormatException(ex);
                }
                Object[] mols = new Molecule[v.size()];
                v.copyInto(mols);
                this.scriptCode.addElement(cmd);
                this.scriptCode.addElement(mols);
                continue;
            }
            if (cmd.equals("delay")) {
                int t;
                this.scriptCode.addElement(cmd);
                tt = st.nextToken();
                if (tt != -2) {
                    st.pushBack();
                    t = 1000;
                } else {
                    t = (int)(1000.0 * st.nval + 0.5);
                }
                this.scriptCode.addElement(new Integer(t));
                continue;
            }
            if (cmd.equals("echo")) {
                st.ordinaryChar(32);
                st.ordinaryChar(46);
                st.ordinaryChar(45);
                st.ordinaryChars(48, 57);
                boolean first = true;
                StringBuffer sbuf = new StringBuffer();
                while ((tt = st.nextToken()) != -1 && tt != 10 && tt != 59 && tt != 10) {
                    String s;
                    String string = s = st.sval == null ? String.valueOf((char)tt) : st.sval;
                    if (first && s.startsWith(" ")) {
                        s = s.substring(1);
                        first = false;
                    }
                    sbuf.append(s);
                }
                st.whitespaceChars(32, 32);
                st.parseNumbers();
                this.scriptCode.addElement("echo");
                this.scriptCode.addElement(sbuf.toString());
                continue;
            }
            if (styles.get(cmd) != null) {
                tt = st.nextToken();
                boolean on = false;
                if (tt == -3) {
                    String s = st.sval.toLowerCase();
                    if (s.equals("on") || s.equals("true")) {
                        on = true;
                    } else if ((cmd.equals("cpk") || cmd.equals("spacefill")) && (s.equals("temperature") || s.equals("user"))) {
                        on = true;
                    } else if (!s.equals("off") && !s.equals("false")) {
                        on = true;
                        st.pushBack();
                    }
                } else if (tt == -2) {
                    on = true;
                } else {
                    on = true;
                    st.pushBack();
                }
                if (!on) continue;
                this.scriptCode.addElement(cmd);
                this.scriptCode.addElement(new Boolean(true));
                continue;
            }
            if (cmd.equals("rotate")) {
                double[] axis = RasMolScripter.readAxis(st);
                if (axis == null) {
                    throw new IOException("Axis not specified in rotate <axis> <angle>");
                }
                tt = st.nextToken();
                if (tt != -2) {
                    throw new IOException("Angle missing in rotate <axis> <angle>");
                }
                this.scriptCode.addElement("rotate");
                this.scriptCode.addElement(axis);
                this.scriptCode.addElement(new Double(st.nval * Math.PI / 180.0));
                continue;
            }
            if (cmd.equals("zoom")) {
                tt = st.nextToken();
                if (tt != -2) {
                    throw new IOException("Zoom value (percentage) missing in zoom <value>");
                }
                this.scriptCode.addElement("zoom");
                this.scriptCode.addElement(new Double(0.01 * st.nval));
                continue;
            }
            if (!cmd.equals("center") && !cmd.equals("centre")) continue;
            tt = st.nextToken();
            if (tt == -2) {
                this.scriptCode.addElement("center");
                this.scriptCode.addElement(new Integer((int)(st.nval + 0.5)));
                continue;
            }
            if (tt == 91) {
                IOException ex = new IOException("Syntax error in " + cmd + " [x, y, z]");
                tt = st.nextToken();
                if (tt != -2) {
                    throw ex;
                }
                DPoint3 p = new DPoint3();
                p.x = st.nval / 250.0;
                tt = st.nextToken();
                if (tt != 44) {
                    throw ex;
                }
                tt = st.nextToken();
                if (tt != -2) {
                    throw ex;
                }
                p.y = st.nval / 250.0;
                tt = st.nextToken();
                if (tt != 44) {
                    throw ex;
                }
                tt = st.nextToken();
                if (tt != -2) {
                    throw ex;
                }
                p.z = st.nval / 250.0;
                tt = st.nextToken();
                if (tt != 93) {
                    throw ex;
                }
                this.scriptCode.addElement("center");
                this.scriptCode.addElement(p);
                continue;
            }
            st.pushBack();
            this.scriptCode.addElement("center");
            this.scriptCode.addElement(new Boolean(true));
        }
        return true;
    }

    private static double[] readAxis(StreamTokenizer st) throws IOException {
        if (st.nextToken() == -3) {
            String s = st.sval.toLowerCase();
            double[] axis = new double[]{0.0, 0.0, 0.0};
            if (s.equals("x")) {
                axis[0] = 1.0;
                return axis;
            }
            if (s.equals("y")) {
                axis[1] = 1.0;
                return axis;
            }
            if (s.equals("z")) {
                axis[2] = 1.0;
                return axis;
            }
        }
        return null;
    }

    static {
        for (int i = 0; i < RENDERING_STYLES.length; ++i) {
            styles.put(RENDERING_STYLES[i], new Integer(i));
        }
        styles.put("cpk", new Integer(524288));
    }
}

