/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.util.ErrorDisplay;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.SequentialScheduler;
import chemaxon.marvin.view.swing.SpreadsheetProgressMonitor;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.VisibleDocuments;
import chemaxon.struc.MDocument;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JProgressBar;

public class RecordFetcher {
    protected MDocStorage docStorage;
    protected JProgressBar progressBar = null;
    protected ErrorDisplay errorDisplay = null;
    protected SequentialScheduler scheduler;
    protected Runnable scrollBarUpdater;
    protected Runnable guiUpdater;
    protected SpreadsheetProgressMonitor prereadProgressMonitor;
    protected Object prereadLock = new Object();
    private Runnable prereadTask;
    private int currentTopRow = -1;
    private int currentBottomRow = -1;
    private Runnable prereadStartListener = null;
    private Runnable prereadEndListener = null;
    private int endRecordIndex = Integer.MAX_VALUE;
    private List<Listener> listeners;

    public RecordFetcher(MDocStorage ds, Runnable scrupd, Runnable guiupd, SequentialScheduler sch, int endi) {
        this.docStorage = ds;
        this.scheduler = sch != null ? sch : new SequentialScheduler();
        this.endRecordIndex = endi;
        this.scrollBarUpdater = scrupd;
        this.guiUpdater = guiupd;
        this.prereadTask = new Runnable(){

            @Override
            public void run() {
                Runnable listener = RecordFetcher.this.prereadStartListener;
                if (listener != null) {
                    EventQueue.invokeLater(listener);
                }
                RecordFetcher.this.prereadProgressMonitor.setCanceled(false);
                try {
                    RecordFetcher.this.docStorage.countRecords(RecordFetcher.this.prereadProgressMonitor, 500, RecordFetcher.this.scrollBarUpdater, RecordFetcher.this.endRecordIndex);
                }
                catch (IOException ex) {
                    if (RecordFetcher.this.errorDisplay != null) {
                        RecordFetcher.this.errorDisplay.error("Read error after molecule " + RecordFetcher.this.docStorage.getSize() + ":\n" + ex.getMessage(), ex);
                    }
                    return;
                }
                int max = RecordFetcher.this.prereadProgressMonitor.getMaximum();
                RecordFetcher.this.prereadProgressMonitor.setProgressValue(max);
                if (RecordFetcher.this.scrollBarUpdater != null) {
                    RecordFetcher.this.scrollBarUpdater.run();
                }
                if ((listener = RecordFetcher.this.prereadEndListener) != null) {
                    EventQueue.invokeLater(listener);
                }
            }
        };
    }

    public void setPrereadListeners(Runnable start, Runnable end) {
        this.prereadStartListener = start;
        this.prereadEndListener = end;
    }

    public void addListener(Listener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(Listener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public void setEndRecordIndex(int max) {
        this.endRecordIndex = max;
    }

    public int getEndRecordIndex() {
        return this.endRecordIndex;
    }

    public void setProgressBar(JProgressBar pbar) {
        this.progressBar = pbar;
        this.prereadProgressMonitor = new SpreadsheetProgressMonitor(this.progressBar);
        this.prereadLock = new Object();
    }

    public void setErrorDisplay(ErrorDisplay errdisp) {
        this.errorDisplay = errdisp;
    }

    public SequentialScheduler getScheduler() {
        return this.scheduler;
    }

    public void startPrereadIfNeeded() {
        MDocSource ds = this.docStorage.getDocSource();
        if (ds == null || ds.isEndReached()) {
            return;
        }
        this.scheduler.invokeLater(this.prereadTask, Integer.MAX_VALUE, "preread");
    }

    public void enqueueAccess(Runnable task, int irec_min, String name, ViewHandler vh) {
        this.cancelPreread();
        Runnable r = this.createAccessTask(task);
        this.scheduler.invokeLater(r, irec_min, name);
    }

    public void enqueueAccessAndWait(Runnable task, ViewHandler vh) throws InterruptedException, InvocationTargetException {
        this.cancelPreread();
        Runnable r = this.createAccessTask(task);
        this.scheduler.invokeAndWait(r);
    }

    private Runnable createAccessTask(final Runnable task) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RecordFetcher.this.cancelPreread();
                Object object = RecordFetcher.this.prereadLock;
                synchronized (object) {
                    RecordFetcher.this.cancelPreread();
                    try {
                        task.run();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        RecordFetcher.this.startPrereadIfNeeded();
                    }
                }
            }
        };
    }

    public void enqueueFetching(final ViewHandler vh, final int irec_min, final int irec_max) {
        final int topRow = vh.rowFromRecordIndex(irec_min);
        int bottomRow = vh.rowFromRecordIndex(irec_max);
        if (topRow == this.currentTopRow && bottomRow == this.currentBottomRow) {
            return;
        }
        this.currentTopRow = topRow;
        this.currentBottomRow = bottomRow;
        this.cancelPreread();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int dssize;
                MDocSource ds = RecordFetcher.this.docStorage.getDocSource();
                int n = dssize = ds != null ? ds.getRecordCountMax() - RecordFetcher.this.docStorage.getOffset() : RecordFetcher.this.docStorage.getSize();
                if (irec_min >= dssize && (ds == null || ds.isEndReached()) || topRow != RecordFetcher.this.currentTopRow) {
                    return;
                }
                RecordFetcher.this.cancelPreread();
                Object object = RecordFetcher.this.prereadLock;
                synchronized (object) {
                    RecordFetcher.this.cancelPreread();
                    if (irec_min < dssize) {
                        MDocument[] docs = new MDocument[irec_max + 1 - irec_min];
                        MDocStorage.Listener[] dslisteners = RecordFetcher.this.docStorage.getListeners();
                        try {
                            for (int irec = irec_min; irec <= irec_max; ++irec) {
                                docs[irec - irec_min] = RecordFetcher.this.docStorage.getMainDoc(irec);
                            }
                        }
                        catch (MDocStorage.RecordUnavailableException ex) {
                        }
                        catch (IOException ex) {
                            if (RecordFetcher.this.errorDisplay != null) {
                                RecordFetcher.this.errorDisplay.error("Read error after molecule " + RecordFetcher.this.docStorage.getSize() + ":\n" + ex.getMessage(), ex);
                            }
                            return;
                        }
                        finally {
                            RecordFetcher.this.docStorage.setListeners(dslisteners);
                        }
                        if (vh.hasVerticalScrollbar()) {
                            VisibleDocuments oldvd = vh.getVisibleDocs();
                            VisibleDocuments vd = new VisibleDocuments(irec_min, docs);
                            vh.setVisibleDocs(vd);
                            if (RecordFetcher.this.listeners != null) {
                                for (int i = 0; i < RecordFetcher.this.listeners.size(); ++i) {
                                    Listener l = (Listener)RecordFetcher.this.listeners.get(i);
                                    l.recordsRetrieved(RecordFetcher.this.docStorage, oldvd, vd);
                                }
                            }
                            RecordFetcher.this.guiUpdate(vh, irec_min);
                        }
                    }
                    RecordFetcher.this.startPrereadIfNeeded();
                }
            }
        };
        this.scheduler.invokeLater(r, irec_min, "update visible cells");
    }

    public void cancelPreread() {
        if (this.prereadProgressMonitor != null) {
            this.prereadProgressMonitor.setCanceled(true);
        }
    }

    private void guiUpdate(final ViewHandler vh, final int irec_min) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                int irec;
                VisibleDocuments vd = vh.getVisibleDocs();
                if (vd != null && (irec = vd.getRecordIndex()) == irec_min) {
                    int row = vh.rowFromRecordIndex(irec_min);
                    vh.updateVisibleCells(row);
                }
                if (RecordFetcher.this.guiUpdater != null) {
                    RecordFetcher.this.guiUpdater.run();
                }
            }
        });
    }

    protected static Throwable originalThrowable(Throwable t) {
        for (Throwable t2 = t; t2 != null; t2 = t2.getCause()) {
            t = t2;
        }
        return t;
    }

    public static interface Listener {
        public void recordsRetrieved(MDocStorage var1, VisibleDocuments var2, VisibleDocuments var3);
    }
}

