/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.common.util.MProgressMonitor;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JProgressBar;

public class SpreadsheetProgressMonitor
implements MProgressMonitor {
    protected boolean cancel = false;
    private JProgressBar progressBar;
    private int minimum = 0;
    private int maximum = 0;
    private int prevScaledProgress;
    private long initialTime;
    private long prevTime;
    private long firstTimeWithTooHighPrec;
    private boolean decreasePrec;
    private long factor = 1000000000L;
    private int precision = 7;
    private boolean started;
    private boolean foundFactor;
    private static final NumberFormat HOURFMT;
    private static final NumberFormat MINFMT;
    private static final NumberFormat SECFMT;
    private static final NumberFormat MINFMT_LONG;

    public SpreadsheetProgressMonitor(JProgressBar pbar) {
        this.progressBar = pbar;
    }

    @Override
    public void initProgressMonitor(String note, int min, int max) {
        this.prevScaledProgress = -1;
        this.minimum = min;
        this.maximum = max;
        if (this.progressBar != null) {
            this.progressBar.setStringPainted(true);
            this.progressBar.setMinimum(min);
            this.progressBar.setMaximum(max);
        }
        this.started = false;
        this.foundFactor = false;
        this.decreasePrec = false;
        this.initialTime = System.currentTimeMillis();
    }

    @Override
    public boolean setProgressValue(int x) {
        int scaledProgress;
        this.cancel = this.isCanceled();
        if (this.progressBar == null) {
            return !this.cancel;
        }
        this.progressBar.setValue(x);
        if (!this.started) {
            this.progressBar.setString("");
        }
        int n = scaledProgress = this.maximum > this.minimum ? (int)(this.factor * (long)(x - this.minimum) / (long)(this.maximum - this.minimum)) : (int)this.factor;
        if (scaledProgress != this.prevScaledProgress || !this.foundFactor) {
            long time = System.currentTimeMillis();
            if (this.started) {
                long dt = time - this.prevTime;
                if (dt < 100L && this.factor != 10L) {
                    if (this.decreasePrec && time - this.firstTimeWithTooHighPrec > 500L) {
                        --this.precision;
                        this.factor /= 10L;
                        this.prevScaledProgress /= 10;
                        this.decreasePrec = false;
                    } else {
                        if (!this.decreasePrec) {
                            this.decreasePrec = true;
                            this.firstTimeWithTooHighPrec = time;
                        }
                        this.prevScaledProgress = scaledProgress;
                        this.prevTime = time;
                    }
                } else if (dt > 1000L && this.factor != 1000000000L) {
                    ++this.precision;
                    this.factor *= 10L;
                    this.prevScaledProgress /= 10;
                    double p = (double)(scaledProgress *= 10) / (double)this.factor;
                    String s = this.message(p, this.precision, time);
                    this.progressBar.setString(s);
                    this.prevScaledProgress = scaledProgress;
                    this.prevTime = time;
                } else {
                    this.foundFactor = true;
                    double p = (double)scaledProgress / (double)this.factor;
                    String s = this.message(p, this.precision, time);
                    this.progressBar.setString(s);
                    this.prevScaledProgress = scaledProgress;
                    this.prevTime = time;
                }
            } else {
                this.started = true;
                this.prevScaledProgress = scaledProgress;
                this.prevTime = time;
            }
        }
        if (x == this.maximum || this.cancel) {
            this.progressBar.setValue(0);
            this.progressBar.setString("");
            this.prevScaledProgress = -1;
        }
        return !this.cancel;
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int max) {
        this.maximum = max;
        if (this.progressBar != null) {
            this.progressBar.setMaximum(max);
        }
    }

    public void setCanceled(boolean v) {
        this.cancel = v;
    }

    @Override
    public boolean isCanceled() {
        return this.cancel;
    }

    @Override
    public MProgressMonitor getChild() {
        return null;
    }

    @Override
    public int getLevel() {
        return 0;
    }

    @Override
    public boolean isDialogVisible() {
        return false;
    }

    @Override
    public MProgressMonitor newInstance() {
        return null;
    }

    private String message(double progress, int prec, long time) {
        StringBuffer sb = new StringBuffer();
        sb.append(SpreadsheetProgressMonitor.formatPercent(100.0 * progress, prec));
        int estimated = -1;
        long t = time - this.initialTime;
        if (progress != 0.0) {
            estimated = (int)Math.round((double)t / (1000.0 * progress));
        }
        if (estimated > 0) {
            if (progress != 1.0) {
                sb.append("  ETA: ");
                boolean hours = estimated >= 3600;
                sb.append(this.formatTime(estimated - (int)(t / 1000L), hours));
                sb.append("  (total ~ ");
                sb.append(this.formatTime(estimated, hours));
                sb.append(')');
            } else {
                sb.append(' ');
                sb.append(this.formatTime(estimated, false));
            }
        }
        return sb.toString();
    }

    private static String formatPercent(double x, int prec) {
        StringBuffer sb = new StringBuffer("##0");
        if (prec > 0) {
            sb.append('.');
        }
        for (int i = 0; i < prec; ++i) {
            sb.append('0');
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        return df.format(x) + "%";
    }

    public String formatTime(int t, boolean hours) {
        int m = t / 60;
        int s = t - 60 * m;
        int h = m / 60;
        if (hours || t >= 3600) {
            return HOURFMT.format(h) + ":" + MINFMT.format(m % 60) + ":" + SECFMT.format(s);
        }
        return MINFMT_LONG.format(m) + ":" + SECFMT.format(s);
    }

    static {
        SECFMT = NumberFormat.getIntegerInstance(Locale.US);
        SECFMT.setMinimumIntegerDigits(2);
        MINFMT = NumberFormat.getIntegerInstance(Locale.US);
        MINFMT.setMinimumIntegerDigits(2);
        HOURFMT = NumberFormat.getIntegerInstance(Locale.US);
        MINFMT_LONG = NumberFormat.getIntegerInstance(Locale.US);
        MINFMT_LONG.setMinimumIntegerDigits(2);
    }
}

