/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MolImporter;
import chemaxon.license.LicenseException;
import chemaxon.marvin.common.MDocPasteListener;
import chemaxon.marvin.io.ArrayMDocSource;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.io.MFieldAccessor;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.RewindableMDocSource;
import chemaxon.marvin.io.fieldaccess.MFieldAccessorWrapper;
import chemaxon.marvin.swing.ActionCheckBoxMenuItem;
import chemaxon.marvin.swing.ActionMenuItem;
import chemaxon.marvin.swing.BasicActions;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.marvin.view.CellType;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.SequentialScheduler;
import chemaxon.marvin.view.TaskScheduler;
import chemaxon.marvin.view.swing.CellFiller;
import chemaxon.marvin.view.swing.RecordFetcher;
import chemaxon.marvin.view.swing.SDFColoring;
import chemaxon.marvin.view.swing.TableOptions;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.VisibleDocuments;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class TableSupport {
    public final TaskScheduler scheduler;
    private static final int TMP_CACHE_SIZE = 512;
    private static final int SHOWMOL_PRESERVE_SETTINGS = 1;
    private static final int SHOWMOL_NO_HOURGLASS = 2;
    private SDFColoring sdfColoring = null;
    private Dimension cellSize = new Dimension(64, 64);
    private ViewPanel viewPanel = null;
    private TableOptions tableOptions = null;
    private final Action tableOptionsAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            TableSupport.this.tableOptions.showDialog();
        }
    };
    private boolean fieldsShownSet = false;
    private boolean nameShownSet = false;
    private boolean autoCacheSize = false;
    private int startAt = Integer.MAX_VALUE;
    private int maxSize = Integer.MIN_VALUE;
    private String inputName;
    private MDocStorage.Listener myStorageListener = new MDocStorage.Listener(){

        @Override
        public void docProduced(MDocStorage ds, MDocument doc, int i) {
        }

        @Override
        public void storageSizeChanged(MDocStorage ds, int oldsz, int newsz) {
            ViewHandler vh = TableSupport.this.viewPanel.getViewHandler();
            if (vh != null) {
                vh.storageSizeChanged(oldsz, newsz);
            }
        }

        @Override
        public void storageSizeFinalized(MDocStorage ds) {
            ViewHandler vh = TableSupport.this.viewPanel.getViewHandler();
            if (vh != null) {
                vh.storageSizeFinalized(ds.getSize());
            }
        }
    };
    private RecordFetcher.Listener myRFListener = new RecordFetcher.Listener(){

        @Override
        public void recordsRetrieved(final MDocStorage ds, VisibleDocuments oldvd, final VisibleDocuments vd) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        int irec = vd.getRecordIndex();
                        int nrec = vd.getNumDocuments();
                        for (int k = irec; k < irec + nrec; ++k) {
                            MDocument doc = vd.getMainDocument(k);
                            String label = ds.getDocLabel(k, doc);
                            TableSupport.this.fillCell(k, doc, label, ds.getSize());
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
        }
    };

    TableSupport(ViewPanel vpan) {
        this.viewPanel = vpan;
        this.scheduler = new TaskScheduler(){

            @Override
            public void invokeLater(Runnable task, int index) {
                ViewHandler vh = TableSupport.this.viewPanel.getViewHandler();
                RecordFetcher rf = vh.getRecordFetcher();
                rf.enqueueAccess(task, index, "user task", vh);
            }

            @Override
            public void invokeAndWait(Runnable task) throws InterruptedException, InvocationTargetException {
                ViewHandler vh = TableSupport.this.viewPanel.getViewHandler();
                RecordFetcher rf = vh.getRecordFetcher();
                rf.enqueueAccessAndWait(task, vh);
            }

            @Override
            public void waitForAll() throws InterruptedException {
                ViewHandler vh = TableSupport.this.viewPanel.getViewHandler();
                SequentialScheduler ss = vh.getScheduler();
                ss.waitForAll();
            }
        };
        this.sdfColoring = new SDFColoring(this.viewPanel, null, null);
        this.tableOptions = new TableOptions(vpan);
        this.tableOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TableSupport.this.enqueueUpdate();
            }
        });
        vpan.setCleanDim(vpan.getCleanDim());
        this.setFieldFont(null, this.tableOptions.getFieldFontSize());
        this.setFieldFont("$MolName", this.tableOptions.getMolNameFontSize());
        this.setFieldFont("$GenName", this.tableOptions.getGenNameFontSize());
        this.setFieldFont("$SMILES", this.tableOptions.getSMILESFontSize());
        this.autoCacheSize = this.getDocStorage().getCacheCapacity() == 0;
        this.viewPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                String name = ev.getPropertyName();
                if (name.equals("file")) {
                    File f = TableSupport.this.viewPanel.getFile();
                    TableSupport.this.tableOptions.setSubsetChangable(f != null);
                } else if (name.startsWith("doc")) {
                    int k = Integer.parseInt(name.substring(3));
                    MDocument doc = TableSupport.this.viewPanel.getDocument(k);
                    TableSupport.this.tableOptions.updateFields(doc);
                }
            }
        });
        this.viewPanel.addPasteListener(new MDocPasteListener(){

            @Override
            public void mdocsPasted(MDocument[] docs, int irec) {
                if (irec == 0 && TableSupport.this.viewPanel.getMolCount() == 1 && docs.length == 1) {
                    TableSupport.this.start(new ArrayMDocSource(docs), "Pasted Molecule");
                }
            }
        });
        SwingUtil.initAction(this.tableOptionsAction, BasicActions.RESOURCES, "options", null);
    }

    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    public void setCellSize(Dimension size) {
        this.cellSize.width = size.width;
        this.cellSize.height = size.height;
    }

    public void setSDFColoring(String tag, Properties props) {
        this.sdfColoring = new SDFColoring(this.viewPanel, tag, props);
    }

    public void start(MDocSource dsrc, String inputName) {
        this.viewPanel.beginHourglass();
        this.inputName = inputName;
        UpdateTask r = new UpdateTask(dsrc, inputName);
        ViewHandler vh = this.viewPanel.getViewHandler();
        SequentialScheduler ss = vh.getScheduler();
        ss.invokeLater(r, this.tableOptions.getStartAt() - 1, "showMolecules");
    }

    public void startNow(MDocSource dsrc, String inputName) throws InterruptedException, InvocationTargetException {
        this.viewPanel.beginHourglass();
        this.inputName = inputName;
        UpdateTask r = new UpdateTask(dsrc, inputName);
        ViewHandler vh = this.viewPanel.getViewHandler();
        SequentialScheduler ss = vh.getScheduler();
        ss.invokeAndWait(r);
    }

    public void enqueueUpdate() {
        this.viewPanel.beginHourglass();
        UpdateTask r = new UpdateTask();
        ViewHandler vh = this.viewPanel.getViewHandler();
        SequentialScheduler ss = vh.getScheduler();
        ss.invokeLater(r, this.tableOptions.getStartAt() - 1, "showMolecules");
    }

    public boolean setDocument(int k, MDocument doc) {
        return this.setDocument(k, doc, null);
    }

    public MDocStorage getDocStorage() {
        return this.viewPanel.getViewHandler().getStorage();
    }

    public Dimension getDefaultSize() {
        int rows = this.tableOptions.getMaxRows();
        int cols = this.tableOptions.getMaxCols();
        int vhtype = this.tableOptions.getViewHandlerType();
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension scr = tk.getScreenSize();
        int w = vhtype == 1 ? Math.min(32 + cols * 64, scr.width - 32) : 512;
        int h = Math.min(32 + rows * 64, scr.height - 96);
        return new Dimension(w, h);
    }

    public void makeTableMenu(Container menu) {
        JMenuItem mi = new ActionMenuItem(this.tableOptionsAction);
        menu.add(mi);
        ActionListener tbloptActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TableSupport.this.enqueueUpdate();
            }
        };
        mi = new ActionCheckBoxMenuItem(this.tableOptions.getFieldsShownAction());
        menu.add(mi);
        mi.addActionListener(tbloptActionListener);
        mi = new ActionCheckBoxMenuItem(this.tableOptions.getMolNameShownAction());
        menu.add(mi);
        mi.addActionListener(tbloptActionListener);
        mi = new ActionCheckBoxMenuItem(this.tableOptions.getGenNameShownAction());
        menu.add(mi);
        mi.addActionListener(tbloptActionListener);
        mi = new ActionCheckBoxMenuItem(this.tableOptions.getSMILESShownAction());
        menu.add(mi);
        mi.addActionListener(tbloptActionListener);
    }

    private void setTableMenusEnabled(boolean v) {
        this.tableOptions.getMolNameShownAction().setEnabled(v);
        this.tableOptions.getGenNameShownAction().setEnabled(v);
        this.tableOptions.getSMILESShownAction().setEnabled(v);
        this.tableOptions.getFieldsShownAction().setEnabled(v);
        this.tableOptionsAction.setEnabled(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMolecules(final MDocStorage ds, int opts) {
        if (ds.getSize() < 1) {
            return;
        }
        Color savedMolbg = this.viewPanel.getMolbg();
        String savedRendering = this.viewPanel.getRendering();
        String savedNavmode = this.viewPanel.getNavmode();
        ViewHandler vh = this.viewPanel.getViewHandler();
        final int topLeft0 = vh.getTopLeft();
        final int ncols0 = vh.getColumnCount();
        final int nr0 = vh.getNumRecordsInARow();
        final int topRow0 = topLeft0 / ncols0;
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = kfm.getFocusOwner();
        final boolean needFocusRequest = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, this.viewPanel);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TableSupport.this.setTableMenusEnabled(false);
                    TableSupport.this.viewPanel.setVisible(false);
                    TableSupport.this.initTable(ds.getSize(), ds, null);
                    ViewHandler vh = TableSupport.this.viewPanel.getViewHandler();
                    int ncols = vh.getColumnCount();
                    int nr = vh.getNumRecordsInARow();
                    int topLeft = ncols == ncols0 && nr == nr0 ? topLeft0 : topRow0 * nr0 / nr * ncols;
                    vh.setTopLeft(topLeft);
                }
            });
        }
        catch (InterruptedException ex) {
            System.err.println("TableSupport.showMolecules: " + ex.toString());
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            System.err.println("TableSupport.showMolecules:");
            t.printStackTrace();
        }
        int dim = Math.max(2, ds.getMaxDimCached());
        this.sdfColoring.init();
        vh.getCellFiller().setSDFColoring(this.sdfColoring);
        try {
            if ((opts & 2) == 0) {
                this.viewPanel.beginHourglass();
            }
            this.fillCells(ds);
        }
        finally {
            if ((opts & 2) == 0) {
                this.viewPanel.endHourglass();
            }
        }
        if ((opts & 1) != 0) {
            this.viewPanel.setMolbg(savedMolbg);
            this.viewPanel.setNavmode(savedNavmode);
            this.viewPanel.setRendering(savedRendering);
        } else if (dim != this.viewPanel.getCleanDim()) {
            this.viewPanel.setCleanDim(dim);
        }
        try {
            this.viewPanel.repaint();
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TableSupport.this.viewPanel.setVisible(true);
                    TableSupport.this.setTableMenusEnabled(true);
                    if (needFocusRequest) {
                        TableSupport.this.viewPanel.requestFocusInWindow();
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            System.err.println("TableSupport.showMolecules: " + ex.toString());
        }
        catch (InvocationTargetException ex) {
            System.err.println("TableSupport.showMolecules: " + ex.toString());
        }
    }

    private boolean setDocSource(MDocSource dsrc) throws InterruptedException {
        String title;
        String msg;
        int r;
        MPropertyContainer gpc;
        int cacheSize;
        this.startAt = this.tableOptions.getStartAt();
        this.maxSize = this.tableOptions.getMaxSize();
        MDocStorage ds = this.getDocStorage();
        ds.setSize(0);
        if (this.maxSize != 0) {
            cacheSize = this.maxSize;
        } else {
            int n = this.tableOptions.getMaxRows() * this.tableOptions.getMaxCols();
            cacheSize = 3 * n;
        }
        ds.setCacheCapacity(cacheSize);
        ds.removeListener(this.myStorageListener);
        MDocSource dp = dsrc != null ? (dsrc.isRewindable() ? dsrc : new RewindableMDocSource(dsrc, 512)) : null;
        this.tableOptions.setSubsetChangable(dp != null);
        ds.setDocSource(dp, this.startAt - 1, this.maxSize);
        this.tableOptions.initFields();
        this.tableOptions.setListFont(this.viewPanel.getFieldFont(null));
        if (this.viewPanel.getSaveGlobalGUIProperties() && (gpc = ds.getGlobalGUIProperties()) != null && gpc.size() > 0 && (r = JOptionPane.showConfirmDialog(this.viewPanel, msg = "The input file includes GUI settings for Marvin.\nAre you sure to overwrite current settings with the input file stored ones?", title = "Overwrite GUI settings", 0)) == 0) {
            this.viewPanel.setGlobalGUIProperties(gpc);
        }
        final MDocStorage fds = ds;
        final int fcacheSize = cacheSize;
        Runnable r2 = new Runnable(){

            @Override
            public void run() {
                MDocStorage ds = fds;
                int start = TableSupport.this.tableOptions.getStartAt() - 1;
                int cacheSize = fcacheSize;
                try {
                    MDocument doc;
                    for (int k = 0; k < cacheSize && (doc = ds.getMainDoc(k)) != null; ++k) {
                        TableSupport.this.tableOptions.updateFields(doc);
                    }
                    if (ds.getSize() == cacheSize && TableSupport.this.maxSize == 0) {
                        ds.setSize((cacheSize * 3 + 2) / 2);
                    }
                }
                catch (MDocStorage.RecordUnavailableException ex) {
                    TableSupport.this.maxSize = ds.getSize();
                }
                catch (IOException ex) {
                    TableSupport.this.maxSize = ds.getSize();
                    TableSupport.this.viewPanel.getErrorDisplay().error("Read error after molecule " + ds.getSize() + ":\n" + ex.getMessage(), ex);
                }
            }
        };
        ViewHandler viewhnd = this.viewPanel.getViewHandler();
        RecordFetcher rf = viewhnd.getRecordFetcher();
        SequentialScheduler scheduler = rf.getScheduler();
        if (scheduler.isTaskThread()) {
            r2.run();
        } else {
            scheduler.invokeLater(r2, 0, "initial molecule file reading");
            scheduler.waitForAll();
        }
        ds.addListener(this.myStorageListener);
        this.myStorageListener.storageSizeChanged(ds, 0, ds.getSize());
        return ds.getSize() > 0;
    }

    private boolean[] examine(MProgressMonitor pmon) {
        int nrecs = 4;
        boolean hasFields = false;
        boolean hasName = false;
        boolean nameIsRecNum = false;
        try {
            MDocStorage ds = this.getDocStorage();
            int off = ds.getOffset();
            if (ds.getSize() == 0) {
                return null;
            }
            for (int i = 0; i < nrecs && i < ds.getSize(); ++i) {
                MDocument doc = ds.getMainDoc(i, pmon);
                if (doc == null) {
                    if (i == 0) {
                        return null;
                    }
                    break;
                }
                Molecule m = (Molecule)doc.getMainMoleculeGraph();
                int n = m.getPropertyCount();
                hasFields |= n > 0;
                String name = m.getName().trim();
                hasName |= name.length() != 0;
                if (i != 0 && !nameIsRecNum) continue;
                nameIsRecNum = name.equals(String.valueOf(off + i + 1));
            }
        }
        catch (MDocStorage.RecordUnavailableException ex) {
        }
        catch (MDocStorage.CancellationException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        return new boolean[]{hasFields, hasName && !nameIsRecNum};
    }

    private void initTable(int size, MDocStorage ds, MProgressMonitor pmon) {
        this.initTable0(size, ds, pmon);
    }

    private void initTable0(int size, MDocStorage ds, MProgressMonitor pmon) {
        boolean[] res;
        TableOptions topts = this.tableOptions;
        int vh = topts.getViewHandlerType();
        if (vh == 0) {
            vh = this.getFormatDefaultView(ds);
        }
        if (!(vh != 0 && this.nameShownSet || (res = this.examine(pmon)) == null)) {
            boolean hasFields = res[0];
            if (vh == 0) {
                vh = hasFields ? 2 : 1;
            }
            boolean hasName = res[1];
            if (!this.nameShownSet && !topts.isMolNameShown()) {
                topts.setMolNameShown(hasName);
                this.nameShownSet = true;
            }
            if (!this.fieldsShownSet && !topts.getFieldsShown()) {
                topts.setFieldsShown(vh == 2);
                this.fieldsShownSet = true;
            }
        }
        this.setFieldFont(null, topts.getFieldFontSize());
        this.setFieldFont("$MolName", topts.getMolNameFontSize());
        this.setFieldFont("$GenName", topts.getGenNameFontSize());
        this.setFieldFont("$SMILES", topts.getSMILESFontSize());
        ViewHandler viewhnd = this.viewPanel.getViewHandler();
        int maxSize = topts.getMaxSize();
        RecordFetcher rf = viewhnd.getRecordFetcher();
        rf.setEndRecordIndex(maxSize != 0 ? topts.getStartAt() + maxSize - 1 : Integer.MAX_VALUE);
        if (vh == 2) {
            this.initSpreadsheetView(this.viewPanel, ds);
        } else if (vh == 1) {
            this.initGridBagView(this.viewPanel, size, ds);
        }
        viewhnd = this.viewPanel.getViewHandler();
        rf = viewhnd.getRecordFetcher();
        rf.removeListener(this.myRFListener);
        rf.addListener(this.myRFListener);
        CellFiller cf = viewhnd.getCellFiller();
        cf.setSDFColoring(this.sdfColoring);
        cf.setSingleCellLabelShown(topts.isSingleCellLabelShown());
        cf.setMolNameShown(topts.isMolNameShown());
        cf.setGenNameShown(topts.isGenNameShown());
        cf.setSMILESShown(topts.isSMILESShown());
        cf.setFieldsShown(topts.getFieldsShown());
        cf.setSelectedFields(topts.getSelectedFields());
        this.initCache();
    }

    private int getFormatDefaultView(MDocStorage ds) {
        MolImporter molImporter;
        MolImportModule molImportModule;
        if (ds == null) {
            return 0;
        }
        MDocSource source = ds.getDocSource();
        if (source instanceof MolImporter && (molImportModule = (molImporter = (MolImporter)source).getMolImportModule()) != null) {
            switch (molImportModule.getPreferredView()) {
                case Default: {
                    return 0;
                }
                case Matrix: {
                    return 1;
                }
                case Spreadsheet: {
                    return 2;
                }
            }
        }
        return 0;
    }

    private void setFieldFont(String key, int sz) {
        Font f0 = this.viewPanel.getFieldFont(key);
        Font f = f0 == null ? new Font("Dialog", 0, sz) : new Font(f0.getName(), f0.getStyle(), sz);
        this.viewPanel.setFieldFont(key, f);
    }

    private void initGridBagView(ViewPanel vpan, int size, MDocStorage ds) {
        int vCols = this.tableOptions.getMaxCols();
        int vRows = this.tableOptions.getMaxRows();
        int cols = size < vCols ? size : vCols;
        int rows = size % cols == 0 ? size / cols : size / cols + 1;
        int actualVRows = rows < vRows && (ds == null || ds.isSizeFinal()) ? rows : vRows;
        int actualVCols = cols < vCols ? cols : vCols;
        int row = 0;
        boolean shMolname = this.tableOptions.isMolNameShown();
        boolean shGenName = this.tableOptions.isGenNameShown();
        boolean shSmiles = this.tableOptions.isSMILESShown();
        boolean shFields = this.tableOptions.getFieldsShown();
        int nf = shFields ? this.tableOptions.getSelectedFields().length : 0;
        int fieldFontSize = this.tableOptions.getFieldFontSize();
        int molnameFontSize = this.tableOptions.getMolNameFontSize();
        int iupacNameFontSize = this.tableOptions.getGenNameFontSize();
        int smilesFontSize = this.tableOptions.getSMILESFontSize();
        boolean showLabels = this.tableOptions.isSingleCellLabelShown() || size > 1;
        Properties params = new Properties();
        params.setProperty("viewhandler", "GridBagView");
        params.setProperty("rows", "0");
        params.setProperty("cols", "" + cols);
        params.setProperty("visiblecols", "" + actualVCols);
        params.setProperty("visiblerows", "" + actualVRows);
        int nfl = 2 + nf;
        if (shMolname) {
            ++nfl;
        }
        if (shGenName) {
            ++nfl;
        }
        if (shSmiles) {
            ++nfl;
        }
        params.setProperty("layout", ":" + nfl + ":1" + (showLabels ? ":L:" + row++ + ":0:1:1:c:h:0:0" : "") + ":M:" + row++ + ":0:1:1:c:b:1:1" + (shMolname ? ":T:" + row++ + ":0:1:1:nw:h:0:0" : "") + (shGenName ? ":T:" + row++ + ":0:1:1:nw:h:0:0" : "") + (shSmiles ? ":T:" + row++ + ":0:1:1:nw:h:0:0" : "") + (shFields && nf != 0 ? ":T:" + row++ + ":0:" + nf + ":1:nw:b:0:0" : ""));
        params.setProperty("param", (showLabels ? ":L:10b" : "") + ":M:" + this.cellSize.width + ":" + this.cellSize.height + (shMolname ? ":T:" + molnameFontSize + ":10:r" : "") + (shGenName ? ":T:" + iupacNameFontSize + ":10:r" : "") + (shSmiles ? ":T:" + smilesFontSize + ":10:r" : "") + (shFields && nf != 0 ? ":T:" + fieldFontSize + ":10:r" : ""));
        vpan.setProperties(params);
        if (ds != null) {
            ds.removeListener(this.myStorageListener);
            ds.addListener(this.myStorageListener);
        }
        RecordFetcher rf = vpan.getViewHandler().getRecordFetcher();
        rf.setPrereadListeners(new Runnable(){

            @Override
            public void run() {
                TableSupport.this.setTableMenusEnabled(false);
            }
        }, new Runnable(){

            @Override
            public void run() {
                TableSupport.this.setTableMenusEnabled(true);
            }
        });
    }

    private void initSpreadsheetView(ViewPanel vpan, MDocStorage ds) {
        MFieldAccessor fa;
        int h = this.tableOptions.getRowHeight();
        int w = this.tableOptions.getColumnWidth();
        Properties params = new Properties();
        StringBuffer sb = new StringBuffer("SpreadsheetView:#");
        int mmf = this.tableOptions.getMainMolFieldness();
        if ((mmf & 2) != 0 || mmf == 0 && ds != null && ds.getSize() != 0 && ds.getDocSource() == null) {
            sb.append(",M");
        }
        boolean fixed = false;
        if (this.tableOptions.isMolNameShown()) {
            fixed = this.fixColumns(fixed, sb);
            sb.append(",T:$MolName");
        }
        if (this.tableOptions.isGenNameShown()) {
            fixed = this.fixColumns(fixed, sb);
            sb.append(",T:$GenName");
        }
        if (this.tableOptions.isSMILESShown()) {
            fixed = this.fixColumns(fixed, sb);
            sb.append(",T:$SMILES");
        }
        if (!((fa = this.getDocStorage().getFieldAccessor()) instanceof MFieldAccessorWrapper)) {
            fa = new MFieldAccessorWrapper(fa);
            this.getDocStorage().setFieldAccessor(fa);
        }
        MFieldAccessorWrapper xfa = (MFieldAccessorWrapper)fa;
        xfa.setMolNameEnabled(this.tableOptions.isMolNameShown());
        xfa.setGenNameEnabled(this.tableOptions.isGenNameShown());
        xfa.setSMILESEnabled(this.tableOptions.isSMILESShown());
        if (this.tableOptions.getFieldsShown()) {
            String[] incFields = this.tableOptions.getSelectedFields();
            CellType[] types = this.tableOptions.getSelectedFieldTypes();
            for (int i = 0; i < incFields.length; ++i) {
                fixed = this.fixColumns(fixed, sb);
                String typestr = ",T:";
                if (types[i] == CellType.MOLECULE) {
                    typestr = ",M:";
                }
                sb.append(typestr);
                String s = EncodingUtil.escape(incFields[i], 2);
                sb.append(s);
            }
        }
        params.setProperty("viewhandler", sb.toString());
        params.setProperty("rowheight", String.valueOf(h));
        params.setProperty("columnwidth", String.valueOf(w));
        params.setProperty("columnwidths", this.tableOptions.getColumnWidthsString());
        vpan.setProperties(params);
    }

    private boolean fixColumns(boolean fixed, StringBuffer sb) {
        if (!fixed) {
            sb.append(",|");
            fixed = true;
        }
        return fixed;
    }

    private void fillCells(MDocStorage ds) {
        int n = ds.getSize();
        int[] indices = ds.getCachedDocIndices();
        MDialogProgressMonitor pmon = new MDialogProgressMonitor(this.viewPanel, "Reading input");
        for (int i = 0; i < indices.length; ++i) {
            int k = indices[i];
            MDocument doc = null;
            try {
                doc = ds.getMainDoc(k, pmon);
            }
            catch (MDocStorage.RecordUnavailableException ex) {
                this.viewPanel.getErrorDisplay().error("Cannot get non-existent record", ex);
            }
            catch (MDocStorage.CancellationException ex) {
                this.viewPanel.getErrorDisplay().error("Cannot get record because operation was cancelled", ex);
            }
            catch (IOException ex) {
                this.viewPanel.getErrorDisplay().error("Read error before getting molecule " + k + ":\n" + ex.getMessage(), ex);
            }
            if (doc == null) continue;
            String label = ds.getDocLabel(k, doc);
            this.fillCell(k, doc, label, n);
        }
        this.viewPanel.requestFocus();
    }

    private boolean setDocument(int k, MDocument doc, String label) {
        ViewHandler vh = this.viewPanel.getViewHandler();
        if (vh != null) {
            int n = vh.getNumRecords();
            MDocStorage ds = vh.getStorage();
            if (label == null) {
                label = ds.getDocLabel(k, doc);
            }
            this.fillCell(k, doc, label, n);
            return true;
        }
        return false;
    }

    private void fillCell(int k, MDocument doc, String label, int n) {
        ViewHandler vh = this.viewPanel.getViewHandler();
        if (vh != null) {
            CellFiller cf = vh.getCellFiller();
            if (cf.getSDFColoring() == null) {
                cf.setSDFColoring(this.sdfColoring);
            }
            TableOptions topts = this.tableOptions;
            int nf0 = topts.getSelectedFieldCount();
            cf.fillCellInViewApp(k, doc, label, n);
            int nf = topts.getSelectedFieldCount();
            if (nf > nf0 && this.tableOptions.getFieldsShown()) {
                this.enqueueUpdate();
            }
        }
    }

    private void initCache() {
        if (!this.autoCacheSize) {
            return;
        }
        MDocStorage ds = this.getDocStorage();
        if (this.tableOptions.getMaxSize() != 0) {
            ds.setCacheCapacity(this.tableOptions.getMaxSize());
        } else {
            int sz = 3 * this.tableOptions.getMaxRows() * this.tableOptions.getMaxCols();
            ds.setCacheCapacity(Math.max(sz, 100));
        }
    }

    private class UpdateTask
    implements Runnable {
        private boolean update;
        private String inputName;
        private MDocSource docSource;

        public UpdateTask() {
            this(true, tableSupport.getDocStorage().getDocSource(), null);
        }

        public UpdateTask(MDocSource dsrc, String name) {
            this(false, dsrc, name);
        }

        private UpdateTask(boolean u, MDocSource dsrc, String name) {
            this.update = u;
            this.docSource = dsrc;
            this.inputName = name != null ? name : TableSupport.this.inputName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.run0();
            }
            finally {
                TableSupport.this.viewPanel.endHourglass();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run0() {
            MDocStorage ds = null;
            if (this.update && TableSupport.this.tableOptions.getStartAt() == TableSupport.this.startAt && TableSupport.this.tableOptions.getMaxSize() == TableSupport.this.maxSize) {
                ds = TableSupport.this.getDocStorage();
            } else {
                try {
                    ds = TableSupport.this.setDocSource(this.docSource) ? TableSupport.this.getDocStorage() : null;
                }
                catch (LicenseException lex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TableSupport.this.viewPanel.getErrorDisplay().error(lex.getMessage(), lex);
                        }
                    });
                }
                catch (Exception ex) {
                    final StringBuffer s = new StringBuffer("Error during molecule display: " + ex);
                    if (!"unknown".equals(this.inputName)) {
                        s.append("\nCannot load structures from " + this.inputName + ".");
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TableSupport.this.viewPanel.getErrorDisplay().error(s.toString(), ex);
                        }
                    });
                }
            }
            if (ds != null) {
                TableSupport.this.viewPanel.beginHourglass();
                try {
                    TableSupport.this.showMolecules(TableSupport.this.getDocStorage(), 1);
                }
                finally {
                    TableSupport.this.viewPanel.endHourglass();
                }
            } else {
                TableSupport.this.initTable(1, null, null);
            }
        }
    }
}

