/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.marvin.common.swing.DnD;
import chemaxon.marvin.common.swing.MolCanvas;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.swing.BasicActions;
import chemaxon.marvin.swing.ExportGraphics;
import chemaxon.marvin.swing.MAction;
import chemaxon.marvin.swing.SaveImageTool;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.modules.MViewFrame;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PageSettings;
import chemaxon.struc.graphics.MMoleculeMovie;
import chemaxon.util.ImageExportUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class ViewCanvas
extends MolCanvas
implements MouseListener,
MouseMotionListener,
ActionListener,
PropertyChangeListener,
CallbackIface {
    private static final long serialVersionUID = 3979819797881974530L;
    private static final int MIN_WIDTH = 200;
    private static final int MIN_HEIGHT = 200;
    private static final int MAX_WIDTH = 600;
    private static final int MAX_HEIGHT = 600;
    private MAction windowAction;
    private MDocument document;
    private boolean inZoomWindow = false;
    private transient JPopupMenu currentPopup;
    private int markedAtom = -1;
    private int highlightedAtom = -1;
    protected ViewPanel viewPanel;
    private MViewFrame viewFrame;
    private transient DnD viewDnD;
    private int cellIndex;
    public static final Color ATOM_HIGHLIGHT_COLOR = new Color(200, 200, 255);
    public static final Color ATOM_MARK_COLOR = new Color(150, 150, 255);
    double winScale;
    private DPoint3 moleculeCenter = null;
    private Dimension preferredSize1 = null;
    private Dimension rsize = null;
    boolean error;
    private MolPainter painter;
    private Color moleculeBackground = null;
    private Vector nextV = new Vector();
    private transient CTransform3D savedTransform;
    private transient CTransform3D preTransform0 = null;
    private boolean isLowQuality = false;

    public ViewCanvas() {
        this.initTransient();
    }

    public ViewCanvas(ViewPanel vpan) {
        this(vpan, null, new MolPainter(vpan.painterCommon), -2);
    }

    public ViewCanvas(ViewPanel vpan, MDocument doc, MolPainter p, int icell) {
        this.windowAction = new MAction("window", ViewPanel.RESOURCES.getString("windowMenuLabel"));
        this.windowAction.addActionListener(this);
        this.viewPanel = vpan;
        this.document = doc;
        this.painter = p;
        this.cellIndex = icell;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.initTransient();
        this.setWinmode(0);
    }

    public boolean isSelected() {
        ViewPanel vpan = this.viewPanel;
        return vpan != null && vpan.getSelectedCellIndex() == this.cellIndex;
    }

    @Override
    public void setEnabled(boolean v) {
        boolean oldv = this.isEnabled();
        super.setEnabled(v);
        if (oldv && !v) {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        } else if (!oldv && v) {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }
    }

    public boolean isInWin() {
        return this.inZoomWindow;
    }

    public synchronized void setWinmode(int mode) {
        this.inZoomWindow = mode != 0;
        this.preferredSize1 = null;
    }

    public MAction getWindowAction() {
        return this.windowAction;
    }

    @Override
    public MolPainter getPainter() {
        return this.painter;
    }

    public void setMolbg(Color c) {
        this.moleculeBackground = c;
    }

    public MDocument getDocument() {
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(MDocument doc, MolPainter painter, int i) {
        this.resetAtomMark();
        if (painter != null) {
            Vector vector = this.nextV;
            synchronized (vector) {
                Object[] arr = new Object[]{doc, painter};
                this.nextV.addElement(arr);
            }
        } else {
            this.document = null;
        }
        this.cellIndex = i;
    }

    private void resetAtomMark() {
        if (this.markedAtom != -1) {
            this.viewPanel.doFireAtomMarkLocationChange(-1, -1);
            this.markedAtom = -1;
        }
    }

    void setDocumentImmediately(MDocument doc) {
        this.document = doc;
        this.resetAtomMark();
    }

    @Override
    public void paint(Graphics g) {
        MDocument doc = this.document;
        MMoleculeMovie mmm = doc != null ? doc.getMoleculeMovie() : null;
        this.paintGraphics(g, this.getSize(), false, 1.0, mmm != null ? mmm.getCurrentFrameIndex() : 0);
    }

    @Override
    public void update(Graphics g) {
        MDocument doc = this.document;
        MMoleculeMovie mmm = doc != null ? doc.getMoleculeMovie() : null;
        this.paintGraphics(g, this.getSize(), false, 1.0, mmm != null ? mmm.getCurrentFrameIndex() : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void paintGraphics(Graphics g, Dimension d, boolean saveImage, double relScale, int i) {
        var7_6 = this.nextV;
        synchronized (var7_6) {
            n = this.nextV.size() - 1;
            if (n >= 0) {
                arr = (Object[])this.nextV.elementAt(n);
                doc = (MDocument)arr[0];
                p = (MolPainter)arr[1];
                this.setDocumentAndPainter(doc, p, i);
                this.nextV.removeAllElements();
            }
        }
        painter0 = this.painter;
        if (d.width <= 0 || d.height <= 0 || painter0 == null || this.viewPanel == null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
            return;
        }
        dim = this.getDim();
        bg = this.moleculeBackground != null ? this.moleculeBackground : this.viewPanel.getMolbg(dim, this.cellIndex);
        rendering = this.viewPanel.getRendering(dim);
        painter0.setBackground(bg);
        if (!saveImage) {
            g.setColor(bg);
            g.fillRect(0, 0, d.width, d.height);
        }
        if (this.document != null && !this.error) {
            if (this.inZoomWindow) {
                painter0.setScreen(d);
                min = this.getPreferredSize();
                xscale = (double)d.width / (double)min.width;
                yscale = (double)d.height / (double)min.height;
                scale = Math.min(xscale, yscale);
                mag = scale * this.winScale;
                this.viewPanel.getViewHandler().setWinScale(this.cellIndex, mag);
            } else {
                mag = this.isMultipageEnabled() != false ? painter0.getScale() : ((x = this.viewPanel.getTabScale(true)) > 0.0 ? x : painter0.maxScale(d));
            }
            painter0.setScreen(d);
            painter0.setScale(mag);
            oldRendering = painter0.getCommon().getRendering();
            try {
                g2 = (Graphics2D)g;
                painter0.getCommon().setRendering(rendering);
                if (g2.getClip() == null) {
                    g2.setClip(0, 0, d.width, d.height);
                }
                painter0.paintDocument(g2, this.document, null);
                if (!this.isMultipageEnabled()) ** GOTO lbl65
                painter0.paintMultipage(g2, this.document);
                painter0.paintMultipageHeader(g2, this.document);
                if (this.inZoomWindow) ** GOTO lbl65
                painter0.paintMultipageInfo(g2, this.getSize(), ViewPanel.RESOURCES.getString("multipageInfo"));
            }
            catch (SecurityException sex) {
                this.viewPanel.getErrorDisplay().firewallError(sex, null);
            }
            finally {
                painter0.getCommon().setRendering(oldRendering);
            }
        } else {
            asc = g.getFontMetrics().getAscent();
            desc = g.getFontMetrics().getDescent();
            if (this.error) {
                g.drawString(this.document == null ? "cannot read molecule; invalid format" : "cannot read applet parameters", 0, asc);
                g.drawString("see Java Console", 0, 2 * asc + desc);
            } else {
                g.drawString("no molecule found", 0, asc);
            }
        }
lbl65:
        // 6 sources

        if (this.viewPanel.isSelectable() && this.isSelected() && !saveImage && (this.viewPanel.getMolCount() != 1 || Environment.APPLET)) {
            g.setColor(ColorCollection.isLight(bg) != false ? Color.blue : Color.orange);
            x0 = 1;
            y0 = 1;
            x1 = 1 + d.width / 10;
            y1 = 1 + d.height / 10;
            for (j = 0; j < 4; ++j) {
                if ((j & 1) == 1) {
                    x0 = d.width - 1 - x0;
                    x1 = d.width - 1 - x1;
                }
                if (j == 2) {
                    y0 = d.height - 1 - y0;
                    y1 = d.height - 1 - y1;
                }
                g.drawLine(x0, y0, x1, y0);
                g.drawLine(x0, y0, x0, y1);
            }
        }
        if (this.isLowQuality) {
            painter0.getCommon().setDispQuality(1);
            this.isLowQuality = false;
        }
        if (!this.isEnabled()) {
            c = new Color(bg.getRed(), bg.getGreen(), bg.getBlue(), 180);
            g.setColor(c);
            g.fillRect(0, 0, d.width, d.height);
        }
    }

    private void setDocumentAndPainter(MDocument doc, MolPainter p, int i) {
        MMoleculeMovie mmm;
        this.resetAtomMark();
        Dimension size = this.getSize();
        this.document = doc;
        if (doc == null) {
            doc = new MDocument(new Molecule());
        }
        if ((mmm = doc.getMoleculeMovie()) != null) {
            mmm.setCurrentFrameIndex(i);
        }
        this.painter = p;
        this.painter.setBoundsFor(doc);
        p.setScreen(size);
        p.setScale(p.maxScale(size));
        if (this.preTransform0 == null) {
            this.preTransform0 = new CTransform3D();
        }
        this.painter.getRTransform(this.preTransform0);
        if (doc.getPageSettings().isMultiPageEnabled()) {
            this.fitPage();
        }
    }

    int getDim() {
        return this.document != null ? this.document.getPrimaryMolecule().getDim() : 0;
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.viewPanel.getApplet() != null) {
            this.requestFocusInWindow();
        }
        try {
            this.viewPanel.showStatus("Right click for menu");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.highlightedAtom != -1) {
            this.document.clearCheckerMarks();
            this.highlightedAtom = -1;
            if (this.markedAtom != -1) {
                this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{this.document.getMainMoleculeGraph().getAtomArray()[this.markedAtom]}, null, ATOM_MARK_COLOR));
            }
            this.repaint();
        }
        try {
            this.viewPanel.showStatus("");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        int mod = ev.getModifiers();
        this.requestFocusInWindow();
        int clicks = ev.getClickCount();
        if ((mod & 0xFFFFFFEF) == 0) {
            if (clicks == 2) {
                this.viewPanel.doubleClick(this.cellIndex);
            } else if (clicks == 1) {
                Object object = this.viewPanel.getMolPanelLock();
                synchronized (object) {
                    if (this.viewPanel.isAtomMarkAndHighlightEnabled()) {
                        this.markAtom();
                    }
                    int i = this.cellIndex;
                    if (this.viewPanel.getSelectedCellIndex() == i && this.markedAtom == -1) {
                        i = -1;
                    }
                    this.viewPanel.setSelectedCellIndex(i);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        if (ev.isPopupTrigger() && this.viewPanel.arePopupMenusEnabled()) {
            this.viewPanel.setSelectedCellIndex(this.cellIndex);
            this.showPopup(ev);
        }
        if (!this.viewPanel.isAnimated(this.cellIndex)) {
            this.repaint();
        }
    }

    @Override
    public synchronized void mousePressed(MouseEvent ev) {
        boolean isPopupTrigger;
        if (!this.isEnabled()) {
            return;
        }
        this.viewPanel.updateCleanDim(this);
        this.initDrag(ev);
        boolean bl = isPopupTrigger = ev.isPopupTrigger() && this.viewPanel.arePopupMenusEnabled();
        if (this.popupVisible()) {
            this.currentPopup.setVisible(false);
            this.currentPopup = null;
        } else if (isPopupTrigger) {
            this.viewPanel.setSelectedCellIndex(this.cellIndex);
            this.showPopup(ev);
        }
        if (!isPopupTrigger) {
            this.savedTransform = this.painter.getRTransform();
        }
    }

    private boolean popupVisible() {
        return this.currentPopup != null && this.currentPopup.isVisible();
    }

    private void showPopup(MouseEvent ev) {
        JPopupMenu popup = new JPopupMenu();
        JMenu menu = this.viewPanel.createTransformMenu(true);
        popup.add(menu);
        this.viewPanel.addTransformViewMenuItems(menu, true, null);
        this.viewPanel.addAnimationMenu(popup, true, this.cellIndex, null);
        popup.addSeparator();
        this.viewPanel.addViewSubmenus(popup, true);
        popup.addSeparator();
        menu = BasicActions.createEditMenu(false);
        popup.add(menu);
        this.viewPanel.makeEditMenu(menu, true, null);
        menu = BasicActions.createStructureMenu(false);
        popup.add(menu);
        this.viewPanel.makeStructureMenu(menu, true, null);
        popup.addSeparator();
        if (this.document != null && this.document.getMoleculeMovie() == null) {
            this.viewPanel.makeSaveAsMenu(popup, true, null);
        }
        this.viewPanel.addPrintMenu(popup, true, null);
        if (!this.inZoomWindow) {
            popup.addSeparator();
            this.windowAction.addTo(popup, 44);
            this.windowAction.setEnabled(this.viewPanel.isDetachable());
            if (this.isMultipageEnabled()) {
                this.viewPanel.addPagesMenu(popup, true);
            }
            popup.addSeparator();
        }
        this.viewPanel.addHelpMenu(popup, true, null);
        MolPanel.setPopupHeavyWeight(popup);
        this.viewPanel.setAnimMenuItems(this.viewPanel.isAnimated(this.cellIndex), this.viewPanel.getAnimLength(this.cellIndex));
        popup.show(ev.getComponent(), ev.getX(), ev.getY());
        this.currentPopup = popup;
    }

    private void scale(double mag) {
        CTransform3D U2 = new CTransform3D();
        U2.setIdentity();
        U2.setScale(mag);
        this.transform(U2);
    }

    private void scroll(double dx, double dy) {
        CTransform3D U2 = new CTransform3D();
        U2.setIdentity();
        U2.setTranslation(dx, dy, 0.0);
        this.transform(U2);
    }

    public void centralize(PageSettings ps) {
        Dimension canvasSize = this.getSize();
        DPoint3 upperLeft = this.painter.getSelectedMultipageCell(ps);
        Dimension d = this.painter.getMultipageCellBounds(ps);
        double mag = this.painter.getScale() / 1.54;
        double dx = ((double)((canvasSize.width - d.width) / 2) - upperLeft.x) / mag;
        double dy = (upperLeft.y - (double)((canvasSize.height - d.height) / 2)) / mag;
        this.scroll(dx, dy);
    }

    public void fitPageWidth() {
        if (!this.isMultipageEnabled()) {
            return;
        }
        PageSettings ps = this.document.getPageSettings();
        DPoint3 oldUpperLeft = this.painter.getSelectedMultipageCell(ps);
        double m = this.painter.getWidthFitScale(this.getSize(), this.document);
        this.scale(m);
        DPoint3 upperLeft = this.painter.getSelectedMultipageCell(ps);
        double mag = this.painter.getScale() / 1.54;
        this.scroll((2.0 - upperLeft.x) / mag, (upperLeft.y - oldUpperLeft.y) / mag);
    }

    public void fitPageHeight() {
        if (!this.isMultipageEnabled()) {
            return;
        }
        Dimension canvasSize = this.getSize();
        if (!this.inZoomWindow) {
            canvasSize.height = (int)((double)canvasSize.height - (double)this.painter.getCommon().getBaseFont().getSize() * 1.5);
        }
        PageSettings ps = this.document.getPageSettings();
        DPoint3 oldUpperLeft = this.painter.getSelectedMultipageCell(ps);
        double m = this.painter.getHeightFitScale(canvasSize, this.document);
        this.scale(m);
        DPoint3 upperLeft = this.painter.getSelectedMultipageCell(ps);
        double mag = this.painter.getScale() / 1.54;
        this.scroll((oldUpperLeft.x - upperLeft.x) / mag, (upperLeft.y - 2.0) / mag);
    }

    public void fitPage() {
        if (!this.isMultipageEnabled()) {
            return;
        }
        Dimension canvasSize = this.getSize();
        if (!this.inZoomWindow) {
            canvasSize.height = (int)((double)canvasSize.height - (double)this.painter.getCommon().getBaseFont().getSize() * 1.5);
        }
        PageSettings ps = this.document.getPageSettings();
        double m1 = this.painter.getHeightFitScale(canvasSize, this.document);
        double m2 = this.painter.getWidthFitScale(canvasSize, this.document);
        double m = Math.min(m1, m2);
        this.scale(m);
        DPoint3 upperLeft = this.painter.getSelectedMultipageCell(ps);
        double mag = this.painter.getScale() / 1.54;
        Dimension pageSize = this.painter.getMultipageCellBounds(ps);
        if (m == m1) {
            this.scroll(((double)((canvasSize.width - pageSize.width) / 2) - upperLeft.x) / mag, (upperLeft.y - 2.0) / mag);
        } else {
            this.scroll((2.0 - upperLeft.x) / mag, (upperLeft.y - (double)((canvasSize.height - pageSize.height) / 2)) / mag);
        }
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        if (!this.viewPanel.isAtomMarkAndHighlightEnabled() || this.document == null) {
            return;
        }
        int diameter = (int)Math.round(2.0 * this.getPainter().getAtomSize() * this.getPainter().getRTransform().getScale() * this.getPainter().getScale() / 1.54);
        Rectangle hitBox = new Rectangle(ev.getX() - diameter / 2, ev.getY() - diameter / 2, diameter, diameter);
        int focused = -1;
        boolean found = false;
        double topZ = Double.MIN_VALUE;
        for (int i = 0; i < this.document.getMainMoleculeGraph().getAtomArray().length; ++i) {
            MolAtom atom = this.document.getMainMoleculeGraph().getAtomArray()[i];
            DPoint3 viewPoint = new DPoint3(atom.getX(), atom.getY(), atom.getZ());
            if (!hitBox.contains(this.getPainter().calcGP(viewPoint.x, viewPoint.y, viewPoint.z))) continue;
            this.getPainter().getTransformMatrix().transform(viewPoint);
            if (!found) {
                topZ = viewPoint.z;
                found = true;
                focused = i;
                continue;
            }
            if (!(viewPoint.z > topZ)) continue;
            focused = i;
        }
        this.highlightAtom(focused);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.viewPanel.isDraggable()) {
            return;
        }
        boolean animated = this.viewPanel.isAnimated(this.cellIndex);
        int mod = ev.getModifiers();
        double[] spin = null;
        ViewCanvas viewCanvas = this;
        synchronized (viewCanvas) {
            MDocument doc = this.document;
            if (doc != null && !doc.isEmpty() && !this.popupVisible()) {
                if (this.painter.getCommon().getDispQuality() == 1) {
                    this.isLowQuality = true;
                    this.painter.getCommon().setDispQuality(0);
                }
                double mag = this.painter.getScale();
                int nav = this.getNavMode();
                DPoint3 roto = this.calcTransformCenter(nav);
                int x = ev.getX();
                int y = ev.getY();
                CTransform3D U2 = new CTransform3D();
                U2.setIdentity();
                if ((mod & 2) != 0 || nav == 0) {
                    double dx = (double)(x - this.draggedPointerX) / mag;
                    double dy = (double)(this.draggedPointerY - y) / mag;
                    U2.setTranslation(dx, dy, 0.0);
                } else if ((mod & 1) != 0 || nav == 32) {
                    this.zoomRotate(ev, U2, true);
                    U2.setRotationCenter(roto);
                } else if (nav == 8) {
                    this.zoomRotate(ev, U2, false);
                    U2.setRotationCenter(roto);
                } else if (nav == 16) {
                    this.rotZ(ev, U2);
                    U2.setRotationCenter(roto);
                } else if (nav == 24) {
                    this.rot3D(ev, U2);
                    U2.setRotationCenter(roto);
                    if (animated && this.viewPanel.getDragToSpin()) {
                        long dt = Math.max(this.getDragTime(ev), 1L);
                        spin = new double[]{500.0 * this.dragPhi / (double)dt, this.dragPhiX, this.dragPhiY, 0.0};
                    }
                }
                if (spin == null) {
                    this.transform(U2);
                    if (this.preTransform0 == null) {
                        this.preTransform0 = new CTransform3D();
                    }
                    this.painter.getRTransform(this.preTransform0);
                }
            }
        }
        if (spin != null) {
            this.viewPanel.setSpin(this.cellIndex, spin);
        }
        if (this.document != null && this.document.getPageSettings().isMultiPageEnabled()) {
            this.painter.updateMultipage(this.document.getPageSettings(), this.getSize());
            if (this.viewFrame != null) {
                this.viewFrame.updateStatusBarSettings();
            }
        }
        this.repaint();
        this.draggedPointerX = ev.getX();
        this.draggedPointerY = ev.getY();
    }

    @Override
    public DPoint3 calcTransformCenter() {
        DPoint3 roto = new DPoint3();
        this.viewPanel.calcTransformedCenter(this.cellIndex, roto);
        return roto;
    }

    protected DPoint3 getCenter() {
        return this.moleculeCenter;
    }

    public void setCenter(DPoint3 o) {
        this.moleculeCenter = o;
    }

    public synchronized void calcTransformedCenter(DPoint3 roto) {
        DPoint3 p = this.moleculeCenter;
        if (p != null) {
            roto.x = p.x;
            roto.y = p.y;
            roto.z = p.z;
            CTransform3D t = this.painter.getRTransform();
            t.transform(roto);
        }
    }

    public synchronized void transform(CTransform3D u) {
        this.transform(u, false);
    }

    public synchronized void transform(CTransform3D u, boolean reScale) {
        this.painter.transform(u, reScale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd != null && cmd.equals("window")) {
            this.viewPanel.beginHourglass();
            try {
                this.viewPanel.setWinmode(1, this.cellIndex);
            }
            finally {
                this.viewPanel.endHourglass();
            }
        }
    }

    public synchronized void setReqScale(double m) {
        this.winScale = m;
        this.preferredSize1 = null;
    }

    public Dimension getReqSize() {
        return this.rsize;
    }

    public synchronized void setReqSize(Dimension d) {
        boolean autoTabScale = this.viewPanel != null && this.viewPanel.getAutoTabScale();
        this.rsize = d;
        if (this.painter != null && !autoTabScale) {
            this.painter.setBoundsFor(this.document);
            this.painter.setScreen(d);
            this.painter.setScale(this.painter.maxScale(d));
        }
        this.preferredSize1 = null;
    }

    private Dimension calcMultipagePreferredSize(MDocument doc) {
        Dimension d = new Dimension();
        Dimension pageSize = this.painter.getMultipageCellBounds(doc.getPageSettings());
        double m1 = 196.0 / (double)pageSize.width;
        double m2 = 196.0 / (double)pageSize.height;
        this.winScale = Math.min(m1, m2) * this.painter.getScale();
        pageSize.width = (int)((double)pageSize.width * this.winScale);
        pageSize.height = (int)((double)pageSize.height * this.winScale);
        d.width = 200;
        d.height = 200;
        this.fitPage();
        return d;
    }

    @Override
    public Dimension getPreferredSize() {
        double tabScale = this.viewPanel != null ? this.viewPanel.getTabScale(true) : -1.0;
        boolean autoTabScale = this.viewPanel != null && this.viewPanel.getAutoTabScale();
        boolean onlyOne = this.viewPanel != null && this.viewPanel.getCellCount() == 1;
        boolean inWin = this.inZoomWindow;
        if (inWin || tabScale > 0.0 && !autoTabScale && onlyOne) {
            double x = inWin ? this.winScale : tabScale;
            Dimension d = this.preferredSize1;
            if (d == null) {
                MDocument doc = this.document;
                if (doc == null) {
                    d = this.rsize;
                } else {
                    this.painter.setScale(x);
                    this.painter.setBoundsFor(doc);
                    Rectangle r = this.painter.getBounds();
                    d = new Dimension(inWin && r.width < 200 ? 200 : r.width, inWin && r.height < 200 ? 200 : r.height);
                    if (inWin && (r.width > 600 || r.height > 600)) {
                        double mw = 600.0 / (double)r.width;
                        double mh = 600.0 / (double)r.height;
                        double m = Math.min(mh, mw);
                        this.winScale = this.painter.getScale() * m;
                        d.width = 600;
                        d.height = 600;
                    }
                    if (doc.getPageSettings().isMultiPageEnabled()) {
                        d = this.calcMultipagePreferredSize(doc);
                    }
                }
                this.preferredSize1 = d;
            }
            return d;
        }
        if (this.rsize == null) {
            throw new RuntimeException("ViewCanvas.getPreferredSize() returns null because setReqSize had not been called");
        }
        if (this.document == null) {
            return this.rsize;
        }
        if (this.document.getPageSettings().isMultiPageEnabled()) {
            Dimension d;
            this.preferredSize1 = d = this.calcMultipagePreferredSize(this.document);
            this.rsize = d;
        }
        return this.rsize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    void clean(int dim) {
        try {
            this.viewPanel.clean0(this.cellIndex, dim, true);
            this.repaint();
        }
        catch (SecurityException sex) {
            this.viewPanel.getErrorDisplay().firewallError(sex, null);
        }
        catch (Throwable ex) {
            this.viewPanel.getErrorDisplay().error("Error in module Clean" + dim + "D", ex);
        }
    }

    public int getCellIndex() {
        return this.cellIndex;
    }

    public int getAnimLength() {
        MDocument doc = this.document;
        MMoleculeMovie mmm = doc != null ? doc.getMoleculeMovie() : null;
        return mmm != null ? mmm.getMoleculeCount() : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewind() {
        ViewCanvas viewCanvas = this;
        synchronized (viewCanvas) {
            MMoleculeMovie mmm = this.document.getMoleculeMovie();
            if (mmm != null) {
                mmm.setCurrentFrameIndex(0);
            }
            if (this.preTransform0 != null) {
                this.painter.setRTransform(this.preTransform0);
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimIndex(int i) {
        ViewCanvas viewCanvas = this;
        synchronized (viewCanvas) {
            MMoleculeMovie mmm = this.document.getMoleculeMovie();
            if (mmm != null) {
                mmm.setCurrentFrameIndex(i);
            }
            if (i == 0) {
                if (this.preTransform0 == null) {
                    this.preTransform0 = new CTransform3D();
                }
                this.painter.getRTransform(this.preTransform0);
            }
        }
        this.repaint();
    }

    public int getAnimIndex() {
        MDocument doc = this.document;
        if (doc == null) {
            return 0;
        }
        MMoleculeMovie mmm = doc.getMoleculeMovie();
        return mmm != null ? mmm.getCurrentFrameIndex() : 0;
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setTransform")) {
            this.painter.setRTransform((CTransform3D)arg);
            this.repaint();
        } else if (method.equals("canbeDnDdrag")) {
            int navopts = (this.viewPanel.getDispopts() & 0x38) >> 3;
            MDocument doc = this.document;
            if (doc != null && !this.popupVisible() && navopts == 0) {
                return new Boolean(true);
            }
        } else if (method.equals("startrot")) {
            ViewHandler vh = this.viewPanel.getViewHandler();
            CallbackIface c = (CallbackIface)((Object)vh.getFrame(this.cellIndex));
            this.viewPanel.setAnimatedIfNeeded(this.cellIndex);
            if (c != null) {
                c.callback(method, arg);
            }
        } else if (method.equals("stoprot")) {
            ViewHandler vh = this.viewPanel.getViewHandler();
            CallbackIface c = (CallbackIface)((Object)vh.getFrame(this.cellIndex));
            this.viewPanel.setAnimatedIfNeeded(this.cellIndex);
            if (c != null) {
                c.callback(method, arg);
            }
        } else {
            if (method.equals("getSavedTransform")) {
                return this.savedTransform;
            }
            if (method.equals("getIndex")) {
                return new Integer(this.cellIndex);
            }
            if (method.equals("debug")) {
                int d = this.viewPanel.getDebug();
                DnD dnd = this.viewDnD;
                if (dnd != null) {
                    dnd.setDebug(d);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveImage() {
        block17: {
            try {
                Dimension d = this.getSize();
                int n = this.getAnimLength();
                if (this.viewPanel.isAnimated(this.cellIndex)) {
                    if (n == 1) {
                        n = this.viewPanel.getSpinAnimLength(this.cellIndex);
                    }
                } else {
                    n = 1;
                }
                SaveImageTool sit = this.viewPanel.getSaveImageTool();
                Object[] imgs = sit.createInitialImages(d, this.viewPanel.getMolbg(), this.painter.getScale(), n);
                if (sit.getFormat() != null && sit.getFormat().equals("emf") && Environment.MSWINDOWS) {
                    boolean success = false;
                    Molecule m = this.viewPanel.getDocument(this.cellIndex).getPrimaryMolecule();
                    boolean tmp = this.viewPanel.getSaveGlobalGUIProperties();
                    this.viewPanel.setSaveGlobalGUIProperties(true);
                    Properties props = ImageExportUtil.mergeProperties(this.viewPanel.getUserSettings(), this.viewPanel.getGlobalGUIProperties(), new Rectangle(sit.getImageSize()));
                    props.setProperty("transbg", Boolean.toString(sit.isTransparent()));
                    this.viewPanel.setSaveGlobalGUIProperties(tmp);
                    String params = ImageExportUtil.createImageExporterParameter(props, "emf", m.getDocument());
                    success = ImageExportUtil.generateEMFToFile(m.toFormat("mrv"), params, sit.getImageFile().getAbsolutePath());
                    if (success) {
                        this.viewPanel.setSaveCwdToUserSettings(sit.getImageFile());
                        return;
                    }
                }
                if (imgs == null) break block17;
                double relmag = sit.getMagnification();
                MarvinModule r = this.viewPanel.getAnimatorForSaving(this.cellIndex);
                ViewCanvas viewCanvas = this;
                synchronized (viewCanvas) {
                    if (this.preTransform0 != null) {
                        this.painter.setRTransform(this.preTransform0);
                    }
                    for (int i = 0; i < n; ++i) {
                        int j;
                        Graphics2D g;
                        if (imgs[0] instanceof Graphics2D) {
                            g = (Graphics2D)imgs[i];
                        } else if (imgs[0] instanceof ExportGraphics) {
                            Object mm = sit.getExportModule();
                            g = ((ExportGraphics)imgs[i]).getGraphics2D((CallbackIface)mm);
                        } else {
                            g = (Graphics2D)((Image)imgs[i]).getGraphics();
                        }
                        int n2 = j = n == 1 ? this.getAnimIndex() : i;
                        if (r != null) {
                            r.modfunc("next");
                        }
                        boolean oldTransparency = this.getPainter().isTransparent();
                        this.getPainter().setTransparent(sit.isTransparent());
                        this.paintGraphics(g, d, true, relmag, j);
                        this.getPainter().setTransparent(oldTransparency);
                    }
                }
                sit.exportImage(imgs);
            }
            catch (OutOfMemoryError er) {
                this.viewPanel.getErrorDisplay().error("Image size error.\nReduce the scale parameter's value.", er);
            }
        }
    }

    public synchronized DnD getDnD() {
        String jver;
        if (this.viewDnD == null && this.viewPanel != null && !(jver = System.getProperty("java.version")).startsWith("1.1")) {
            this.viewDnD = new DnD("view.swing.ViewDnD", this, this.viewPanel, this.viewPanel, 3, "ACTION_COPY", this.viewPanel.getDebug());
        }
        return this.viewDnD;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String name = ev.getPropertyName();
        if (name.equals("navmode")) {
            Cursor cc = this.viewPanel.getCurrentCursor();
            if (cc.equals(Cursor.getPredefinedCursor(3))) {
                cc = Cursor.getDefaultCursor();
            }
            this.setCursor(cc);
        } else if (name.equals("tabScale")) {
            this.preferredSize1 = null;
        }
    }

    public void initCellRendering() {
        this.preTransform0 = null;
        this.savedTransform = null;
    }

    public void initTransient() {
        if (this.viewPanel != null) {
            this.viewPanel.addPropertyChangeListener(this);
        }
        this.viewDnD = null;
        if (this.viewPanel != null) {
            this.getDnD();
        }
    }

    protected void removeFromListeners() {
        this.viewPanel.removePropertyChangeListener(this);
        this.windowAction.removeActionListener(this);
    }

    public void removePopupMenu() {
        this.currentPopup = null;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        if (this.viewPanel != null) {
            this.viewPanel.removePropertyChangeListener(this);
        }
        this.viewDnD = null;
        out.defaultWriteObject();
        this.initTransient();
    }

    public void setViewFrame(MViewFrame frame) {
        this.viewFrame = frame;
    }

    public void resetView() {
        this.painter.resetMolPainter();
        this.preferredSize1 = null;
        if (this.isMultipageEnabled()) {
            this.fitPage();
        } else {
            this.painter.setBoundsFor(this.document);
        }
        this.repaint();
    }

    public boolean isMultipageEnabled() {
        if (this.document == null) {
            return false;
        }
        return this.document.getPageSettings().isMultiPageEnabled();
    }

    public void previousPage() {
        if (!this.isMultipageEnabled()) {
            return;
        }
        PageSettings ps = this.document.getPageSettings();
        int previousPage = ps.getSelectedPage() - 1;
        if (previousPage >= 0) {
            ps.setSelectedPage(previousPage);
        } else {
            ps.setSelectedPage(0);
        }
        this.centralize(ps);
        this.repaint();
    }

    public void nextPage() {
        int lastPage;
        if (!this.isMultipageEnabled()) {
            return;
        }
        PageSettings ps = this.document.getPageSettings();
        int nextPage = ps.getSelectedPage() + 1;
        if (nextPage <= (lastPage = ps.getColumnCount() * ps.getRowCount() - 1)) {
            ps.setSelectedPage(nextPage);
        } else {
            ps.setSelectedPage(lastPage);
        }
        this.centralize(ps);
        this.repaint();
    }

    public void firstPage() {
        if (!this.isMultipageEnabled()) {
            return;
        }
        PageSettings ps = this.document.getPageSettings();
        ps.setSelectedPage(0);
        this.centralize(ps);
        this.repaint();
    }

    public void lastPage() {
        if (!this.isMultipageEnabled()) {
            return;
        }
        PageSettings ps = this.document.getPageSettings();
        ps.setSelectedPage(ps.getColumnCount() * ps.getRowCount() - 1);
        this.centralize(ps);
        this.repaint();
    }

    private void markAtom() {
        if (this.document != null) {
            if (this.highlightedAtom == this.markedAtom && this.highlightedAtom != -1) {
                return;
            }
            this.document.clearCheckerMarks();
            if (this.highlightedAtom == -1 && this.markedAtom != -1) {
                this.viewPanel.doFireAtomMarkLocationChange(-1, -1);
                this.markedAtom = -1;
            } else if (this.highlightedAtom != -1) {
                this.markedAtom = this.highlightedAtom;
                this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{this.document.getMainMoleculeGraph().getAtomArray()[this.markedAtom]}, null, ATOM_MARK_COLOR));
                this.viewPanel.doFireAtomMarkLocationChange(this.cellIndex, this.markedAtom);
            } else if (this.highlightedAtom == -1 && this.viewPanel.getOldMarkedCell() != -1 && this.viewPanel.getOldMarkedAtom() != -1) {
                this.viewPanel.doFireAtomMarkLocationChange(-1, -1);
            }
            this.repaint();
        }
    }

    public void markAtom(int atomNumber) {
        if (!this.viewPanel.isAtomMarkAndHighlightEnabled()) {
            return;
        }
        this.highlightAtom(atomNumber);
        this.markAtom();
    }

    public void removeAtomMark(boolean firePropertyChange) {
        if (this.document == null) {
            return;
        }
        if (this.markedAtom == -1) {
            return;
        }
        if (firePropertyChange) {
            this.viewPanel.doFireAtomMarkLocationChange(-1, -1);
        }
        this.markedAtom = -1;
        this.highlightedAtom = -1;
        this.document.clearCheckerMarks();
        this.repaint();
    }

    public void highlightAtom(int atomNumber) {
        if (atomNumber == this.highlightedAtom) {
            return;
        }
        if (this.highlightedAtom != -1 || this.highlightedAtom != atomNumber) {
            this.document.clearCheckerMarks();
        }
        if (!this.viewPanel.isAtomMarkAndHighlightEnabled()) {
            return;
        }
        if (atomNumber != -1) {
            this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{this.document.getMainMoleculeGraph().getAtomArray()[atomNumber]}, null, ATOM_HIGHLIGHT_COLOR));
        }
        this.highlightedAtom = atomNumber;
        if (this.markedAtom != -1) {
            this.document.addCheckerMark(new MDocument.CheckerMark(new MolAtom[]{this.document.getMainMoleculeGraph().getAtomArray()[this.markedAtom]}, null, ATOM_MARK_COLOR));
        }
        this.repaint();
    }

    public int getMarkedAtom() {
        return this.markedAtom;
    }

    public int getHighlightedAtom() {
        return this.highlightedAtom;
    }
}

