/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.license.LicenseException;
import chemaxon.marvin.common.AtomSelectionHandler;
import chemaxon.marvin.common.MDocPasteListener;
import chemaxon.marvin.common.UserSettings;
import chemaxon.marvin.common.swing.CommonActions;
import chemaxon.marvin.common.swing.DispOptsActions;
import chemaxon.marvin.common.swing.MolButton;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.MoleculeProvider;
import chemaxon.marvin.common.swing.PagesActions;
import chemaxon.marvin.common.swing.action.ViewRecentFileActions;
import chemaxon.marvin.common.swing.modules.MessagePanel;
import chemaxon.marvin.common.swing.spi.PreferencesDialogProvider;
import chemaxon.marvin.io.MFieldAccessor;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.cml.MrvExport;
import chemaxon.marvin.paint.internal.ColorCollection;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.swing.BasicActions;
import chemaxon.marvin.swing.MAction;
import chemaxon.marvin.swing.MActionComponent;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.swing.ToggleButtonActionGroup;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.CancelPrintException;
import chemaxon.marvin.util.ColorSetUtil;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.ErrorDisplay;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.MolLoader;
import chemaxon.marvin.util.PrintControl;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.SequentialScheduler;
import chemaxon.marvin.view.swing.DefaultSketchMoleculeProvider;
import chemaxon.marvin.view.swing.RecordFetcher;
import chemaxon.marvin.view.swing.TableSupport;
import chemaxon.marvin.view.swing.TableSupportCreator;
import chemaxon.marvin.view.swing.ViewActions;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMoleculeGraphIface;
import chemaxon.struc.graphics.MMoleculeMovie;
import chemaxon.struc.prop.MMoleculeProp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ViewPanel
extends MolPanel
implements MouseListener,
BasicActions.CCCPListener,
PagesActions.Listener {
    private static final long serialVersionUID = 802342314015862847L;
    private static int[] MM_MAP;
    static final ResourceBundle RESOURCES;
    public static final String BADP = "Bad applet parameter \"";
    private static long total;
    private static long live;
    private Window molFrame0 = null;
    private ViewActions viewActions;
    private MAction[] navigationActions;
    String[] molStrings = null;
    private String molString = null;
    private Vector[] rasmolScripts = null;
    private AtomSelectionHandler[] moleculeSelections = null;
    private MarvinModule[] rasmolScripters = null;
    private ViewHandler viewHandler = null;
    private Font defaultFieldFont = null;
    private Map<String, Font> fieldFontMap = null;
    private final Action findAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            ViewPanel.this.doFind();
        }
    };
    private final Action findAgainAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            ViewPanel.this.doFindAgain();
        }
    };
    private double winScale = 0.0;
    private int borderWidth = 0;
    private Color borderColor = null;
    private double tabScale = -1.0;
    private boolean autoTabScale = false;
    private boolean tabScaleCalcNeeded = false;
    private boolean animSynchronized;
    private boolean startLoad;
    private int rows;
    private int cols;
    private MarvinModule animator = null;
    boolean selectable = true;
    private int editable = 0;
    private boolean importEnabled = true;
    private CallbackIface skbridge = null;
    private CallbackIface findTextModule = null;
    private int selected;
    private boolean detachable = true;
    transient Object tabScaleLock;
    private int tabScaleCalcInProgress = 0;
    private boolean draggable = true;
    private Map<Integer, Color> molbgMap;
    private MoleculeProvider sketchMoleculeProvider;
    private TableSupport tableSupport;
    protected CommonActions commonActions;
    private int oldMarkedCell = -1;
    private int oldMarkedAtom = -1;
    private boolean atomMarkAndHighlightEnabled = this.userSettings == null ? true : Boolean.parseBoolean(this.userSettings.getProperty("viewAtomMarkEnabled"));
    public static final int NO_MARK = -1;

    public ViewPanel(Component parent, int dim, UserSettings settings) {
        super(parent, settings);
        this.getCommonActions().getPasteAction().setEnabled(this.importEnabled);
        ++total;
        ++live;
        this.addKeyListener(this);
        this.setCleanDim(dim);
        if (dim == 3) {
            this.setDispopts(this.getDispopts() & 0xFFFFFFC7 | 0x18, false, true);
        }
        this.initActions();
        this.initTransient();
        this.addActionListenerToMyActions(this);
        this.navmodeCursors[0] = super.loadCursor("move_32x32.png");
        this.selected = -1;
        this.updateSelectionDependentActions();
    }

    public ViewPanel(Window f, MolPanel parentp, int dim, Properties props) {
        this(parentp, dim, null);
        this.setProperties(props);
        this.setDetachable(false);
        this.molFrame0 = f;
        this.selected = -1;
        this.updateSelectionDependentActions();
    }

    public TableSupport getTableSupport() {
        if (this.tableSupport == null) {
            this.tableSupport = TableSupportCreator.create(this);
        }
        return this.tableSupport;
    }

    @Override
    public String getAppletInfo() {
        return "MarvinView ".concat(mver).concat(", (C) 1998-2012 ChemAxon Ltd.");
    }

    @Override
    public String getProgName() {
        return "MarvinView";
    }

    @Override
    public String getAboutPath() {
        return "";
    }

    @Override
    public String getHelpSetLocation() {
        return "help/view_set.hs";
    }

    @Override
    protected String getHelpPropertyName() {
        return "viewHelp";
    }

    @Override
    protected String getQuickHelpPropertyName() {
        return "viewQuickHelp";
    }

    @Override
    protected final void showPreferencesDialog(PreferencesDialogProvider provider) {
        provider.show(this, null, null);
    }

    @Override
    protected void molInit() throws Throwable {
        this.removeAll();
        this.cleanupActionGroups();
        super.molInit();
        if (this.animator != null) {
            this.animator.modfunc("init");
        }
        this.rows = 0;
        this.cols = 1;
        this.winScale = 26.4;
        String s = this.getParameter("molbg");
        if (s != null && s.length() != 0 && s.charAt(0) == '#') {
            int i = s.indexOf(44);
            if (i >= 0) {
                s = s.substring(i + 1);
            }
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                String def = st.nextToken();
                i = def.indexOf(58);
                if (i < 0) continue;
                int icell = Integer.parseInt(def.substring(0, i));
                Color bg = Color.decode(def.substring(i + 1));
                if (this.molbgMap == null) {
                    this.molbgMap = new HashMap<Integer, Color>();
                }
                this.molbgMap.put(new Integer(icell), bg);
            }
        }
        if ((s = this.getParameter("winScale|mag")) != null) {
            this.winScale = Double.valueOf(s);
        }
        if ((s = this.getParameter("tabScale")) != null) {
            this.tabScale = Double.valueOf(s);
        }
        if ((s = this.getParameter("autoTabScale")) != null) {
            this.autoTabScale = ViewPanel.isTrue(s);
        }
        if ((s = this.getParameter("rows")) != null) {
            this.rows = Integer.parseInt(s);
        }
        if ((s = this.getParameter("cols")) != null) {
            this.cols = Integer.parseInt(s);
        }
        if ((s = this.getParameter("border")) != null) {
            this.setBorderWidth(Integer.parseInt(s));
        }
        if ((s = this.getParameter("borderColor")) != null && s.length() != 0 && s.charAt(0) == '#') {
            Color c = Color.decode(s);
            this.setBorderColor(c);
        }
        if ((s = this.getParameter("selectable")) != null) {
            this.selectable = Boolean.valueOf(s);
        }
        if ((s = this.getParameter("editable")) != null) {
            this.setEditable(Integer.parseInt(s));
        }
        if ((s = this.getParameter("importEnabled")) != null) {
            this.importEnabled = Boolean.valueOf(s);
            this.getCommonActions().getPasteAction().setEnabled(this.importEnabled);
        }
        if ((s = this.getParameter("draggable")) != null) {
            this.setDraggable(Boolean.valueOf(s));
        }
        if ((s = this.getParameter("selectedIndex")) != null) {
            this.setSelectedCellIndex(Integer.parseInt(s));
        }
        this.animSynchronized = false;
        s = this.getParameter("animSync");
        if (s != null) {
            this.animSynchronized = Boolean.valueOf(s);
        }
        if ((s = this.getParameter("background|bgcolor")) != null && s.length() != 0 && s.charAt(0) == '#') {
            Color c = Color.decode(s);
            this.setBackground(c);
        }
        if (this.getParameter("transferButtonVisible") == null) {
            this.changeProperty("transferButtonVisible", "true");
        }
        if ((s = this.getParameter("viewCarbonVisibility")) != null) {
            this.setCarbonVisibility(s);
        } else {
            this.setCarbonVisibility(this.getDefaultCarbonVisibility());
        }
        s = this.getParameter("viewLigandOrderVisibility");
        if (s != null) {
            this.setLigandOrderVisibility(s);
        } else {
            this.setLigandOrderVisibility(this.getDefaultLigandOrderVisibility());
        }
        if (this.applet != null) {
            URL base = this.applet.getCodeBase();
            this.defaultHelpURL = new URL(base, "help/view/view-index.html");
            this.defaultQuickHelpURL = new URL(base, "help/view/view.html");
        }
        String vhname = null;
        String args = null;
        s = null;
        vhname = this.getParameter("viewHandler");
        if (vhname != null) {
            int i = vhname.indexOf(58);
            if (i >= 0) {
                args = vhname.substring(i + 1);
                s = vhname.substring(0, i);
            } else {
                s = vhname;
            }
        } else {
            s = "GridBagView";
        }
        boolean createvh = true;
        MDocStorage docStorage = null;
        SequentialScheduler scheduler = null;
        int endRecordIndex = Integer.MAX_VALUE;
        if (this.viewHandler != null) {
            docStorage = this.viewHandler.getStorage();
            RecordFetcher oldrf = this.viewHandler.getRecordFetcher();
            scheduler = oldrf.getScheduler();
            endRecordIndex = oldrf.getEndRecordIndex();
            this.viewHandler.destruct();
            boolean bl = createvh = vhname != null && !vhname.equals(this.viewHandler.getNameAndArgs());
        }
        if (createvh) {
            if (docStorage == null) {
                docStorage = new MDocStorage(0);
            }
            this.viewHandler = (ViewHandler)MarvinModule.load("view.swing." + s, new Class[]{String.class, MDocStorage.class, SequentialScheduler.class, Integer.TYPE}, new Object[]{args, docStorage, scheduler, new Integer(endRecordIndex)}, this);
        }
        this.viewHandler.init(this, this.molFrame0);
        this.startLoad = true;
        s = this.getParameter("detachable");
        if (s != null) {
            this.setDetachable(Boolean.valueOf(s));
        }
        if ((s = this.getParameter("listenmouseevent")) != null && this.applet != null && ViewPanel.isTrue(s)) {
            this.getCanvas(0).addMouseListener((MouseListener)((Object)this.applet));
        }
        int nrec = this.viewHandler.getNumRecords();
        s = this.getParameter("spin");
        if (s != null) {
            double[] spin = this.readSpin(s);
            this.setSpin(-1, spin);
        }
        if (nrec > 0) {
            for (int i = 0; i < nrec; ++i) {
                s = this.getParameter("spin" + i);
                if (s != null) {
                    double[] spin = this.readSpin(s);
                    this.setSpin(i, spin);
                }
                if ((s = this.getParameter("script" + i)) == null) continue;
                this.setScript(i, s);
            }
            if ((this.rasmolScripts == null || this.rasmolScripts[0] == null) && (s = this.getParameter("script")) != null) {
                this.setScript(0, s);
            }
        }
        try {
            this.visibleCells(true);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            if (ex.getMessage().equals("512")) {
                this.getErrorDisplay().error("Cannot display molecule cell(s) due to a limitation in the Java class library.\nThe number of cells or data fields is probably too large for the GridBagLayout class to handle.\n", ex);
            }
            return;
        }
        this.fireDispoptsChange(0);
        this.updateSaveAsMenu();
    }

    @Override
    protected boolean getDefaultRgroupVisibility() {
        return true;
    }

    @Override
    protected void checkReadEnableActions(boolean v) {
    }

    public void initMolArrays(int nrec, int nm) {
        this.molString = this.getParameter("mol");
        this.molStrings = new String[nrec];
        this.moleculeSelections = null;
        this.rasmolScripts = null;
        this.rasmolScripters = null;
    }

    public void setAtomAndBondSets(int i) {
        String ss;
        int setSeq;
        MDocStorage ds = this.viewHandler.getStorage();
        String s = this.getParameter("selection" + i);
        if (s != null) {
            ds.setSelectedAtoms(i, null, s);
        }
        for (setSeq = 0; setSeq <= 63; ++setSeq) {
            ss = String.valueOf(i) + "." + setSeq;
            s = this.getParameter("set" + ss + "|" + "atomSet" + ss);
            if (s == null) continue;
            ds.setAtomSetSeq(i, null, s, setSeq);
        }
        for (setSeq = 0; setSeq <= 63; ++setSeq) {
            ss = String.valueOf(i) + "." + setSeq;
            s = this.getParameter("bondSet" + ss);
            if (s == null) continue;
            ds.setBondSetSeq(i, null, s, setSeq);
        }
    }

    @Override
    public void startstop(boolean stopped) {
        String[] mstrs = this.molStrings;
        String mstr = this.molString;
        Vector[] scripts = this.rasmolScripts;
        if (this.startLoad && !stopped && mstrs != null) {
            this.molStrings = null;
            this.molString = null;
            if (mstrs.length > this.viewHandler.getNumRecords() || !ViewPanel.isEmpty(mstrs)) {
                this.viewHandler.setNumRecords(mstrs.length);
            }
            if (mstr != null) {
                MDocStorage ds = this.viewHandler.getStorage();
                ds.fillWithNulls();
            }
            if (mstr != null || mstrs.length > 0) {
                for (int i = 0; i < this.viewHandler.getStorage().getSize(); ++i) {
                    this.setAtomAndBondSets(i);
                }
            }
            for (int i = 0; i < mstrs.length; ++i) {
                boolean isScript;
                boolean bl = isScript = scripts != null && scripts[i] != null;
                if (mstrs[i] == null) continue;
                this.startLoader(mstrs[i], null, i, isScript);
            }
            if (mstr != null) {
                this.startLoader(mstr, null, -1L, scripts != null && scripts.length != 0 && scripts[0] != null);
            }
            this.startLoad = false;
        }
        super.startstop(stopped);
        if (this.skbridge != null) {
            this.skbridge.callback("setStopped", stopped);
        }
        if (stopped) {
            this.jscripter = null;
        }
    }

    private static boolean isEmpty(String[] mstrs) {
        boolean empty = true;
        for (int i = 0; i < mstrs.length; ++i) {
            empty &= mstrs[i] == null;
        }
        return empty;
    }

    public boolean isDetachable() {
        return this.detachable;
    }

    public void setDetachable(boolean b) {
        Boolean old = this.detachable;
        Boolean val = b;
        this.detachable = b;
        this.viewHandler.setDetachable(b);
        this.changeListeners.firePropertyChange("detachable", old, val);
    }

    public void setWinmode(int mode, int icell) {
        this.viewHandler.setWinmode(mode, icell);
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (!this.isEnabled()) {
            return;
        }
        if (ev.getSource() instanceof MolButton) {
            MolButton b = (MolButton)ev.getSource();
            this.viewHandler.mouseReleasedOver(b);
        }
    }

    @Override
    public void keyReleased(KeyEvent ev) {
    }

    @Override
    public void keyPressed(KeyEvent ev) {
    }

    @Override
    public void keyTyped(KeyEvent ev) {
    }

    @Override
    public void doOpenMSpace() {
        try {
            this.openMSpace();
        }
        catch (Throwable th) {
            this.getErrorDisplay().error("Error opening MarvinSpace", th);
        }
    }

    @Override
    public void doSource() {
        Molecule mol;
        int icell = this.getSelectedCellIndex();
        MDocument doc = this.getSelectedDocument();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
            doc = this.getDocument(0);
        }
        Molecule molecule = mol = doc != null ? doc.getPrimaryMolecule() : null;
        if (icell >= 0 && mol != null) {
            this.editSource(doc, icell, this.getPainter(icell));
        } else {
            this.showNoCellSelectedError();
        }
    }

    @Override
    public void doCopy() {
        this.doCopy("default");
    }

    @Override
    public void doCut() {
    }

    @Override
    public void doCopySMILES() {
        this.doCopy("smiles");
    }

    @Override
    public void doCopyAs() {
        this.doCopy("dialog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopy(String fmt) {
        int icell = this.getSelectedCellIndex();
        MDocument doc = this.getSelectedDocument();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
            doc = this.getDocument(0);
        }
        if (doc != null) {
            this.beginHourglass();
            try {
                this.setMClipboardMol(doc, this.viewHandler.getMolPainter(icell), fmt);
            }
            catch (SecurityException sex) {
                this.getErrorDisplay().firewallError(sex, null);
            }
            finally {
                this.endHourglass();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPaste() {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        if (icell >= 0) {
            this.beginHourglass();
            try {
                Molecule m = this.getMClipboardMol();
                if (m != null) {
                    Molecule[] mm = new Molecule[]{m};
                    this.molLoaded(mm, icell);
                    MDocument[] docs = new MDocument[]{m.getDocument()};
                    for (int i = 0; i < this.pasteListeners.size(); ++i) {
                        ((MDocPasteListener)this.pasteListeners.get(i)).mdocsPasted(docs, icell);
                    }
                }
            }
            catch (SecurityException sex) {
                this.getErrorDisplay().firewallError(sex, null);
            }
            finally {
                this.endHourglass();
            }
        }
    }

    public Object getFindTextAsObject() {
        return this.findTextModule;
    }

    private void doFind() {
        CallbackIface ci = this.findTextModule;
        if (ci == null) {
            this.findTextModule = ci = (CallbackIface)MarvinModule.load("view.swing.FindText", this);
            ci.callback("setViewHandler", this.viewHandler);
            ci.callback("addPropertyChangeListener", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent ev) {
                    String key = ev.getPropertyName();
                    Object val = ev.getNewValue();
                    if (key.equals("word")) {
                        ViewPanel.this.getFindAgainAction().setEnabled(!val.equals(""));
                        ViewPanel.this.viewHandler.repaintText();
                    }
                }
            });
        }
        ci.callback("show", SwingUtilities.getWindowAncestor(this));
    }

    private void doFindAgain() {
        CallbackIface ci = this.findTextModule;
        if (ci == null) {
            this.doFind();
        } else {
            ci.callback("findAgain", null);
        }
    }

    @Override
    public void doAromatize(boolean v) {
        this.aromatize(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aromatize(boolean arom) {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        this.beginHourglass();
        try {
            boolean r;
            String[] msg = new String[1];
            MDocStorage ds = this.viewHandler.getStorage();
            if (icell == -1) {
                r = ds.aromatizeAll(arom, this.getUserSettings().getAromatizeMethod(), msg);
                if (r) {
                    this.viewHandler.visibleCells(true);
                }
            } else {
                String key;
                int irec = this.viewHandler.recordIndexFromMolCellIndex(icell);
                r = ds.aromatize(irec, key = this.viewHandler.fieldKeyFromMolCellIndex(icell), arom, this.getUserSettings().getAromatizeMethod(), msg);
                if (r && this.getVisibleCellIndex(icell) != -1) {
                    this.viewHandler.setVisibleCell(icell);
                }
            }
            if (r) {
                this.viewHandler.repaintMolComponent(icell);
            }
            if (msg[0] != null) {
                JOptionPane.showMessageDialog(this, msg[0], "Cannot perform operation", 2);
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    @Override
    public JMenu addToolsMenu(Container parentMenu, Object target) {
        JMenu result = super.addToolsMenu(parentMenu, target);
        HashMap<String, JMenu> subMenuMap = new HashMap<String, JMenu>();
        for (int i = 0; i < this.pluginActions.length; ++i) {
            if (this.pluginGroups[i] == null || this.pluginGroups[i].equals("")) {
                result.add(this.pluginActions[i]);
                continue;
            }
            if (!subMenuMap.containsKey(this.pluginGroups[i])) {
                JMenu subMenu = new JMenu(this.pluginGroups[i]);
                subMenu.setMnemonic(this.pluginGroupMnemonics[i]);
                result.add(subMenu);
                subMenuMap.put(this.pluginGroups[i], subMenu);
            }
            ((JMenu)subMenuMap.get(this.pluginGroups[i])).add(this.pluginActions[i]);
            if (!this.pluginSeparators[i]) continue;
            ((JMenu)subMenuMap.get(this.pluginGroups[i])).addSeparator();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean clean0(int icell, int dim, boolean usepm) {
        boolean canceled = false;
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        this.beginHourglass();
        try {
            boolean r;
            String[] msg = new String[1];
            MDocStorage ds = this.viewHandler.getStorage();
            String opts = this.getCleanOpts(dim);
            if (icell == -1) {
                r = ds.cleanAll(dim, opts, null, msg);
                this.viewHandler.repaintMols();
                if (r) {
                    this.viewHandler.visibleCells(true);
                }
            } else {
                MDialogProgressMonitor pm;
                String key;
                int irec = this.viewHandler.recordIndexFromMolCellIndex(icell);
                r = ds.clean(irec, key = this.viewHandler.fieldKeyFromMolCellIndex(icell), dim, opts, pm = usepm ? new MDialogProgressMonitor(this, "Cleaning...") : null, msg);
                if (r && this.getVisibleCellIndex(icell) != -1) {
                    try {
                        MDocument d = ds.getDoc(irec, key);
                        DPoint3 o = d.calcCenter();
                        this.execRasmolCommand("setCenter", icell, o);
                        this.viewHandler.setVisibleCell(icell);
                    }
                    catch (MDocStorage.RecordUnavailableException ex) {
                        this.getErrorDisplay().error("Cannot clean molecule in non-existent record", ex);
                    }
                    catch (IOException ex) {
                        this.getErrorDisplay().error("Cannot clean molecule in non-existent record", ex);
                    }
                }
                boolean bl = canceled = pm != null && pm.isCanceled();
            }
            if (r) {
                this.viewHandler.repaintMolComponent(icell);
            }
            if (msg[0] != null) {
                JOptionPane.showMessageDialog(this, msg[0], "Cannot perform operation", 2);
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
        return !canceled;
    }

    @Override
    public void doRegenBonds() {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        if (icell >= 0) {
            this.regenBonds(icell);
        } else {
            this.showNoCellSelectedError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doHydrogenize(boolean v) {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        this.beginHourglass();
        try {
            this.hydrogenize(v ? "hydrogenize" : "dehydrogenize", icell);
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        finally {
            this.endHourglass();
        }
    }

    @Override
    public void doExpandSgroup(Object ppo) {
        this.doContractOrExpandSgroup(false);
    }

    @Override
    public void doContractSgroup(Object ppo) {
        this.doContractOrExpandSgroup(true);
    }

    private void doContractOrExpandSgroup(boolean contr) {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        this.contractOrExpandSgroups(contr, icell);
    }

    private void contractOrExpandSgroups(boolean contr, int icell) {
        boolean r;
        MDocStorage ds = this.viewHandler.getStorage();
        if (icell == -1) {
            r = ds.contractOrExpandSgroupsAll(contr);
            if (r) {
                this.viewHandler.visibleCells(true);
            }
        } else {
            String key;
            int irec = this.viewHandler.recordIndexFromMolCellIndex(icell);
            r = ds.contractOrExpandSgroups(irec, key = this.viewHandler.fieldKeyFromMolCellIndex(icell), contr);
            if (r && this.getVisibleCellIndex(icell) != -1) {
                this.viewHandler.setVisibleCell(icell);
            }
        }
        if (r) {
            this.viewHandler.repaintMolComponent(icell);
        }
    }

    @Override
    public void doClean(int dim) {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        this.cleanActionPerformed(dim, icell);
    }

    @Override
    public void doClean2dWedgeBonds() {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        if (icell < 0) {
            this.getErrorDisplay().error("No selected cell", new Exception("No selected cell"));
            return;
        }
        Molecule m = this.getDocument(icell).getPrimaryMolecule();
        this.clean2dWedgeBonds(icell, m);
    }

    @Override
    protected void showConformers(int icell, Molecule m) {
        try {
            MarvinModule mm = (MarvinModule)MarvinModule.load("view.swing.ShowConformers", new Class[]{Integer.TYPE, Molecule.class, MolPanel.class, ErrorDisplay.class}, new Object[]{icell, m, this, this.errorDisplay}, this);
            mm.modfunc(null);
        }
        catch (ClassNotFoundException ex) {
            this.errorDisplay.error(ex);
        }
        catch (NoSuchMethodException ex) {
            this.errorDisplay.error(ex);
        }
        catch (InstantiationException ex) {
            this.errorDisplay.error(ex);
        }
        catch (IllegalAccessException ex) {
            this.errorDisplay.error(ex);
        }
        catch (InvocationTargetException ex) {
            this.errorDisplay.error(ex);
        }
    }

    @Override
    public void doClean3dSelConf() {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        if (icell < 0) {
            this.getErrorDisplay().warning("No selected cell.", null);
            return;
        }
        MDocument d = this.getDocument(icell);
        Molecule m = null;
        if (d != null) {
            m = d.getPrimaryMolecule();
        }
        if (m != null) {
            this.clean3dSelConf(icell, m);
        } else {
            this.getErrorDisplay().warning("No molecule.", null);
        }
    }

    @Override
    public void doResetView() {
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell < 0) {
            int molCount = this.getMolCount();
            for (int i = 0; i < molCount; ++i) {
                ViewCanvas canvas = this.getCanvas(i);
                if (canvas == null) continue;
                canvas.resetView();
            }
        } else {
            ViewCanvas canvas;
            ViewCanvas viewCanvas = canvas = selectedCell >= 0 ? this.getCanvas(selectedCell) : null;
            if (canvas != null) {
                canvas.resetView();
            }
        }
    }

    public void doMsketch() {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        if (icell >= 0) {
            this.launchSketcher(icell);
        } else {
            this.showNoCellSelectedError();
        }
    }

    public void doStartrot(boolean start) {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        boolean animated = false;
        if (icell >= 0) {
            animated = this.isAnimated(icell);
        }
        if (start && !animated) {
            if (icell >= 0) {
                this.animate(String.valueOf(icell));
            } else {
                this.showNoCellSelectedError();
            }
        } else if (!start && animated) {
            if (icell >= 0) {
                this.animate(String.valueOf(-icell - 1));
            } else {
                this.showNoCellSelectedError();
            }
        }
        if (icell >= 0) {
            this.setAnimated(icell, this.getAnimLength(icell));
        }
    }

    public void doRewind() {
        ViewCanvas canv;
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        this.animate(String.valueOf(-icell - 1));
        ViewCanvas viewCanvas = canv = icell >= 0 ? this.getCanvas(icell) : null;
        if (canv != null) {
            canv.rewind();
        }
    }

    public void doQuantSpin() {
        int icell = this.getSelectedCellIndex();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
        }
        MarvinModule r = this.animator;
        if (icell >= 0 && this.isAnimated(icell) && r != null) {
            Object[] args = new Object[]{new Integer(icell), "quantSpin"};
            r.modfunc(args);
        }
    }

    private int selectPrintDevice() {
        String message = "Print Device";
        Object[] options = new String[]{"Print", "Print to PDF", "Print Preview"};
        int res = MessagePanel.showOptionDialog(this, "Print Device", message, options, options[0]);
        return res;
    }

    private void generalPrint(int device, int mode) {
        String className = null;
        if (device == 0) {
            className = "chemaxon.marvin.modules.print.Print2Device";
        } else if (device == 1) {
            className = "chemaxon.marvin.modules.print.Print2Pdf";
        } else if (device == 2) {
            className = "chemaxon.marvin.modules.print.PrintPreview";
        } else {
            return;
        }
        try {
            Class<?> pdclass = Class.forName(className);
            final PrintControl printControl = (PrintControl)pdclass.newInstance();
            printControl.setContent(this);
            printControl.initSettings(mode);
            if (SwingUtilities.isEventDispatchThread()) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        printControl.doPrint();
                    }
                };
                new Thread(r).start();
            } else {
                printControl.doPrint();
            }
        }
        catch (ClassNotFoundException cnfex) {
            this.getErrorDisplay().error("Cannot find " + className, cnfex);
        }
        catch (IllegalAccessException iaex) {
            this.getErrorDisplay().error("Cannot instantiate " + className, iaex);
        }
        catch (InstantiationException insex) {
            this.getErrorDisplay().error("Cannot instantiate " + className, insex);
        }
        catch (CancelPrintException cpx) {
            System.err.println("interrupted printing:" + cpx.getMessage());
        }
    }

    public void doPrintAll() {
        this.generalPrint(this.selectPrintDevice(), 2);
    }

    public void doPrintVisible() {
        this.generalPrint(this.selectPrintDevice(), 1);
    }

    public void doPrintCell() {
        this.generalPrint(this.selectPrintDevice(), 0);
    }

    public void doSaveAll() {
        this.doSave("saveAll", true);
    }

    public void doSaveSelected() {
        this.doSave("saveSelected", false);
    }

    private void doSave(String cmd, boolean silentMode) {
        boolean enableRgrps;
        ViewCanvas canv;
        int icell = this.getSelectedCellIndex();
        MDocument doc = this.getSelectedDocument();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
            doc = this.getDocument(0);
        }
        Molecule mol = doc != null ? doc.getPrimaryMolecule() : null;
        ViewCanvas viewCanvas = canv = icell >= 0 ? this.getCanvas(icell) : null;
        if (canv == null && cmd.equals("saveSelected")) {
            cmd = "saveMore";
        }
        boolean bl = enableRgrps = (this.painterCommon.getDispopts() & 0x4000000) != 0;
        if (!enableRgrps && mol instanceof RgMoleculeGraphIface) {
            mol = (Molecule)((RgMoleculeGraphIface)((Object)mol)).getRootG();
        }
        if (cmd.equals("saveSelected")) {
            this.saveMolfile(null, null, "saveAs", mol, canv.getPainter(), true, true, silentMode);
        } else {
            this.saveMolfile(null, null, cmd, mol, null, true, true, silentMode);
        }
    }

    public void doSetDragToSpin(boolean v) {
        if (!v) {
            int icell = this.getSelectedCellIndex();
            if (icell < 0 && this.getMolCount() == 1) {
                icell = 0;
            }
            MarvinModule r = this.animator;
            if (icell >= 0 && this.isAnimated(icell) && r != null) {
                Object[] args = new Object[]{new Integer(icell), "stopSpin"};
                r.modfunc(args);
            }
        }
    }

    @Override
    public void doFitPageWidth() {
        ViewCanvas canvas;
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell >= 0 && (canvas = this.getCanvas(selectedCell)) != null) {
            canvas.fitPageWidth();
            canvas.repaint();
        }
    }

    @Override
    public void doFitPageHeight() {
        ViewCanvas canvas;
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell >= 0 && (canvas = this.getCanvas(selectedCell)) != null) {
            canvas.fitPageHeight();
            canvas.repaint();
        }
    }

    @Override
    public void doFitPage() {
        ViewCanvas canvas;
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell >= 0 && (canvas = this.getCanvas(selectedCell)) != null) {
            canvas.fitPage();
            canvas.repaint();
        }
    }

    @Override
    public void doPreviousPage() {
        ViewCanvas canvas;
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell >= 0 && (canvas = this.getCanvas(selectedCell)) != null) {
            canvas.previousPage();
        }
    }

    @Override
    public void doNextPage() {
        ViewCanvas canvas;
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell >= 0 && (canvas = this.getCanvas(selectedCell)) != null) {
            canvas.nextPage();
        }
    }

    @Override
    public void doFirstPage() {
        ViewCanvas canvas;
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell >= 0 && (canvas = this.getCanvas(selectedCell)) != null) {
            canvas.firstPage();
        }
    }

    @Override
    public void doLastPage() {
        ViewCanvas canvas;
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell >= 0 && (canvas = this.getCanvas(selectedCell)) != null) {
            canvas.lastPage();
        }
    }

    @Override
    public void doGoToPageFromMenu() {
        int selectedCell = this.getSelectedCellIndex();
        if (selectedCell >= 0) {
            ViewCanvas canvas = this.getCanvas(selectedCell);
            CallbackIface mm = (CallbackIface)MarvinModule.load("common.swing.IntegerDialog", this);
            if (mm != null) {
                mm.callback("setDocument", canvas.getDocument());
                mm.callback("setViewPanel", this);
                mm.callback("setViewCanvas", canvas);
                mm.callback("show", null);
            }
        }
    }

    @Override
    public void doGoToPage() {
    }

    @Override
    public void doSaveImage() {
        ViewCanvas canv;
        int icell = this.getSelectedCellIndex();
        MDocument doc = this.getSelectedDocument();
        if (icell < 0 && this.getMolCount() == 1) {
            icell = 0;
            doc = this.getDocument(0);
        }
        Molecule mol = doc != null ? doc.getPrimaryMolecule() : null;
        ViewCanvas viewCanvas = canv = icell >= 0 ? this.getCanvas(icell) : null;
        if (mol == null || mol.isEmpty()) {
            this.showNoCellSelectedError();
        } else if (this.showSaveImageFileChooser(3)) {
            canv.saveImage();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String cmd = ev.getActionCommand();
        if (cmd != null) {
            int icell = this.getSelectedCellIndex();
            if (icell < 0 && this.getMolCount() == 1) {
                icell = 0;
            }
            if (cmd.startsWith("clean2d-")) {
                this.cleanActionPerformed(2, icell);
            } else if (cmd.startsWith("clean3d-")) {
                this.cleanActionPerformed(3, icell);
            } else if (cmd.startsWith("plugin_")) {
                this.pluginActionPerformed(cmd, icell);
            } else if (cmd.equals("vkDown")) {
                this.viewHandler.keyPressed(40);
            } else if (cmd.equals("vkEnd")) {
                this.viewHandler.keyPressed(35);
            } else if (cmd.equals("vkEnter")) {
                this.viewHandler.keyPressed(10);
            } else if (cmd.equals("vkHome")) {
                this.viewHandler.keyPressed(36);
            } else if (cmd.equals("vkLeft")) {
                this.viewHandler.keyPressed(37);
            } else if (cmd.equals("vkPageDown")) {
                this.viewHandler.keyPressed(34);
            } else if (cmd.equals("vkPageUp")) {
                this.viewHandler.keyPressed(33);
            } else if (cmd.equals("vkRight")) {
                this.viewHandler.keyPressed(39);
            } else if (cmd.equals("vkUp")) {
                this.viewHandler.keyPressed(38);
            }
        }
    }

    @Override
    protected void nextTransformMode() {
        DispOptsActions actions = this.getCommonActions().getDispOptsActions();
        ToggleButtonActionGroup a = actions.getNavmodeActions();
        int i = a.getSelectedIndex();
        a.setSelectedIndex((i + 1) % 3);
    }

    @Override
    protected void repaintMols() {
        if (this.viewHandler != null) {
            this.viewHandler.repaintMols();
        }
    }

    public MDocument[] getDocuments() {
        int last = -1;
        MDocStorage ds = this.viewHandler.getStorage();
        for (int irec = 0; irec < this.viewHandler.getNumRecords(); ++irec) {
            MDocument doc = ds.getCachedDoc(irec, null);
            if (doc == null || doc.isEmpty()) continue;
            last = irec;
        }
        MDocument[] docs = new MDocument[last + 1];
        for (int irec = 0; irec < docs.length; ++irec) {
            docs[irec] = ds.getCachedDoc(irec, null);
        }
        return docs;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public int getVisibleRows() {
        return this.viewHandler.getVisibleRows();
    }

    public int getVisibleCols() {
        return this.viewHandler.getVisibleCols();
    }

    public void setVerticalScrollBarMaximum(int max) {
        this.viewHandler.setVerticalScrollBarMaximum(max);
    }

    public int[] getScrollBarsMax() {
        return this.viewHandler.getScrollBarsMax();
    }

    public int[] getScrollBarsMin() {
        return this.viewHandler.getScrollBarsMin();
    }

    public int[] getScrollBarsValue() {
        return this.viewHandler.getScrollBarsValue();
    }

    @Override
    public void setAtomsize(double l) {
        super.setAtomsize(l);
        if (this.viewHandler == null) {
            return;
        }
        for (int irec = 0; irec < this.viewHandler.getNumRecords(); ++irec) {
            int nm = this.viewHandler.getNumMoleculesInRecord();
            for (int im = 0; im < nm; ++im) {
                int icell = irec * nm + im;
                MolPainter p = this.viewHandler.getMolPainter(icell);
                if (p == null) continue;
                p.setAtomSize(l);
            }
        }
    }

    @Override
    public void setAtomFont(Font f) {
        super.setAtomFont(f);
        if (this.viewHandler == null) {
            return;
        }
        for (int irec = 0; irec < this.viewHandler.getNumRecords(); ++irec) {
            int nm = this.viewHandler.getNumMoleculesInRecord();
            for (int im = 0; im < nm; ++im) {
                int icell = irec * nm + im;
                MolPainter p = this.viewHandler.getMolPainter(icell);
                if (p == null) continue;
                p.resetFonts();
            }
        }
    }

    public Font getFieldFont(String key) {
        if (key == null) {
            return this.defaultFieldFont;
        }
        if (this.fieldFontMap != null) {
            Font f = this.fieldFontMap.get(key);
            return f;
        }
        return null;
    }

    public void setFieldFont(String key, Font f) {
        if (key == null) {
            this.defaultFieldFont = f;
        } else if (this.fieldFontMap == null) {
            if (f != null) {
                this.fieldFontMap = new HashMap<String, Font>();
                this.fieldFontMap.put(key, f);
            }
        } else if (f != null) {
            this.fieldFontMap.put(key, f);
        } else {
            this.fieldFontMap.remove(key);
        }
    }

    @Override
    public int getMolCount() {
        int nm = this.viewHandler.getNumMoleculesInRecord();
        return this.viewHandler.getNumRecords() * nm;
    }

    public int getAnimLength(int icell) {
        if (icell >= 0) {
            int nm = this.viewHandler.getNumMoleculesInRecord();
            int irec = icell / nm;
            if (irec >= this.viewHandler.getNumRecords()) {
                return 0;
            }
            int im = icell - irec * nm;
            MDocument doc = this.viewHandler.getCachedDocument(irec, im);
            if (doc != null) {
                MMoleculeMovie mmm = doc.getMoleculeMovie();
                if (mmm != null) {
                    return mmm.getMoleculeCount();
                }
                return 1;
            }
        }
        return 0;
    }

    public int getSpinAnimLength(int i) {
        MarvinModule r = this.animator;
        if (r != null) {
            return (Integer)r.getSomething("spinAnimLength" + i);
        }
        return 0;
    }

    public void setVisibleSize(int vrows, int vcols) {
        this.viewHandler.setVisibleSize(vrows, vcols);
        if (this.cols < vcols) {
            this.cols = vcols;
        }
    }

    @Override
    public void addRecentFileToUserSettings(File f) {
        if (f != null) {
            this.userSettings.addToViewRecentFileList(f);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateRecentFileListMenu();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewPanel.this.updateRecentFileListMenu();
                }
            });
        }
    }

    @Override
    public void setSaveCwdToUserSettings(File f) {
        if (f != null) {
            if (f.isFile()) {
                f = f.getParentFile();
            }
            this.userSettings.setViewSaveWorkingDir(f.getAbsolutePath());
        }
    }

    @Override
    public void setLoadCwdToUserSettings(File f) {
        if (f != null) {
            if (f.isFile()) {
                f = f.getParentFile();
            }
            this.userSettings.setViewLoadWorkingDir(f.getAbsolutePath());
        }
    }

    @Override
    public File getLoadCwdFromUserSettings() {
        return this.userSettings.getViewLoadWorkingDir();
    }

    @Override
    public File getSaveCwdFromUserSettings() {
        return this.userSettings.getViewSaveWorkingDir();
    }

    @Override
    public Color getDefaultMolbg() {
        return this.getDefaultMolbg(this.getCleanDim());
    }

    private Color getDefaultMolbg(int dim) {
        UserSettings settings = this.getUserSettings();
        if (settings != null) {
            return dim == 3 ? settings.getViewMolbg3d() : settings.getViewMolbg2d();
        }
        return null;
    }

    @Override
    public void setDefaultMolbg(Color c) {
        UserSettings settings = this.getUserSettings();
        int d = this.getCleanDim();
        if (d == 3 || d == 0) {
            settings.setViewMolbg3d(c);
        }
        if (d == 2 || d == 0) {
            settings.setViewMolbg2d(c);
        }
    }

    public Color getMolbg(int dim) {
        return this.getCleanDim() == dim ? this.getMolbg() : this.getDefaultMolbg(dim);
    }

    public Color getMolbg(int dim, int icell) {
        Color bg;
        if (this.molbgMap != null && (bg = this.molbgMap.get(new Integer(icell))) != null) {
            return bg;
        }
        return this.getMolbg(dim);
    }

    @Override
    public Color getAtomSetColor(int i) {
        MolPainter p = this.viewHandler.getMolPainter(0);
        return this.painterCommon.getAtomSetColor(i, null, p.getColors());
    }

    @Override
    public void setCleanDim(int dim) {
        String nav;
        String r;
        Color c;
        super.setCleanDim(dim);
        UserSettings settings = this.getUserSettings();
        if (dim == 3) {
            c = settings.getViewMolbg3d();
            r = settings.getViewRendering3d();
            nav = settings.getViewNavmode3d();
        } else {
            c = settings.getViewMolbg2d();
            r = settings.getViewRendering2d();
            nav = settings.getViewNavmode2d();
        }
        this.setMolbg(c);
        this.setRendering(r);
        this.setNavmode(nav);
    }

    @Override
    public void setColorScheme(String v) {
        super.setColorScheme(v);
        this.userSettings.setViewColorScheme(v);
        DispOptsActions dispoptsActions = this.getCommonActions().getDispOptsActions();
        dispoptsActions.getColorSchemeActions().setValue(v);
    }

    @Override
    protected String getDefaultColorSchemePropertyName() {
        return "viewColorScheme";
    }

    @Override
    public String getDefaultColorScheme() {
        return this.getUserSettings().getViewColorScheme();
    }

    @Override
    public void setDefaultColorScheme(String c) {
        this.setViewColorScheme(c);
    }

    @Override
    public String getDefaultImplicitH() {
        return this.getUserSettings().getViewImplicitH();
    }

    @Override
    public void setDefaultImplicitH(String s) {
        this.setViewImplicitH(s);
    }

    @Override
    protected String getDefaultImplicitHPropertyName() {
        return "viewImplicitH";
    }

    @Override
    public String getDefaultAnyBond() {
        return this.getUserSettings().getViewAnyBond();
    }

    @Override
    public String getDefaultAnyBondPropertyName() {
        return "viewAnyBond";
    }

    @Override
    public String getCarbonVisibility() {
        return this.painterCommon.getCarbonVisibility();
    }

    @Override
    public void setCarbonVisibility(String s) {
        int opts0 = this.painterCommon.getDispopts();
        this.painterCommon.setCarbonVisibility(s);
        if (this.fireDispoptsChange(opts0)) {
            this.repaintMols();
        }
        this.userSettings.setViewCarbonVisibility(s);
    }

    @Override
    public String getLigandOrderVisibility() {
        return this.painterCommon.getLigandOrderVisibility();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLigandOrderVisibility(String visibility) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.painterCommon.setLigandOrderVisibility(visibility);
            this.userSettings.setViewLigandOrderVisibility(visibility);
        }
    }

    @Override
    public String getDefaultCarbonVisibilityPropertyName() {
        return "viewCarbonVisibility";
    }

    @Override
    public String getDefaultLigandOrderVisibilityPropertyName() {
        return "viewLigandOrderVisibility";
    }

    @Override
    public String getDefaultRendering() {
        return this.getDefaultRendering(this.getCleanDim());
    }

    public String getRendering(int dim) {
        return this.getCleanDim() == dim ? this.getRendering() : this.getDefaultRendering(dim);
    }

    private String getDefaultRendering(int dim) {
        UserSettings settings = this.getUserSettings();
        return dim == 3 ? settings.getViewRendering3d() : settings.getViewRendering2d();
    }

    @Override
    public void setDefaultRendering(String s) {
        UserSettings settings = this.getUserSettings();
        int d = this.getCleanDim();
        if (d == 3 || d == 0) {
            settings.setViewRendering3d(s);
        }
        if (d == 2 || d == 0) {
            settings.setViewRendering2d(s);
        }
    }

    @Override
    public void setDefaultNavmode(String s) {
        UserSettings settings = this.getUserSettings();
        int d = this.getCleanDim();
        if (d == 3 || d == 0) {
            settings.setViewNavmode3d(s);
        }
        if (d == 2 || d == 0) {
            settings.setViewNavmode2d(s);
        }
    }

    @Override
    public String getDefaultRenderingPropertyName() {
        return this.getCleanDim() == 3 ? "viewRendering3d" : "viewRendering2d";
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public Color getBorderColor() {
        if (this.borderColor != null) {
            return this.borderColor;
        }
        Color bg = this.getBackground();
        return ColorCollection.isLight(bg) ? bg.darker() : bg.brighter();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int b) {
        int prevb = this.borderWidth;
        this.borderWidth = b;
        if (this.viewHandler != null) {
            this.viewHandler.setBorderWidth(b);
        }
        Integer old = new Integer(prevb);
        Integer val = new Integer(b);
        this.changeListeners.firePropertyChange("borderWidth", old, val);
    }

    public String getL(int n) {
        return this.viewHandler.getL(n);
    }

    public void setL(int n, String s) {
        this.viewHandler.setL(n, s);
    }

    public void setActionB(int i, String s) {
        this.viewHandler.setActionB(i, s);
    }

    public void setActionC(int i, String s) {
        this.viewHandler.setActionC(i, s);
    }

    public boolean getC(int n) {
        return this.viewHandler.getC(n);
    }

    public void setC(int n, boolean s) {
        this.viewHandler.setC(n, s);
    }

    public String getT(int n) {
        return this.viewHandler.getT(n);
    }

    public void setT(int n, String s) {
        this.viewHandler.setT(n, s);
    }

    public AbstractButton getVisibleButtonB(int i) {
        return this.viewHandler.getVisibleButtonB(i);
    }

    public AbstractButton getVisibleButtonC(int i) {
        return this.viewHandler.getVisibleButtonC(i);
    }

    public int indexOfButtonC(AbstractButton cb) {
        return this.viewHandler.indexOfButtonC(cb);
    }

    public int indexOfButtonB(AbstractButton b) {
        return this.viewHandler.indexOfButtonB(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecord(int irec, MDocument old, MDocument doc) {
        ViewHandler vh = this.viewHandler;
        if (vh == null) {
            return;
        }
        int nm = vh.getNumMoleculesInRecord();
        Object object = this.getMolPanelLock();
        synchronized (object) {
            MMoleculeMovie mmm;
            MDocument d;
            Serializable p;
            int im;
            if (this.getDebug() > 1) {
                System.err.println("ViewPanel.updateRecord(#" + Long.toHexString(irec) + ", " + irec + "): making it visible");
            }
            for (im = 0; im < nm; ++im) {
                int j = irec * nm + im;
                p = vh.getMolPainter(j);
                d = vh.getCachedDocument(irec, im);
                if (p == null) {
                    if (d == null || d.isEmpty()) continue;
                    p = new MolPainter(this.painterCommon);
                }
                this.initMolPainter((MolPainter)p, d);
                vh.setMolPainter(irec, im, (MolPainter)p);
            }
            vh.setMainDocumentInRecord(irec, doc);
            for (im = 0; im < nm; ++im) {
                this.doSelect(irec, im);
            }
            for (im = 0; im < nm; ++im) {
                int icell = irec * nm + im;
                p = vh.getMolCenter(icell);
                d = vh.getCachedDocument(irec, im);
                if (p == null && (d == null || d.isEmpty())) continue;
                p = d != null ? d.calcCenter(null) : null;
                vh.setMolCenter(icell, (DPoint3)p);
            }
            vh.initMainDocumentInRecord(irec, true);
            if (doc != null && (mmm = doc.getMoleculeMovie()) != null && mmm.getMoleculeCount() > 1) {
                this.animate(String.valueOf(irec));
            }
            this.changeListeners.firePropertyChange("doc" + irec, old, doc);
            vh.updateRecord(irec);
        }
    }

    public MolPainter createMolPainter(MDocument d) {
        MolPainter p = new MolPainter(this.painterCommon);
        this.initMolPainter(p, d);
        return p;
    }

    private void initMolPainter(MolPainter p, MDocument d) {
        p.setIdentityTransform();
        if (d != null) {
            p.setRTransformFromDocument(d);
        }
        p.setAtomSize(this.getUserSettings().getAtomSize());
        p.setCentralized(true);
    }

    public void setM(int n, Molecule m) {
        Molecule[] mols;
        if (m == null) {
            mols = null;
        } else {
            mols = new Molecule[1];
            MDocument doc = m.getDocument();
            MDocument mdoc = this.viewHandler.getStorage().getCachedDoc(n, null);
            if (mdoc != null && doc != null) {
                ColorSetUtil.copySets(doc, mdoc);
            }
            mols[0] = doc != null ? doc.cloneMainMolecule() : m.cloneMolecule();
            mols[0].setGUIContracted(true);
        }
        this.molLoaded(mols, n);
    }

    public void setM(int n, String s, String opts) {
        String msg0;
        boolean debug = this.getDebug() > 1;
        String string = msg0 = debug ? "ViewPanel.setM(" + n + ", ...): " : null;
        if (s == null || s.trim().length() == 0) {
            if (debug) {
                System.err.println(msg0 + "empty molecule");
            }
            if ((long)n == -1L) {
                for (int i = 0; i < this.viewHandler.getNumRecords(); ++i) {
                    this.molLoaded(null, i);
                }
            } else if ((long)n != -2L) {
                this.molLoaded(null, n);
            }
        } else {
            int nrec;
            if (debug) {
                System.err.println(msg0 + "starting loader");
            }
            if ((nrec = this.viewHandler.getNumRecords()) != 0) {
                MDocStorage ds = this.viewHandler.getStorage();
                if ((long)n == -1L) {
                    for (int irec = 0; irec < nrec; ++irec) {
                        this.viewHandler.setMainDocumentInRecord(irec, null);
                    }
                } else if ((long)n == -2L) {
                    for (int irec = 0; irec < nrec; ++irec) {
                        MDocument doc = ds.getCachedDoc(irec, null);
                        if (doc == null || !doc.isEmpty()) continue;
                        this.viewHandler.setMainDocumentInRecord(irec, null);
                    }
                } else {
                    MDocument doc = ds.getCachedDoc(n, null);
                    if (n < nrec && doc != null) {
                        this.viewHandler.setMainDocumentInRecord(n, null);
                    }
                }
            }
            this.startLoader(s, opts, n, false);
        }
    }

    public void setM(int n, File f, String opts) {
        Molecule[] mols = this.readMols(f, opts);
        this.molLoaded(mols, n);
    }

    public MolPainter getPainter(int icell) {
        return this.viewHandler.getMolPainter(icell);
    }

    @Override
    public MDocument getDocument(int icell) {
        int nm = this.viewHandler.getNumMoleculesInRecord();
        int irec = icell / nm;
        int im = icell - irec * nm;
        return this.viewHandler.getCachedDocument(irec, im);
    }

    @Override
    public void repaintMolComponent(int icell) {
        this.viewHandler.repaintMolComponent(icell);
    }

    public ViewCanvas getCanvas(int n) {
        ViewHandler h = this.viewHandler;
        return h != null ? h.getCanvas(n) : null;
    }

    public int getVisibleCellIndex(int absindex) {
        return this.viewHandler.getVisibleCellIndex(absindex);
    }

    public int getAbsoluteCellIndex(int visibleIndex) {
        return this.viewHandler.getAbsoluteCellIndex(visibleIndex);
    }

    public int getAbsoluteCellIndex(JComponent canvas) {
        if (canvas instanceof ViewCanvas) {
            Integer index = (Integer)((ViewCanvas)canvas).callback("getIndex", null);
            return index;
        }
        return -1;
    }

    public void setVisibleCanvas(int k, int icell) {
        if (this.viewHandler != null) {
            this.viewHandler.setVisibleCanvas(this.painterCommon, k, icell);
        }
        this.setAnimatedIfNeeded(icell);
    }

    private double[] readSpin(String spinstr) throws NumberFormatException {
        int i;
        StringTokenizer st = new StringTokenizer(spinstr, ", \t\n");
        if (!st.hasMoreTokens()) {
            return null;
        }
        double[] spin = new double[4];
        spin[0] = Double.valueOf(st.nextToken()) * Math.PI / 180.0;
        for (i = 0; st.hasMoreTokens() && i < 3; ++i) {
            spin[i + 1] = Double.valueOf(st.nextToken());
        }
        if (i == 0) {
            spin[2] = 1.0;
        }
        return spin;
    }

    private MarvinModule getAnimator() {
        MarvinModule r = this.animator;
        if (r == null) {
            try {
                r = this.animator = (MarvinModule)MarvinModule.load("view.swing.MViewAnimator", this);
            }
            catch (SecurityException sex) {
                this.getErrorDisplay().firewallError(sex, null);
                return null;
            }
            r.modfunc(this);
        }
        return r;
    }

    public void setMolString(int i, String s) {
        this.molStrings[i] = s;
    }

    private void setScript(int i, String s) {
        if (this.rasmolScripts == null) {
            this.rasmolScripts = new Vector[this.molStrings.length];
        }
        this.rasmolScripts[i] = new Vector();
        this.molStrings[i] = s;
    }

    private void execScript(int i, MolPainter p) {
        if (this.rasmolScripts == null) {
            return;
        }
        Vector script = this.rasmolScripts[i];
        if (script != null && p != null) {
            MarvinModule r;
            if (this.rasmolScripters == null) {
                this.rasmolScripters = new MarvinModule[this.rasmolScripts.length];
            }
            if ((r = this.rasmolScripters[i]) == null) {
                this.rasmolScripters[i] = r = (MarvinModule)MarvinModule.load("view.RasMolScripter", this);
            }
            r.modfunc(script);
            r.modfunc(new Integer(i));
            r.modfunc(this);
            Object ret = r.modfunc(p);
            if (ret != null && ret instanceof Throwable) {
                Throwable ex = (Throwable)ret;
                this.getErrorDisplay().error("Error in rasmol script:\n" + ex.getMessage(), ex);
            }
        }
    }

    public void setSelectedCellIndex(int i) {
        if (this.viewHandler.setSelectedCellIndex(i)) {
            int oldi = this.selected;
            this.selected = i;
            this.updateSelectionDependentActions();
            if (i != oldi && oldi >= 0) {
                this.viewHandler.unselectMoleculeCell(oldi);
                if (this.viewHandler != null && this.viewHandler.getCanvas(oldi) != null) {
                    this.viewHandler.getCanvas(oldi).removeAtomMark(false);
                }
            }
            this.updateSaveAsMenu();
            this.changeListeners.firePropertyChange("selectedIndex", new Integer(oldi), new Integer(this.selected));
        }
    }

    public int getSelectedCellIndex() {
        return this.selected;
    }

    private MDocument getSelectedDocument() {
        return this.selected >= 0 ? this.getDocument(this.selected) : null;
    }

    public int getVisibleSelectedCellIndex() {
        return this.getVisibleRows() == 1 && this.getVisibleCols() == 1 ? this.getAbsoluteCellIndex(0) : this.getSelectedCellIndex();
    }

    public int getCellCount() {
        return this.viewHandler.getCellCount();
    }

    public int getRowCount0() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.cols;
    }

    public void setEditable(int e) {
        Integer old = new Integer(this.editable);
        this.editable = e;
        Integer val = new Integer(this.editable);
        this.viewActions.getEditStructure().setEnabled(e > 0);
        this.changeListeners.firePropertyChange("editable", old, val);
    }

    public int getEditable() {
        return this.editable;
    }

    public boolean isImportEnabled() {
        return this.importEnabled;
    }

    public void setSelectable(boolean v) {
        Boolean old = this.selectable;
        if (!v && this.selected >= 0) {
            this.viewHandler.repaintMolComponent(this.selected);
            this.selected = -1;
            this.updateSelectionDependentActions();
        }
        Boolean val = v;
        this.selectable = v;
        this.changeListeners.firePropertyChange("selectable", old, val);
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void selectAllAtoms(int i, boolean v) throws IllegalArgumentException {
        this.selectAtom(i, -2, v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAtom(int icell, int atom, boolean v) throws IllegalArgumentException {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            if (this.moleculeSelections == null && this.viewHandler == null) {
                throw new IllegalArgumentException("selectAtom called before initialization");
            }
            int nrec = this.viewHandler.getNumRecords();
            int nm = this.viewHandler.getNumMoleculesInRecord();
            int ncells = nrec * nm;
            if (this.moleculeSelections == null) {
                this.moleculeSelections = new AtomSelectionHandler[ncells];
            }
            if (icell < 0 || icell >= ncells) {
                throw new IllegalArgumentException("selectAtom(" + icell + ", " + atom + ", " + v + "): first argument is out of range [0, " + this.moleculeSelections.length + "[");
            }
            AtomSelectionHandler sel = this.moleculeSelections[icell];
            if (sel == null) {
                this.moleculeSelections[icell] = sel = new AtomSelectionHandler();
            }
            sel.selectAtom(atom, v);
            int irec = icell / nm;
            int im = icell - irec * nm;
            this.doSelect(irec, im);
            this.viewHandler.repaintMolComponent(icell);
        }
    }

    @Override
    public void setAtomSetColor(int seq, Color color) {
        int nrec = this.viewHandler.getNumRecords();
        int nm = this.viewHandler.getNumMoleculesInRecord();
        int rgb = color != null ? color.getRGB() : -1;
        for (int irec = 0; irec < nrec; ++irec) {
            for (int im = 0; im < nm; ++im) {
                MDocument doc = this.viewHandler.getCachedDocument(irec, im);
                if (doc == null) continue;
                if (color == null) {
                    doc.setAtomSetColorMode(seq, 2);
                    continue;
                }
                doc.setAtomSetRGB(seq, rgb);
            }
            nrec = this.viewHandler.getNumRecords();
        }
        super.setAtomSetColor(seq, color);
    }

    @Override
    public void setBondSetColor(int seq, Color color) {
        int nrec = this.viewHandler.getNumRecords();
        int nm = this.viewHandler.getNumMoleculesInRecord();
        int rgb = color != null ? color.getRGB() : -1;
        for (int irec = 0; irec < nrec; ++irec) {
            for (int im = 0; im < nm; ++im) {
                MDocument doc = this.viewHandler.getCachedDocument(irec, im);
                if (doc == null) continue;
                if (color == null) {
                    doc.setBondSetColorMode(seq, 2);
                    continue;
                }
                doc.setBondSetRGB(seq, rgb);
            }
            nrec = this.viewHandler.getNumRecords();
        }
        super.setBondSetColor(seq, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSelect(int irec, int im) {
        if (this.moleculeSelections == null) {
            return;
        }
        MDocument doc = this.viewHandler.getCachedDocument(irec, im);
        if (doc == null) {
            return;
        }
        int nm = this.viewHandler.getNumMoleculesInRecord();
        AtomSelectionHandler sel = this.moleculeSelections[irec * nm + im];
        Molecule[] mols = doc.getPrimaryMolecules();
        for (int j = 0; j < mols.length; ++j) {
            Molecule mol = mols[j];
            Object object = mol.getLock();
            synchronized (object) {
                sel.apply(mol);
                continue;
            }
        }
    }

    @Override
    public Object[] getLoadSaveArgs(File f, String opts, String what, Molecule mol) {
        boolean isOpen = what.equals("open");
        Object[] v = new Object[isOpen ? 3 : 5];
        v[0] = f;
        v[1] = opts;
        v[2] = what;
        if (!isOpen) {
            v[3] = mol;
            v[4] = new Integer(this.getMolCount());
        }
        return v;
    }

    public void getCenter(int icell, DPoint3 q) {
        DPoint3 p = this.viewHandler.getMolCenter(icell);
        if (p == null) {
            p = new DPoint3();
        }
        q.x = p.x;
        q.y = p.y;
        q.z = p.z;
    }

    public void calcTransformedCenter(int icell, DPoint3 q) {
        MolPainter p = this.viewHandler.getMolPainter(icell);
        this.getCenter(icell, q);
        CTransform3D t = p.getRTransform();
        t.transform(q);
    }

    public void updateCleanDim(ViewCanvas c) {
        int dim;
        if (c != null && (dim = c.getDim()) != 0) {
            this.setCleanDim(dim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean molLoaderFinished(MolLoader loader) {
        boolean secondRun = loader.isSecondRun();
        if (super.molLoaderFinished(loader)) {
            return true;
        }
        if (!secondRun) {
            return false;
        }
        long id = loader.getId();
        if (id >= 196608L && id < 262144L) {
            return false;
        }
        Vector script = loader.getScript();
        if (script != null) {
            int irec = (int)id;
            int nm = this.viewHandler.getNumMoleculesInRecord();
            Object object = this.getMolPanelLock();
            synchronized (object) {
                if (this.rasmolScripts == null) {
                    this.rasmolScripts = new Vector[this.getMolCount()];
                }
                this.rasmolScripts[irec] = script;
                MolPainter p = this.viewHandler.getMolPainter(irec * nm);
                if (p != null) {
                    this.execScript(irec, p);
                }
            }
        } else {
            Molecule[] m = loader.getMols();
            if (m != null) {
                if (id == -1L || id == -2L) {
                    int nrec = this.viewHandler.getNumRecords();
                    MDocStorage ds = this.viewHandler.getStorage();
                    if (loader.isAnimated()) {
                        boolean loaded = false;
                        for (int irec = 0; irec < nrec; ++irec) {
                            MDocument doc = ds.getCachedDoc(irec, null);
                            if (doc != null) continue;
                            if (loaded) {
                                this.molLoaded(null, irec);
                                continue;
                            }
                            this.molLoaded(m, irec);
                            loaded = true;
                        }
                        if (!loaded && this.viewHandler.isIncrementable()) {
                            this.viewHandler.setNumRecords(nrec + 1);
                            this.molLoaded(m, nrec);
                        }
                    } else {
                        int irec;
                        int k = 0;
                        for (irec = 0; irec < nrec; ++irec) {
                            MDocument doc = ds.getCachedDoc(irec, null);
                            if (doc != null) continue;
                            if (k < m.length) {
                                Molecule[] mm = new Molecule[]{m[k++]};
                                this.molLoaded(mm, irec);
                                continue;
                            }
                            this.molLoaded(null, irec);
                        }
                        if (k < m.length && this.viewHandler.isIncrementable()) {
                            this.viewHandler.setNumRecords(nrec + m.length - k);
                            irec = nrec;
                            while (k < m.length) {
                                Molecule[] mm = new Molecule[]{m[k++]};
                                this.molLoaded(mm, irec);
                                ++irec;
                            }
                        }
                    }
                } else {
                    this.molLoaded(m, id);
                }
            } else {
                this.molLoaded(null, id);
            }
        }
        loader.clear();
        return false;
    }

    Object execRasmolCommand(String method, int index, Object arg) {
        if (method.equals("zap")) {
            MDocStorage ds = this.viewHandler.getStorage();
            MDocument doc = ds.getCachedDoc(index, null);
            this.updateRecord(index, doc, null);
        } else if (method.equals("repaint")) {
            this.viewHandler.repaintMolComponent(index);
        } else {
            if (method.equals("getM")) {
                MDocument doc = this.getDocument(index);
                return doc != null ? doc.getPrimaryMolecule() : null;
            }
            if (method.equals("getCenter")) {
                DPoint3 q = (DPoint3)arg;
                this.getCenter(index, q);
            } else if (method.equals("setCenter")) {
                DPoint3 p = new DPoint3((DPoint3)arg);
                this.viewHandler.setMolCenter(index, p);
            } else if (method.equals("load")) {
                Molecule[] mols = (Molecule[])arg;
                this.molLoaded(mols, index);
            }
        }
        return null;
    }

    @Override
    public Object callback(String method, Object arg) {
        Object ret = super.callback(method, arg);
        if (ret != null) {
            return ret;
        }
        if (method.equals("setMol")) {
            Object[] args = (Object[])arg;
            this.setMolRemoveSketch(args);
            this.setMolImpl(args);
        } else if (method.equals("removeSketch")) {
            this.setMolRemoveSketch((Object[])arg);
        } else if (method.equals("setSketchMol")) {
            this.setMolImpl((Object[])arg);
        } else {
            if (method.equals("getMol")) {
                int i = -1;
                if (arg != null) {
                    i = (Integer)arg;
                }
                if (i < 0) {
                    i = this.getVisibleSelectedCellIndex();
                }
                if (i < 0) {
                    this.showNoCellSelectedError();
                    return null;
                }
                if (this.getDocument(i) == null) {
                    return null;
                }
                MDocument doc = this.getDocument(i).cloneDocument();
                Molecule m = (Molecule)doc.getMainMoleculeGraph();
                m.setGUIContracted(false);
                return m;
            }
            if (method.startsWith("rasmol_")) {
                Object[] args = (Object[])arg;
                int index = (Integer)args[0];
                return this.execRasmolCommand(method.substring(7), index, args[1]);
            }
            if (method.equals("isImportEnabled")) {
                return this.isImportEnabled();
            }
            if (method.equals("saveAll") || method.equals("saveMore")) {
                this.saveCallback(method, (Object[])arg);
            } else if (method.equals("savePerformed")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewPanel.this.updateRecentFileListMenu();
                    }
                });
            }
        }
        return null;
    }

    private void setMolRemoveSketch(Object[] args) {
        int icell = (Integer)args[1];
        int nm = this.viewHandler.getNumMoleculesInRecord();
        int irec = icell / nm;
        int im = icell - irec * nm;
        this.viewHandler.addCanvasAgain(irec, im);
        if (this.skbridge != null) {
            this.skbridge.callback("remove", new Integer(icell));
        }
    }

    private void setMolImpl(Object[] args) {
        int icell = (Integer)args[1];
        int nm = this.viewHandler.getNumMoleculesInRecord();
        int irec = icell / nm;
        int im = icell - irec * nm;
        boolean changed = (Boolean)args[2];
        MDocument doc = null;
        doc = changed ? (MDocument)args[0] : this.viewHandler.getCachedDocument(irec, im);
        Molecule[] m = new Molecule[]{doc != null ? (Molecule)doc.getMainMoleculeGraph() : new Molecule()};
        String key = this.viewHandler.fieldKeyFromMolCellIndex(im);
        if (key != null) {
            MDocStorage ds = this.viewHandler.getStorage();
            MDocument maindoc = ds.getCachedDoc(irec, null);
            Molecule mainmol = null;
            if (maindoc != null) {
                mainmol = (Molecule)maindoc.getMainMoleculeGraph();
            }
            MFieldAccessor fa = this.viewHandler.getStorage().getFieldAccessor();
            fa.setField(irec, mainmol, key, new MMoleculeProp(m[0]));
            MDocument d = m[0].getDocument();
            if (d == null) {
                d = new MDocument(m[0]);
            }
            this.viewHandler.setValueAt(d, irec, key);
            this.updateRecord(irec, maindoc, maindoc);
            this.updateSaveAsMenu();
        } else {
            this.molLoaded(m, irec);
        }
    }

    private void saveAll(File f, MolExportModule cv, CallbackIface savemod, String format2) throws MolExportException {
        SequentialScheduler scheduler = this.viewHandler.getScheduler();
        SaveThread r = new SaveThread(f, cv, savemod, format2, scheduler, null);
        scheduler.invokeLater(r, 0, "saveAll");
    }

    private void saveMol(File f, MDocument d, MolExportModule cv, CallbackIface savemod) throws MolExportException {
        Molecule mol;
        Molecule molecule = mol = d != null ? d.getPrimaryMolecule() : null;
        if (mol != null && !mol.isEmpty()) {
            boolean enableRgrps;
            boolean bl = enableRgrps = (this.painterCommon.getDispopts() & 0x4000000) != 0;
            if (!enableRgrps && mol instanceof RgMoleculeGraphIface) {
                mol = (Molecule)((RgMoleculeGraphIface)((Object)mol)).getRootG();
            }
        }
        if (mol != null) {
            Object[] args = new Object[]{f, cv.convert(mol), Boolean.TRUE};
            savemod.callback("simpleWrite", args);
        }
    }

    private void endSave(File f, MolExportModule cv, CallbackIface savemod, final String format2) {
        try {
            Object[] args = new Object[]{f, cv.close(), Boolean.TRUE};
            savemod.callback("simpleWrite", args);
            this.callback("savePerformed", savemod);
        }
        catch (IOException ex) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewPanel.this.getErrorDisplay().error("Cannot convert molecule(s) to `" + format2 + "' format", ex);
                    ViewPanel.this.callback("setFileFromLoadSave", ViewPanel.this);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCallback(String method, Object[] params) {
        File f = (File)params[0];
        String format2 = (String)params[1];
        CallbackIface savemod = (CallbackIface)params[2];
        int[] savecells = (int[])params[4];
        this.beginHourglass();
        try {
            MolExportModule cv = MFileFormatUtil.createExportModule(format2);
            if (cv == null) {
                throw new Exception("Cannot load export module for `" + format2 + "'");
            }
            if (cv instanceof MrvExport && "mrv".equals(format2) && this.getUserSettings().getSaveGUIPropertiesInMRV()) {
                ((MrvExport)cv).setGlobalGUIProperties(this.getGlobalGUIProperties());
            }
            Object[] args = new Object[]{f, (String)cv.open(format2), Boolean.FALSE};
            savemod.callback("simpleWrite", args);
            if (method.equals("saveMore")) {
                SequentialScheduler scheduler = this.viewHandler.getScheduler();
                IntArrayIterator it = new IntArrayIterator(savecells);
                SaveThread r = new SaveThread(f, cv, savemod, format2, scheduler, it);
                scheduler.invokeLater(r, 0, "saveMore");
            } else {
                this.saveAll(f, cv, savemod, format2);
            }
        }
        catch (SecurityException sex) {
            this.getErrorDisplay().firewallError(sex, null);
        }
        catch (Throwable ex) {
            this.getErrorDisplay().error("Cannot convert molecule(s) to `" + format2 + "' format", ex);
            this.callback("setFileFromLoadSave", this);
        }
        finally {
            this.endHourglass();
        }
    }

    @Override
    public void molLoaded(Molecule[] mols, long id) {
        if (this.getDebug() > 1) {
            System.err.println("ViewPanel.molLoaded(" + mols + ", #" + Long.toHexString(id) + ")");
        }
        super.molLoaded(mols, id);
        ViewHandler vh = this.viewHandler;
        Color bg = this.getMolbg();
        if (mols != null) {
            for (int i = 0; i < mols.length; ++i) {
                Molecule m = mols[i];
                if (m == null) continue;
                this.painterCommon.fillUnsetSetPaletteInDoc(m, bg);
            }
        }
        int irec = (int)id;
        if (vh == null) {
            return;
        }
        MDocument old = vh.getStorage().getCachedDoc(irec, null);
        MDocument doc = null;
        if (mols != null && mols.length != 0) {
            if (mols.length == 1) {
                doc = mols[0].getDocument();
                if (doc == null) {
                    doc = new MDocument(mols[0]);
                }
            } else {
                doc = new MDocument(mols);
            }
        }
        vh.setValueAt(doc, irec, null);
        this.updateRecord(irec, old, doc);
        this.updateSaveAsMenu();
    }

    @Override
    public void updateMol(int index, Molecule mol) {
        this.molLoaded(new Molecule[]{mol}, index);
    }

    public ViewActions getViewActions() {
        return this.viewActions;
    }

    public Action getFindAction() {
        return this.findAction;
    }

    public Action getFindAgainAction() {
        return this.findAgainAction;
    }

    public void makeEditMenu(Container menu, boolean inPopup, Object target) {
        CommonActions actions = this.getCommonActions();
        int f = inPopup ? 44 : 0;
        actions.getCopyAction().addTo(menu, f, target);
        actions.getCopyAsAction().addTo(menu, f, target);
        actions.getCopySMILES().addTo(menu, f, target);
        actions.getPasteAction().addTo(menu, f, target);
        menu.add(new JSeparator());
        menu.add(new JMenuItem(this.getFindAction()));
        menu.add(new JMenuItem(this.getFindAgainAction()));
        menu.add(new JSeparator());
        this.viewActions.getEditStructure().addTo(menu, f, target);
        actions.getSource().addTo(menu, f, target);
        menu.add(new JSeparator());
        actions.getPreferences().addTo(menu, f, target);
    }

    public void makeStructureMenu(Container menu, boolean inPopup, Object target) {
        this.addEditCleanMenu(menu, inPopup);
        menu.add(new JSeparator());
        this.addEditAddMenu(menu, inPopup, target);
        this.addEditRemoveMenu(menu, inPopup, target);
        menu.add(new JSeparator());
        this.addAromatizationMenu(menu, inPopup);
        this.addEditSgroupMenu(menu, inPopup, target);
        menu.add(new JSeparator());
        this.getCommonActions().getRegenBondsAction().addTo(menu, inPopup ? 44 : 0);
    }

    public void setAnimMenuItems(boolean animated, int l) {
        MAction play = this.viewActions.getAnimPlay();
        play.setNameAndMnemonic(ViewActions.RESOURCES.getString(animated ? "animPause" : "animPlay"));
        play.setActionCommand(animated ? "stoprot" : "startrot");
        play.setEnabled(l > 0);
        this.viewActions.getAnimRewind().setEnabled(l > 1);
        this.viewActions.getAnimQuantSpin().setEnabled(animated && l > 0);
        this.viewActions.getDragToSpin().setEnabled(animated && l > 0);
    }

    public void addAnimationMenu(Container menu, boolean inPopup, int index, Object target) {
        int f = inPopup ? 44 : 0;
        JMenu submenu = SwingUtil.createMenu(RESOURCES, "animationMenuLabel", !inPopup);
        menu.add(submenu);
        this.viewActions.getAnimPlay().addTo(submenu, f, target);
        this.viewActions.getAnimRewind().addTo(submenu, f, target);
        this.viewActions.getAnimQuantSpin().addTo(submenu, f, target);
        this.viewActions.getDragToSpin().addTo(submenu, f, target);
        this.setAnimMenuItems(this.isAnimated(index), this.getAnimLength(index));
    }

    public void addPrintMenu(Container menu, boolean inPopup, Object target) {
        int f = inPopup ? 44 : 0;
        JMenu submenu = SwingUtil.createMenu(RESOURCES, "printMenuLabel", !inPopup);
        menu.add(submenu);
        this.viewActions.getPrintAll().addTo(submenu, f, target);
        this.viewActions.getPrintVisible().addTo(submenu, f, target);
        this.viewActions.getPrintCell().addTo(submenu, f, target);
    }

    public void makeSaveAsMenu(Container menu, boolean inPopup, Object target) {
        int f = inPopup ? 44 : 0;
        this.viewActions.getSaveSelected().addTo(menu, f, target);
        this.viewActions.getSaveAll().addTo(menu, f, target);
        this.updateSaveAsMenu();
    }

    public void makeRecentFileListMenu(Container menu) {
        ViewRecentFileActions rfa = new ViewRecentFileActions(this);
        Action[] actions = rfa.getActions();
        if (!Environment.APPLET) {
            JMenu submenu = BasicActions.createRecentFileListMenu();
            for (int i = 0; i < actions.length; ++i) {
                submenu.add(new JMenuItem(actions[i]));
            }
            menu.add(submenu);
        }
    }

    private void updateSaveAsMenu() {
        this.viewActions.getSaveAll().setEnabled(!Environment.UNTRUSTED);
        this.viewActions.getSaveSelected().setEnabled(!Environment.UNTRUSTED && this.getMolCount() > 1);
    }

    private void updateSelectionDependentActions() {
        MAction confsel = this.getCommonActions().getClean3dSelectConformerAction();
        confsel.setEnabled(this.selected != -1);
        this.findAction.setEnabled(this.selected == -1);
    }

    public void updateRecentFileListMenu() {
        JMenuBar menu = ViewPanel.getMarvinMenuBar(this.getRootPane());
        if (menu != null) {
            JPopupMenu tmp;
            int i;
            Component[] comps = menu.getComponents();
            for (i = 0; !(i >= comps.length || comps[i].getName() != null && comps[i].getName().equalsIgnoreCase("file")); ++i) {
            }
            if (i < comps.length && (tmp = ((JMenu)comps[i]).getPopupMenu()) != null) {
                JPopupMenu recentfiles;
                comps = tmp.getComponents();
                for (i = 0; !(i >= comps.length || comps[i].getName() != null && comps[i].getName().equalsIgnoreCase("recentfiles")); ++i) {
                }
                if (i < comps.length && (recentfiles = ((JMenu)comps[i]).getPopupMenu()) != null) {
                    recentfiles.removeAll();
                    ViewRecentFileActions rfa = new ViewRecentFileActions(this);
                    Action[] actions = rfa.getActions();
                    for (int j = 0; j < actions.length; ++j) {
                        recentfiles.add(new JMenuItem(actions[j]));
                    }
                    ViewPanel.updateMarvinMenuBar(this.getRootPane(), menu);
                }
            }
        }
    }

    void launchSketcher(int index) {
        if (this.skbridge == null) {
            try {
                this.skbridge = (CallbackIface)MarvinModule.load("view.swing.MViewSketch", this);
            }
            catch (SecurityException sex) {
                this.getErrorDisplay().firewallError(sex, null);
            }
            if (this.skbridge == null) {
                return;
            }
            this.skbridge.callback("init", this);
            this.skbridge.callback("setProvider", this.getSketchMoleculeProvider());
        }
        this.skbridge.callback("show", new Integer(index));
        this.viewHandler.removeCellFromPanel(index);
    }

    public void setSketchMoleculeProvider(MoleculeProvider provider) {
        this.sketchMoleculeProvider = provider;
    }

    public MoleculeProvider getSketchMoleculeProvider() {
        if (this.sketchMoleculeProvider == null) {
            this.sketchMoleculeProvider = new DefaultSketchMoleculeProvider(this);
        }
        return this.sketchMoleculeProvider;
    }

    private void openMSpace() throws Exception {
        CallbackIface msw = this.loadMSpaceViewer();
        JDialog mspaceDialog = this.getMSpaceDialog(msw);
        mspaceDialog.setVisible(true);
        int i = this.getVisibleSelectedCellIndex();
        if (i >= 0) {
            if (this.getDocument(i) != null) {
                MDocument doc = this.getDocument(i).cloneDocument();
                Molecule m = (Molecule)doc.getMainMoleculeGraph();
                m.setGUIContracted(false);
                Object o = msw.callback("addMoleculeToEmptyCell", m);
                if (o != null && o instanceof Exception) {
                    throw (Exception)o;
                }
            }
        } else {
            int[] s = new int[]{this.getVisibleRows(), this.getVisibleCols()};
            msw.callback("setLayout", s);
            for (i = 0; i < s[0] * s[1] && this.getDocument(i) != null; ++i) {
                MDocument doc = this.getDocument(i).cloneDocument();
                Molecule m = (Molecule)doc.getMainMoleculeGraph();
                m.setGUIContracted(false);
                msw.callback("addMoleculeToEmptyCell", m);
            }
        }
    }

    public void doubleClick(int index) {
        if (!this.openSketcher(index)) {
            this.openViewer(index);
        }
    }

    public boolean isSketchOpened(int index) {
        Object o;
        if (this.skbridge != null && (o = this.skbridge.callback("isOpened", new Integer(index))) != null) {
            return (Boolean)o;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openSketcher(int index) {
        boolean allowed = false;
        if (this.getEditable() == 2) {
            this.beginHourglass();
            try {
                this.launchSketcher(index);
                allowed = true;
            }
            finally {
                this.endHourglass();
            }
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openViewer(int index) {
        boolean allowed = false;
        if (this.isDetachable()) {
            this.beginHourglass();
            try {
                this.setWinmode(1, index);
                allowed = true;
            }
            finally {
                this.endHourglass();
            }
        }
        return allowed;
    }

    public void closeSketcher(int index) {
        if (this.skbridge != null) {
            this.skbridge.callback("close", new Integer(index));
        }
    }

    public void destroySketcher() {
        if (this.skbridge != null) {
            this.skbridge.callback("destroy", null);
            this.skbridge = null;
        }
    }

    @Override
    protected void clean(int icell) {
        this.clean0(icell, this.getCleanDim(), true);
    }

    private void hydrogenize(String cmd, int icell) {
        String[] msg = new String[1];
        MDocStorage ds = this.viewHandler.getStorage();
        boolean hydr = cmd.equals("hydrogenize");
        if (icell == -1) {
            boolean r = ds.hydrogenizeAll(hydr, msg);
            if (r) {
                this.viewHandler.visibleCells(true);
            }
            if (r) {
                this.viewHandler.repaintMols();
            }
        } else {
            String key;
            int irec = this.viewHandler.recordIndexFromMolCellIndex(icell);
            boolean r = ds.hydrogenize(irec, key = this.viewHandler.fieldKeyFromMolCellIndex(icell), hydr, msg);
            if (r && this.getVisibleCellIndex(icell) != -1) {
                this.viewHandler.setVisibleCell(icell);
            }
            if (r) {
                this.viewHandler.repaintMolComponent(icell);
            }
        }
        if (msg[0] != null) {
            JOptionPane.showMessageDialog(this, msg[0], "Cannot perform operation", 2);
        }
    }

    public void setAnimatedIfNeeded(int icell) {
        int i = this.getSelectedCellIndex();
        if (i >= 0 && (i == icell || icell < 0) || i < 0 && this.getMolCount() == 1) {
            this.setAnimated(i, this.getAnimLength(icell));
        }
    }

    public String getAnimated() {
        MarvinModule r = this.animator;
        return r != null ? (String)r.getSomething("getAnimated") : null;
    }

    public boolean isAnimated(int icell) {
        MarvinModule r = this.animator;
        if (r != null && icell >= 0) {
            Boolean b = (Boolean)r.getSomething(new Integer(icell));
            return b;
        }
        return false;
    }

    public void setAnimated(int icell, int l) {
        JMenuItem[] mis = new JMenuItem[4];
        boolean v = false;
        if (icell >= 0) {
            v = this.isAnimated(icell);
        } else if (this.getMolCount() == 1) {
            v = this.isAnimated(0);
        }
        this.setAnimMenuItems(v, l);
    }

    public boolean isAnimSync() {
        return this.animSynchronized;
    }

    public void setAnimSync(boolean s) {
        Boolean old = this.animSynchronized;
        Boolean val = s;
        this.animSynchronized = s;
        this.changeListeners.firePropertyChange("animSync", old, val);
    }

    public void animate(String args) {
        MarvinModule r = this.getAnimator();
        r.modfunc("animate ".concat(args));
    }

    public void setSpin(int i, double[] spin) {
        Object[] args = new Object[]{new Integer(i), spin};
        MarvinModule r = this.getAnimator();
        if (r != null) {
            r.modfunc(args);
        }
    }

    public boolean getDragToSpin() {
        return this.viewActions.getDragToSpin().isSelected();
    }

    public double getWinScale() {
        return this.winScale;
    }

    public void setWinScale(double scale) {
        Double old = new Double(this.winScale);
        this.winScale = scale;
        this.viewHandler.setWinScale(scale);
        Double val = new Double(scale);
        this.userSettings.setProperty("imageScale", String.valueOf(this.winScale), false);
        this.changeListeners.firePropertyChange("winScale", old, val);
    }

    private void initZoom() {
        int nrec = this.viewHandler.getNumRecords();
        for (int irec = 0; irec < nrec; ++irec) {
            int nm = this.viewHandler.getNumMoleculesInRecord();
            for (int im = 0; im < nm; ++im) {
                int icell = irec * nm + im;
                MolPainter p = this.viewHandler.getMolPainter(icell);
                if (p == null) continue;
                p.initZoom();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTabScale(boolean simpleIfCalcInProgress) {
        if (simpleIfCalcInProgress && this.tabScaleCalcInProgress != 0) {
            return this.tabScale;
        }
        Object object = this.tabScaleLock;
        synchronized (object) {
            if (this.tabScaleCalcNeeded) {
                this.tabScaleCalcNeeded = false;
                this.setTabScale(this.getBestTabScale(null));
            }
            return this.tabScale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTabScaleSimple() {
        Object object = this.tabScaleLock;
        synchronized (object) {
            return this.tabScale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTabScale(double scale) {
        Object object = this.tabScaleLock;
        synchronized (object) {
            Double old = new Double(this.tabScale);
            this.tabScale = scale;
            Double val = new Double(scale);
            this.initZoom();
            this.changeListeners.firePropertyChange("tabScale", old, val);
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTabScale(int i) {
        Object object = this.tabScaleLock;
        synchronized (object) {
            double x = this.tabScale;
            return x > 0.0 ? x : this.getBestTabScale(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBestTabScale(int icell) {
        Object object = this.tabScaleLock;
        synchronized (object) {
            int nm = this.viewHandler.getNumMoleculesInRecord();
            int irec = icell / nm;
            int im = icell - irec * nm;
            return this.viewHandler.getBestTabScale(irec, im);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBestTabScale(MProgressMonitor pmon) {
        ++this.tabScaleCalcInProgress;
        try {
            Object object = this.tabScaleLock;
            synchronized (object) {
                double min = -1.0;
                int nrec = this.viewHandler.getNumRecords();
                if (pmon != null) {
                    pmon.initProgressMonitor(null, 0, nrec);
                }
                for (int irec = 0; irec < nrec; ++irec) {
                    int nm = this.viewHandler.getNumMoleculesInRecord();
                    for (int im = 0; im < nm; ++im) {
                        double x = this.getBestTabScale(irec * nm + im);
                        if (!(min < 0.0 && x > 0.0) && (!(min > 0.0) || !(x > 0.0) || !(x < min))) continue;
                        min = x;
                    }
                    int n = this.viewHandler.getNumRecords();
                    if (n != nrec) {
                        nrec = n;
                        if (pmon != null) {
                            pmon.setMaximum(nrec);
                        }
                    }
                    if (pmon == null) continue;
                    pmon.setProgressValue(irec);
                    if (pmon.isCanceled()) break;
                }
                if (pmon != null) {
                    pmon.setProgressValue(nrec);
                }
                double d = min;
                return d;
            }
        }
        finally {
            --this.tabScaleCalcInProgress;
        }
    }

    public boolean getAutoTabScale() {
        return this.autoTabScale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoTabScale(boolean v) {
        Object object = this.tabScaleLock;
        synchronized (object) {
            Boolean old = this.autoTabScale;
            Boolean val = v;
            this.autoTabScale = v;
            this.changeListeners.firePropertyChange("autoTabScale", old, val);
        }
    }

    public void print() {
        String message = "Print Mode";
        Object[] options = new String[]{"All", "All Visible", "This Molecule"};
        int res = MessagePanel.showOptionDialog(this, "Print Mode", message, options, options[0]);
        if (res == 0) {
            this.doPrintAll();
        } else if (res == 1) {
            this.doPrintVisible();
        } else if (res == 2) {
            this.doPrintCell();
        } else {
            return;
        }
    }

    private void visibleCells(boolean set) {
        if (this.viewHandler.getStorage().getDocSource() == null) {
            this.viewHandler.visibleCells(set);
        }
    }

    @Override
    public void setDebug(int debug) {
        super.setDebug(debug);
        if (this.viewHandler != null) {
            this.viewHandler.setDebug(debug != 0);
        }
    }

    @Override
    public void destroy() {
        MarvinModule animator = this.getAnimator();
        if (animator != null) {
            animator.modfunc(new String("destroy"));
        }
        if (this.viewHandler != null) {
            this.viewHandler.destruct();
            this.viewHandler = null;
        }
        if (this.skbridge != null) {
            this.skbridge.callback("destroy", null);
            this.skbridge = null;
        }
        this.removeMouseListener(this);
        super.destroy();
    }

    @Override
    public void exit() {
        RecordFetcher rf;
        UserSettings settings = this.getUserSettings();
        if (this.getCleanDim() == 3) {
            settings.setViewMolbg3d(this.getMolbg());
        } else {
            settings.setViewMolbg2d(this.getMolbg());
        }
        if (this.colorSchemeChangedFromGUI) {
            settings.setViewColorScheme(this.getColorScheme());
        }
        settings.setViewImplicitH(this.getImplicitH());
        ViewHandler vh = this.viewHandler;
        if (vh != null && (rf = vh.getRecordFetcher()) != null) {
            rf.cancelPreread();
        }
        super.exit();
    }

    @Override
    public void addActionListener(ActionListener l) {
        super.addActionListener(l);
        this.addActionListenerToMyActions(l);
    }

    private void addActionListenerToMyActions(ActionListener l) {
        for (int i = 0; i < this.navigationActions.length; ++i) {
            this.navigationActions[i].addActionListener(l);
        }
    }

    @Override
    public void removeActionListener(ActionListener l) {
        super.removeActionListener(l);
        for (int i = 0; i < this.navigationActions.length; ++i) {
            this.navigationActions[i].removeActionListener(l);
        }
    }

    @Override
    public String getFormat() {
        String fmt = super.getFormat();
        if (fmt == null) {
            fmt = "DEFAULT";
        }
        if (fmt.equals("DEFAULT")) {
            MDocument doc = this.getSelectedDocument();
            String f = null;
            if (doc != null) {
                f = doc.getInputFormat();
                return f != null ? f : fmt;
            }
            MDocStorage ds = this.viewHandler.getStorage();
            int[] indices = ds.getCachedDocIndices();
            for (int i = 0; i < indices.length; ++i) {
                int k = indices[i];
                try {
                    doc = ds.getMainDoc(k);
                    if (doc != null && (f = doc.getInputFormat()) != null) {
                        return f;
                    }
                    continue;
                }
                catch (MDocStorage.RecordUnavailableException ex) {
                    continue;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return fmt;
    }

    MarvinModule getAnimatorForSaving(int i) {
        MarvinModule r = this.animator;
        return r != null ? (MarvinModule)r.modfunc("cloneForSaving" + i) : null;
    }

    private void showNoCellSelectedError() {
        JOptionPane.showMessageDialog(this, "Select a molecule first.", "No molecule selected", 0);
    }

    @Override
    protected void setMarvinCursor(Cursor cursor) {
        if (this.viewHandler != null) {
            this.viewHandler.setMarvinCursor();
        }
    }

    private void initActions() {
        this.getCommonActions().getDispOptsActions().setDispOpts(this.painterCommon.getDispopts());
        this.getCommonActions().getDispOptsActions().setDispOptsExt(this.painterCommon.getDispoptsExt());
        this.updateImplicitHActions();
        this.setClean2dOpts(this.userSettings.getClean2dOpts());
        this.setClean3dOpts(this.userSettings.getClean3dOpts());
        this.setAromatizeMethod(this.userSettings.getAromatizeMethod());
        this.viewActions = new ViewActions(this);
        this.viewActions.getDragToSpin().setSelected(true);
        this.getCommonActions().initAccelerators(this);
        this.navigationActions = new MAction[9];
        this.navigationActions[0] = this.createAction("vkDown", "vkDown", KeyStroke.getKeyStroke(40, 0));
        this.navigationActions[1] = this.createAction("vkEnd", "vkEnd", KeyStroke.getKeyStroke(35, 0));
        this.navigationActions[2] = this.createAction("vkEnter", "vkEnter", KeyStroke.getKeyStroke(10, 0));
        this.navigationActions[3] = this.createAction("vkHome", "vkHome", KeyStroke.getKeyStroke(36, 0));
        this.navigationActions[4] = this.createAction("vkLeft", "vkLeft", KeyStroke.getKeyStroke(37, 0));
        this.navigationActions[5] = this.createAction("vkPageDown", "vkPageDown", KeyStroke.getKeyStroke(34, 0));
        this.navigationActions[6] = this.createAction("vkPageUp", "vkPageUp", KeyStroke.getKeyStroke(33, 0));
        this.navigationActions[7] = this.createAction("vkRight", "vkRight", KeyStroke.getKeyStroke(39, 0));
        this.navigationActions[8] = this.createAction("vkUp", "vkUp", KeyStroke.getKeyStroke(38, 0));
        SwingUtil.initAction(this.findAction, RESOURCES, "find", SwingUtil.getCommandKeyStroke(70));
        SwingUtil.initAction(this.findAgainAction, RESOURCES, "findAgain", KeyStroke.getKeyStroke(114, 0));
        this.findAgainAction.setEnabled(false);
    }

    private void initTransient() {
        this.tabScaleLock = new Object();
        if (this.viewHandler != null) {
            this.viewHandler.initTransientC();
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initTransient();
        this.setDispoptsMenuItems();
    }

    public static long getTotalInstanceNumber() {
        return total;
    }

    public static long getLiveInstanceNumber() {
        return live;
    }

    protected void finalize() throws Throwable {
        --live;
        if (this.getDebug() != 0) {
            System.err.println("ViewPanel#" + this.hashCode() + " died");
        }
        super.finalize();
    }

    public JMenu addPagesMenu(Container menu, boolean inPopup) {
        PagesActions pgactions = this.getCommonActions().getPagesActions();
        JMenu submenu = pgactions.createMenu(inPopup);
        menu.add(submenu);
        return submenu;
    }

    @Override
    public MPropertyContainer getGlobalGUIProperties() {
        MPropertyContainer newPC = super.getGlobalGUIProperties();
        if (newPC != null) {
            // empty if block
        }
        return newPC;
    }

    @Override
    public void setGlobalGUIProperties(MPropertyContainer gp) {
        super.setGlobalGUIProperties(gp);
        if (this.globalGUIProperties != null) {
            UserSettings userSettings = this.getUserSettings();
            if (this.getCleanDim() == 2) {
                userSettings.setViewMolbg2d(this.getMolbg());
                userSettings.setViewRendering2d(this.getRendering());
                String s = userSettings.getViewNavmode2d();
                this.setNavmode(s);
            } else {
                userSettings.setViewMolbg3d(this.getMolbg());
                userSettings.setViewRendering3d(this.getRendering());
                String s = userSettings.getViewNavmode3d();
                this.setNavmode(s);
            }
            userSettings.setViewAnyBond(this.getAnyBond());
            userSettings.setViewImplicitH(this.getImplicitH());
            userSettings.setViewColorScheme(this.getColorScheme());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setEnabled(enabled);
        }
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean b) {
        if (this.draggable == b) {
            return;
        }
        Boolean old = this.draggable;
        Boolean val = b;
        this.draggable = b;
        this.changeListeners.firePropertyChange("draggable", old, val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValenceErrorVisibleInView(boolean v) {
        Object object = this.getMolPanelLock();
        synchronized (object) {
            this.painterCommon.setValenceErrorVisibleInView(v);
            super.setValenceErrorVisibleInView(v);
        }
    }

    public boolean isEnableRgroups() {
        return (this.painterCommon.getDispopts() & 0x4000000) != 0;
    }

    public JMenu addEditAddMenu(Container menu, boolean inPopup, Object target) {
        int f = inPopup ? 44 : 0;
        JMenu submenu = SwingUtil.createMenu(RESOURCES, "editAddMenuLabel", !inPopup);
        menu.add(submenu);
        this.getCommonActions().getHydrogenizeAction().addTo(submenu, f, target);
        return submenu;
    }

    public void addAromatizationMenu(Container menu, boolean inPopup) {
        int f = inPopup ? 44 : 0;
        JMenu submenu = SwingUtil.createMenu(RESOURCES, "aromatization", !inPopup);
        menu.add(submenu);
        this.getCommonActions().getAromatize().addTo(submenu, f);
        JMenu conversionMethodMenu = SwingUtil.createMenu(RESOURCES, "conversionMethod", !inPopup);
        this.getCommonActions().getAromatizeMethodActions().addTo(conversionMethodMenu, 0, f);
        submenu.add(conversionMethodMenu);
        this.getCommonActions().getDearomatize().addTo(submenu, f);
    }

    public JMenu addClean2DMenu(Container menu, boolean inPopup) {
        int f = inPopup ? 44 : 0;
        JMenu submenu = SwingUtil.createMenu(RESOURCES, "clean2d", !inPopup);
        this.getCommonActions().getClean2dAction().addTo(submenu, f);
        submenu.addSeparator();
        this.getCommonActions().getClean2dWedgeBondsAction().addTo(submenu, f);
        menu.add(submenu);
        return submenu;
    }

    public JMenu addClean3DMenu(Container menu, boolean inPopup) {
        int f = inPopup ? 44 : 0;
        JMenu submenu = SwingUtil.createMenu(RESOURCES, "clean3d", !inPopup);
        this.getCommonActions().getClean3dAction().addTo(submenu, f);
        JMenu optsMenu = SwingUtil.createMenu(RESOURCES, "clean3dOpts", !inPopup);
        this.getCommonActions().getClean3dOptActions().addTo(optsMenu, 0, f);
        submenu.add(optsMenu);
        submenu.addSeparator();
        this.getCommonActions().getClean3dSelectConformerAction().addTo(submenu, f);
        menu.add(submenu);
        return submenu;
    }

    public void addEditCleanMenu(Container menu, boolean inPopup) {
        this.createVecs();
        this.addClean2DMenu(menu, inPopup);
        this.addClean3DMenu(menu, inPopup);
    }

    public JMenu addEditRemoveMenu(Container menu, boolean inPopup, Object target) {
        int f = inPopup ? 44 : 0;
        JMenu submenu = SwingUtil.createMenu(RESOURCES, "editRemoveMenuLabel", !inPopup);
        menu.add(submenu);
        this.getCommonActions().getDehydrogenizeAction().addTo(submenu, f, target);
        return submenu;
    }

    public JMenu addEditSgroupMenu(Container menu, boolean inPopup, Object target) {
        int f = inPopup ? 44 : 0;
        JMenu submenu = ViewPanel.createMenuG("groups", !inPopup);
        menu.add(submenu);
        this.getCommonActions().getContractSgroupAction().addTo(submenu, f, target);
        this.getCommonActions().getExpandSgroupAction().addTo(submenu, f, target);
        return submenu;
    }

    public void addTransformViewMenuItems(JMenu menu, boolean inPopup, Object target) {
        DispOptsActions dispoptsActions = this.getCommonActions().getDispOptsActions();
        int f = inPopup ? 44 : 0;
        dispoptsActions.getNavmodeActions().addTo(menu, 0, f, target);
        this.setDispoptsMenuItems();
        menu.addSeparator();
        this.getCommonActions().getResetViewAction().addTo(menu, f, target);
    }

    public void addOpenMSpaceMenuItem(Container menu) {
        this.getCommonActions().getOpenMSpaceAction().addTo(menu);
    }

    public JMenu createTransformMenu(boolean inPopup) {
        return SwingUtil.createMenu(RESOURCES, "transformMenuLabel", !inPopup);
    }

    public void addViewSubmenus(Container menu, boolean inPopup) {
        int f = inPopup ? 44 : 0;
        DispOptsActions dispoptsActions = this.getCommonActions().getDispOptsActions();
        this.createVecs();
        JMenu submenu = ViewPanel.createMenuG("display", !inPopup);
        menu.add(submenu);
        submenu.setName("display.view");
        dispoptsActions.getAtomSymbolsVisibleAction().addTo(submenu, f);
        submenu.addSeparator();
        dispoptsActions.getRenderingActions().addTo(submenu, 0, f);
        submenu.addSeparator();
        JMenu subsubmenu = SwingUtil.createMenu(RESOURCES, "viewDisplayQualityMenuLabel", !inPopup);
        submenu.add(subsubmenu);
        dispoptsActions.getDispQualityActions().addTo(subsubmenu, 0, f);
        submenu = ViewPanel.createMenuG("colors", !inPopup);
        menu.add(submenu);
        submenu.setName("colors.view");
        dispoptsActions.getColorSchemeActions().addTo(submenu, 0, f);
        dispoptsActions.getSetColoringEnabledAction().addTo(submenu, f);
        submenu.addSeparator();
        this.getCommonActions().getChoosebg().addTo(submenu, f);
        this.getCommonActions().getWhitebg().addTo(submenu, f);
        this.getCommonActions().getBlackbg().addTo(submenu, f);
        menu.add(dispoptsActions.createStereoMenu(inPopup));
        menu.add(dispoptsActions.createHydrogenMenu(inPopup));
        menu.add(dispoptsActions.createMiscMenu(inPopup));
        this.setDispoptsMenuItems();
    }

    @Override
    public void makeHelpMenu(Container menu, boolean popup, Object target) {
        int f;
        int n = f = popup ? 44 : 0;
        if (this.getHelpURL() != null) {
            this.getCommonActions().getHelpContents().addTo(menu, f, target);
        }
        menu.add(new JSeparator());
        this.getCommonActions().getLicenses().addTo(menu, f, target);
        menu.add(new JSeparator());
        this.getCommonActions().getAboutJVM().addTo(menu, f, target);
    }

    @Override
    public void setAromatizeMethod(int method) {
        super.setAromatizeMethod(method);
        this.getCommonActions().getAromatizeMethodActions().setValue(new Integer(method));
    }

    @Override
    public void doSetRendering(int k) {
        super.doSetRendering(k);
        this.updateImplicitHActions();
    }

    @Override
    public void setAtomMappingVisible(boolean v) {
        super.setAtomMappingVisible(v);
        DispOptsActions actions = this.getCommonActions().getDispOptsActions();
        actions.getAtomMappingVisibleAction().setSelected(v);
    }

    @Override
    public void setAtomNumbersVisible(boolean v) {
        super.setAtomNumbersVisible(v);
        DispOptsActions actions = this.getCommonActions().getDispOptsActions();
        actions.getAtomNumbersVisibleAction().setSelected(v);
    }

    @Override
    public void setClean2dOpts(String s) {
        super.setClean2dOpts(s);
        ToggleButtonActionGroup group = this.getCommonActions().getClean2dOptActions();
        this.setGroupValue(s, group);
    }

    @Override
    public void setClean3dOpts(String s) {
        super.setClean3dOpts(s);
        ToggleButtonActionGroup group = this.getCommonActions().getClean3dOptActions();
        this.setGroupValue(s, group);
    }

    @Override
    public void setDispQuality(int k) {
        super.setDispQuality(k);
        DispOptsActions dispoptsActions = this.getCommonActions().getDispOptsActions();
        dispoptsActions.getDispQualityActions().setValue(new Integer(k));
    }

    @Override
    public void setGrinvVisible(boolean v) {
        super.setGrinvVisible(v);
        DispOptsActions actions = this.getCommonActions().getDispOptsActions();
        actions.getGrinvVisibleAction().setSelected(v);
    }

    @Override
    public void setLonePairsAutoCalc(boolean v) {
        super.setLonePairsAutoCalc(v);
        DispOptsActions actions = this.getCommonActions().getDispOptsActions();
        actions.getLonePairsAutoCalcAction().setSelected(v);
    }

    @Override
    public void setLonePairsVisible(boolean v) {
        super.setLonePairsVisible(v);
        DispOptsActions actions = this.getCommonActions().getDispOptsActions();
        actions.getLonePairsVisibleAction().setSelected(v);
    }

    @Override
    public void setValencePropertyVisible(boolean v) {
        super.setValencePropertyVisible(v);
        this.getCommonActions().getDispOptsActions().getValencePropertiesVisibleAction().setSelected(v);
    }

    @Override
    public void setLigandErrorVisible(boolean v) {
        super.setLigandErrorVisible(v);
        this.getCommonActions().getDispOptsActions().getLigandErrorVisibleAction().setSelected(v);
    }

    @Override
    public void setRendering(String s) {
        super.setRendering(s);
        DispOptsActions dispoptsActions = this.getCommonActions().getDispOptsActions();
        dispoptsActions.getRenderingActions().setValue(s);
    }

    @Override
    public void setSetColoringEnabled(boolean v) {
        super.setSetColoringEnabled(v);
        DispOptsActions actions = this.getCommonActions().getDispOptsActions();
        actions.getSetColoringEnabledAction().setSelected(v);
    }

    private void setGroupValue(String s, ToggleButtonActionGroup group) {
        try {
            group.setValue(s);
        }
        catch (IllegalArgumentException ex) {
            group.setSelectedIndex(-1);
        }
    }

    @Override
    public void setDispopts(int opts, boolean save, boolean setmenus) {
        super.setDispopts(opts, save, setmenus);
        if (setmenus) {
            this.setDispoptsMenuItems();
        }
    }

    public void cleanupActionGroups() {
        this.getCommonActions().cleanupActionGroups();
    }

    protected void setDispoptsMenuItems() {
        this.createVecs();
        this.getCommonActions().getDispOptsActions().setDispOpts(this.painterCommon.getDispopts());
        this.getCommonActions().getDispOptsActions().setDispOptsExt(this.painterCommon.getDispoptsExt());
        this.updateImplicitHActions();
        ToggleButtonActionGroup chiralitySupportActions = this.getCommonActions().getDispOptsActions().getChiralitySupportActions();
        chiralitySupportActions.setSelectedIndex(2 - chiralitySupportActions.getSelectedIndex());
    }

    private void updateImplicitHActions() {
        int opts = this.painterCommon.getDispopts();
        DispOptsActions actions = this.getCommonActions().getDispOptsActions();
        ToggleButtonActionGroup implhActions = actions.getImplicitHActions();
        if (this.painterCommon.isImplicitHEnabled() && !this.painterCommon.isImplicitHEnabledWhenCarbon()) {
            int selInd = implhActions.getSelectedIndex();
            implhActions.setEnabled(3, true);
            implhActions.setEnabled(2, true);
            implhActions.setEnabled(1, false);
            implhActions.setEnabled(0, false);
            if (selInd <= 1) {
                implhActions.setSelectedIndex(2);
            }
        } else {
            implhActions.setEnabled(this.painterCommon.isImplicitHEnabled());
            implhActions.setSelectedIndex(3 - opts & 3);
        }
    }

    public CommonActions getCommonActions() {
        if (this.commonActions == null) {
            this.commonActions = new CommonActions(this, MM_MAP, null);
        }
        return this.commonActions;
    }

    protected final MAction createAction(String cmd, String label, KeyStroke accel) {
        KeyStroke[] keyStrokeArray;
        MAction action = new MAction(cmd, label, accel);
        if (accel != null) {
            KeyStroke[] keyStrokeArray2 = new KeyStroke[1];
            keyStrokeArray = keyStrokeArray2;
            keyStrokeArray2[0] = accel;
        } else {
            keyStrokeArray = null;
        }
        this.initAccelerators(action, keyStrokeArray);
        return action;
    }

    public static void removeFromActionsRecursively(Container menu) {
        if (menu == null) {
            return;
        }
        int elemcount = menu.getComponentCount();
        if (menu instanceof JMenu) {
            elemcount = ((JMenu)menu).getItemCount();
        }
        for (int i = elemcount - 1; i >= 0; --i) {
            Component c;
            Component component = c = menu instanceof JMenu ? ((JMenu)menu).getItem(i) : menu.getComponent(i);
            if (c instanceof JMenu) {
                ViewPanel.removeFromActionsRecursively((Container)c);
            }
            if (c instanceof MActionComponent) {
                ((MActionComponent)((Object)c)).removeFromAction();
            }
            menu.remove(i);
        }
    }

    @Override
    public void setPrintEnabled(boolean b) {
        super.setPrintEnabled(b);
        this.getViewActions().getPrintAll().setEnabled(b);
        this.getViewActions().getPrintCell().setEnabled(b);
        this.getViewActions().getPrintVisible().setEnabled(b);
    }

    @Override
    public void updateBounds() {
        int selectedCell = this.getSelectedCellIndex();
        ViewCanvas canvas = selectedCell >= 0 ? this.getCanvas(selectedCell) : this.getCanvas(0);
        if (canvas != null) {
            MoleculeGraph mol = canvas.getDocument().getMainMoleculeGraph();
            Molecule molecule = null;
            if (!this.painterCommon.isRgDefinitionVisible() && mol instanceof RgMoleculeGraphIface) {
                molecule = (Molecule)((RgMoleculeGraphIface)((Object)mol)).getRootG();
            } else if (mol instanceof Molecule) {
                molecule = (Molecule)mol;
            }
            if (molecule != null) {
                canvas.getPainter().setBoundsFor(molecule, false, false);
                canvas.fitPage();
            }
        }
    }

    public void doFireAtomMarkLocationChange(int newMarkedCell, int newMarkedAtom) {
        this.propertyChange(new PropertyChangeEvent(this, "atomMarked", this.getOldMarkedCell() + "," + this.getOldMarkedAtom(), newMarkedCell + "," + newMarkedAtom));
        this.setOldMarkedAtom(newMarkedAtom);
        this.setOldMarkedCell(newMarkedCell);
    }

    public int getOldMarkedCell() {
        return this.oldMarkedCell;
    }

    private void setOldMarkedCell(int oldMarkedCell) {
        this.oldMarkedCell = oldMarkedCell;
    }

    public int getOldMarkedAtom() {
        return this.oldMarkedAtom;
    }

    private void setOldMarkedAtom(int oldMarkedAtom) {
        this.oldMarkedAtom = oldMarkedAtom;
    }

    public boolean isAtomMarkAndHighlightEnabled() {
        return this.atomMarkAndHighlightEnabled;
    }

    public void setAtomMarkAndHighlightEnabled(boolean enabled) {
        if (!enabled && this.oldMarkedAtom != -1 && this.oldMarkedCell != -1) {
            this.getCanvas(this.oldMarkedCell).removeAtomMark(true);
        }
        this.atomMarkAndHighlightEnabled = enabled;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        super.propertyChange(ev);
        String key = ev.getPropertyName();
        if (key.equals("viewAtomMarkEnabled")) {
            this.setAtomMarkAndHighlightEnabled((Boolean)ev.getNewValue());
        } else if (key.equals("viewRendering2d") || key.equals("viewRendering3d")) {
            this.setRendering(ev.getNewValue().toString());
            this.repaintMols();
        }
    }

    static {
        total = 0L;
        live = 0L;
        RESOURCES = ViewPanel.getResourceBundle(ViewPanel.class.getName());
        MM_MAP = new int[5];
        ViewPanel.MM_MAP[0] = 0;
        ViewPanel.MM_MAP[1] = 1;
        ViewPanel.MM_MAP[2] = 3;
        ViewPanel.MM_MAP[3] = 2;
        ViewPanel.MM_MAP[4] = 4;
    }

    private class IntArrayIterator
    implements Iterator {
        private int[] array;
        private int index = 0;

        public IntArrayIterator(int[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.array[this.index++];
            }
            throw new NoSuchElementException("No more element");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unsupported operation");
        }
    }

    private class SaveThread
    implements Runnable {
        private File f;
        private final MolExportModule cv;
        private final CallbackIface savemod;
        private final String format;
        private final SequentialScheduler scheduler;
        private final Iterator selectedIndexIt;
        private int startpos = 0;
        private boolean isStartedHourglass = false;

        private SaveThread(File f, MolExportModule cv, CallbackIface savemod, String format2, SequentialScheduler scheduler, Iterator sii) {
            this.f = f;
            this.cv = cv;
            this.savemod = savemod;
            this.format = format2;
            this.scheduler = scheduler;
            this.selectedIndexIt = sii;
            if (this.selectedIndexIt != null) {
                this.startpos = (Integer)this.selectedIndexIt.next();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void end() {
            try {
                ViewPanel.this.endSave(this.f, this.cv, this.savemod, this.format);
            }
            finally {
                ViewPanel.this.endHourglass();
            }
        }

        @Override
        public void run() {
            int n;
            MDocStorage ds;
            block12: {
                ds = ViewPanel.this.viewHandler.getStorage();
                n = ds.getSize();
                if (!this.isStartedHourglass) {
                    ViewPanel.this.beginHourglass();
                    this.isStartedHourglass = true;
                }
                try {
                    int x;
                    if (this.selectedIndexIt == null) {
                        x = this.startpos;
                        while (x < n) {
                            MDocument d = ds.getMainDoc(x++);
                            ViewPanel.this.saveMol(this.f, d, this.cv, this.savemod);
                        }
                        this.startpos = n;
                        break block12;
                    }
                    try {
                        x = this.startpos;
                        while (x < n) {
                            MDocument d = ds.getMainDoc(x);
                            ViewPanel.this.saveMol(this.f, d, this.cv, this.savemod);
                            x = (Integer)this.selectedIndexIt.next();
                        }
                        this.startpos = x;
                    }
                    catch (NoSuchElementException nee) {
                        this.end();
                        return;
                    }
                }
                catch (LicenseException lex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewPanel.this.getErrorDisplay().error(lex.getMessage(), lex);
                        }
                    });
                }
                catch (IOException ex) {
                    this.end();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ViewPanel.this.getErrorDisplay().error("Cannot convert molecule(s) to `" + SaveThread.this.format + "' format", ex);
                            ViewPanel.this.callback("setFileFromLoadSave", ViewPanel.this);
                        }
                    });
                    return;
                }
                catch (MDocStorage.RecordUnavailableException ex) {
                    this.end();
                    return;
                }
            }
            if (ds.getSize() == n) {
                this.end();
            } else {
                String name = this.selectedIndexIt != null ? "saveAll(" + n + "-" : "saveMore(" + n + "-";
                this.scheduler.invokeLater(this, n, name);
            }
        }
    }
}

