/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.modules.FindInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class FindText
implements CallbackIface,
FindInfo,
KeyListener {
    private static final ResourceBundle RESOURCES = MolPanel.getResourceBundle(FindText.class.getName());
    private static final String EOFREACHED_TITLE = RESOURCES.getString("eofReachedTitle");
    private static final String EOFREACHED_MESSAGE = RESOURCES.getString("eofReachedMessage");
    private ViewHandler viewHandler;
    private String theWord = "";
    private int theIndexToGo = -1;
    private boolean caseSensitive = false;
    private JTextField textField;
    private JDialog dialog;
    private JButton gotoButton;
    private JButton findNextButton;
    private JCheckBox matchCaseCB;
    private JButton closeButton;
    private Window parent;
    private Action gotoAction;
    private Action findNextAction;
    private Action closeAction;
    private PropertyChangeSupport changeListeners = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeListeners.addPropertyChangeListener(l);
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setViewHandler")) {
            this.setViewHandler((ViewHandler)arg);
        } else if (method.equals("addPropertyChangeListener")) {
            this.addPropertyChangeListener((PropertyChangeListener)arg);
        } else if (method.equals("show")) {
            this.setParent((Window)arg);
            this.show();
        } else if (method.equals("findAgain")) {
            this.findFromCurrentRecord();
        }
        return null;
    }

    @Override
    public String getWord() {
        return this.theWord;
    }

    public void setWord(String word) {
        String old = this.theWord;
        this.theWord = word;
        this.changeListeners.firePropertyChange("word", old, word);
    }

    @Override
    public boolean getMatchCase() {
        return this.caseSensitive;
    }

    public void setViewHandler(ViewHandler vh) {
        this.viewHandler = vh;
    }

    public void setParent(Window parent) {
        this.parent = parent;
    }

    public void show() {
        if (this.parent instanceof Dialog) {
            this.dialog = new JDialog((Dialog)this.parent);
        }
        if (this.parent instanceof Frame) {
            this.dialog = new JDialog((Frame)this.parent);
        }
        this.gotoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindText.this.doGoTo();
            }
        };
        SwingUtil.initAction(this.gotoAction, RESOURCES, "goto", null);
        this.gotoAction.setEnabled(false);
        this.findNextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindText.this.doFindFromCurrentRecord();
            }
        };
        SwingUtil.initAction(this.findNextAction, RESOURCES, "findNext", null);
        this.closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindText.this.doClose();
            }
        };
        SwingUtil.initAction(this.closeAction, RESOURCES, "close", null);
        this.initComponents();
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setVisible(true);
    }

    private void initComponents() {
        this.dialog.setTitle("Find");
        this.dialog.setResizable(false);
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createFindPanel(), "Center");
        contentPane.add((Component)this.createButtonBar(), "South");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
    }

    @Override
    public void keyPressed(KeyEvent ev) {
        Object src = ev.getSource();
        if (src instanceof AbstractButton) {
            char c = ev.getKeyChar();
            if (c == '\u001b') {
                this.doClose();
            } else if (c == '\n') {
                this.doFindFromCurrentRecord();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ev) {
        if (ev.getSource() instanceof JTextComponent) {
            String text = this.textField.getText();
            int i = -1;
            try {
                i = Integer.parseInt(text);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (i >= 1) {
                this.setWord("");
                this.gotoAction.setEnabled(true);
                this.theIndexToGo = i - 1;
            } else {
                this.theIndexToGo = -1;
                this.gotoAction.setEnabled(false);
            }
            this.findNextAction.setEnabled(text.length() != 0);
        }
    }

    @Override
    public void keyTyped(KeyEvent ev) {
        if (ev.getSource() instanceof JTextComponent && ev.getKeyChar() == '\u001b') {
            this.doClose();
        }
    }

    private JPanel createFindPanel() {
        this.textField = new JTextField(40);
        if (!this.theWord.equals("")) {
            this.textField.setText(this.theWord);
        } else {
            int topLeft = this.viewHandler.getTopLeft();
            int irec = this.viewHandler.recordIndexFromCellIndex(topLeft);
            this.textField.setText(String.valueOf(irec + 1));
        }
        this.textField.select(0, this.textField.getText().length());
        this.textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (FindText.this.theIndexToGo >= 0) {
                    FindText.this.doGoTo();
                } else {
                    FindText.this.doFindFromCurrentRecord();
                }
                FindText.this.doClose();
            }
        });
        this.textField.addKeyListener(this);
        JPanel p = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        p.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbl.setConstraints(p.add(this.textField), gbc);
        return p;
    }

    private JPanel createButtonBar() {
        this.gotoButton = new JButton(this.gotoAction);
        this.findNextButton = new JButton(this.findNextAction);
        this.matchCaseCB = new JCheckBox("Match Case");
        this.matchCaseCB.setSelected(this.caseSensitive);
        this.closeButton = new JButton(this.closeAction);
        JPanel p = new JPanel();
        p.add(this.gotoButton);
        p.add(this.findNextButton);
        p.add(this.matchCaseCB);
        p.add(this.closeButton);
        for (int i = 0; i < p.getComponentCount(); ++i) {
            AbstractButton b = (AbstractButton)p.getComponent(i);
            b.addKeyListener(this);
        }
        return p;
    }

    private void doFindFromCurrentRecord() {
        this.setWord(this.textField.getText());
        this.caseSensitive = this.matchCaseCB.isSelected();
        if (!this.theWord.equals("")) {
            this.findFromCurrentRecord();
        }
    }

    private void doGoTo() {
        ViewHandler vh = this.viewHandler;
        int ncols = vh.getColumnCount();
        int nrecs = vh.getNumRecordsInARow();
        vh.setTopLeft(this.theIndexToGo * ncols / nrecs);
    }

    private void findFromCurrentRecord() {
        int topLeft = this.viewHandler.getTopLeft();
        int irec = this.viewHandler.recordIndexFromCellIndex(topLeft);
        int row0 = this.viewHandler.rowFromRecordIndex(irec);
        while (this.viewHandler.rowFromRecordIndex(++irec) == row0) {
        }
        this.findFromRecord(irec);
    }

    private void findFromRecord(final int firstRecordIndex) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                int irec;
                int max;
                MDocStorage ds = FindText.this.viewHandler.getStorage();
                int rrecs = FindText.this.viewHandler.getNumRecordsInARow();
                int vrecs = rrecs * FindText.this.viewHandler.getVisibleRows();
                int nrecs = FindText.this.viewHandler.getNumRecords();
                String[] text = null;
                int n = max = rrecs == 1 ? nrecs - vrecs : nrecs - vrecs + rrecs;
                for (irec = firstRecordIndex; irec < max && (text = FindText.this.viewHandler.readTextFieldValues(irec, text)) != null; ++irec) {
                    if (!FindText.matches(text, FindText.this.theWord, FindText.this.caseSensitive)) continue;
                    int row = FindText.this.viewHandler.rowFromRecordIndex(irec);
                    int ncols = FindText.this.viewHandler.getColumnCount();
                    final int icell = row * ncols;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FindText.this.viewHandler.setTopLeft(icell);
                        }
                    });
                    return;
                }
                if (irec >= nrecs - vrecs) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int r = JOptionPane.showConfirmDialog(FindText.this.parent, EOFREACHED_MESSAGE, EOFREACHED_TITLE, 0, 1);
                            if (r == 0) {
                                FindText.this.findFromRecord(0);
                            } else {
                                FindText.this.doClose();
                            }
                        }
                    });
                }
            }
        };
        this.viewHandler.getScheduler().invokeLater(run, firstRecordIndex);
    }

    private static boolean matches(String[] text, String str, boolean cs) {
        if (cs) {
            for (int i = 0; i < text.length; ++i) {
                if (text[i].indexOf(str) < 0) continue;
                return true;
            }
        } else {
            str = str.toLowerCase();
            for (int i = 0; i < text.length; ++i) {
                if (text[i].toLowerCase().indexOf(str) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private void doClose() {
        if (this.dialog != null && this.dialog.isVisible()) {
            this.setWord(this.theIndexToGo < 0 ? this.textField.getText() : "");
            this.caseSensitive = this.matchCaseCB.isSelected();
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
        }
    }
}

