/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.swing.CellFiller;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;

public class GridBagCellFiller
extends CellFiller {
    private ViewPanel vpan;

    public GridBagCellFiller(ViewPanel p) {
        this.vpan = p;
    }

    @Override
    public void fillCellInViewApp(int i, MDocument doc, String label, int n) {
        ViewHandler vh = this.vpan.getViewHandler();
        if (doc != null && this.getSDFColoring() != null) {
            this.getSDFColoring().perform(doc);
        }
        this.setDocument(i, doc);
        if (this.isSingleCellLabelShown() || n > 1) {
            vh.setL(i, label);
        }
        if (doc != null) {
            int textCount;
            boolean shMolname = this.isMolNameShown();
            boolean shGenName = this.isGenNameShown();
            boolean shSmiles = this.isSMILESShown();
            boolean shFields = this.getFieldsShown();
            int nf = shFields ? this.getSelectedFields().length : 0;
            int n2 = textCount = nf > 0 ? 1 : 0;
            if (shMolname) {
                ++textCount;
            }
            if (shGenName) {
                ++textCount;
            }
            if (shSmiles) {
                ++textCount;
            }
            int textI = 0;
            if (shMolname) {
                String name = doc.getMainMoleculeGraph().getName();
                vh.setT(i * textCount + textI++, name);
            }
            if (shGenName && LicenseHandler.getInstance().isLicensed("Structure to Name Plugin")) {
                Molecule mol = doc.getPrimaryMolecule();
                String name = null;
                try {
                    name = mol.exportToFormat("name");
                }
                catch (MolExportException ex) {
                    for (Throwable t = ex; t != null; t = t.getCause()) {
                        name = t.getMessage();
                    }
                }
                vh.setT(i * textCount + textI++, name);
            }
            if (shSmiles) {
                String smilesstr = "";
                try {
                    String[] res = MFileFormatUtil.convertToSmilingFormat(doc.getPrimaryMolecule());
                    smilesstr = res[0];
                }
                catch (Throwable ex) {
                    for (Throwable t = ex; t != null; t = t.getCause()) {
                        smilesstr = t.getMessage();
                    }
                }
                vh.setT(i * textCount + textI++, smilesstr);
            }
            Molecule mainmol = (Molecule)doc.getMainMoleculeGraph();
            if (shFields && nf > 0) {
                vh.setT(i * textCount + textI++, this.getFields(mainmol));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDocument(int i, MDocument doc) {
        Molecule m = null;
        if (doc != null) {
            m = (Molecule)doc.getMainMoleculeGraph();
        }
        MDocStorage mDocStorage = this.vpan.getViewHandler().getStorage();
        synchronized (mDocStorage) {
            this.vpan.setM(i, m);
        }
    }

    private String getFields(Molecule mol) {
        StringBuffer sb = new StringBuffer();
        String[] incFields = this.getSelectedFields();
        for (int i = 0; i < incFields.length; ++i) {
            GridBagCellFiller.appendField(mol, incFields[i], sb);
        }
        sb.setLength(sb.length() == 0 ? 0 : sb.length() - 1);
        return sb.toString();
    }

    private static String appendField(Molecule mol, String key, StringBuffer sb) {
        String value = mol.getProperty(key);
        if (value != null) {
            value = value.trim();
            try {
                try {
                    Integer inum = Integer.valueOf(value);
                    value = inum.toString();
                }
                catch (NumberFormatException ex) {
                    Double dnum = Double.valueOf(value);
                    value = dnum.toString();
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            if (!value.equals("")) {
                sb.append(key + ": " + value + "\n");
            }
        }
        return value;
    }
}

