/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.core.util.BondTable;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.common.swing.MolButton;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.paint.internal.MolPainterCommon;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.Environment;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.text.MStringTokenizer;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.SequentialScheduler;
import chemaxon.marvin.view.swing.CellFiller;
import chemaxon.marvin.view.swing.RecordFetcher;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.VisibleDocuments;
import chemaxon.marvin.view.swing.modules.GridBagCellFiller;
import chemaxon.marvin.view.swing.modules.MEditorPane;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class GridBagView
extends ViewHandler
implements AdjustmentListener,
PropertyChangeListener,
MouseWheelListener {
    private static final long serialVersionUID = -789048384817106941L;
    private static final int SCRBAR_VALUE = 1;
    private static final int SCRBAR_MAXIMUM = 2;
    private static final int SCRBAR_VISIBLE = 4;
    private ViewPanel viewPanel;
    private CellFiller cellFiller;
    private int visibleRows;
    private int visibleCols;
    private ViewCanvas[][] horizontalBorders = null;
    private ViewCanvas[][] verticalBorders = null;
    private JScrollBar vScrollBar = null;
    private int vScrollBarValidValue = 0;
    private int vScrollBarTempValue = 0;
    private JScrollBar hScrollBar = null;
    private int hScrollBarValidValue = 0;
    private int hScrollBarTempValue = 0;
    private Window[] molFrames;
    private double defaultWinScale;
    private Map<Integer, Double> winScales;
    private transient JFrame[] imgFrames;
    private int numVisibleHdrCells;
    private int numHdrCells;
    private int topRow;
    private int leftCol;
    private MDocStorage docStorage;
    private RecordFetcher recordFetcher;
    private Dimension[] molSizes = null;
    private List<ViewCanvas> visibleCanV = new ArrayList<ViewCanvas>();
    private String[] labLabels = null;
    private String[] btnLabels = null;
    private byte[] btnEnabled = null;
    private String[][] cbxLabels = null;
    private boolean[] cbxStates = null;
    private byte[] cbxEnabled = null;
    private String[] txtStrings = null;
    private boolean[] txtEnabled = null;
    private String[][] imgFiles = null;
    private transient Image[][] imgImages = null;
    private String[] imgTitles = null;
    private int[] numberM = null;
    private int[] numberL = null;
    private int[] numberB = null;
    private int[] numberC = null;
    private int[] numberT = null;
    private int[] numberI = null;
    private Map<ViewCanvas, GridBagConstraints> canvasGbcs;
    private Font[] labfnt;
    private Font[] txtfnt;
    private Font[] btnfnt;
    private String[] btndsc;
    private List<JLabel> visibleLabV;
    private List<MolButton> visibleCbxV;
    private List<JTextComponent> visibleTxtV;
    private List<MolButton> visibleImgV;
    private Font[] cbxfnt;
    private String[] cbxdsc;
    private String[] cbxjs;
    private int[] cbxg;
    private List<List<Integer>> cbgvV;
    private short[] txtFlags;
    private List<MolButton> visibleBtnV;
    private String[] btnurl;
    private String[] btnspecc;
    private String[] btnfrm;
    private Map<String, String> celljs = new HashMap<String, String>();
    private Runnable scrollBarUpdaterInEDT = new Runnable(){

        @Override
        public void run() {
            GridBagView.this.setVerticalScrollBarMaximum(GridBagView.this.getBestScrollBarMax());
        }
    };
    private Runnable scrollBarUpdater = new Runnable(){

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                GridBagView.this.scrollBarUpdaterInEDT.run();
            } else {
                EventQueue.invokeLater(GridBagView.this.scrollBarUpdaterInEDT);
            }
        }
    };

    public GridBagView(String args, MDocStorage ds, SequentialScheduler sch, int endi) {
        if (ds == null) {
            ds = new MDocStorage(0);
        }
        this.recordFetcher = new RecordFetcher(ds, this.scrollBarUpdater, null, sch, endi);
        this.docStorage = ds;
        ds.addListener(new MDocStorage.Listener(){

            @Override
            public void docProduced(MDocStorage ds, MDocument doc, int k) {
                GridBagView.this.viewPanel.setAtomAndBondSets(k);
            }

            @Override
            public void storageSizeChanged(MDocStorage ds, int oldsz, int sz) {
                GridBagView.this.setVerticalScrollBarMaximum(GridBagView.this.getBestScrollBarMax());
            }

            @Override
            public void storageSizeFinalized(MDocStorage ds) {
            }
        });
        this.defaultWinScale = -1.0;
        this.winScales = new HashMap<Integer, Double>();
    }

    @Override
    public String getNameAndArgs() {
        return "GridBagView";
    }

    @Override
    protected void destruct() {
        for (int i = 0; i < this.visibleCanV.size(); ++i) {
            ViewCanvas c = this.visibleCanV.get(i);
            this.viewPanel.removePropertyChangeListener(c);
            c.removePopupMenu();
        }
        this.visibleCanV.clear();
        ViewPanel v = this.viewPanel;
        if (v != null) {
            v.removePropertyChangeListener(this);
        }
    }

    @Override
    protected void init(ViewPanel v, Window f0) {
        if (this.viewPanel != null) {
            this.viewPanel.removePropertyChangeListener(this);
        }
        this.viewPanel = v;
        v.addPropertyChangeListener(this);
        v.addMouseWheelListener(this);
        this.cellFiller = new GridBagCellFiller(v);
        this.visibleLabV = new ArrayList<JLabel>();
        this.visibleCbxV = new ArrayList<MolButton>();
        this.cbgvV = new ArrayList<List<Integer>>();
        this.visibleBtnV = new ArrayList<MolButton>();
        this.visibleTxtV = new ArrayList<JTextComponent>();
        this.visibleImgV = new ArrayList<MolButton>();
        this.canvasGbcs = new HashMap<ViewCanvas, GridBagConstraints>();
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int vrows = rows;
        int vcols = cols;
        String s = this.viewPanel.getParameter("visibleRows");
        if (s != null) {
            vrows = Integer.parseInt(s);
        }
        if ((s = this.viewPanel.getParameter("visibleCols")) != null) {
            vcols = Integer.parseInt(s);
        }
        this.viewPanel.setVisibleSize(vrows, vcols);
        int maxcells = rows * cols;
        for (int i = 0; i < maxcells; ++i) {
            String key = "molChanged" + String.valueOf(i);
            String value = this.viewPanel.getParameter(key);
            if (value == null) continue;
            this.celljs.put(key, value);
        }
        String[] scomps = new String[2];
        int[][] grids = new int[2][];
        int[][] nccs = new int[2][6];
        String[] layouts = new String[]{this.viewPanel.getParameter("layoutH"), this.viewPanel.getParameter("layout")};
        if (layouts[0] == null && layouts[1] == null) {
            layouts[0] = this.viewPanel.getParameter("layout0");
            layouts[1] = this.viewPanel.getParameter("layout" + this.visibleCols);
            if (layouts[0] != null && layouts[1] != null) {
                System.err.println("deprecated parameters: layout0, layout" + this.visibleCols + "; use layoutH and layout instead");
            } else {
                layouts[1] = layouts[0];
                layouts[0] = null;
            }
        }
        if (layouts[1] == null) {
            layouts[1] = ":1:1:M:0:0:1:1:c:b:1:1";
        }
        if (layouts[0] != null) {
            this.inilay(0, layouts, scomps, grids, nccs);
        } else {
            grids[0] = new int[2];
            scomps[0] = "";
            nccs[0] = new int[6];
        }
        this.inilay(1, layouts, scomps, grids, nccs);
        int[] pnccs = null;
        int nM = 0;
        int nL = 0;
        int nB = 0;
        int nC = 0;
        int nT = 0;
        int nI = 0;
        this.numVisibleHdrCells = layouts[0] != null ? this.visibleCols : 0;
        this.numHdrCells = layouts[0] != null ? cols : 0;
        this.topRow = this.numHdrCells > 0 ? 1 : 0;
        this.setVisibleDocs(null);
        this.leftCol = 0;
        this.numberM = new int[2];
        this.numberL = new int[2];
        this.numberB = new int[2];
        this.numberC = new int[2];
        this.numberT = new int[2];
        this.numberI = new int[2];
        for (int i = 0; i < 2; ++i) {
            pnccs = nccs[i];
            this.numberM[i] = pnccs[0];
            nM += this.numberM[i];
            this.numberL[i] = pnccs[1];
            nL += this.numberL[i];
            this.numberB[i] = pnccs[2];
            nB += this.numberB[i];
            this.numberC[i] = pnccs[3];
            nC += this.numberC[i];
            this.numberT[i] = pnccs[4];
            nT += this.numberT[i];
            this.numberI[i] = pnccs[5];
            nI += this.numberI[i];
        }
        this.labfnt = new Font[nL];
        this.btnfnt = new Font[nB];
        this.btndsc = new String[nB];
        this.btnfrm = new String[nB];
        this.cbxfnt = new Font[nC];
        this.cbxdsc = new String[nC];
        this.cbxg = new int[nC];
        this.txtfnt = new Font[nT];
        this.txtFlags = new short[nT];
        String[] param = new String[2];
        if (this.numHdrCells != 0) {
            s = this.viewPanel.getParameter("paramH");
            if (s == null && (s = this.viewPanel.getParameter("param0")) != null) {
                System.err.println("deprecated parameter param0");
            }
            param[0] = s;
        }
        if ((s = this.viewPanel.getParameter("param")) == null) {
            s = this.viewPanel.getParameter("param" + this.numHdrCells);
        }
        if (s == null) {
            Dimension d;
            JApplet applet = this.viewPanel.getApplet();
            if (applet != null) {
                d = applet.getSize();
                d.width /= this.visibleCols;
                d.height /= this.visibleRows;
            } else {
                d = new Dimension(400, 250);
            }
            s = ":M:".concat(String.valueOf(d.width)).concat(":").concat(String.valueOf(d.height));
        }
        param[1] = s;
        this.molSizes = new Dimension[nM];
        if (param[0] != null) {
            this.inicomps(param[0], scomps[0], 0, 0, 0, 0, 0, 0);
        }
        if (param[1] != null) {
            this.inicomps(param[1], scomps[1], this.numberM[0], this.numberL[0], this.numberB[0], this.numberC[0], this.numberT[0], this.numberI[0]);
        }
        nM = this.numberM[0] * cols + this.numberM[1] * (maxcells - this.numHdrCells);
        nL = this.numberL[0] * cols + this.numberL[1] * (maxcells - this.numHdrCells);
        nB = this.numberB[0] * cols + this.numberB[1] * (maxcells - this.numHdrCells);
        nC = this.numberC[0] * cols + this.numberC[1] * (maxcells - this.numHdrCells);
        nT = this.numberT[0] * cols + this.numberT[1] * (maxcells - this.numHdrCells);
        nI = this.numberI[0] * cols + this.numberI[1] * (maxcells - this.numHdrCells);
        this.imgFrames = new JFrame[nI];
        this.btnspecc = new String[nB];
        this.btnurl = new String[nB];
        this.cbxjs = new String[nC << 1];
        if (this.viewPanel.getDebug() != 0) {
            System.err.print("number of cells: ");
            System.err.println(maxcells);
        }
        this.labLabels = new String[this.numHdrCells * this.numberL[0]];
        this.btnLabels = new String[nB];
        this.btnEnabled = new byte[nB];
        this.cbxLabels = new String[nC][2];
        this.cbxStates = new boolean[nC];
        this.cbxEnabled = new byte[nC];
        this.txtStrings = new String[this.numHdrCells * this.numberT[0]];
        this.txtEnabled = new boolean[this.numHdrCells * this.numberT[0]];
        this.imgFiles = new String[nI][2];
        this.imgImages = new Image[nI][2];
        this.imgTitles = new String[nI];
        this.paracells(scomps, grids);
        this.setNumRecords(nM);
        this.viewPanel.initMolArrays(nM, 1);
        this.inicells(maxcells, scomps);
        this.hScrollBarTempValue = 0;
        this.vScrollBarTempValue = 0;
        if (this.recordFetcher != null) {
            this.recordFetcher.setProgressBar(null);
            this.recordFetcher.setErrorDisplay(this.viewPanel.getErrorDisplay());
        }
    }

    @Override
    protected void setDebug(boolean debug) {
        super.setDebug(debug);
        List<ViewCanvas> v = this.visibleCanV;
        if (v != null && debug) {
            for (int i = 0; i < v.size(); ++i) {
                ViewCanvas canvas = v.get(i);
                canvas.callback("debug", null);
            }
        }
    }

    @Override
    protected void setMarvinCursor() {
        for (int i = 0; i < this.visibleCanV.size(); ++i) {
            ViewCanvas c = this.visibleCanV.get(i);
            Cursor cc = this.viewPanel.getCurrentCursor();
            c.setCursor(cc);
        }
    }

    @Override
    protected void initTransientC() {
        if (this.visibleCanV != null) {
            for (int i = 0; i < this.visibleCanV.size(); ++i) {
                ViewCanvas c = this.visibleCanV.get(i);
                if (c == null) continue;
                c.initTransient();
            }
        }
    }

    @Override
    public boolean isIncrementable() {
        return false;
    }

    @Override
    public MDocStorage getStorage() {
        return this.docStorage;
    }

    @Override
    public CellFiller getCellFiller() {
        return this.cellFiller;
    }

    @Override
    public RecordFetcher getRecordFetcher() {
        return this.recordFetcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setNumRecords(int nrec) {
        MDocStorage ds;
        MDocStorage mDocStorage = ds = this.docStorage;
        synchronized (mDocStorage) {
            if (ds.getSize() != nrec) {
                ds.setSize(nrec);
            }
        }
    }

    @Override
    protected void storageSizeChanged(int oldsz, int newsz) {
    }

    @Override
    protected void storageSizeFinalized(int sz) {
    }

    @Override
    public int getNumMoleculesInRecord() {
        return 1;
    }

    @Override
    public String[] readTextFieldValues(int irec, String[] out) {
        int n1t;
        int n1l = this.numberL != null ? this.numberL[1] : 0;
        int n = n1t = this.numberT != null ? this.numberT[1] : 0;
        if (out == null || out.length != n1l + n1t) {
            out = new String[n1l + n1t];
        }
        int nl = irec * n1l;
        for (int i = 0; i < n1l; ++i) {
            out[i] = this.getL0(nl + i);
        }
        int nt = irec * n1t;
        for (int i = 0; i < n1t; ++i) {
            out[n1l + i] = this.getT0(nt + i);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setMainDocumentInRecord(int irec, MDocument doc) {
        MDocStorage ds;
        MDocStorage mDocStorage = ds = this.docStorage;
        synchronized (mDocStorage) {
            Window f;
            int nrec;
            int nrec0 = ds.getSize();
            ds.storeMainDoc(doc, irec);
            VisibleDocuments vd = this.getVisibleDocs();
            if (vd != null) {
                vd.store(irec, doc);
            }
            if ((nrec = ds.getSize()) > nrec0) {
                this.setVerticalScrollBarMaximum(this.getBestScrollBarMax());
            }
            if ((f = this.getFrame(irec)) != null) {
                ((CallbackIface)((Object)f)).callback("setTitle", doc);
            }
        }
    }

    @Override
    protected void initMainDocumentInRecord(int icell, boolean init) {
        ViewCanvas canv = this.getCanvas(icell);
        if (canv != null) {
            MDocument doc = this.getCachedDocument(icell, 0);
            MolPainter p = this.getMolPainter(icell);
            canv.setDocument(doc, init ? p : null, icell);
            DPoint3 center = this.getMolCenter(icell);
            canv.setCenter(center);
            canv.setReqScale(this.getWinScale(icell));
            this.viewPanel.setAnimatedIfNeeded(icell);
            canv.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MDocument getCachedDocument(int irec, int j) {
        if (irec >= 0 && j == 0) {
            VisibleDocuments vd = this.getVisibleDocs();
            if (this.docStorage.getDocSource() != null && vd != null) {
                MDocument doc = vd.getMainDocument(irec);
                return doc;
            }
            MDocStorage mDocStorage = this.docStorage;
            synchronized (mDocStorage) {
                MDocument doc = this.docStorage.getCachedDoc(irec, null);
                return doc;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setDocument(int irec, int im, MDocument doc) {
        if (im == 0) {
            MDocStorage mDocStorage = this.docStorage;
            synchronized (mDocStorage) {
                this.docStorage.storeMainDoc(doc, irec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setMolPainter(int irec, int im, MolPainter p) {
        if (im == 0) {
            MDocStorage mDocStorage = this.docStorage;
            synchronized (mDocStorage) {
                this.docStorage.setMolPainter(irec, null, p);
            }
        }
    }

    @Override
    public MolPainter getMolPainter(int icell) {
        return this.docStorage.getMolPainter(icell, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMolCenter(int icell, DPoint3 p) {
        MDocStorage mDocStorage = this.docStorage;
        synchronized (mDocStorage) {
            this.docStorage.setMolCenter(icell, null, p);
        }
        ViewCanvas c = this.getCanvas(icell);
        if (c != null) {
            c.setCenter(p);
        }
    }

    @Override
    public DPoint3 getMolCenter(int icell) {
        DPoint3 p = this.docStorage.getMolCenter(icell, null);
        return p != null ? new DPoint3(p) : new DPoint3();
    }

    private void initTransient() {
        if (this.imgFiles != null) {
            this.imgFrames = new JFrame[this.imgFiles.length];
            this.imgImages = new Image[this.imgFiles.length][2];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void molLoaded(MDocument doc, int irec) {
        if (doc == null) {
            this.setMainDocumentInRecord(irec, new MDocument(new Molecule()));
        } else {
            int[] sel;
            this.setMainDocumentInRecord(irec, doc);
            MDocStorage mDocStorage = this.docStorage;
            synchronized (mDocStorage) {
                sel = this.docStorage.getSelectedAtoms(irec, null);
            }
            Molecule[] m = doc.getPrimaryMolecules();
            if (sel != null) {
                for (int j = 0; j < sel.length; ++j) {
                    int atom = sel[j];
                    for (int k = 0; k < m.length; ++k) {
                        if (atom < 0 || atom >= m[k].getAtomCount()) continue;
                        m[k].getAtom(atom).setSelected(true);
                    }
                }
            }
            MDocStorage mDocStorage2 = this.docStorage;
            synchronized (mDocStorage2) {
                this.docStorage.setSelectedAtoms(irec, null, (int[])null);
            }
            this.doSetSetSeqs(m, irec);
        }
    }

    @Override
    protected void setValueAt(Object val, int irec, String key) {
        if (key == null) {
            MDocument doc = (MDocument)val;
            this.molLoaded(doc, irec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAtomSetSeq(int icell, int atom, int seq) {
        Molecule[] m;
        int im;
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        MDocument doc = this.getCachedDocument(irec, im = icell - irec * nm);
        Molecule[] moleculeArray = m = doc != null ? doc.getPrimaryMolecules() : null;
        if (m != null) {
            for (int j = 0; j < m.length; ++j) {
                MolAtom a = m[j].getAtom(atom);
                a.setSetSeq(seq);
            }
            ViewCanvas canv = this.getCanvas(icell);
            if (canv != null) {
                canv.repaint();
            }
            return;
        }
        MDocStorage mDocStorage = this.docStorage;
        synchronized (mDocStorage) {
            this.docStorage.setAtomSetSeq(icell, null, atom, seq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBondSetSeq(int icell, int j1, int j2, int seq) {
        int im;
        int nm;
        int irec;
        MDocument doc;
        Molecule[] m;
        if (j2 < j1) {
            int t = j2;
            j2 = j1;
            j1 = t;
        }
        Molecule[] moleculeArray = m = (doc = this.getCachedDocument(irec = icell / (nm = this.getNumMoleculesInRecord()), im = icell - irec * nm)) != null ? doc.getPrimaryMolecules() : null;
        if (m != null) {
            for (int j = 0; j < m.length; ++j) {
                BondTable btab = m[j].getBondTable();
                MolBond b = m[j].getBond(btab.getBondIndex(j1, j2));
                b.setSetSeq(seq);
            }
            ViewCanvas canv = this.getCanvas(icell);
            if (canv != null) {
                canv.repaint();
            }
            return;
        }
        MDocStorage mDocStorage = this.docStorage;
        synchronized (mDocStorage) {
            this.docStorage.setBondSetSeq(icell, null, j1, j2, seq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBondSetSeqAll(int icell, int seq) {
        int im;
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        MDocument doc = this.getCachedDocument(irec, im = icell - irec * nm);
        if (doc != null) {
            Molecule[] m = doc.getAllNonEmptyMolecules();
            for (int j = 0; j < m.length; ++j) {
                for (int k = 0; k < m[j].getBondCount(); ++k) {
                    MolBond b = m[j].getBond(k);
                    b.setSetSeq(seq);
                }
            }
            ViewCanvas canv = this.getCanvas(icell);
            if (canv != null) {
                canv.repaint();
            }
            return;
        }
        MDocStorage mDocStorage = this.docStorage;
        synchronized (mDocStorage) {
            this.docStorage.setBondSetSeqAll(icell, null, seq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetSetSeqs(Molecule[] mols, int icell) {
        MDocStorage mDocStorage = this.docStorage;
        synchronized (mDocStorage) {
            this.docStorage.doSetSetSeqs(mols, icell, null);
        }
        MolPainter p = this.getMolPainter(icell);
        Color bg = p != null ? p.getBackground() : this.viewPanel.getMolbg();
        for (int i = 0; i < mols.length; ++i) {
            this.viewPanel.painterCommon.fillUnsetSetPaletteInDoc(mols[i], bg);
        }
    }

    double getWinScale(int icell) {
        Double sc = this.winScales.get(new Integer(icell));
        return sc != null ? sc : (this.defaultWinScale > 0.0 ? this.defaultWinScale : this.viewPanel.getWinScale());
    }

    @Override
    protected void setWinScale(double sc) {
        this.defaultWinScale = sc;
    }

    @Override
    protected void setWinScale(int icell, double sc) {
        this.winScales.put(new Integer(icell), new Double(sc));
    }

    @Override
    protected void setDetachable(boolean b) {
        for (int i = 0; i < this.getCellCount(); ++i) {
            ViewCanvas c = this.getCanvas(i);
            if (c == null) continue;
            c.getWindowAction().setEnabled(b);
        }
    }

    @Override
    protected void setWinmode(int mode, int icell) {
        Object f;
        ViewCanvas canv = this.getCanvas(icell);
        if (canv == null) {
            return;
        }
        MDocument doc = canv.getDocument();
        Window frame = this.getFrame(icell);
        if (mode == 1 && doc != null) {
            if (frame == null) {
                block17: {
                    f = null;
                    try {
                        Window parent = SwingUtilities.getWindowAncestor(this.viewPanel);
                        if (parent instanceof Dialog || parent instanceof Frame) {
                            Class parentClass = parent instanceof Dialog ? Dialog.class : Frame.class;
                            try {
                                f = (CallbackIface)MarvinModule.load("view.swing.MViewFrame", new Class[]{parentClass}, new Object[]{parent}, this.viewPanel);
                                break block17;
                            }
                            catch (ExceptionInInitializerError ex) {
                                Throwable t = ex.getCause();
                                if (t instanceof SecurityException) {
                                    throw (SecurityException)t;
                                }
                                throw ex;
                            }
                            catch (Throwable ex) {
                                f = null;
                                break block17;
                            }
                        }
                        f = (CallbackIface)MarvinModule.load("view.swing.MViewFrame", this.viewPanel);
                    }
                    catch (SecurityException sex) {
                        this.viewPanel.getErrorDisplay().firewallError(sex, null);
                    }
                }
                if (f != null) {
                    f.callback("setIndex", new Integer(icell));
                    f.callback("setViewPanel", this.viewPanel);
                    f.callback("init", null);
                    f.callback("setTitle", doc);
                }
                frame = (Window)f;
                this.setFrame(icell, (Window)f);
            }
            canv.setReqScale(this.getWinScale(icell));
        }
        if (frame != null) {
            this.viewPanel.remove(canv);
            if (mode == 1) {
                f = this.viewPanel.getFont();
                if (frame instanceof RootPaneContainer) {
                    RootPaneContainer container = (RootPaneContainer)((Object)frame);
                    ((Component)container.getContentPane()).setFont((Font)f);
                }
                ((CallbackIface)((Object)frame)).callback("setViewCanvas", canv);
                frame.pack();
                this.viewPanel.showWindow(frame);
                frame.requestFocus();
            }
        }
        if (mode == 0) {
            MolPainter painter = canv.getPainter();
            if (painter != null) {
                MDocument d = this.getCachedDocument(icell, 0);
                painter.setBoundsFor(d);
                double tabScale = this.viewPanel.getTabScaleSimple();
                this.unsetWinmode(icell, painter, tabScale);
            }
            this.addCanvasAgain(icell, 0);
            this.viewPanel.validate();
            if (frame != null) {
                this.viewPanel.unregWindow(frame);
                this.setFrame(icell, null);
            }
        }
        this.viewPanel.repaint();
    }

    @Override
    public Window getFrame(int icell) {
        int i = -1;
        try {
            i = this.visibleIndex(icell, this.numberM);
        }
        catch (ArithmeticException ex) {
            return null;
        }
        return i >= 0 && i < this.molFrames.length ? this.molFrames[i] : null;
    }

    private void setFrame(int icell, Window f) {
        int i = -1;
        try {
            i = this.visibleIndex(icell, this.numberM);
        }
        catch (ArithmeticException ex) {
            return;
        }
        if (i >= 0 && i < this.molFrames.length) {
            this.molFrames[i] = f;
        }
    }

    @Override
    protected void updateRecord(int i) {
        String key = "molChanged" + String.valueOf(i);
        final String action = this.celljs.get(key);
        this.recordFetcher.startPrereadIfNeeded();
        if (action != null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    GridBagView.this.viewPanel.js(action);
                }
            };
            t.start();
        }
    }

    @Override
    protected void repaintMolComponent(int icell) {
        ViewCanvas c = this.getCanvas(icell);
        if (c != null) {
            c.repaint();
        }
    }

    @Override
    protected void repaintMols() {
        List<ViewCanvas> v = this.visibleCanV;
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                ViewCanvas c = v.get(i);
                c.repaint();
            }
        }
    }

    @Override
    protected void repaintText() {
    }

    @Override
    public void setVisibleSize(int vrows, int vcols) {
        int j;
        int i;
        if (this.molFrames != null) {
            int cols = this.getColumnCount();
            int r = this.topRow + this.visibleRows - this.numHdrCells / cols;
            for (i = this.topRow; i < r; ++i) {
                for (j = this.leftCol; j < this.leftCol + this.visibleCols; ++j) {
                    int icell = this.numHdrCells + (i - this.numHdrCells / cols) * cols + j;
                    this.setWinmode(0, icell);
                }
            }
        }
        this.visibleRows = vrows;
        this.visibleCols = vcols;
        int borderWidth = this.viewPanel.getBorderWidth();
        if (vrows > 1) {
            this.horizontalBorders = new ViewCanvas[vrows - 1][vcols];
            Color color = this.viewPanel.getBorderColor();
            for (i = 0; i < this.horizontalBorders.length; ++i) {
                for (j = 0; j < vcols; ++j) {
                    ViewCanvas c;
                    this.horizontalBorders[i][j] = c = new ViewCanvas();
                    c.setOpaque(true);
                    c.setBackground(color);
                    c.setReqSize(new Dimension(0, borderWidth));
                }
            }
        } else {
            this.horizontalBorders = null;
        }
        if (vcols > 1) {
            this.verticalBorders = new ViewCanvas[vrows][vcols - 1];
            Color color = this.viewPanel.getBorderColor();
            for (i = 0; i < vrows; ++i) {
                for (j = 0; j < this.verticalBorders[i].length; ++j) {
                    ViewCanvas c;
                    this.verticalBorders[i][j] = c = new ViewCanvas();
                    c.setOpaque(true);
                    c.setBackground(color);
                    c.setReqSize(new Dimension(borderWidth, 0));
                }
            }
        } else {
            this.verticalBorders = null;
        }
        this.molFrames = new Window[vrows * vcols];
    }

    @Override
    public void setVisibleCanvas(MolPainterCommon pcommon, int k, int icell) {
        super.setVisibleCanvas(pcommon, k, icell);
        MolPainter p = this.getMolPainter(icell);
        MDocument doc = this.getCachedDocument(icell, 0);
        if (p == null) {
            p = this.viewPanel.createMolPainter(doc);
            this.setMolPainter(icell, 0, p);
        }
        ViewCanvas c = this.visibleCanV.get(k);
        c.setDocument(doc, p, icell);
        c.setCenter(this.getMolCenter(icell));
        c.repaint();
    }

    @Override
    public void setAnimated(int icell, boolean v) {
    }

    @Override
    public ViewCanvas getCanvas(int n) {
        int i = -1;
        try {
            i = this.visibleIndex(n, this.numberM);
        }
        catch (ArithmeticException ex) {
            return null;
        }
        int nc = this.visibleCanV.size();
        return i >= 0 && i < nc ? this.visibleCanV.get(i) : null;
    }

    @Override
    protected void setTableContentsEnabled(boolean v) {
        int i;
        int n = this.visibleCanV.size();
        for (i = 0; i < n; ++i) {
            ViewCanvas c = this.visibleCanV.get(i);
            c.setEnabled(v);
        }
        n = this.visibleBtnV.size();
        for (i = 0; i < n; ++i) {
            if (v) {
                int k = this.realIndexFromVisible(i, this.numberB);
                this.setActionB(k, this.btnurl[k]);
                continue;
            }
            MolButton c = this.visibleBtnV.get(i);
            c.setEnabled(false);
        }
        n = this.visibleCbxV.size();
        for (i = 0; i < n; ++i) {
            if (v) {
                int k = this.realIndexFromVisible(i, this.numberC);
                this.setActionC(k, this.cbxjs[k]);
                continue;
            }
            MolButton c = this.visibleCbxV.get(i);
            c.setEnabled(false);
        }
        n = this.visibleTxtV.size();
        for (i = 0; i < n; ++i) {
            JTextComponent c = this.visibleTxtV.get(i);
            if (v) {
                int k = this.realIndexFromVisible(i, this.numberT);
                c.setEnabled(this.isEnabledT0(k));
                continue;
            }
            c.setEnabled(v);
        }
        n = this.visibleImgV.size();
        for (i = 0; i < n; ++i) {
            MolButton c = this.visibleImgV.get(i);
            c.setEnabled(v);
        }
    }

    @Override
    protected void removeCellFromPanel(int icell) {
        ViewCanvas c = this.getCanvas(icell);
        if (c != null) {
            this.viewPanel.remove(c);
        }
    }

    @Override
    protected void addCanvasAgain(int irec, int im) {
        ViewCanvas c = this.getCanvas(irec);
        if (c != null) {
            c.setWinmode(0);
            GridBagConstraints gbc = this.canvasGbcs.get(c);
            this.addWithGBC(c, gbc);
        }
    }

    private void addWithGBC(Component c, GridBagConstraints gbc) {
        GridBagLayout gbl = (GridBagLayout)this.viewPanel.getLayout();
        this.viewPanel.add(c);
        gbl.setConstraints(c, gbc);
        this.viewPanel.validate();
        this.viewPanel.repaint();
    }

    @Override
    public int getVisibleRows() {
        return this.visibleRows;
    }

    @Override
    public int getVisibleCols() {
        return this.visibleCols;
    }

    @Override
    public int getVisibleCellIndex(int absindex) {
        return this.visibleIndex(absindex, this.numberM);
    }

    @Override
    public int getAbsoluteCellIndex(int visibleIndex) {
        return this.realIndexFromVisible(visibleIndex, this.numberM);
    }

    @Override
    public void setBorderWidth(int b) {
        ViewCanvas c;
        int j;
        int i;
        if (this.horizontalBorders != null) {
            for (i = 0; i < this.horizontalBorders.length; ++i) {
                for (j = 0; j < this.horizontalBorders[i].length; ++j) {
                    c = this.horizontalBorders[i][j];
                    c.setReqSize(new Dimension(0, b));
                    c.invalidate();
                }
            }
        }
        if (this.verticalBorders != null) {
            for (i = 0; i < this.verticalBorders.length; ++i) {
                for (j = 0; j < this.verticalBorders[i].length; ++j) {
                    c = this.verticalBorders[i][j];
                    c.setReqSize(new Dimension(b, 0));
                    c.invalidate();
                }
            }
        }
        this.viewPanel.validate();
    }

    @Override
    public String getL(int n) {
        int vn = this.visibleIndex(n, this.numberL);
        if (vn >= 0) {
            return this.visibleLabV.get(vn).getText();
        }
        return this.getL0(n);
    }

    private String getL0(int n) {
        int n1;
        int n0 = this.numberL != null ? this.numberL[0] : 1;
        int n2 = n1 = this.numberL != null ? this.numberL[1] : 1;
        if (n < this.numHdrCells * n0) {
            return this.labLabels[n];
        }
        return this.docStorage.getL((n -= this.numHdrCells * n0) / n1, n % n1);
    }

    @Override
    public void setL(int n, String s) {
        int vn = this.visibleIndex(n, this.numberL);
        if (vn >= 0) {
            JLabel l = this.visibleLabV.get(vn);
            l.setText(s);
        }
        this.setL0(n, s);
        this.viewPanel.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setL0(int n, String s) {
        int n1;
        int n0 = this.numberL != null ? this.numberL[0] : 1;
        int n2 = n1 = this.numberL != null ? this.numberL[1] : 1;
        if (n < this.numHdrCells * n0) {
            this.labLabels[n] = s;
        } else {
            n -= this.numHdrCells * n0;
            MDocStorage mDocStorage = this.docStorage;
            synchronized (mDocStorage) {
                this.docStorage.setL(n / n1, n % n1, s);
            }
        }
    }

    @Override
    public void setRecordIDBackground(int k, Color color) {
        this.docStorage.setIDBackgroundRGBA(k, color != null ? color.getRGB() : 0);
        this.setVisibleCellL(k);
    }

    @Override
    public void setRecordIDForeground(int k, Color color) {
        this.docStorage.setIDForegroundRGBA(k, color != null ? color.getRGB() : 0);
        this.setVisibleCellL(k);
    }

    @Override
    public void setActionB(int i, String s) {
        boolean enabled;
        this.btnurl[i] = s;
        int vi = this.visibleIndex(i, this.numberB);
        boolean bl = enabled = s != null && s.length() != 0;
        int n = enabled ? 2 : (this.btnEnabled[i] = s != null ? 1 : 0);
        if (vi >= 0) {
            MolButton b = this.visibleBtnV.get(vi);
            b.setEnabled(enabled);
        }
    }

    @Override
    public void setActionC(int i, String s) {
        this.cbxjs[i] = s;
        String s2 = this.cbxjs[i ^ 1];
        boolean maybeenabled = s != null || s2 != null;
        boolean enabled1 = s != null && s.length() != 0;
        boolean enabled2 = s2 != null && s2.length() != 0;
        boolean enabled = enabled1 || enabled2;
        int j = i >> 1;
        this.cbxEnabled[j] = enabled ? 2 : (maybeenabled ? 1 : 0);
        int vj = this.visibleIndex(j, this.numberC);
        if (vj >= 0) {
            MolButton b = this.visibleCbxV.get(vj);
            b.setEnabled(enabled);
        }
    }

    @Override
    public boolean getC(int n) {
        int vn = this.visibleIndex(n, this.numberC);
        if (vn >= 0) {
            return this.visibleCbxV.get(vn).isSelected();
        }
        return this.cbxStates[n];
    }

    @Override
    public void setC(int n, boolean s) {
        this.cbxStates[n] = s;
        int vn = this.visibleIndex(n, this.numberC);
        if (vn >= 0) {
            MolButton b = this.visibleCbxV.get(vn);
            b.setSelected(s);
        }
    }

    @Override
    public String getT(int n) {
        int vn = this.visibleIndex(n, this.numberT);
        if (vn >= 0) {
            return this.visibleTxtV.get(vn).getText();
        }
        return this.getT0(n);
    }

    private String getT0(int n) {
        int n1;
        int n0 = this.numberT != null ? this.numberT[0] : 1;
        int n2 = n1 = this.numberT != null ? this.numberT[1] : 1;
        if (n < this.numHdrCells * n0) {
            return this.txtStrings[n];
        }
        return this.docStorage.getT((n -= this.numHdrCells * n0) / n1, n % n1);
    }

    @Override
    public void setT(int n, String s) {
        boolean enabled = s != null;
        String txt = enabled ? s : "";
        this.setT0(n, txt);
        this.setEnabledT0(n, enabled);
        int vn = this.visibleIndex(n, this.numberT);
        if (vn >= 0) {
            JTextComponent t = this.visibleTxtV.get(vn);
            t.setEnabled(enabled);
            t.setText(txt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setT0(int n, String s) {
        int n1;
        int n0 = this.numberT != null ? this.numberT[0] : 1;
        int n2 = n1 = this.numberT != null ? this.numberT[1] : 1;
        if (n < this.numHdrCells * n0) {
            this.txtStrings[n] = s;
        } else {
            n -= this.numHdrCells * n0;
            MDocStorage mDocStorage = this.docStorage;
            synchronized (mDocStorage) {
                this.docStorage.setT(n / n1, n % n1, s);
            }
        }
    }

    private boolean isEnabledT0(int n) {
        int n1;
        int n0 = this.numberT != null ? this.numberT[0] : 1;
        int n2 = n1 = this.numberT != null ? this.numberT[1] : 1;
        if (n < this.numHdrCells * n0) {
            return this.txtEnabled[n];
        }
        return this.docStorage.isEnabledT((n -= this.numHdrCells * n0) / n1, n % n1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledT0(int n, boolean v) {
        int n1;
        int n0 = this.numberT != null ? this.numberT[0] : 1;
        int n2 = n1 = this.numberT != null ? this.numberT[1] : 1;
        if (n < this.numHdrCells * n0) {
            this.txtEnabled[n] = v;
        } else {
            n -= this.numHdrCells * n0;
            MDocStorage mDocStorage = this.docStorage;
            synchronized (mDocStorage) {
                this.docStorage.setEnabledT(n / n1, n % n1, v);
            }
        }
    }

    @Override
    public AbstractButton getVisibleButtonB(int i) {
        return this.visibleBtnV.get(i);
    }

    @Override
    public AbstractButton getVisibleButtonC(int i) {
        return this.visibleCbxV.get(i);
    }

    @Override
    public int indexOfButtonC(AbstractButton cb) {
        return this.visibleCbxV.indexOf(cb);
    }

    @Override
    public int indexOfButtonB(AbstractButton b) {
        return this.visibleBtnV.indexOf(b);
    }

    @Override
    public void unsetWinmode(int i, MolPainter painter, double tabScale) {
        int top = this.numHdrCells * this.numberM[0];
        int j2 = i < top ? (this.numberM[0] != 0 ? i % this.numberM[0] : -1) : this.numberM[0] + (i - top) % this.numberM[1];
        if (j2 >= 0) {
            Dimension dim = this.molSizes[j2];
            painter.setScreen(dim);
            double x = tabScale > 0.0 ? tabScale : painter.maxScale(dim);
            painter.setScale(x);
        }
    }

    @Override
    protected void setVisibleCell(int icell) {
        int ii;
        int k;
        int imin1 = icell < this.numHdrCells ? icell : this.numHdrCells;
        int imax2 = icell < this.numHdrCells ? 0 : icell - this.numHdrCells;
        int iM = this.numberM[0] * imin1 + this.numberM[1] * imax2;
        int j = icell < this.numHdrCells ? 0 : 1;
        for (int i = 0; i < this.numberM[j] && (k = this.visibleIndex(ii = iM + i, this.numberM)) >= 0; ++i) {
            this.viewPanel.setVisibleCanvas(k, ii);
        }
        this.setVisibleCellL(icell);
        this.setVisibleCellB(icell);
        this.setVisibleCellC(icell);
        this.setVisibleCellT(icell);
        this.setVisibleCellI(icell);
    }

    private void setVisibleCellL(int icell) {
        int k;
        int imin1 = icell < this.numHdrCells ? icell : this.numHdrCells;
        int imax2 = icell < this.numHdrCells ? 0 : icell - this.numHdrCells;
        int iL = this.numberL[0] * imin1 + this.numberL[1] * imax2;
        int j = icell < this.numHdrCells ? 0 : 1;
        int hilitbg = this.docStorage.getIDBackgroundRGBA(icell);
        int hilitfg = this.docStorage.getIDForegroundRGBA(icell);
        for (int i = 0; i < this.numberL[j] && (k = this.visibleIndex(iL + i, this.numberL)) >= 0; ++i) {
            JLabel l = this.visibleLabV.get(k);
            if (iL + i < this.numHdrCells * this.numberL[0] + this.docStorage.getSize() * this.numberL[1]) {
                String s = this.getL0(iL + i);
                l.setText(s);
            } else {
                l.setText("");
            }
            if (i != 0) continue;
            l.setOpaque(hilitbg != 0);
            l.setBackground(hilitbg != 0 ? new Color(hilitbg, true) : null);
            l.setForeground(hilitfg != 0 ? new Color(hilitfg, true) : null);
        }
    }

    private void setVisibleCellB(int icell) {
        int k;
        int imin1 = icell < this.numHdrCells ? icell : this.numHdrCells;
        int imax2 = icell < this.numHdrCells ? 0 : icell - this.numHdrCells;
        int iB = this.numberB[0] * imin1 + this.numberB[1] * imax2;
        int j = icell < this.numHdrCells ? 0 : 1;
        for (int i = 0; i < this.numberB[j] && (k = this.visibleIndex(iB + i, this.numberB)) >= 0; ++i) {
            MolButton b = this.visibleBtnV.get(k);
            b.setEnabled(this.btnEnabled[iB + i] == 2);
            if (this.btnLabels.length > iB + i) {
                b.setText(0, this.btnEnabled[iB + i] != 0 ? this.btnLabels[iB + i] : "");
                continue;
            }
            b.setText(0, "");
        }
    }

    private void setVisibleCellC(int icell) {
        int k;
        int imin1 = icell < this.numHdrCells ? icell : this.numHdrCells;
        int imax2 = icell < this.numHdrCells ? 0 : icell - this.numHdrCells;
        int iC = this.numberC[0] * imin1 + this.numberC[1] * imax2;
        int j = icell < this.numHdrCells ? 0 : 1;
        for (int i = 0; i < this.numberC[j] && (k = this.visibleIndex(iC + i, this.numberC)) >= 0; ++i) {
            MolButton c = this.visibleCbxV.get(k);
            if (this.cbxStates.length > iC + i) {
                c.setEnabled(this.cbxEnabled[iC + i] == 2);
                if (this.cbxEnabled[iC + i] > 0) {
                    c.setSelected(this.cbxStates[iC + i]);
                    c.setText(0, this.cbxLabels[iC + i][0]);
                    c.setText(1, this.cbxLabels[iC + i][1]);
                    continue;
                }
                c.setSelected(false);
                c.setText(0, " ");
                continue;
            }
            c.setEnabled(false);
            c.setSelected(false);
            c.setText(0, " ");
        }
    }

    private void setVisibleCellT(int icell) {
        int k;
        int imin1 = icell < this.numHdrCells ? icell : this.numHdrCells;
        int imax2 = icell < this.numHdrCells ? 0 : icell - this.numHdrCells;
        int iT = this.numberT[0] * imin1 + this.numberT[1] * imax2;
        int j = icell < this.numHdrCells ? 0 : 1;
        for (int i = 0; i < this.numberT[j] && (k = this.visibleIndex(iT + i, this.numberT)) >= 0; ++i) {
            JTextComponent t = this.visibleTxtV.get(k);
            if (iT + i < this.numHdrCells * this.numberT[0] + this.docStorage.getSize() * this.numberT[1] && this.isEnabledT0(iT + i)) {
                t.setEnabled(true);
                t.setText(this.getT0(iT + i));
                continue;
            }
            t.setEnabled(false);
            t.setText("");
        }
    }

    private void setVisibleCellI(int icell) {
        int ii;
        int k;
        int imin1 = icell < this.numHdrCells ? icell : this.numHdrCells;
        int imax2 = icell < this.numHdrCells ? 0 : icell - this.numHdrCells;
        int iI = this.numberI[0] * imin1 + this.numberI[1] * imax2;
        int j = icell < this.numHdrCells ? 0 : 1;
        MediaTracker tracker = null;
        for (int i = 0; i < this.numberI[j] && (k = this.visibleIndex(ii = iI + i, this.numberI)) >= 0; ++i) {
            MolButton b = this.visibleImgV.get(k);
            if (this.imgImages.length > ii) {
                String f;
                Image img = this.imgImages[ii][0];
                if (img == null && (f = this.imgFiles[ii][0]) != null && f.length() != 0) {
                    this.imgImages[ii][0] = img = this.viewPanel.getImage(f);
                    if (img != null) {
                        if (tracker == null) {
                            tracker = new MediaTracker(this.viewPanel);
                        }
                        tracker.addImage(img, 0);
                    }
                }
                b.setIcon(img);
                boolean zoomable = this.imgFiles[ii][1] != null;
                b.setStyle(zoomable ? 0 : 1);
                b.removeMouseListener(this.viewPanel);
                if (zoomable) {
                    b.addMouseListener(this.viewPanel);
                }
            } else {
                b.setIcon((Image)null);
                b.setStyle(1);
                b.removeMouseListener(this.viewPanel);
            }
            b.repaint();
        }
        if (tracker != null) {
            try {
                tracker.waitForAll();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    @Override
    protected void visibleCells(boolean set) {
        for (int i = 0; i < this.numVisibleHdrCells; ++i) {
            if (set) {
                this.setVisibleCell(this.leftCol + i);
                continue;
            }
            this.getVisibleCell(this.leftCol + i);
        }
        int cols = this.getColumnCount();
        int r = this.topRow + this.visibleRows - this.numHdrCells / cols;
        for (int i = this.topRow; i < r; ++i) {
            for (int j = this.leftCol; j < this.leftCol + this.visibleCols; ++j) {
                int icell = this.numHdrCells + (i - this.numHdrCells / cols) * cols + j;
                if (set) {
                    this.setVisibleCell(icell);
                    continue;
                }
                this.getVisibleCell(icell);
            }
        }
        if (set) {
            this.viewPanel.validate();
        }
    }

    @Override
    protected void mouseReleasedOver(MolButton b) {
        int i = this.visibleCbxV.indexOf(b);
        if (i != -1) {
            int index = this.realIndexFromVisible(i, this.numberC);
            int i2 = i < this.numberC[0] * this.visibleCols ? i % this.numberC[0] : this.numberC[0] + (i - this.numberC[0] * this.visibleCols) % this.numberC[1];
            int g = this.cbxg[i2];
            if (g != -1) {
                List<Integer> v = this.cbgvV.get(g);
                for (int j2 : v) {
                    int j;
                    MolButton bb;
                    if (j2 == i2 || !(bb = this.visibleCbxV.get(j = i + j2 - i2)).isSelected()) continue;
                    bb.setSelected(false);
                    this.cbxchg(bb, index + j2 - i2);
                }
            }
            this.cbxchg(b, index);
        } else {
            i = this.visibleBtnV.indexOf(b);
            if (i != -1) {
                int index = this.realIndexFromVisible(i, this.numberB);
                int i2 = i < this.numberB[0] ? i : this.numberB[0] + (i - this.numberB[0]) % this.numberB[1];
                String win = this.btnfrm[i2];
                String s = this.btnurl[index];
                String sC = this.btnspecc[index] + 'C';
                i = s.indexOf(sC);
                if (i != -1) {
                    StringBuffer sbuf = new StringBuffer(s.substring(0, i));
                    sbuf.append(s.substring(i + sC.length()));
                    Iterator<MolButton> it = this.visibleCbxV.iterator();
                    int hex = 0;
                    int mask = 1;
                    boolean undone = true;
                    while (it.hasNext()) {
                        if (it.next().isSelected()) {
                            hex |= mask;
                        }
                        undone = true;
                        if ((mask <<= 1) != 16) continue;
                        sbuf.insert(i, Integer.toString(hex, 16));
                        hex = 0;
                        mask = 1;
                        undone = false;
                    }
                    if (undone) {
                        sbuf.insert(i, Integer.toString(hex, 16));
                    }
                    s = sbuf.toString();
                }
                if ((s = s.trim()).startsWith("js:")) {
                    this.viewPanel.js(s);
                } else if (s.length() > 0) {
                    try {
                        JApplet applet = this.viewPanel.getApplet();
                        if (applet != null) {
                            URL u = new URL(applet.getDocumentBase(), s);
                            applet.getAppletContext().showDocument(u, win);
                        }
                    }
                    catch (MalformedURLException exc) {
                        System.err.println("Bad url for button: " + s);
                        exc.printStackTrace();
                    }
                }
            } else {
                i = this.visibleImgV.indexOf(b);
                if (i != -1) {
                    int index = this.realIndexFromVisible(i, this.numberI);
                    String s = this.imgFiles[index][1];
                    if (s.startsWith("js:")) {
                        this.viewPanel.js(s);
                    } else {
                        Image img;
                        JFrame f = this.imgFrames[index];
                        if (f == null) {
                            this.imgFrames[index] = f = (JFrame)MarvinModule.load("view.swing.ImageViewFrame", this.viewPanel);
                        }
                        if ((img = this.imgImages[index][1]) == null) {
                            this.imgImages[index][1] = img = this.viewPanel.getImage(s);
                        }
                        Object[] args = new Object[4];
                        args[0] = img;
                        args[1] = this.viewPanel;
                        args[2] = this.imgTitles[index];
                        ((CallbackIface)((Object)f)).callback("init", args);
                        this.viewPanel.showWindow(f);
                    }
                }
            }
        }
    }

    @Override
    protected void keyPressed(int key) {
        if (this.viewPanel.getSelectedCellIndex() >= 0 && this.viewPanel.isSelectable()) {
            int rows = this.getRowCount();
            int cols = this.getColumnCount();
            int index = this.viewPanel.getSelectedCellIndex();
            if (index < 0) {
                index = this.topRow * cols - this.numHdrCells + this.numberM[0] + this.leftCol;
            }
            int col = index % cols;
            int row = index / cols;
            if (key == 36) {
                if (row != this.numHdrCells / cols && !this.checkScrollBack(0)) {
                    return;
                }
                row = this.numHdrCells / cols;
                col = 0;
            } else if (key == 35) {
                if (row != rows - 1 && !this.checkScrollToEnd()) {
                    return;
                }
                if (this.docStorage.isSizeFinal()) {
                    row = rows - 1;
                    col = cols - 1;
                } else {
                    row = this.getRowCount() - this.getVisibleRows();
                    col = this.getColumnCount() - this.getVisibleCols();
                }
            } else if (key == 40) {
                ++row;
            } else if (key == 38) {
                if (row != this.numHdrCells / cols && !this.checkScrollBack(1)) {
                    return;
                }
                --row;
            } else if (key == 34) {
                row += this.visibleRows;
            } else if (key == 33) {
                if (row != this.numHdrCells / cols && !this.checkScrollBack(this.getVisibleRows())) {
                    return;
                }
                row -= this.visibleRows;
            } else if (key == 39) {
                ++col;
            } else if (key == 37) {
                --col;
            } else if (key == 10) {
                this.viewPanel.doubleClick(index);
                return;
            }
            this.setSelectedCell(row, col);
        } else {
            if (this.hScrollBar != null) {
                int hscrOldV;
                int hscrNewV = hscrOldV = this.hScrollBar.getValue();
                int hscrW = this.hScrollBar.getVisibleAmount();
                int hscrMax = this.hScrollBar.getMaximum() - hscrW;
                if (key == 39) {
                    hscrNewV = hscrOldV + 1;
                } else if (key == 37) {
                    hscrNewV = hscrOldV - 1;
                }
                if (hscrNewV > hscrMax) {
                    hscrNewV = hscrMax;
                }
                if (hscrNewV < 0) {
                    hscrNewV = 0;
                }
                if (hscrNewV != hscrOldV) {
                    this.hScrollBar.setValue(hscrNewV);
                }
            }
            if (this.vScrollBar != null) {
                int vscrOldV;
                int vscrNewV = vscrOldV = this.vScrollBar.getValue();
                int vscrH = this.vScrollBar.getVisibleAmount();
                int vscrMax = this.vScrollBar.getMaximum() - vscrH;
                if (key == 36) {
                    if (vscrOldV != 0 && !this.checkScrollBack(0)) {
                        return;
                    }
                    vscrNewV = 0;
                } else if (key == 35) {
                    if (vscrMax != vscrOldV && !this.checkScrollToEnd()) {
                        return;
                    }
                    vscrNewV = vscrMax;
                } else if (key == 40) {
                    vscrNewV = vscrOldV + 1;
                } else if (key == 38) {
                    if (vscrOldV != 0 && !this.checkScrollBack(1)) {
                        return;
                    }
                    vscrNewV = vscrOldV - 1;
                } else if (key == 34) {
                    vscrNewV = vscrOldV + vscrH;
                } else if (key == 33) {
                    if (!this.checkScrollBack(this.getVisibleRows())) {
                        return;
                    }
                    vscrNewV = vscrOldV - vscrH;
                }
                this.scrollVerticallyTo(vscrNewV);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.vScrollBar != null) {
            int vscrOldV;
            int vscrNewV = vscrOldV = this.vScrollBar.getValue();
            if (e.getWheelRotation() < 0) {
                vscrNewV = vscrOldV - 1;
            } else {
                if (vscrOldV != 0 && !this.checkScrollBack(1)) {
                    return;
                }
                vscrNewV = vscrOldV + 1;
            }
            this.scrollVerticallyTo(vscrNewV);
        }
    }

    private void setSelectedCell(int row, int col) {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int index = this.viewPanel.getSelectedCellIndex();
        if (index < 0) {
            index = this.topRow * cols - this.numHdrCells + this.numberM[0] + this.leftCol;
        }
        if (row < this.numHdrCells / cols) {
            row = this.numHdrCells / cols;
        } else if (row >= rows) {
            row = rows - 1;
        }
        if (col < 0) {
            col = 0;
        } else if (col >= cols) {
            col = cols - 1;
        }
        int next = row * cols - this.numHdrCells + this.numberM[0] + col;
        if (next != index) {
            this.viewPanel.setSelectedCellIndex(next);
        }
    }

    private void scrollVerticallyTo(int vscrNewV) {
        int vscrOldV = this.vScrollBar.getValue();
        int vscrH = this.vScrollBar.getVisibleAmount();
        int vscrMax = this.vScrollBar.getMaximum() - vscrH;
        if (vscrNewV > vscrMax) {
            vscrNewV = vscrMax;
        }
        if (vscrNewV < 0) {
            vscrNewV = 0;
        }
        if (vscrNewV != vscrOldV) {
            this.vScrollBar.setValue(vscrNewV);
        }
    }

    private boolean isScrollBackPossibleTo(int row) {
        if (this.docStorage.isRewindable()) {
            return true;
        }
        if (this.numHdrCells > 0) {
            --row;
        }
        int vpos = row * this.getColumnCount();
        int ipos = this.docStorage.getDocSourcePosition();
        return ipos - vpos <= this.docStorage.getCacheCapacity();
    }

    private boolean isScrollBackPossibleBy(int n) {
        return this.docStorage.isRewindable() && n == 0 || this.isScrollBackPossibleTo(this.topRow - n);
    }

    private boolean checkScrollBack(int n) {
        if (this.isScrollBackPossibleBy(n)) {
            return true;
        }
        JOptionPane.showMessageDialog(this.viewPanel, "Scrolling back is not possible.\n(Input stream is not seekable.)", "Operation not allowed", 2);
        return false;
    }

    private boolean checkScrollToEnd() {
        if (this.docStorage.isRewindable()) {
            return true;
        }
        JOptionPane.showMessageDialog(this.viewPanel, "Jumping to end is not allowed.\n(Input stream is not seekable.)", "Operation not allowed", 2);
        return false;
    }

    private void inilay(int i, String[] layout, String[] scomps, int[][] grids, int[][] nccs) throws IllegalArgumentException {
        int j;
        int[] T = new int[256];
        T[77] = 1;
        T[76] = 2;
        T[66] = 3;
        T[67] = 4;
        T[84] = 5;
        T[73] = 6;
        StringBuffer sbuf = new StringBuffer();
        ArrayList<Integer> gridV = new ArrayList<Integer>();
        MStringTokenizer mst = new MStringTokenizer(layout[i]);
        String errmsg = "Bad applet parameter \"".concat(i == 0 ? "layoutH" : "layout").concat("\": \"");
        try {
            gridV.add(Integer.valueOf(mst.trimNextToken("")));
            gridV.add(Integer.valueOf(mst.trimNextToken("")));
            j = 0;
            while (mst.hasMoreTokens()) {
                String sc = mst.trimNextToken("");
                char c = sc.charAt(0);
                int k = T[c];
                if (k == 0) {
                    throw new IllegalArgumentException(errmsg.concat(sc).concat("\": not one of the known component types 0, M, L, B, C, or T."));
                }
                int[] nArray = nccs[i];
                int n = k - 1;
                nArray[n] = nArray[n] + 1;
                if (this.viewPanel.getDebug() != 0) {
                    System.err.print("constraints for component type ");
                    System.err.println(sc);
                }
                sbuf.append(c);
                gridV.add(Integer.valueOf(mst.trimNextToken("")));
                gridV.add(Integer.valueOf(mst.trimNextToken("")));
                String t = GridBagView.nxtt0(mst, "1");
                Integer ix = new Integer(1);
                if (t == null || T[t.charAt(0)] != 0) {
                    mst.back();
                } else {
                    ix = Integer.valueOf(t);
                }
                gridV.add(ix);
                t = GridBagView.nxtt0(mst, "1");
                ix = new Integer(1);
                if (t == null || T[t.charAt(0)] != 0) {
                    mst.back();
                } else {
                    ix = Integer.valueOf(t);
                }
                gridV.add(ix);
                t = GridBagView.nxtt0(mst, "c");
                int x = 10;
                if (t == null || T[t.charAt(0)] != 0) {
                    mst.back();
                } else if (t.equals("n")) {
                    x = 11;
                } else if (t.equals("ne")) {
                    x = 12;
                } else if (t.equals("e")) {
                    x = 13;
                } else if (t.equals("se")) {
                    x = 14;
                } else if (t.equals("s")) {
                    x = 15;
                } else if (t.equals("sw")) {
                    x = 16;
                } else if (t.equals("w")) {
                    x = 17;
                } else if (t.equals("nw")) {
                    x = 18;
                } else if (!t.equals("c")) {
                    throw new IllegalArgumentException(errmsg.concat(t).concat("\": not one of the known anchor types c, n, ne, e, se, s, sw, w, nw."));
                }
                gridV.add(new Integer(x));
                t = GridBagView.nxtt0(mst, "n");
                x = 0;
                if (t == null || T[t.charAt(0)] != 0) {
                    mst.back();
                } else if (t.equals("h")) {
                    x = 2;
                } else if (t.equals("v")) {
                    x = 3;
                } else if (t.equals("b")) {
                    x = 1;
                } else if (!t.equals("n")) {
                    throw new IllegalArgumentException(errmsg.concat(t).concat("\": not one of the known fill types n, h, v, b."));
                }
                gridV.add(new Integer(x));
                for (int l = 0; l < 2; ++l) {
                    ix = new Integer(0);
                    t = GridBagView.nxtt0(mst, "0");
                    if (t == null || T[t.charAt(0)] != 0) {
                        mst.back();
                    } else {
                        ix = Integer.valueOf(t);
                    }
                    gridV.add(ix);
                }
                ++j;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(errmsg.concat(e.getMessage()).concat("\": not an integer."));
        }
        grids[i] = new int[gridV.size()];
        for (j = 0; j < gridV.size(); ++j) {
            grids[i][j] = (Integer)gridV.get(j);
        }
        scomps[i] = sbuf.toString();
    }

    private void inicomps(String param, String scomp, int iM, int iL, int iB, int iC, int iT, int iI) throws IllegalArgumentException {
        MStringTokenizer mst = new MStringTokenizer(param);
        int g0 = this.cbgvV.size();
        String errmsg = "Bad applet parameter \"".concat(param).concat("\": \"");
        try {
            int j = 0;
            while (mst.hasMoreTokens()) {
                String sc;
                char cc;
                char c = scomp.charAt(j);
                if (c != (cc = (sc = mst.trimNextToken("")).charAt(0))) {
                    throw new IllegalArgumentException(errmsg.concat(sc).concat("\": bad component type; ").concat(String.valueOf(c)).concat(" is required here."));
                }
                if (this.viewPanel.getDebug() != 0) {
                    System.err.print("default parameters for component type ");
                    System.err.println(sc);
                }
                if (c == 'M') {
                    int w = mst.nextIntDefault(1);
                    int h = mst.nextIntDefault(1);
                    this.molSizes[iM++] = new Dimension(w, h);
                } else if (c == 'I') {
                    ++iI;
                } else {
                    String s = mst.trimNextToken("");
                    int ib = s.indexOf(98);
                    int ii = s.indexOf(105);
                    int imax = -1;
                    int style = 0;
                    if (ib != -1) {
                        style = 1;
                        imax = ib;
                    }
                    if (ii != -1) {
                        style |= 2;
                        if (imax == -1 || ii < ib) {
                            imax = ii;
                        }
                    }
                    if (imax == -1) {
                        imax = s.length();
                    }
                    int size = Integer.parseInt(s.substring(0, imax));
                    Font fnt = c == 'T' ? new Font("Monospaced", style, size) : MolPainter.makeFont(style, size, this.viewPanel.painterCommon);
                    fnt = GridBagView.reuse(fnt, this.labfnt, iL);
                    fnt = GridBagView.reuse(fnt, this.btnfnt, iB);
                    fnt = GridBagView.reuse(fnt, this.cbxfnt, iC);
                    fnt = GridBagView.reuse(fnt, this.txtfnt, iT);
                    if (c == 'L') {
                        this.labfnt[iL++] = fnt;
                    } else if (c == 'B') {
                        this.btnfnt[iB] = fnt;
                        this.btndsc[iB] = mst.trimNextToken("");
                        this.btnfrm[iB++] = mst.trimNextToken("");
                    } else if (c == 'C') {
                        this.cbxfnt[iC] = fnt;
                        this.cbxdsc[iC] = mst.trimNextToken("");
                        int l = sc.length();
                        int g = -1;
                        if (l > 1 && sc.charAt(1) == 'g') {
                            int n = this.cbgvV.size();
                            int n2 = g = l > 2 ? g0 + Integer.parseInt(sc.substring(2)) : n;
                            if (g <= n) {
                                List<Integer> v;
                                if (g == n) {
                                    v = new ArrayList<Integer>();
                                    this.cbgvV.add(v);
                                } else {
                                    v = this.cbgvV.get(g);
                                }
                                v.add(new Integer(iC));
                            } else {
                                throw new IllegalArgumentException(errmsg.concat(String.valueOf(g)).concat("\": checkbox group number bigger than the total number of checkboxes so far, ").concat(String.valueOf(n)));
                            }
                        }
                        this.cbxg[iC++] = g;
                    } else if (c == 'T') {
                        this.txtfnt[iT] = fnt;
                        s = mst.trimNextToken("");
                        try {
                            this.txtFlags[iT] = (short)Integer.parseInt(s);
                        }
                        catch (Exception ex) {
                            this.txtFlags[iT] = 10;
                            mst.back();
                        }
                        s = mst.trimNextToken("");
                        if (s.equals("rw")) {
                            int n = iT;
                            this.txtFlags[n] = (short)(this.txtFlags[n] | 0x4000);
                        } else if (!s.equals("r")) {
                            mst.back();
                        }
                        ++iT;
                    }
                }
                ++j;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(errmsg.concat(e.getMessage()).concat("\": not an integer."));
        }
    }

    private void paracells(String[] scomps, int[][] grids) {
        int vr;
        int iM = 0;
        int iL = 0;
        int iB = 0;
        int iC = 0;
        int iT = 0;
        int iI = 0;
        GridBagLayout gbl = new GridBagLayout();
        this.viewPanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        int col = 0;
        int celly = 0;
        int cellx = 0;
        int totalwidth = 0;
        int totalheight = 0;
        for (int icell = 0; icell < this.visibleRows * this.visibleCols; ++icell) {
            ViewCanvas bcanv;
            boolean hashorborder;
            int igrid = 2;
            if (this.viewPanel.getDebug() != 0) {
                System.err.print("row=");
                System.err.print(row);
                System.err.print(" col=");
                System.err.println(col);
            }
            int i2 = icell < this.numVisibleHdrCells ? 0 : 1;
            int[] grid = grids[i2];
            String sc = scomps[i2];
            for (int i = 0; i < sc.length(); ++i) {
                ViewCanvas canv = null;
                JComponent c = null;
                gbc.gridy = celly + grid[igrid++];
                gbc.gridx = cellx + grid[igrid++];
                gbc.gridheight = grid[igrid++];
                gbc.gridwidth = grid[igrid++];
                gbc.anchor = grid[igrid++];
                gbc.fill = grid[igrid++];
                gbc.weighty = grid[igrid++];
                gbc.weightx = grid[igrid++];
                switch (sc.charAt(i)) {
                    case 'M': {
                        int top = this.numVisibleHdrCells * this.numberM[0];
                        i2 = iM < top ? (this.numberM[0] > 0 ? iM % this.numberM[0] : -1) : this.numberM[0] + (iM - top) % this.numberM[1];
                        canv = new ViewCanvas(this.viewPanel);
                        canv.setReqSize(this.molSizes[i2]);
                        this.visibleCanV.add(canv);
                        this.canvasGbcs.put(canv, (GridBagConstraints)gbc.clone());
                        c = canv;
                        ++iM;
                        break;
                    }
                    case 'L': {
                        int top = this.numVisibleHdrCells * this.numberL[0];
                        i2 = iL < top ? (this.numberL[0] > 0 ? iL % this.numberL[0] : -1) : this.numberL[0] + (iL - top) % this.numberL[1];
                        ViewLabel lb = new ViewLabel("", GridBagView.getLabelAlignment(gbc.anchor));
                        lb.setFont(this.labfnt[i2]);
                        this.visibleLabV.add(lb);
                        c = lb;
                        ++iL;
                        break;
                    }
                    case 'B': {
                        int top = this.numVisibleHdrCells * this.numberB[0];
                        i2 = iB < top ? (this.numberB[0] > 0 ? iB % this.numberB[0] : -1) : this.numberB[0] + (iB - top) % this.numberB[1];
                        MolButton b = new MolButton("");
                        this.visibleBtnV.add(b);
                        c = b;
                        b.setDescriptions(this.btndsc[i2], null);
                        b.setFont(this.btnfnt[i2]);
                        b.setStyle(2);
                        b.addMouseListener(this.viewPanel);
                        ++iB;
                        break;
                    }
                    case 'C': {
                        int top = this.numVisibleHdrCells * this.numberC[0];
                        i2 = iC < top ? (this.numberC[0] > 0 ? iC % this.numberC[0] : -1) : this.numberC[0] + (iC - top) % this.numberC[1];
                        MolButton b = new MolButton("", 1);
                        this.visibleCbxV.add(b);
                        b.setDescriptions(this.cbxdsc[i2], this.cbxdsc[i2]);
                        b.setFont(this.cbxfnt[i2]);
                        b.setStyle(2);
                        b.addMouseListener(this.viewPanel);
                        c = b;
                        ++iC;
                        break;
                    }
                    case 'T': {
                        JTextComponent tf;
                        int top = this.numVisibleHdrCells * this.numberT[0];
                        i2 = iT < top ? (this.numberT[0] > 0 ? iT % this.numberT[0] : -1) : this.numberT[0] + (iT - top) % this.numberT[1];
                        int txtcols = this.txtFlags[i2] & 0x3FFF;
                        if (txtcols > 0) {
                            tf = new JTextArea(""){

                                @Override
                                public Dimension getMinimumSize() {
                                    Dimension d = super.getMinimumSize();
                                    d.width = GridBagView.this.calcPreferredTextCompWidth(d.width);
                                    return d;
                                }

                                @Override
                                public Dimension getPreferredSize() {
                                    Dimension d = super.getPreferredSize();
                                    d.width = GridBagView.this.calcPreferredTextCompWidth(d.width);
                                    return d;
                                }
                            };
                            ((JTextArea)tf).setColumns(txtcols);
                            ((JTextArea)tf).setFont(this.txtfnt[i2]);
                            tf.setEditable((this.txtFlags[i2] & 0x4000) != 0);
                            this.visibleTxtV.add(tf);
                            c = tf;
                            ++iT;
                            break;
                        }
                        tf = new MEditorPane(){

                            @Override
                            public Dimension getMinimumSize() {
                                Dimension d = super.getPreferredSize();
                                d.width = GridBagView.this.calcPreferredTextCompWidth(d.width);
                                return d;
                            }

                            @Override
                            public Dimension getPreferredSize() {
                                Dimension d = super.getPreferredSize();
                                d.width = GridBagView.this.calcPreferredTextCompWidth(d.width);
                                return d;
                            }
                        };
                        tf.setFont(this.txtfnt[i2]);
                        tf.setEditable((this.txtFlags[i2] & 0x4000) != 0);
                        this.visibleTxtV.add(tf);
                        c = tf;
                        ((JEditorPane)tf).setContentType("text/html");
                        ++iT;
                        break;
                    }
                    case 'I': {
                        int top = this.numVisibleHdrCells * this.numberI[0];
                        i2 = iL < top ? (this.numberI[0] > 0 ? iI % this.numberI[0] : -1) : this.numberI[0] + (iI - top) % this.numberI[1];
                        MolButton ib = new MolButton("");
                        ib.addMouseListener(this.viewPanel);
                        this.visibleImgV.add(ib);
                        c = ib;
                        ++iI;
                    }
                }
                if (c == null) {
                    c = new ViewLabel();
                }
                this.addWithGBC(c, gbc);
            }
            this.viewPanel.setDebug(this.viewPanel.getDebug());
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            boolean bl = hashorborder = row < this.visibleRows - 1;
            if (hashorborder) {
                gbc.fill = 2;
                gbc.gridx = cellx;
                gbc.gridy = celly + grid[0];
                gbc.gridwidth = grid[1];
                gbc.gridheight = 1;
                bcanv = this.horizontalBorders[row][col];
                this.addWithGBC(bcanv, gbc);
            }
            if (col < this.visibleCols - 1) {
                gbc.fill = 3;
                gbc.gridx = cellx + grid[1];
                gbc.gridy = celly;
                gbc.gridwidth = 1;
                gbc.gridheight = grid[0];
                bcanv = this.verticalBorders[row][col];
                this.addWithGBC(bcanv, gbc);
                ++cellx;
            }
            if (gbc.gridx + gbc.gridwidth > totalwidth) {
                totalwidth = gbc.gridx + gbc.gridwidth;
            }
            if (gbc.gridy + gbc.gridheight > totalheight) {
                totalheight = gbc.gridy + gbc.gridheight;
            }
            cellx += grid[1];
            if (++col < this.visibleCols) continue;
            col = 0;
            celly += grid[0];
            if (hashorborder) {
                ++celly;
            }
            cellx = 0;
            ++row;
        }
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        MDocSource dsrc = this.docStorage.getDocSource();
        int endi = this.recordFetcher.getEndRecordIndex();
        if (this.visibleRows != rows || dsrc != null && endi == Integer.MAX_VALUE && !dsrc.isEndReached()) {
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.gridx = totalwidth;
            gbc.gridy = grids[0][0];
            gbc.gridwidth = 1;
            gbc.gridheight = totalheight - grids[0][0];
            gbc.fill = 3;
            vr = this.visibleRows - this.numVisibleHdrCells / this.visibleCols;
            int r = this.getBestScrollBarMax();
            this.vScrollBar = new JScrollBar(1, 0, vr, 0, r);
            this.addWithGBC(this.vScrollBar, gbc);
            this.vScrollBar.addAdjustmentListener(this);
        } else if (this.vScrollBar != null) {
            vr = this.visibleRows - this.numVisibleHdrCells / this.visibleCols;
            int r = this.getBestScrollBarMax();
            GridBagView.setScrollBarSilently(this.vScrollBar, 7, 0, r, vr);
            this.vScrollBarTempValue = 0;
            this.vScrollBarValidValue = 0;
            this.enqueueUpdaterThread(0);
        }
        if (this.visibleCols != cols) {
            gbc.weightx = 1.0;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = totalheight;
            gbc.gridwidth = totalwidth;
            gbc.gridheight = 1;
            gbc.fill = 2;
            this.hScrollBar = new JScrollBar(0, 0, this.visibleCols, 0, cols);
            this.addWithGBC(this.hScrollBar, gbc);
            this.hScrollBar.addAdjustmentListener(this);
        } else if (!Environment.APPLET && this.vScrollBar != null && Environment.MACOS) {
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridx = 0;
            gbc.gridy = totalheight;
            gbc.gridwidth = totalwidth;
            gbc.gridheight = 1;
            gbc.fill = 0;
            JPanel panel = new JPanel();
            panel.setOpaque(true);
            panel.setMinimumSize(new Dimension(0, 16));
            panel.setPreferredSize(new Dimension(0, 16));
            this.addWithGBC(panel, gbc);
        }
        if (!Environment.APPLET && this.vScrollBar == null && this.hScrollBar != null && Environment.MACOS) {
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridx = totalwidth + 1;
            gbc.gridy = grids[0][0];
            gbc.gridwidth = 1;
            gbc.gridheight = totalheight - grids[0][0];
            gbc.fill = 0;
            JPanel panel = new JPanel();
            panel.setOpaque(true);
            panel.setMinimumSize(new Dimension(16, 0));
            panel.setPreferredSize(new Dimension(16, 0));
            this.addWithGBC(panel, gbc);
        }
    }

    private int calcPreferredTextCompWidth(int prefWidth) {
        int canvasWidth;
        if (this.molSizes[0] != null && prefWidth > (canvasWidth = this.molSizes[0].width)) {
            return canvasWidth;
        }
        return prefWidth;
    }

    private static int getLabelAlignment(int gbcanchor) {
        if (gbcanchor == 10 || gbcanchor == 11 || gbcanchor == 15) {
            return 0;
        }
        if (gbcanchor == 13 || gbcanchor == 12 || gbcanchor == 14) {
            return 4;
        }
        return 2;
    }

    private void inicells(int maxcells, String[] scomps) throws IllegalArgumentException {
        int iM = 0;
        int iL = 0;
        int iB = 0;
        int iC = 0;
        int iT = 0;
        int iI = 0;
        int icbxjs = 0;
        for (int icell = 0; icell < maxcells; ++icell) {
            String parname = "cell".concat(String.valueOf(icell));
            String parstr = this.viewPanel.getParameter(parname);
            MStringTokenizer mst = this.viewPanel.createMStringTokenizer(parstr);
            String sc = scomps[icell < this.numHdrCells ? 0 : 1];
            block9: for (int i = 0; i < sc.length(); ++i) {
                String altpar = parname + "_" + i;
                String s = parstr;
                switch (sc.charAt(i)) {
                    case 'M': {
                        s = s != null ? this.parseMolStr(mst, s) : this.getNonseparatedParameter(altpar);
                        this.viewPanel.setMolString(iM, s);
                        ++iM;
                        continue block9;
                    }
                    case 'L': {
                        if (s != null) {
                            s = GridBagView.nextLabel(mst);
                        } else {
                            s = this.getNonseparatedParameter(altpar);
                            if (s == null) {
                                s = "";
                            }
                        }
                        this.setL0(iL, s);
                        ++iL;
                        continue block9;
                    }
                    case 'B': {
                        if (s == null && (s = this.viewPanel.getParameter(altpar)) != null) {
                            mst = this.viewPanel.createMStringTokenizer(s);
                        }
                        if (s != null) {
                            this.btnLabels[iB] = GridBagView.nextLabel(mst);
                            String u = GridBagView.nextLabel(mst);
                            if (u == null) {
                                u = "%";
                            }
                            this.btnspecc[iB] = u;
                            this.btnurl[iB] = u = mst.trimNextToken("");
                            this.btnEnabled[iB] = u.length() != 0 ? 2 : 1;
                        } else {
                            this.btnLabels[iB] = "";
                            this.btnspecc[iB] = "";
                            this.btnurl[iB] = "";
                            this.btnEnabled[iB] = 0;
                        }
                        ++iB;
                        continue block9;
                    }
                    case 'C': {
                        if (s == null && (s = this.viewPanel.getParameter(altpar)) != null) {
                            mst = this.viewPanel.createMStringTokenizer(s);
                        }
                        if (s != null) {
                            this.cbxLabels[iC] = new String[2];
                            this.cbxLabels[iC][0] = GridBagView.nextLabel(mst);
                            this.cbxLabels[iC][1] = GridBagView.nextLabel(mst);
                            this.cbxStates[iC] = mst.trimNextToken("").equals("1");
                            String s0 = mst.trimNextToken("");
                            String s1 = mst.trimNextToken("");
                            this.cbxjs[icbxjs] = s0;
                            this.cbxjs[icbxjs | 1] = s1;
                            this.cbxEnabled[iC] = s0.length() != 0 || s1.length() != 0 ? 2 : 1;
                        } else {
                            this.cbxLabels[iC] = new String[2];
                            this.cbxLabels[iC][0] = "";
                            this.cbxLabels[iC][1] = "";
                            this.cbxStates[iC] = false;
                            this.cbxjs[icbxjs] = "";
                            this.cbxjs[icbxjs | 1] = "";
                            this.cbxEnabled[iC] = 0;
                        }
                        ++iC;
                        icbxjs += 2;
                        continue block9;
                    }
                    case 'T': {
                        s = s != null ? GridBagView.nextLabel(mst) : this.getNonseparatedParameter(altpar);
                        if (s != null) {
                            this.setT0(iT, s);
                            this.setEnabledT0(iT, true);
                        } else {
                            this.setT0(iT, "");
                            this.setEnabledT0(iT, false);
                        }
                        ++iT;
                        continue block9;
                    }
                    case 'I': {
                        if (s == null && (s = this.viewPanel.getParameter(altpar)) != null) {
                            mst = this.viewPanel.createMStringTokenizer(s);
                        }
                        if (s != null) {
                            this.imgFiles[iI] = new String[2];
                            this.imgFiles[iI][0] = mst.nextToken();
                            String s2 = mst.nextToken();
                            if (s2 != null && s2.length() == 0) {
                                s2 = null;
                            }
                            this.imgFiles[iI][1] = s2;
                            this.imgTitles[iI] = GridBagView.nextLabel(mst);
                        }
                        ++iI;
                    }
                }
            }
        }
    }

    private String parseMolStr(MStringTokenizer mst, String str) {
        if (mst.getEscapeChar() == '\u0000') {
            str = str.substring(mst.getPosition());
            String sep = String.valueOf(mst.getSeparatorChar());
            int i = 0;
            int nsep = 0;
            while ((i = str.indexOf("}" + sep, i + 1)) >= 0) {
                String[] fmt;
                String s = str.substring(0, i + 1);
                boolean found = false;
                String[] fopts = MFileFormatUtil.splitFileAndOptions(s);
                if (fopts[1] != null && (fmt = MFileFormatUtil.splitFormatAndOptions(fopts[1]))[0] != null) {
                    MFileFormat[] mff = MFileFormatUtil.findFormats(fmt[0], 0L, 0L);
                    boolean bl = found = mff.length != 0;
                }
                if (!found) continue;
                for (int j = 0; j < s.length(); ++j) {
                    if (str.charAt(j) != mst.getSeparatorChar()) continue;
                    ++nsep;
                }
            }
            return mst.nextToken(nsep);
        }
        return mst.nextToken();
    }

    private String getNonseparatedParameter(String name) {
        String s = this.viewPanel.getParameter(name);
        return s;
    }

    private static String nextLabel(MStringTokenizer mst) {
        String s = mst.nextToken();
        return s != null ? s : "";
    }

    private int realIndexFromVisible(int i, int[] numbers) {
        int cols = this.getColumnCount();
        if (i < numbers[0] * this.numVisibleHdrCells) {
            int row = i / (numbers[0] * this.visibleCols);
            int col = this.leftCol + i / numbers[0] % this.visibleCols;
            return (row * cols + col) * numbers[0] + i % numbers[0];
        }
        int j = i - numbers[0] * this.numVisibleHdrCells;
        int row = this.topRow + j / (numbers[1] * this.visibleCols);
        int col = this.leftCol + j / numbers[1] % this.visibleCols;
        return numbers[0] * this.numVisibleHdrCells + ((row - this.numVisibleHdrCells / this.visibleCols) * cols + col) * numbers[1] + j % numbers[1];
    }

    private int visibleIndex(int i, int[] numbers) {
        int n1;
        int n0 = numbers != null ? numbers[0] : 1;
        int n = n1 = numbers != null ? numbers[1] : 1;
        if (i < this.numHdrCells * n0) {
            int j = i - this.leftCol * n0;
            int k = j >= 0 && j < this.numVisibleHdrCells * n0 ? j : -1;
            return k;
        }
        int cols = this.getColumnCount();
        int row = ((i -= this.numHdrCells * n0) / n1 + this.numHdrCells) / cols;
        int col = i / n1 % cols;
        int r = this.topRow + this.visibleRows - this.numVisibleHdrCells / this.visibleCols;
        if (row < this.topRow || col < this.leftCol) {
            return -1;
        }
        if (row < r && col < this.leftCol + this.visibleCols) {
            int k = this.numVisibleHdrCells * n0 + ((row - this.topRow) * this.visibleCols + col - this.leftCol) * n1 + i % n1;
            return k;
        }
        return -1;
    }

    private void getVisibleCell(int icell) {
        int imin1 = icell < this.numHdrCells ? icell : this.numHdrCells;
        int imax2 = icell < this.numHdrCells ? 0 : icell - this.numHdrCells;
        int iC = this.numberC[0] * imin1 + this.numberC[1] * imax2;
        int j = icell < this.numHdrCells ? 0 : 1;
        for (int i = 0; i < this.numberC[j]; ++i) {
            int k = this.visibleIndex(iC + i, this.numberC);
            MolButton c = this.visibleCbxV.get(k);
            if (iC + i >= this.cbxStates.length) continue;
            this.cbxStates[iC + i] = c.isSelected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adjustmentValueChanged(AdjustmentEvent ev) {
        Object target = ev.getSource();
        if (target != this.vScrollBar && target != this.hScrollBar) {
            return;
        }
        JScrollBar scrbar = (JScrollBar)target;
        int x = ev.getValue();
        Object object = this.viewPanel.getMolPanelLock();
        synchronized (object) {
            switch (ev.getAdjustmentType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int oldx;
                    int n = oldx = scrbar == this.vScrollBar ? this.vScrollBarValidValue : this.hScrollBarValidValue;
                    if (x < oldx && !this.isScrollBackPossibleTo(x)) {
                        scrbar.setValue(oldx);
                        return;
                    }
                    if (scrbar == this.vScrollBar) {
                        if (this.vScrollBarTempValue == x) {
                            return;
                        }
                        this.vScrollBarTempValue = x;
                    } else {
                        if (this.hScrollBarTempValue == x) {
                            return;
                        }
                        this.hScrollBarTempValue = x;
                    }
                    int cols = this.getColumnCount();
                    if (target == this.vScrollBar) {
                        x += this.numHdrCells / cols;
                    }
                    if (scrbar == this.vScrollBar && x != this.topRow || scrbar == this.hScrollBar && x != this.leftCol) {
                        for (int i = 0; i < this.viewPanel.getMolCount(); ++i) {
                            ViewCanvas c = this.getCanvas(i);
                            if (c == null || !c.isInWin() && c.getParent() != null) continue;
                            this.viewPanel.setWinmode(0, i);
                        }
                        this.viewPanel.destroySketcher();
                    }
                    this.enqueueUpdaterThread(x);
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.handlePropertyChange(ev, this.viewPanel);
    }

    private void setCornerFromScrollBar(JScrollBar scrbar, int x) {
        if (scrbar == this.vScrollBar) {
            this.topRow = x;
        } else {
            this.leftCol = x;
        }
        if (scrbar != null && x != scrbar.getValue() && scrbar.getValue() + scrbar.getVisibleAmount() == scrbar.getMaximum()) {
            scrbar.setValue(x);
        }
    }

    private void cbxchg(MolButton b, int i) {
        String s;
        i <<= 1;
        if (b.isSelected()) {
            i |= 1;
        }
        if (i < this.cbxjs.length && (s = this.cbxjs[i]).startsWith("js:")) {
            this.viewPanel.js(s);
        }
    }

    private int getBestScrollBarMax() {
        int vr = this.visibleRows - this.numVisibleHdrCells / this.visibleCols;
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        int r = rows - this.numHdrCells / cols;
        return Math.max(r, vr);
    }

    @Override
    public int getTopLeft() {
        return this.topRow * this.getColumnCount();
    }

    @Override
    public void setTopLeft(int index) {
        int row = index / this.getColumnCount();
        this.enqueueUpdaterThread(row);
        JScrollBar vscr = this.vScrollBar;
        if (vscr != null && EventQueue.isDispatchThread()) {
            vscr.removeAdjustmentListener(this);
            vscr.setValue(row);
            vscr.addAdjustmentListener(this);
            this.updateVisibleCells(row);
        }
    }

    @Override
    public void setVerticalScrollBarMaximum(final int max) {
        if (this.vScrollBar == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.setVerticalScrollBarMaximum0(max);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GridBagView.this.setVerticalScrollBarMaximum0(max);
                }
            });
        }
    }

    private void setVerticalScrollBarMaximum0(int max) {
        int oldmax = this.vScrollBar.getMaximum();
        int oldv = this.vScrollBar.getValue();
        if (max <= oldv && max < oldmax) {
            double q = (double)oldv / (double)oldmax;
            GridBagView.setScrollBarSilently(this.vScrollBar, 1, (int)(q * (double)max), 0, 0);
        }
        this.vScrollBar.setMaximum(max);
    }

    private static void setScrollBarSilently(JScrollBar scr, int f, int val, int max, int visible) {
        int i;
        AdjustmentListener[] l = scr.getAdjustmentListeners();
        for (i = 0; i < l.length; ++i) {
            scr.removeAdjustmentListener(l[i]);
        }
        if ((f & 1) != 0) {
            scr.setValue(val);
        }
        if ((f & 2) != 0) {
            scr.setMaximum(max);
        }
        if ((f & 4) != 0) {
            scr.setVisibleAmount(visible);
        }
        for (i = 0; i < l.length; ++i) {
            scr.addAdjustmentListener(l[i]);
        }
    }

    @Override
    public void setScrollBarsValue(int h, int v) {
        if (this.hScrollBar != null) {
            this.hScrollBar.setValue(h);
        }
        if (this.vScrollBar != null) {
            this.vScrollBar.setValue(v);
        }
    }

    @Override
    public int getScrollBarRowIncrement() {
        return 1;
    }

    @Override
    public int[] getScrollBarsMax() {
        int[] value = new int[]{-1, -1};
        if (this.hScrollBar != null) {
            value[0] = this.hScrollBar.getMaximum();
        }
        if (this.vScrollBar != null) {
            value[1] = this.vScrollBar.getMaximum();
        }
        return value;
    }

    @Override
    public void setScrollBarsMax(int h, int v) {
        JScrollBar hscr = this.hScrollBar;
        JScrollBar vscr = this.vScrollBar;
        if (hscr != null) {
            hscr.setMaximum(h);
        }
        if (vscr != null) {
            vscr.setMaximum(v);
        }
    }

    @Override
    public int[] getScrollBarsMin() {
        int[] value = new int[]{-1, -1};
        if (this.hScrollBar != null) {
            value[0] = this.hScrollBar.getMinimum();
        }
        if (this.vScrollBar != null) {
            value[1] = this.vScrollBar.getMinimum();
        }
        return value;
    }

    @Override
    public int[] getScrollBarsValue() {
        int[] value = new int[]{-1, -1};
        if (this.hScrollBar != null) {
            value[0] = this.hScrollBar.getValue();
        }
        if (this.vScrollBar != null) {
            value[1] = this.vScrollBar.getValue();
        }
        return value;
    }

    @Override
    public boolean setSelectedCellIndex(int i) {
        int selected = this.viewPanel.getSelectedCellIndex();
        if (i >= 0 && this.visibleIndex(i, this.numberM) < 0) {
            int value;
            int prev;
            int rows = this.getRowCount();
            int cols = this.getColumnCount();
            int left = this.leftCol;
            if (this.hScrollBar != null) {
                left = this.hScrollBar.getValue();
            }
            int top = this.topRow;
            if (this.vScrollBar != null) {
                top = this.vScrollBar.getValue() + this.numHdrCells / cols;
            }
            int n = prev = selected >= 0 ? selected : top * cols - this.numHdrCells + this.numberM[0] + left;
            if (this.hScrollBar != null) {
                int x;
                value = this.hScrollBar.getValue();
                int x2 = i % cols;
                int x1 = prev % cols;
                int dx = x2 - x1;
                if (dx / this.visibleCols * this.visibleCols == dx && x1 >= left && x1 < left + this.visibleCols) {
                    x = dx + left;
                } else {
                    int n2 = x = x2 > value ? x2 - this.visibleCols + 1 : x2;
                }
                if (x < 0) {
                    x = 0;
                } else if (x > cols - this.visibleCols) {
                    x = cols - this.visibleCols;
                }
                if (value != x) {
                    this.hScrollBar.setValue(x);
                }
            }
            if (this.vScrollBar != null) {
                int y;
                value = this.vScrollBar.getValue();
                int y2 = i / cols;
                int y1 = prev / cols;
                int dy = y2 - y1;
                int vr = this.visibleRows - this.numHdrCells / cols;
                if (dy / vr * vr == dy && y1 >= top && y1 < top + vr) {
                    y = dy + top;
                } else {
                    int n3 = y = y2 - this.numHdrCells / cols > value ? y2 - vr + 1 : y2;
                }
                if (y < this.numHdrCells / cols) {
                    y = this.numHdrCells / cols;
                } else if (y > rows - vr) {
                    y = rows - vr;
                }
                if (value != (y -= this.numHdrCells / cols)) {
                    this.vScrollBar.setValue(y);
                }
            }
        }
        if (selected != i) {
            if (i >= 0) {
                ViewCanvas c = this.getCanvas(i);
                this.viewPanel.updateCleanDim(c);
                if (c != null) {
                    c.repaint();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void unselectMoleculeCell(int icell) {
        ViewCanvas c = this.getCanvas(icell);
        if (c != null) {
            c.repaint();
        }
    }

    @Override
    public int molCellIndexFromCellIndex(int icell) {
        return icell;
    }

    @Override
    public int recordIndexFromCellIndex(int icell) {
        return icell;
    }

    @Override
    public int recordIndexFromMolCellIndex(int icell) {
        return icell;
    }

    @Override
    public String fieldKeyFromMolCellIndex(int icell) {
        return null;
    }

    @Override
    public int rowFromRecordIndex(int irec) {
        int cols = this.getColumnCount();
        int row = irec / cols;
        return row;
    }

    @Override
    public int getCellCount() {
        int rows = this.getRowCount();
        int cols = this.getColumnCount();
        return rows * cols - this.numHdrCells;
    }

    private int getRowCount() {
        int rows = this.viewPanel.getRowCount0();
        if (rows == 0) {
            int cols = this.getColumnCount();
            int n = this.getNumRecords();
            rows = ((n == 0 ? 1 : n) + this.numHdrCells + cols - 1) / cols;
        }
        return rows;
    }

    @Override
    public int getColumnCount() {
        return this.viewPanel.getColumnCount();
    }

    @Override
    public int getNumRecordsInARow() {
        return this.getColumnCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getBestTabScale(int irec, int im) {
        if (im != 0) {
            return super.getBestTabScale(irec, im);
        }
        double scale = -1.0;
        if (this.molSizes != null) {
            int top = this.numVisibleHdrCells * this.numberM[0];
            int i2 = irec < top ? (this.numberM[0] > 0 ? irec % this.numberM[0] : -1) : this.numberM[0] + (irec - top) % this.numberM[1];
            MDocument doc = null;
            try {
                MDocStorage mDocStorage = this.docStorage;
                synchronized (mDocStorage) {
                    doc = this.docStorage.getMainDoc(irec);
                }
            }
            catch (MDocStorage.RecordUnavailableException ex) {
                this.viewPanel.getErrorDisplay().error("Cannot get non-existent record", ex);
            }
            catch (IOException ex) {
                this.viewPanel.getErrorDisplay().error("Cannot get document in record", ex);
            }
            if (i2 >= 0 && doc != null) {
                Dimension d = this.molSizes[i2];
                MolPainter p = this.docStorage.getMolPainter(irec, null);
                if (p != null && d != null) {
                    if (!p.areBoundsSet()) {
                        p.setBoundsFor(doc);
                    }
                    scale = p.maxScale(d);
                }
            }
        }
        return scale;
    }

    public int getVisibleCanvasCount() {
        return this.visibleCanV != null ? this.visibleCanV.size() : 0;
    }

    private void enqueueUpdaterThread(int row) {
        int cols = this.getColumnCount();
        int icell_min = row * cols;
        int icell_max = icell_min + cols * this.visibleRows - 1;
        this.recordFetcher.enqueueFetching(this, icell_min, icell_max);
    }

    @Override
    public void updateVisibleCells(int x) {
        this.visibleCells(false);
        this.setCornerFromScrollBar(this.vScrollBar, x);
        this.visibleCells(true);
        this.vScrollBarValidValue = x;
        if (this.viewPanel.getSelectedCellIndex() >= 0) {
            if (EventQueue.isDispatchThread()) {
                this.animateSelected();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GridBagView.this.animateSelected();
                    }
                });
            }
        }
    }

    private void animateSelected() {
        int i = this.viewPanel.getSelectedCellIndex();
        if (i >= 0) {
            this.viewPanel.setAnimated(i, this.viewPanel.getAnimLength(i));
        }
    }

    private static String nxtt0(MStringTokenizer mst, String d) {
        String s = mst.trimNextToken();
        return s == null ? null : (s.length() != 0 ? s : d);
    }

    private static Font reuse(Font f, Font[] fonts, int n) {
        for (int i = 0; i < n; ++i) {
            if (!fonts[i].equals(f)) continue;
            f = fonts[i];
            break;
        }
        return f;
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initTransient();
    }

    @Override
    public String getMultiPageSupportedPrintProviderClassName() {
        return "chemaxon.marvin.modules.print.GridBagMPageTable";
    }

    @Override
    public boolean hasVerticalScrollbar() {
        return this.vScrollBar != null;
    }

    private class ViewLabel
    extends JLabel {
        public ViewLabel() {
        }

        public ViewLabel(String s, int horizontalAlignment) {
            super(s, horizontalAlignment);
        }

        private int getTextWidth() {
            Graphics g = this.getGraphics();
            FontMetrics fm = null;
            fm = g != null ? g.getFontMetrics() : this.getFontMetrics(this.getFont());
            String text = this.getText();
            View v = (View)this.getClientProperty("html");
            return v != null ? Math.round(v.getPreferredSpan(0)) : SwingUtilities.computeStringWidth(fm, text);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            int w = this.getTextWidth();
            if (d.width < w) {
                d.width = w;
            }
            return d;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            int w = this.getTextWidth();
            if (d.width < w) {
                d.width = w;
            }
            return d;
        }

        @Override
        public Dimension getSize() {
            Dimension d = super.getSize();
            int w = this.getTextWidth();
            if (d.width < w) {
                d.width = w;
            }
            return d;
        }
    }
}

