/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.swing.BasicActions;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.modules.ImageViewCanvas;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public final class ImageViewFrame
extends JFrame
implements CallbackIface,
WindowListener,
KeyListener {
    private BasicActions basicActions;
    private ViewPanel viewPanel;

    public ImageViewFrame() {
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.basicActions = new BasicActions();
        this.basicActions.addWindowCloseAction(this, this);
    }

    @Override
    public Object callback(String method, Object arg) {
        Object[] args;
        if (method.equals("init") && (args = (Object[])arg)[0] instanceof Image) {
            Image image = (Image)args[0];
            this.viewPanel = (ViewPanel)args[1];
            String title = (String)args[2];
            if (title != null) {
                this.setTitle(title);
            }
            this.init(image);
        }
        return null;
    }

    public void init(Image image) {
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu menu = BasicActions.createFileMenu();
        menu.setMnemonic('F');
        this.basicActions.getWindowCloseAction().addTo(menu, 0);
        menubar.add(menu);
        menu = this.viewPanel.addHelpMenu(menubar, false, null);
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(new ImageViewCanvas(image));
        this.pack();
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        this.viewPanel.hideWindow(this);
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    public void paint() {
    }

    @Override
    public void keyReleased(KeyEvent ev) {
    }

    @Override
    public void keyPressed(KeyEvent ev) {
        int key = ev.getKeyCode();
        if (key == 27) {
            this.viewPanel.hideWindow(this);
        }
    }

    @Override
    public void keyTyped(KeyEvent ev) {
    }
}

