/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class MViewAnimator
extends MarvinModule
implements Runnable {
    private ViewPanel mpan;
    private Vector canV = null;
    private Vector animcanV = new Vector();
    private double[] spinDefault;
    private double[][] spins = null;
    private short[] animMode = null;
    private double[] dphi = null;
    private transient Thread runner = null;
    private int imageSaving = -1;
    private long prevTime;
    private long currentTime;

    public MViewAnimator() {
        this.modfunc("init");
    }

    public MViewAnimator(MViewAnimator o) {
        this.mpan = o.mpan;
        this.canV = o.canV;
        this.animcanV = (Vector)o.animcanV.clone();
        this.spinDefault = o.spinDefault;
        this.spins = o.spins;
        this.dphi = (double[])(o.dphi != null ? new double[o.dphi.length] : null);
        this.animMode = o.animMode;
        this.imageSaving = o.imageSaving;
        this.prevTime = o.prevTime;
        this.currentTime = o.currentTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSomething(Object o) {
        if (o instanceof String) {
            String str = (String)o;
            if (str.equals("getAnimated")) {
                StringBuffer sbuf = new StringBuffer();
                Vector vector = this.animcanV;
                synchronized (vector) {
                    int n = this.animcanV.size();
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            Integer index = (Integer)this.animcanV.elementAt(i);
                            if (i > 0) {
                                sbuf.append(",");
                            }
                            sbuf.append(index);
                        }
                    }
                }
                return sbuf.toString();
            }
            if (str.startsWith("spinAnimLength")) {
                double[] spin = null;
                int i = -1;
                try {
                    i = Integer.parseInt(str.substring(14));
                }
                catch (NumberFormatException ex) {
                    return new Integer(0);
                }
                if (this.spins != null) {
                    spin = this.spins[i];
                }
                if (spin == null) {
                    spin = this.spinDefault;
                }
                int n = 0;
                double frameRate = this.mpan.getAnimFPS();
                if (frameRate > 0.0) {
                    n = (int)Math.round(Math.PI * 2 * frameRate / spin[0]);
                }
                return new Integer(n);
            }
        } else if (o instanceof Integer) {
            int i = (Integer)o;
            short[] x = this.animMode;
            if (x != null && i < x.length) {
                return new Boolean(x[i] != 0);
            }
            return new Boolean(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object modfunc(Object arg) {
        if (arg instanceof ViewPanel) {
            this.mpan = (ViewPanel)arg;
        } else {
            Object[] args;
            if (arg instanceof String) {
                Vector vector;
                String str = (String)arg;
                if (str.equals("init")) {
                    vector = this.animcanV;
                    synchronized (vector) {
                        this.canV = null;
                        this.animcanV.removeAllElements();
                        this.animMode = null;
                        this.runner = null;
                        double[] spin = new double[]{0.6283185307179586, 0.0, 1.0, 0.0};
                        this.spinDefault = spin;
                    }
                }
                if (str.equals("destroy")) {
                    Vector vector2 = this.animcanV;
                    synchronized (vector2) {
                        this.canV = null;
                        this.animcanV.removeAllElements();
                        this.animMode = null;
                        this.runner = null;
                        return null;
                    }
                }
                if (str.startsWith("animate ")) {
                    str = str.substring(8);
                    vector = this.animcanV;
                    synchronized (vector) {
                        int i;
                        StringBuffer sbuf;
                        if (str.equals("off")) {
                            sbuf = new StringBuffer();
                            for (i = 0; i < this.mpan.getMolCount(); ++i) {
                                if (i > 0) {
                                    sbuf.append(",");
                                }
                                sbuf.append(String.valueOf(-i - 1));
                            }
                            str = sbuf.toString();
                        } else if (str.equals("all")) {
                            sbuf = new StringBuffer();
                            for (i = 0; i < this.mpan.getMolCount(); ++i) {
                                if (i > 0) {
                                    sbuf.append(",");
                                }
                                sbuf.append(String.valueOf(i));
                            }
                            str = sbuf.toString();
                        }
                        StringTokenizer st = new StringTokenizer(str, ", \t\r\n");
                        while (st.hasMoreTokens()) {
                            try {
                                int i2 = Integer.parseInt(st.nextToken());
                                boolean add = i2 >= 0;
                                int k = add ? i2 : -i2 - 1;
                                Integer ko = new Integer(k);
                                int j = this.animcanV.indexOf(ko);
                                this.mpan.getViewHandler().setAnimated(k, add);
                                ViewCanvas c = this.mpan.getCanvas(k);
                                if (j < 0) {
                                    if (!add) continue;
                                    this.animcanV.addElement(ko);
                                    if (this.animMode == null) {
                                        this.animMode = new short[this.mpan.getMolCount()];
                                    }
                                    this.animMode[k] = 1;
                                    c.callback("startrot", null);
                                    continue;
                                }
                                if (add) continue;
                                this.animcanV.removeElementAt(j);
                                this.animMode[k] = 0;
                                c.callback("stoprot", null);
                            }
                            catch (Exception ex) {}
                        }
                    }
                }
                if (str.startsWith("cloneForSaving")) {
                    MViewAnimator r = new MViewAnimator(this);
                    try {
                        r.imageSaving = Integer.parseInt(str.substring(14));
                    }
                    catch (NumberFormatException ex) {
                        r.imageSaving = -1;
                    }
                    r.dphi = new double[this.mpan.getMolCount()];
                    return r;
                }
                if (str.equals("next")) {
                    CTransform3D T = new CTransform3D();
                    DPoint3 o = new DPoint3(0.0, 0.0, 0.0);
                    this.step(T, o, null);
                    return null;
                }
                Vector T = this.animcanV;
                synchronized (T) {
                    this.initRunner(false);
                }
            }
            if (arg instanceof Object[] && (args = (Object[])arg)[0] instanceof Integer) {
                int i = (Integer)args[0];
                Vector vector = this.animcanV;
                synchronized (vector) {
                    if (args[1].equals("stopSpin")) {
                        this.quantSpin(i, true);
                    } else if (args[1].equals("quantSpin")) {
                        this.quantSpin(i, false);
                    } else {
                        if (i < 0) {
                            if (args[1] != null) {
                                this.spinDefault = (double[])args[1];
                            }
                            i = 0;
                        }
                        if (this.spins == null) {
                            int n = this.mpan.getMolCount();
                            this.spins = new double[n][];
                        }
                        this.spins[i] = args.length > 1 ? (double[])args[1] : null;
                    }
                }
            }
        }
        return null;
    }

    private void quantSpin(int i, boolean stop) {
        String msg = null;
        ViewCanvas canv = this.mpan.getCanvas(i);
        double[] spin = null;
        if (this.spins != null) {
            spin = this.spins[i];
        }
        if (spin == null) {
            spin = new double[this.spinDefault.length];
            System.arraycopy(this.spinDefault, 0, spin, 0, this.spinDefault.length);
            if (this.spins == null) {
                this.spins = new double[this.mpan.getMolCount()][];
            }
            this.spins[i] = spin;
        }
        if (canv != null) {
            double frameRate;
            int n = canv.getAnimLength();
            if (stop) {
                spin[0] = 0.0;
            } else if (n > 0 && (frameRate = this.mpan.getAnimFPS()) > 0.0) {
                int k;
                double J;
                if (n == 1 && spin[0] > 0.0) {
                    n = (int)Math.round(Math.PI * 2 * frameRate / spin[0]);
                }
                if (spin[0] != (J = Math.PI * 2 * frameRate * (double)(k = (int)Math.round((double)n * spin[0] / (Math.PI * 2 * frameRate))) / (double)n)) {
                    msg = "Number of rotations changed to the closest integer.\nOld value: " + spin[0] / frameRate / (Math.PI * 2) * (double)n + "/" + n + " frames\n" + "New value: " + k + "/" + n + " frames";
                    spin[0] = J;
                } else {
                    msg = "Number of rotations not changed.\nValue: " + k + "/" + n + " frames";
                }
            }
        }
        if (!stop) {
            if (msg == null) {
                msg = "Not spinning.";
            }
            JOptionPane.showMessageDialog(null, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void step(CTransform3D T, DPoint3 o, Thread thisthread) {
        double frameRate = this.mpan.getAnimFPS();
        int delay = (int)(1000.0 / frameRate + 0.5);
        int repeatDelay = (int)(this.mpan.getAnimDelay() * frameRate + 0.5);
        boolean sync = this.mpan.isAnimSync();
        int maxLength = 0;
        int syncStep = 0;
        Vector vector = this.animcanV;
        synchronized (vector) {
            ViewCanvas canv;
            int i;
            for (i = 0; i < this.animcanV.size(); ++i) {
                double df;
                int icell = (Integer)this.animcanV.elementAt(i);
                if (this.imageSaving >= 0 && this.imageSaving != icell || (canv = this.mpan.getCanvas(icell)) == null) continue;
                int ncells = this.mpan.getMolCount();
                MDocument doc = icell < ncells ? this.mpan.getDocument(icell) : null;
                double[] J = this.spins != null ? this.spins[icell] : null;
                double d = df = icell < this.dphi.length ? this.dphi[icell] : 0.0;
                if (J == null && canv.getAnimLength() == 1) {
                    J = this.spinDefault;
                }
                if (doc == null || J == null) continue;
                canv.calcTransformedCenter(o);
                T.setRotation(J[1], J[2], J[3], df);
                T.setRotationCenter(o);
                canv.transform(T);
            }
            if (sync && this.imageSaving < 0) {
                for (i = 0; i < this.animcanV.size(); ++i) {
                    int index = (Integer)this.animcanV.elementAt(i);
                    canv = this.mpan.getCanvas(index);
                    int n = canv.getAnimLength();
                    if (n <= maxLength) continue;
                    maxLength = n;
                }
                if (this.animcanV.size() > 0) {
                    int index = (Integer)this.animcanV.elementAt(0);
                    ViewCanvas canv2 = this.mpan.getCanvas(index);
                    syncStep = canv2.getAnimIndex();
                }
            }
        }
        if (this.imageSaving >= 0) {
            this.currentTime += (long)delay;
        } else {
            this.currentTime = System.currentTimeMillis();
            int dt = delay - (int)(this.currentTime - this.prevTime);
            if (dt > 0) {
                try {
                    Thread.sleep(dt);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                this.currentTime += (long)dt;
            }
        }
        Vector vector2 = this.animcanV;
        synchronized (vector2) {
            int index;
            int i;
            double dphi0 = 0.001 * (double)(this.currentTime - this.prevTime);
            for (i = 0; i < this.animcanV.size(); ++i) {
                double[] spin;
                index = (Integer)this.animcanV.elementAt(i);
                double[] dArray = spin = this.spins != null ? this.spins[index] : null;
                if (spin == null) {
                    spin = this.spinDefault;
                }
                if (index >= this.dphi.length) {
                    double[] newdphi = new double[index + 1];
                    System.arraycopy(this.dphi, 0, newdphi, 0, this.dphi.length);
                    this.dphi = newdphi;
                }
                this.dphi[index] = dphi0 * spin[0];
            }
            this.prevTime = this.currentTime;
            if (this.imageSaving < 0) {
                for (i = 0; i < this.animcanV.size(); ++i) {
                    int n;
                    index = (Integer)this.animcanV.elementAt(i);
                    ViewCanvas canv = this.mpan.getCanvas(index);
                    int n2 = n = canv != null ? canv.getAnimLength() : 0;
                    if (n > 1) {
                        int j;
                        if (sync) {
                            n = maxLength;
                            j = syncStep;
                        } else {
                            j = canv.getAnimIndex();
                        }
                        canv.setAnimIndex((j + 1) % (n + repeatDelay));
                    }
                    if (index >= this.mpan.getMolCount()) continue;
                    this.mpan.repaintMolComponent(index);
                }
            }
        }
    }

    @Override
    public void run() {
        Thread thisthread = Thread.currentThread();
        if (thisthread == null) {
            return;
        }
        this.dphi = new double[this.mpan.getMolCount()];
        CTransform3D T = new CTransform3D();
        DPoint3 o = new DPoint3(0.0, 0.0, 0.0);
        this.currentTime = this.prevTime = System.currentTimeMillis();
        while (thisthread == this.runner) {
            this.step(T, o, thisthread);
        }
    }

    private void initRunner(boolean forceCreate) {
        if (this.animcanV.size() != 0) {
            if (this.runner == null || forceCreate) {
                this.runner = new Thread((Runnable)this, "MRV-3d-rotator");
                this.runner.start();
            }
        } else {
            this.runner = null;
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.initRunner(true);
    }
}

