/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.common.swing.PagesActions;
import chemaxon.marvin.swing.BasicActions;
import chemaxon.marvin.swing.MAction;
import chemaxon.marvin.swing.MDialogProgressMonitor;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.modules.ViewFrameStatusBar;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.PageSettings;
import chemaxon.struc.graphics.MMoleculeMovie;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class MViewFrame
extends JDialog
implements CallbackIface,
PagesActions.Listener,
ActionListener,
WindowListener,
MenuListener,
PropertyChangeListener,
KeyListener {
    private static final long serialVersionUID = -5254790510542955255L;
    private PagesActions pagesActions;
    private BasicActions basicActions;
    private MAction printAction;
    private MDocument sketchDocument;
    private ViewPanel viewPanel;
    private int index;
    private ViewCanvas canvas = null;
    private JMenuItem msketchmi;
    private MolPanel parentPanel = null;
    private String text = null;
    private JMenuBar menubar;
    private ViewFrameStatusBar statusBar;
    private JMenu pagesMenu;

    public MViewFrame() {
        this.initialize();
    }

    public MViewFrame(Dialog parent) {
        super(parent);
        this.initialize();
    }

    public MViewFrame(Frame parent) {
        super(parent);
        this.initialize();
    }

    private void initialize() {
        this.addWindowListener(this);
        this.addKeyListener(this);
        this.printAction = new MAction("print", BasicActions.RESOURCES.getString("print"), SwingUtil.getCommandKeyStroke(80));
        this.pagesActions = new PagesActions(this);
        this.basicActions = new BasicActions();
        this.basicActions.addWindowCloseAction(this, this);
        this.printAction.addActionListener(this);
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setIndex")) {
            this.index = (Integer)arg;
        } else if (method.equals("setViewPanel")) {
            this.viewPanel = (ViewPanel)arg;
            this.viewPanel.addPropertyChangeListener(this);
        } else if (method.equals("setViewCanvas")) {
            this.canvas = (ViewCanvas)arg;
            this.canvas.setWinmode(1);
            this.makeLayout(this.canvas, null);
        } else if (method.equals("init")) {
            this.init();
        } else if (method.equals("setTitle")) {
            MMoleculeMovie mmm;
            String name;
            MDocument d = (MDocument)arg;
            Molecule m = (Molecule)d.getMainMoleculeGraph();
            String string = name = m == null ? "" : m.getName();
            if (name.length() == 0 && (mmm = d.getMoleculeMovie()) != null) {
                m = mmm.getCurrentMolecule();
                name = m.getName();
            }
            this.setTitle(name.length() == 0 ? "MarvinView " : name);
        } else if (method.equals("startrot")) {
            this.viewPanel.setAnimMenuItems(true, this.viewPanel.getAnimLength(this.index));
        } else if (method.equals("stoprot")) {
            this.viewPanel.setAnimMenuItems(false, this.viewPanel.getAnimLength(this.index));
        } else if (method.equals("setMolPanel")) {
            this.parentPanel = (MolPanel)arg;
        } else if (method.equals("setSketchDoc")) {
            MDocument doc = (MDocument)arg;
            this.sketchDocument = doc.cloneDocument();
        } else if (method.equals("setText")) {
            this.text = (String)arg;
        } else if (method.equals("newPanel")) {
            Object[] args = (Object[])arg;
            final int dim = (Integer)args[0];
            final String title = (String)args[1];
            this.parentPanel.beginHourglass();
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        MViewFrame.this.newPanel(dim, title);
                    }
                    finally {
                        MViewFrame.this.parentPanel.endHourglass();
                    }
                }
            };
            t.start();
        } else if (method.equals("setTransform")) {
            // empty if block
        }
        return null;
    }

    private void newPanel(int dim, String title) {
        Properties props = this.parentPanel.getProperties();
        props.put("rows", "1");
        props.put("cols", "1");
        props.put("visibleRows", "1");
        props.put("visibleCols", "1");
        if (this.text != null) {
            props.put("layout", ":2:1:M:1:0:1:1:c:b:1:1:T:0:0:1:1:w:n:0:1");
            props.put("param", ":M:10:10:T:12b");
            String bg = props.getProperty("viewmolbg" + dim + "d");
            if (bg != null) {
                props.put("molbg", bg);
                props.put("background", bg);
            }
        } else {
            props.put("layout", ":1:1:M:1:0:1:1:c:b:1:1");
            props.put("param", ":M:10:10");
        }
        this.viewPanel = new ViewPanel(this, this.parentPanel, dim, props);
        if (this.text != null) {
            this.viewPanel.setT(0, this.text);
        }
        this.viewPanel.startstop(false);
        int cellcount = this.viewPanel.getCellCount();
        this.canvas = this.viewPanel.getCanvas(cellcount - 1);
        this.makeLayout(this.viewPanel, this.sketchDocument);
        Molecule m = this.sketchDocument.getPrimaryMolecule();
        if (dim != m.getDim()) {
            MDialogProgressMonitor pm = new MDialogProgressMonitor(this.viewPanel, "Cleaning...");
            m.clean(dim, this.parentPanel.getCleanOpts(dim), pm);
        }
        Object[] o = new Object[]{this.sketchDocument, new Integer(0), new Boolean(true)};
        this.viewPanel.callback("setMol", o);
        this.init();
        if (title != null) {
            this.setTitle(title);
        } else {
            this.callback("setTitle", this.sketchDocument);
        }
        this.setSize(400, 400);
        try {
            Method method = JDialog.class.getMethod("setLocationRelativeTo", Component.class);
            method.invoke((Object)this, this.parentPanel);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.setVisible(true);
    }

    public void init() {
        Object target = null;
        this.menubar = new JMenuBar();
        this.setJMenuBar(this.menubar);
        JMenu menu = BasicActions.createFileMenu();
        this.viewPanel.makeRecentFileListMenu(menu);
        this.viewPanel.makeSaveAsMenu(menu, false, target);
        this.viewPanel.getCommonActions().getSaveImageAction().addTo(menu, 0);
        this.printAction.addTo(menu, 0, target);
        this.basicActions.getWindowCloseAction().addTo(menu, 0, target);
        this.menubar.add(menu);
        menu = BasicActions.createEditMenu(true);
        this.viewPanel.makeEditMenu(menu, false, target);
        this.menubar.add(menu);
        menu = BasicActions.createViewMenu();
        JMenu submenu = this.viewPanel.createTransformMenu(false);
        menu.add(submenu);
        this.viewPanel.addTransformViewMenuItems(submenu, false, target);
        this.viewPanel.addAnimationMenu(menu, false, this.index, target);
        menu.addSeparator();
        this.viewPanel.addViewSubmenus(menu, false);
        menu.addSeparator();
        this.viewPanel.addOpenMSpaceMenuItem(menu);
        this.menubar.add(menu);
        menu = BasicActions.createStructureMenu(true);
        this.viewPanel.makeStructureMenu(menu, false, target);
        menu = this.viewPanel.addToolsMenu(this.menubar, target);
        this.pagesMenu = this.pagesActions.createMenu();
        this.menubar.add(this.pagesMenu);
        menu = this.viewPanel.addHelpMenu(this.menubar, false, target);
        for (int i = 0; i < this.menubar.getMenuCount(); ++i) {
            this.addActionListenerRecursively(this.menubar.getMenu(i));
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.viewPanel.firePropertyChangeEvent("windowOpened", null, "viewframe" + Integer.toString(this.index));
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.viewPanel.firePropertyChangeEvent("windowClosing", null, "viewframe" + Integer.toString(this.index));
        boolean mine = this.getContentPane().getComponent(0) == this.viewPanel;
        this.viewPanel.setWinmode(0, this.index);
        ViewPanel.removeFromActionsRecursively(this.getJMenuBar());
        if (mine) {
            this.viewPanel.destroy();
            this.viewPanel = null;
        }
    }

    private void addActionListenerRecursively(JMenu menu) {
        menu.addMenuListener(this);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem mi = menu.getItem(i);
            if (mi == null) continue;
            if (mi instanceof JMenu) {
                this.addActionListenerRecursively((JMenu)mi);
                continue;
            }
            mi.addActionListener(this);
        }
    }

    @Override
    public void windowClosed(WindowEvent ev) {
        if (this.viewPanel != null) {
            this.viewPanel.firePropertyChangeEvent("windowClosed", null, "viewframe" + Integer.toString(this.index));
        }
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    @Override
    public void menuSelected(MenuEvent ev) {
        this.viewPanel.setSelectedCellIndex(this.index);
    }

    @Override
    public void menuDeselected(MenuEvent ev) {
    }

    @Override
    public void menuCanceled(MenuEvent ev) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() instanceof JMenuItem) {
            this.viewPanel.setSelectedCellIndex(this.index);
            return;
        }
        String cmd = ev.getActionCommand();
        MDocument d = this.canvas.getDocument();
        this.viewPanel.beginHourglass();
        if (cmd.equals("print")) {
            CallbackIface mm = null;
            ViewPanel vpan = this.viewPanel;
            try {
                mm = (CallbackIface)MarvinModule.load("common.swing.Print", vpan);
            }
            catch (SecurityException sex) {
                vpan.getErrorDisplay().firewallError(sex, null);
            }
            if (mm != null) {
                mm.callback("setAtomsize", vpan.getUserSettings().getAtomSize());
                mm.callback("setBondSpacing", new Double(vpan.getBondSpacing()));
                mm.callback("setDispopts", new Integer(vpan.getDispopts()));
                mm.callback("setMol", d.getMainMoleculeGraph());
            }
            vpan.endHourglass();
            if (mm != null) {
                mm.callback("print", this);
            }
            return;
        }
        this.viewPanel.endHourglass();
    }

    @Override
    public void doGoToPage() {
        MDocument d = this.canvas.getDocument();
        if (d == null) {
            return;
        }
        PageSettings ps = d.getPageSettings();
        int x = 0;
        try {
            x = Integer.valueOf(this.statusBar.getSelectedPageField().getText());
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (x > 0 && x <= ps.getColumnCount() * ps.getRowCount()) {
            ps.setSelectedPage(x - 1);
        } else {
            PagesActions.showErrorMessageDialog(this.canvas);
        }
        this.canvas.centralize(ps);
        this.canvas.repaint();
        this.statusBar.update();
    }

    @Override
    public void doFitPage() {
        this.canvas.fitPage();
        this.canvas.repaint();
    }

    @Override
    public void doFitPageWidth() {
        this.canvas.fitPageWidth();
        this.canvas.repaint();
    }

    @Override
    public void doFitPageHeight() {
        this.canvas.fitPageHeight();
        this.canvas.repaint();
    }

    @Override
    public void doLastPage() {
        if (!this.canvas.isMultipageEnabled()) {
            return;
        }
        this.canvas.lastPage();
        this.statusBar.update();
    }

    @Override
    public void doFirstPage() {
        if (!this.canvas.isMultipageEnabled()) {
            return;
        }
        this.canvas.firstPage();
        this.statusBar.update();
    }

    @Override
    public void doNextPage() {
        if (!this.canvas.isMultipageEnabled()) {
            return;
        }
        this.canvas.nextPage();
        this.statusBar.update();
    }

    @Override
    public void doPreviousPage() {
        if (!this.canvas.isMultipageEnabled()) {
            return;
        }
        this.canvas.previousPage();
        this.statusBar.update();
    }

    @Override
    public void doGoToPageFromMenu() {
        CallbackIface mm = (CallbackIface)MarvinModule.load("common.swing.IntegerDialog", this.viewPanel);
        if (mm != null) {
            mm.callback("setDocument", this.canvas.getDocument());
            mm.callback("setViewFrame", this);
            mm.callback("setViewCanvas", this.canvas);
            mm.callback("show", null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String name = ev.getPropertyName();
        Object value = ev.getNewValue();
        if (name.equals("editable") && value instanceof Integer) {
            this.msketchmi.setEnabled((Integer)value != 0);
        }
    }

    @Override
    public void keyReleased(KeyEvent ev) {
    }

    @Override
    public void keyPressed(KeyEvent ev) {
        int key = ev.getKeyCode();
        if (key == 27) {
            this.windowClosing(null);
        }
    }

    @Override
    public void keyTyped(KeyEvent ev) {
    }

    private void makeLayout(Component c, MDocument doc) {
        int n;
        Container contentPane = this.getContentPane();
        contentPane.removeAll();
        GridBagLayout gbl = new GridBagLayout();
        contentPane.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbl.setConstraints(contentPane.add(c), gbc);
        if (doc == null) {
            doc = this.canvas.getDocument();
        }
        Molecule mol = doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
        int n2 = n = mol != null ? mol.getPropertyCount() : 0;
        if (n != 0) {
            ++gbc.gridy;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 18;
            FieldView txt = new FieldView(mol);
            gbl.setConstraints(contentPane.add(txt), gbc);
        }
        if (this.isMultiPageEnabled(doc)) {
            ++gbc.gridy;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.anchor = 15;
            this.statusBar = new ViewFrameStatusBar(this.pagesActions, this.canvas);
            gbl.setConstraints(contentPane.add(this.statusBar), gbc);
            this.statusBar.update();
            this.canvas.setViewFrame(this);
            this.updatePagesMenu();
        }
    }

    private boolean isMultiPageEnabled(MDocument doc) {
        if (doc == null) {
            return false;
        }
        return doc.getPageSettings().isMultiPageEnabled();
    }

    public void updatePagesMenu() {
        MDocument document = this.canvas.getDocument();
        if (document == null) {
            return;
        }
        int added = -1;
        for (int i = 0; i < this.menubar.getMenuCount() && added < 0; ++i) {
            JMenu menu = this.menubar.getMenu(i);
            if (menu != this.pagesMenu) continue;
            added = i;
        }
        if (document.getPageSettings().isEnabled() && added == -1) {
            this.menubar.add((Component)this.pagesMenu, this.menubar.getMenuCount() - 1);
        } else if (!document.getPageSettings().isEnabled() && added >= 0) {
            this.menubar.remove(added);
        }
        this.menubar.repaint();
    }

    public void updateStatusBarSettings() {
        this.statusBar.update();
    }

    public class FieldView
    extends JScrollPane {
        private static final long serialVersionUID = -785712208091222222L;
        JEditorPane txt;

        public FieldView(Molecule mol) {
            StringBuffer sb = new StringBuffer("<html>");
            int n = mol.getPropertyCount();
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    sb.append("\n<br>");
                }
                String key = mol.getPropertyKey(i);
                sb.append("<b>");
                sb.append(key);
                sb.append(":</b> ");
                sb.append(mol.getProperty(key));
            }
            sb.append("</html>");
            this.txt = new JEditorPane("text/html", sb.toString());
            this.setViewportView(this.txt);
            this.txt.setEditable(false);
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dtxt = this.txt.getPreferredSize();
            Dimension dcanv = MViewFrame.this.canvas.getPreferredSize();
            int h = Math.min(dtxt.height, dcanv.height / 2);
            return new Dimension(0, h);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dtxt = this.txt.getPreferredSize();
            Dimension dcanv = MViewFrame.this.canvas.getPreferredSize();
            int h = Math.min(dtxt.height, dcanv.height);
            return new Dimension(0, h);
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

