/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.sketch.swing.SketchPanel;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.view.swing.ViewPanel;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MViewSketch
implements CallbackIface {
    private ViewPanel mvpan = null;
    private Map<Integer, SketchPanel> mspanels = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object callback(String what, Object arg) {
        if (what.equals("init")) {
            this.mvpan = (ViewPanel)arg;
            this.mspanels = new HashMap<Integer, SketchPanel>();
        } else if (what.equals("show")) {
            int i = (Integer)arg;
            if (this.mvpan.isAnimated(i)) {
                this.mvpan.animate(String.valueOf(-i - 1));
            }
            this.mvpan.setWinmode(0, i);
            Map<Integer, SketchPanel> map = this.mspanels;
            synchronized (map) {
                SketchPanel mspan = this.mspanels.get(i);
                if (mspan == null) {
                    mspan = new SketchPanel(this.mvpan, 2, i, null, null);
                    this.mspanels.put(new Integer(i), mspan);
                    Properties p = this.mvpan.getProperties();
                    mspan.setProperties(p);
                    mspan.makeMyFrame();
                    mspan.init();
                }
                mspan.setMoleculeProvider(this.mvpan.getSketchMoleculeProvider());
                mspan.clearHistory();
                mspan.getEditor().historize();
                mspan.updateControls();
                mspan.setCleanDim(this.mvpan.getCleanDim());
                mspan.setScrollbars();
                mspan.startstop(false);
            }
            this.mvpan.firePropertyChangeEvent("windowOpened", null, "sketchInView" + Integer.toString(i));
        } else {
            if (what.equals("isOpened")) {
                Integer ii = (Integer)arg;
                return this.mspanels.get(ii) != null;
            }
            if (what.equals("close")) {
                Integer ii = (Integer)arg;
                SketchPanel sp = this.mspanels.get(ii);
                if (sp != null) {
                    sp.setWinmode(false);
                }
            } else if (what.equals("remove")) {
                Integer ii = (Integer)arg;
                Map<Integer, SketchPanel> sp = this.mspanels;
                synchronized (sp) {
                    this.mspanels.remove(ii);
                }
                this.mvpan.firePropertyChangeEvent("windowClosing", null, "sketchInView" + ii.toString());
            } else {
                if (what.equals("setStopped")) {
                    boolean stopped = (Boolean)arg;
                    Map<Integer, SketchPanel> sp = this.mspanels;
                    synchronized (sp) {
                        for (SketchPanel panel : this.mspanels.values()) {
                            panel.startstop(stopped);
                        }
                    }
                }
                if (what.equals("destroy")) {
                    Map<Integer, SketchPanel> map = this.mspanels;
                    synchronized (map) {
                        for (SketchPanel panel : this.mspanels.values()) {
                            panel.exit();
                        }
                        this.mspanels.clear();
                        this.mspanels = null;
                    }
                }
            }
        }
        return null;
    }
}

