/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.modules.SplittedTable;
import chemaxon.struc.MDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class MoleculeCellEditor
extends ViewCanvas
implements TableCellEditor {
    private SplittedTable splittedTable;
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private Color gridColor;
    private boolean inLastColumn = false;

    public MoleculeCellEditor(ViewPanel v, SplittedTable t) {
        super(v);
        this.splittedTable = t;
    }

    @Override
    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        super.paint(g);
        g.setColor(this.gridColor);
        g.drawLine(0, sz.height - 1, sz.width - 1, sz.height - 1);
        if (this.inLastColumn) {
            g.drawLine(sz.width - 1, 0, sz.width - 1, sz.height - 1);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        ViewHandler h = this.viewPanel.getViewHandler();
        h.setMolCenter(this.getCellIndex(), this.getCenter());
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getDocument();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        int part = this.splittedTable.getPartIndex(table);
        col = table.getColumnModel().getColumn(col).getModelIndex();
        int ncols = this.splittedTable.getColumnCount();
        int i = row * ncols + this.splittedTable.getStartColumn(part) + col;
        MDocument doc = value instanceof MDocument ? (MDocument)value : null;
        this.initCellRendering();
        ViewHandler h = this.viewPanel.getViewHandler();
        int icell = h.molCellIndexFromCellIndex(i);
        this.setCenter(h.getMolCenter(icell));
        MolPainter painter = h.getMolPainter(icell);
        if (painter == null) {
            painter = this.viewPanel.createMolPainter(doc);
            h.setMolPainter(icell, painter);
        }
        this.viewPanel.setSelectedCellIndex(icell);
        this.viewPanel.setWinmode(0, icell);
        this.setEnabled(h.getFrame(icell) == null);
        this.setDocument(doc, painter, icell);
        this.gridColor = table.getGridColor();
        this.inLastColumn = col == table.getColumnCount() - 1;
        return this;
    }
}

