/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.modules.SplittedTable;
import chemaxon.struc.MDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MoleculeCellRenderer
implements TableCellRenderer {
    private ViewPanel viewPanel;
    private SplittedTable splittedTable;
    private ViewCanvas defaultCanvas;
    private ViewCanvas[] animatedCanvases;

    public MoleculeCellRenderer(ViewPanel v, SplittedTable t) {
        this.defaultCanvas = new ViewCanvas(v);
        this.viewPanel = v;
        this.splittedTable = t;
        this.animatedCanvases = new ViewCanvas[0];
    }

    public void setAnimated(int icell, boolean v) {
        int n = this.animatedCanvases.length;
        for (int i = 0; i < n; ++i) {
            if (this.animatedCanvases[i].getCellIndex() != icell) continue;
            if (v) {
                return;
            }
            ViewCanvas[] arr = new ViewCanvas[n - 1];
            System.arraycopy(this.animatedCanvases, 0, arr, 0, i);
            System.arraycopy(this.animatedCanvases, i + 1, arr, i, n - i - 1);
            this.animatedCanvases = arr;
        }
        if (v) {
            ViewCanvas[] arr = new ViewCanvas[n + 1];
            System.arraycopy(this.animatedCanvases, 0, arr, 0, n);
            arr[n] = new ViewCanvas(this.viewPanel);
            arr[n].setDocument(null, new MolPainter(this.viewPanel.painterCommon), icell);
            this.animatedCanvases = arr;
        }
    }

    public ViewCanvas getAnimatedCanvas(int icell) {
        for (int i = 0; i < this.animatedCanvases.length; ++i) {
            ViewCanvas c = this.animatedCanvases[i];
            if (c.getCellIndex() != icell) continue;
            return c;
        }
        return null;
    }

    JComponent update(final JTable table, Object value, int row, int col, boolean focused) {
        int part = this.splittedTable.getPartIndex(table);
        col = table.getColumnModel().getColumn(col).getModelIndex();
        int ncols = this.splittedTable.getColumnCount();
        int i = row * ncols + this.splittedTable.getStartColumn(part) + col;
        ViewHandler h = this.viewPanel.getViewHandler();
        int icell = h.molCellIndexFromCellIndex(i);
        ViewCanvas canv = this.getAnimatedCanvas(icell);
        if (canv == null) {
            canv = this.defaultCanvas;
        }
        canv.initCellRendering();
        canv.setMolbg(focused ? table.getSelectionBackground() : null);
        canv.setCenter(h.getMolCenter(icell));
        MolPainter painter = h.getMolPainter(icell);
        if (value == null) {
            canv.setDocument(null, painter, icell);
        } else if (value instanceof MDocument) {
            MDocument doc = (MDocument)value;
            canv.setDocument(doc, painter, icell);
        }
        canv.getWindowAction().setEnabled(this.viewPanel.isDetachable());
        final boolean inLastColumn = col == table.getColumnCount() - 1;
        JPanel p = new JPanel(){

            @Override
            public void paint(Graphics g) {
                Dimension sz = this.getSize();
                super.paint(g);
                g.setColor(table.getGridColor());
                g.drawLine(0, sz.height - 1, sz.width - 1, sz.height - 1);
                if (inLastColumn) {
                    g.drawLine(sz.width - 1, 0, sz.width - 1, sz.height - 1);
                }
            }
        };
        p.setLayout(new GridLayout(1, 1));
        p.add(canv);
        return p;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        JComponent c = this.update(table, value, row, col, hasFocus);
        return c;
    }
}

