/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.swing.ActionMenuItem;
import chemaxon.marvin.swing.BasicActions;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.swing.TableOptions;
import chemaxon.marvin.view.swing.TableSupport;
import chemaxon.marvin.view.swing.TableSupportCreator;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;

public class MolsFrame
extends JDialog
implements ActionListener,
WindowListener,
CallbackIface {
    private ViewPanel vpan = null;
    private MolPanel parent = null;
    private Dimension size = new Dimension(200, 200);
    private int icell = 0;
    private String selectLabel = null;
    private MDocSource docSource;
    private TableSupport tableSupport = null;
    private int molCount = 0;
    private final Action printAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            MolsFrame.this.print();
        }
    };
    private final Action closeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            MolsFrame.this.windowClosing(null);
        }
    };

    public MolsFrame() {
    }

    public MolsFrame(Dialog parent) {
        super(parent);
    }

    public MolsFrame(Frame parent) {
        super(parent);
    }

    public void build() {
        if (this.vpan == null) {
            return;
        }
        this.vpan.setDetachable(true);
        this.initActions();
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu menu = BasicActions.createFileMenu();
        this.vpan.makeRecentFileListMenu(menu);
        boolean animation = this.vpan.isAnimated(0);
        if (!animation) {
            this.tableSupport = TableSupportCreator.create(this.vpan);
            TableOptions tableOptions = this.tableSupport.getTableOptions();
            tableOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    MolsFrame.this.tableSupport.enqueueUpdate();
                }
            });
            tableOptions.setViewHandlerType(1);
            tableOptions.setStartAt(1);
            tableOptions.setMaxCols(this.vpan.getColumnCount());
            tableOptions.setMaxRows(Math.min(this.vpan.getRowCount0(), this.vpan.getVisibleRows()));
            tableOptions.setSingleCellLabelShown(true);
            tableOptions.initFields();
            this.vpan.makeSaveAsMenu(menu, false, null);
            this.vpan.getCommonActions().getSaveImageAction().addTo(menu, 0);
        }
        menu.add(new ActionMenuItem(this.printAction));
        menu.add(new ActionMenuItem(this.closeAction));
        menubar.add(menu);
        menu = BasicActions.createEditMenu(true);
        this.vpan.makeEditMenu(menu, false, null);
        menubar.add(menu);
        menu = BasicActions.createViewMenu();
        JMenu submenu = this.vpan.createTransformMenu(false);
        menu.add(submenu);
        this.vpan.addTransformViewMenuItems(submenu, false, null);
        this.vpan.addAnimationMenu(menu, false, -1, null);
        menu.addSeparator();
        this.vpan.addViewSubmenus(menu, false);
        menubar.add(menu);
        if (!animation) {
            menu = SwingUtil.createMenu(BasicActions.RESOURCES, "table");
            this.tableSupport.makeTableMenu(menu);
            menubar.add(menu);
            menu = BasicActions.createStructureMenu(true);
            this.vpan.makeStructureMenu(menu, false, null);
            menubar.add(menu);
            menu = this.vpan.addToolsMenu(menubar, null);
        }
        menu = this.vpan.addHelpMenu(menubar, false, null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.vpan, "Center");
        if (this.selectLabel != null) {
            JButton selectb = new JButton(this.selectLabel);
            this.getContentPane().add((Component)selectb, "South");
            selectb.addActionListener(this);
            selectb.setFocusable(false);
        }
        if (!animation) {
            this.tableSupport.setCellSize(this.size);
            this.tableSupport.start(this.docSource, "unknown");
        }
        this.pack();
    }

    private void initActions() {
        SwingUtil.initAction(this.printAction, BasicActions.RESOURCES, "print", SwingUtil.getCommandKeyStroke(80));
        SwingUtil.initAction(this.closeAction, BasicActions.RESOURCES, "close", SwingUtil.getCommandKeyStroke(81));
    }

    private void print() {
        this.vpan.print();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.parent != null) {
            int index = this.vpan.getSelectedCellIndex();
            if (index == -1) {
                index = this.vpan.getVisibleSelectedCellIndex();
            }
            if (index > -1 && index < this.vpan.getCellCount()) {
                final int fi = index;
                this.tableSupport.scheduler.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MDocument doc;
                        MDocStorage ds = MolsFrame.this.tableSupport.getDocStorage();
                        try {
                            doc = ds.getMainDoc(fi);
                        }
                        catch (MDocStorage.RecordUnavailableException ex) {
                            MolsFrame.this.vpan.getErrorDisplay().error("Record " + fi + " not available", ex);
                            return;
                        }
                        catch (IOException ex) {
                            MolsFrame.this.vpan.getErrorDisplay().error("Cannot read record " + fi, ex);
                            return;
                        }
                        doc = doc.cloneDocument();
                        final Molecule mol = doc.getPrimaryMolecule();
                        MolPainter p = ds.getMolPainter(fi, null);
                        CTransform3D t = p.getRTransform();
                        doc.transform(t);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MolsFrame.this.parent.updateMol(MolsFrame.this.icell, mol);
                                MolsFrame.this.windowClosing(null);
                            }
                        });
                    }
                }, index);
            } else {
                JOptionPane.showMessageDialog(this, "No molecule selected.", "Warning", 2);
            }
        }
    }

    @Override
    public Object callback(String method, Object arg) {
        if (method.equals("setViewPanel")) {
            this.vpan = (ViewPanel)arg;
        } else if (method.equals("setTitle")) {
            this.setTitle((String)arg);
        } else if (method.equals("setSelectButton")) {
            this.selectLabel = (String)arg;
        } else if (method.equals("setParent")) {
            this.parent = (MolPanel)arg;
        } else if (method.equals("setSourceCell")) {
            this.icell = (Integer)arg;
        } else if (method.equals("setSize")) {
            int w;
            this.size.width = w = ((Integer)arg).intValue();
            this.size.height = w;
        } else if (method.equals("setDocSource")) {
            this.docSource = (MDocSource)arg;
        } else if (method.equals("build")) {
            this.build();
        } else if (method.equals("show")) {
            if (this.parent != null) {
                this.parent.showWindow(this);
            } else {
                this.setVisible(true);
            }
        }
        return null;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public synchronized void windowClosing(WindowEvent e) {
        this.vpan.exit();
        this.setVisible(false);
        this.getContentPane().removeAll();
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }
}

