/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.core.util.BondTable;
import chemaxon.marvin.common.swing.MolPanel;
import chemaxon.marvin.io.MFieldAccessor;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.fieldaccess.MoleculeFieldAccessor;
import chemaxon.marvin.paint.internal.MolPainter;
import chemaxon.marvin.swing.MAction;
import chemaxon.marvin.swing.ToggleButtonAction;
import chemaxon.marvin.util.CallbackIface;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.marvin.util.SwingUtil;
import chemaxon.marvin.util.text.EncodingUtil;
import chemaxon.marvin.util.text.MStringTokenizer;
import chemaxon.marvin.view.CellType;
import chemaxon.marvin.view.MDocStorage;
import chemaxon.marvin.view.SequentialScheduler;
import chemaxon.marvin.view.swing.CellFiller;
import chemaxon.marvin.view.swing.RecordFetcher;
import chemaxon.marvin.view.swing.ViewCanvas;
import chemaxon.marvin.view.swing.ViewHandler;
import chemaxon.marvin.view.swing.ViewPanel;
import chemaxon.marvin.view.swing.VisibleDocuments;
import chemaxon.marvin.view.swing.modules.FindInfo;
import chemaxon.marvin.view.swing.modules.MoleculeCellEditor;
import chemaxon.marvin.view.swing.modules.MoleculeCellRenderer;
import chemaxon.marvin.view.swing.modules.ResizableTable;
import chemaxon.marvin.view.swing.modules.RowColorFunction;
import chemaxon.marvin.view.swing.modules.SplittedTable;
import chemaxon.marvin.view.swing.modules.SpreadsheetCellFiller;
import chemaxon.marvin.view.swing.modules.TextCellEditor;
import chemaxon.marvin.view.swing.modules.TextCellRenderer;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MProp;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MMoleculeProp;
import chemaxon.struc.prop.MPropFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SpreadsheetView
extends ViewHandler
implements RowColorFunction,
ComponentListener,
MouseListener,
ActionListener,
AdjustmentListener,
PropertyChangeListener {
    private static final ResourceBundle RESOURCES = MolPanel.getResourceBundle(SpreadsheetView.class.getName());
    private ViewPanel viewPanel;
    private CellFiller cellFiller;
    private int tableRowHeight = 64;
    private int tableColumnWidth = 64;
    private SplittedTable theTable;
    private JScrollPane scrollPane;
    private JProgressBar progressBar;
    private MTableModel tableModel;
    private MoleculeCellRenderer moleculeCellRenderer;
    private int[] molComponentIndices;
    private int[] splitColumns;
    private CellType[] cellTypes;
    private String[] cellOptions;
    private int recordNumberOfCellValues;
    private MProp[] cellMProps;
    private Object[] cellValues;
    private boolean[] columnLineWrap;
    private MDocStorage docStorage;
    private RecordFetcher recordFetcher;
    private int firstRowToUpdateLater = -1;
    private int lastRowToUpdateLater = -1;
    private Runnable scrollBarUpdater0 = new Runnable(){

        @Override
        public void run() {
            int newsz;
            int oldsz = SpreadsheetView.this.tableModel.getRowCount();
            ((SpreadsheetView)SpreadsheetView.this).tableModel.rowCount = newsz = SpreadsheetView.this.getNumRecords();
            if (newsz > oldsz) {
                SpreadsheetView.this.tableModel.fireTableRowsInserted(oldsz, newsz - 1);
            } else if (newsz < oldsz) {
                SpreadsheetView.this.tableModel.fireTableRowsDeleted(newsz, oldsz - 1);
            }
            if (SpreadsheetView.this.firstRowToUpdateLater >= 0) {
                if (SpreadsheetView.this.firstRowToUpdateLater < newsz) {
                    if (SpreadsheetView.this.lastRowToUpdateLater >= newsz) {
                        SpreadsheetView.this.lastRowToUpdateLater = newsz - 1;
                    }
                    SpreadsheetView.this.tableModel.fireTableRowsUpdated(SpreadsheetView.this.firstRowToUpdateLater, SpreadsheetView.this.lastRowToUpdateLater);
                }
                SpreadsheetView.this.firstRowToUpdateLater = -1;
                SpreadsheetView.this.lastRowToUpdateLater = -1;
            }
        }
    };
    private Runnable guiUpdater = new Runnable(){

        @Override
        public void run() {
            VisibleDocuments vd = SpreadsheetView.this.getVisibleDocs();
            int row = vd.getRecordIndex();
            int n = vd.getNumDocuments();
            TableModelEvent tm = new TableModelEvent(SpreadsheetView.this.tableModel, row, row + n - 1);
            SpreadsheetView.this.tableModel.fireTableChanged(tm);
        }
    };
    private Runnable scrollBarUpdater = new Runnable(){

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                SpreadsheetView.this.scrollBarUpdater0.run();
            } else {
                EventQueue.invokeLater(SpreadsheetView.this.scrollBarUpdater0);
            }
        }
    };
    private List<Window> molFrames;
    private Map<Integer, Rectangle> molFrameRectangles;
    private int numRecordsAtLastUpdateRecord;
    private double defaultWinScale;
    private Map<Integer, Double> winScales;
    private MAction wrapLinesAllOnAction;
    private MAction wrapLinesAllOffAction;
    private ToggleButtonAction wrapLinesColumnAction;
    private transient JPopupMenu currentPopup;
    private String nameAndArgs;

    public SpreadsheetView(String args, MDocStorage ds, SequentialScheduler sch, int endi) {
        int i;
        this.docStorage = ds != null ? ds : new MDocStorage(1);
        ds.addListener(new MDocStorage.Listener(){

            @Override
            public void docProduced(MDocStorage ds, MDocument doc, int k) {
                SpreadsheetView.this.viewPanel.setAtomAndBondSets(k);
            }

            @Override
            public void storageSizeChanged(MDocStorage ds, int oldsz, int sz) {
            }

            @Override
            public void storageSizeFinalized(MDocStorage ds) {
            }
        });
        this.recordFetcher = new RecordFetcher(this.docStorage, this.scrollBarUpdater, this.guiUpdater, sch, endi);
        this.tableModel = new MTableModel();
        this.nameAndArgs = "SpreadsheetView:" + args;
        MStringTokenizer st = new MStringTokenizer(args, ',', '\\');
        this.recordNumberOfCellValues = -1;
        this.numRecordsAtLastUpdateRecord = 1;
        this.defaultWinScale = -1.0;
        this.winScales = new HashMap<Integer, Double>();
        this.molFrames = new ArrayList<Window>();
        this.molFrameRectangles = new HashMap<Integer, Rectangle>();
        int nc = 0;
        ArrayList<CellType> cellTypeVec = new ArrayList<CellType>();
        ArrayList<String> cellOptionVec = new ArrayList<String>();
        ArrayList<Integer> splitcolvec = new ArrayList<Integer>();
        int col = 0;
        while (st.hasMoreTokens()) {
            String opt;
            String type;
            String s = st.nextToken();
            int k = (s = EncodingUtil.unescape(s)).indexOf(58);
            if (k >= 0) {
                type = s.substring(0, k);
                opt = s.substring(k + 1);
            } else {
                type = s;
                opt = null;
            }
            CellType t = CellType.MOLECULE;
            if (type.equals("#")) {
                t = CellType.RECORD_NUMBER;
            } else if (type.equals("M")) {
                t = CellType.MOLECULE;
                ++nc;
            } else if (type.equals("T")) {
                t = CellType.TEXT;
            } else {
                if (type.equals("|")) {
                    splitcolvec.add(new Integer(col));
                    continue;
                }
                throw new IllegalArgumentException("Invalid cell type \"" + type + "\"");
            }
            cellTypeVec.add(t);
            cellOptionVec.add(opt);
            ++col;
        }
        int n = cellTypeVec.size();
        this.cellTypes = new CellType[n];
        this.cellOptions = new String[n];
        for (i = 0; i < n; ++i) {
            this.cellTypes[i] = (CellType)((Object)cellTypeVec.get(i));
            this.cellOptions[i] = (String)cellOptionVec.get(i);
        }
        this.splitColumns = new int[splitcolvec.size()];
        for (i = 0; i < this.splitColumns.length; ++i) {
            this.splitColumns[i] = (Integer)splitcolvec.get(i);
        }
        this.cellValues = new Object[n];
        this.cellMProps = new MProp[n];
        this.columnLineWrap = new boolean[n];
        this.molComponentIndices = new int[nc];
        int ic = 0;
        for (col = 0; col < n; ++col) {
            String key = this.cellOptions[col];
            boolean bl = this.columnLineWrap[col] = key != null && key.equals("SMILES");
            if (this.cellTypes[col] != CellType.MOLECULE) continue;
            this.molComponentIndices[ic++] = col;
        }
        this.initActions();
    }

    @Override
    public String getNameAndArgs() {
        return this.nameAndArgs;
    }

    @Override
    protected void destruct() {
        this.moleculeCellRenderer = null;
        ViewPanel v = this.viewPanel;
        if (v != null) {
            v.removePropertyChangeListener(this);
        }
    }

    @Override
    protected void init(ViewPanel v, Window f0) {
        this.viewPanel = v;
        String s = v.getParameter("rowHeight");
        if (s != null) {
            this.tableRowHeight = Integer.parseInt(s);
        }
        if (this.viewPanel != null) {
            this.viewPanel.removePropertyChangeListener(this);
        }
        v.addPropertyChangeListener(this);
        this.cellFiller = new SpreadsheetCellFiller(v);
        GridBagLayout gbl = new GridBagLayout();
        v.setLayout(gbl);
        this.theTable = new SplittedTable(this.tableModel, this.splitColumns);
        for (int i = 0; i < this.theTable.getPartCount(); ++i) {
            ResizableTable t = this.theTable.getPart(i);
            t.getTableHeader().addMouseListener(this);
            t.getTableHeader().setFont(this.viewPanel.getFieldFont(null));
            t.getActionMap().put("copy", v.getCommonActions().getCopyAction());
        }
        this.theTable.setRowSelectionAllowed(true);
        this.theTable.setColumnSelectionAllowed(true);
        this.theTable.addMouseListener(this);
        this.theTable.setAutoResizeMode(0);
        this.theTable.setAutoCreateColumnsFromModel(false);
        this.theTable.setColumnFlags(0, 1);
        s = v.getParameter("columnWidth");
        if (s != null) {
            int w = Integer.parseInt(s);
            this.theTable.setDefaultColumnWidth(w);
        }
        if ((s = v.getParameter("columnWidths")) != null) {
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                String[] arr = st.nextToken().split(":");
                int i = Integer.parseInt(arr[0]);
                int w = Integer.parseInt(arr[1]);
                this.theTable.setDefaultColumnWidth(i, w);
            }
        }
        this.theTable.setRowHeight(this.tableRowHeight);
        this.scrollPane = this.theTable.createLastScrollPane();
        this.scrollPane.addComponentListener(this);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.theTable.setJScrollPane(this.scrollPane);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbl.setConstraints(v.add(this.theTable.getJComponent()), gbc);
        this.progressBar = new JProgressBar();
        this.progressBar.setBorderPainted(false);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbl.setConstraints(v.add(this.progressBar), gbc);
        if (this.recordFetcher != null) {
            this.recordFetcher.setProgressBar(this.progressBar);
            this.recordFetcher.setErrorDisplay(this.viewPanel.getErrorDisplay());
        }
        int nm = this.getNumMoleculesInRecord();
        this.moleculeCellRenderer = new MoleculeCellRenderer(v, this.theTable);
        boolean im = false;
        for (int i = 0; i < this.cellTypes.length; ++i) {
            this.updateCellRendererInColumn(i);
        }
        if (this.docStorage.getSize() == 0) {
            this.setNumRecords(1);
        }
        this.viewPanel.initMolArrays(1, nm);
    }

    @Override
    protected void setMarvinCursor() {
    }

    @Override
    protected void initTransientC() {
    }

    @Override
    public boolean isIncrementable() {
        return true;
    }

    @Override
    public MDocStorage getStorage() {
        return this.docStorage;
    }

    @Override
    public CellFiller getCellFiller() {
        return this.cellFiller;
    }

    @Override
    public RecordFetcher getRecordFetcher() {
        return this.recordFetcher;
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount();
    }

    @Override
    public int getNumRecordsInARow() {
        return 1;
    }

    @Override
    protected void setNumRecords(int nrec) {
        int icell;
        int nm = this.getNumMoleculesInRecord();
        int nrecmin = Math.min(nrec, this.getNumRecords());
        int nmmin = nm * nrecmin;
        if (this.docStorage != null) {
            this.docStorage.setSize(nrec);
        } else {
            this.docStorage = new MDocStorage(nrec);
            RecordFetcher old = this.recordFetcher;
            this.recordFetcher = new RecordFetcher(this.docStorage, this.scrollBarUpdater, this.guiUpdater, old.getScheduler(), old.getEndRecordIndex());
            this.recordFetcher.getScheduler().setDebug(this.getDebug());
        }
        if (nrec == nrecmin) {
            for (int i = this.molFrames.size() - 1; i >= 0; --i) {
                ViewCanvas c = SpreadsheetView.getViewCanvas(this.molFrames.get(i));
                icell = c.getCellIndex();
                if (icell < nmmin) continue;
                this.setWinmode(0, icell);
            }
            for (Integer key : this.molFrameRectangles.keySet()) {
                icell = key;
                if (icell < nmmin) continue;
                this.molFrameRectangles.remove(key);
            }
        }
        for (int irec = nrecmin; irec < this.docStorage.getSize(); ++irec) {
            for (int im = 0; im < nm; ++im) {
                String ss;
                int setSeq;
                icell = irec * nm + im;
                String key = this.fieldKeyFromMolCellIndex(im);
                String s = this.viewPanel.getParameter("selection" + icell);
                if (s != null) {
                    this.docStorage.setSelectedAtoms(irec, key, s);
                }
                for (setSeq = 0; setSeq <= 63; ++setSeq) {
                    ss = String.valueOf(icell) + "." + setSeq;
                    s = this.viewPanel.getParameter("set" + ss + "|atomSet" + ss);
                    if (s == null) continue;
                    this.docStorage.setAtomSetSeq(irec, key, s, setSeq);
                }
                for (setSeq = 0; setSeq <= 63; ++setSeq) {
                    ss = String.valueOf(icell) + "." + setSeq;
                    s = this.viewPanel.getParameter("bondSet" + ss);
                    if (s == null) continue;
                    this.docStorage.setBondSetSeq(irec, key, s, setSeq);
                }
            }
        }
        this.tableModel.rowCount = nrec;
        this.getScheduler().invokeLater(this.scrollBarUpdater, Integer.MAX_VALUE, "scrollbar update");
    }

    @Override
    protected void storageSizeChanged(int oldsz, int newsz) {
        this.getScheduler().invokeLater(this.scrollBarUpdater, Integer.MAX_VALUE, "scrollbar update");
    }

    @Override
    protected void storageSizeFinalized(int sz) {
    }

    @Override
    public int getNumMoleculesInRecord() {
        return this.molComponentIndices.length;
    }

    @Override
    public String[] readTextFieldValues(int irec, String[] out) {
        MDocument doc = null;
        try {
            doc = this.docStorage.getMainDoc(irec, null);
        }
        catch (MDocStorage.RecordUnavailableException ex) {
            System.err.println("Record " + irec + " unavailable");
            return null;
        }
        catch (MDocStorage.CancellationException ex) {
            System.err.println("Record " + irec + " reading canceled");
            return null;
        }
        catch (IOException ex) {
            System.err.println("Record " + irec + " reading I/O error");
            return null;
        }
        Molecule mol = doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
        this.recordNumberOfCellValues = irec;
        this.docStorage.getFieldAccessor().getFields(irec, mol, this.cellOptions, this.cellMProps);
        int n = 0;
        for (int i = 0; i < this.cellTypes.length; ++i) {
            if (this.cellTypes[i] != CellType.TEXT) continue;
            ++n;
        }
        if (out == null || out.length != n) {
            out = new String[n];
        }
        int k = 0;
        for (int i = 0; i < this.cellTypes.length; ++i) {
            if (this.cellTypes[i] != CellType.TEXT) continue;
            String s = "";
            try {
                s = MPropHandler.convertToString(this.cellMProps[i], null);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            out[k++] = s;
        }
        return out;
    }

    @Override
    protected void setMainDocumentInRecord(int irec, MDocument doc) {
        this.docStorage.storeMainDoc(doc, irec);
        int nm = this.getNumMoleculesInRecord();
        for (int im = 0; im < nm; ++im) {
            int icell = irec * nm + im;
            String key = this.fieldKeyFromMolCellIndex(icell);
            int j = this.findViewFrame(icell);
            if (j < 0) continue;
            Window f = this.molFrames.get(j);
            try {
                MDocument d = this.docStorage.getDoc(irec, key);
                ((CallbackIface)((Object)f)).callback("setTitle", d);
                continue;
            }
            catch (MDocStorage.RecordUnavailableException ex) {
                System.err.println("setMainDocumentInRecord(" + irec + ", doc): cannot getDoc(" + irec + ", " + key + ")");
                return;
            }
            catch (IOException ex) {
                System.err.println("setMainDocumentInRecord(" + irec + ", doc): cannot getDoc(" + irec + ", " + key + ")");
            }
        }
    }

    @Override
    public int getTopLeft() {
        int ncols = this.getColumnCount();
        int row = this.theTable.getTopRow();
        int col = this.theTable.getLastTable().getLeftColumn() + this.theTable.getStartColumn(this.theTable.getPartCount() - 1);
        return row * ncols + col;
    }

    @Override
    public void setTopLeft(int icell) {
        if (this.theTable != null) {
            int ncols = this.getColumnCount();
            int row = icell / ncols;
            int col = icell - row * ncols;
            this.theTable.setTopRow(row);
            this.theTable.getLastTable().setLeftColumn(col - this.theTable.getStartColumn(this.theTable.getPartCount() - 1));
        }
    }

    @Override
    public void setScrollBarsValue(int h, int v) {
        JScrollBar hscr = this.scrollPane.getHorizontalScrollBar();
        JScrollBar vscr = this.scrollPane.getVerticalScrollBar();
        if (hscr != null) {
            hscr.setValue(h);
        }
        if (vscr != null) {
            vscr.setValue(v);
        }
    }

    @Override
    public int getScrollBarRowIncrement() {
        return this.theTable.getRowHeight();
    }

    @Override
    public int[] getScrollBarsMax() {
        int[] value = new int[]{-1, -1};
        JScrollBar hscr = this.scrollPane.getHorizontalScrollBar();
        JScrollBar vscr = this.scrollPane.getVerticalScrollBar();
        if (hscr != null) {
            value[0] = hscr.getMaximum();
        }
        if (vscr != null) {
            value[1] = vscr.getMaximum();
        }
        return value;
    }

    @Override
    public void setScrollBarsMax(int h, int v) {
        JScrollBar hscr = this.scrollPane.getHorizontalScrollBar();
        JScrollBar vscr = this.scrollPane.getVerticalScrollBar();
        if (hscr != null) {
            hscr.setMaximum(h);
        }
        if (vscr != null) {
            vscr.setMaximum(v);
        }
    }

    @Override
    protected void initMainDocumentInRecord(int irec, boolean init) {
    }

    @Override
    protected MDocument getCachedDocument(int irec, int im) {
        String key = this.fieldKeyFromMolCellIndex(im);
        MDocument doc = this.docStorage.getCachedDoc(irec, key);
        return doc;
    }

    @Override
    protected void setDocument(int irec, int im, MDocument doc) {
        if (im == 0) {
            this.docStorage.storeMainDoc(doc, irec);
        } else {
            String key = this.fieldKeyFromMolCellIndex(im);
            this.docStorage.storeDoc(doc, irec, key);
        }
    }

    @Override
    protected void setMolPainter(int irec, int im, MolPainter p) {
        String key = this.fieldKeyFromMolCellIndex(im);
        this.docStorage.setMolPainter(irec, key, p);
    }

    @Override
    public MolPainter getMolPainter(int icell) {
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        String key = this.fieldKeyFromMolCellIndex(icell);
        MolPainter p = this.docStorage.getMolPainter(irec, key);
        return p;
    }

    @Override
    public void setMolCenter(int icell, DPoint3 p) {
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        String key = this.fieldKeyFromMolCellIndex(icell);
        this.docStorage.setMolCenter(irec, key, p);
    }

    @Override
    public DPoint3 getMolCenter(int icell) {
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        String key = this.fieldKeyFromMolCellIndex(icell);
        return this.docStorage.getMolCenter(irec, key);
    }

    @Override
    public void setRecordIDBackground(int k, Color color) {
        this.docStorage.setIDBackgroundRGBA(k, color != null ? color.getRGB() : 0);
        this.tableModel.fireTableCellUpdated(k, 0);
    }

    @Override
    public void setRecordIDForeground(int k, Color color) {
        this.docStorage.setIDForegroundRGBA(k, color != null ? color.getRGB() : 0);
        this.tableModel.fireTableCellUpdated(k, 0);
    }

    @Override
    public Color rowBackground(int row) {
        int rgba = this.docStorage.getIDBackgroundRGBA(row);
        return rgba != 0 ? new Color(rgba, true) : null;
    }

    @Override
    public Color rowForeground(int row) {
        int rgba = this.docStorage.getIDForegroundRGBA(row);
        return rgba != 0 ? new Color(rgba, true) : null;
    }

    @Override
    protected void repaintMolComponent(int icell) {
        int nm = this.getNumMoleculesInRecord();
        int row = icell / nm;
        int col = this.molComponentIndices[icell - row * nm];
        this.tableModel.fireTableCellUpdated(row, col);
    }

    @Override
    protected void repaintMols() {
        int rows = this.theTable.getRowCount();
        for (int i = 0; i < this.molComponentIndices.length; ++i) {
            int col = this.molComponentIndices[i];
            TableModelEvent ev = new TableModelEvent(this.tableModel, 0, rows - 1, col);
            this.tableModel.fireTableChanged(ev);
        }
    }

    @Override
    protected void repaintText() {
        this.tableModel.fireTableDataChanged();
    }

    @Override
    protected void setVisibleSize(int vrows, int vcols) {
    }

    @Override
    protected void visibleCells(boolean set) {
        if (set) {
            int nm = this.getNumMoleculesInRecord();
            for (int i = 0; i < nm; ++i) {
                this.viewPanel.setVisibleCanvas(i, i);
            }
        }
    }

    @Override
    protected void molLoaded(MDocument maindoc, int irec) {
        int nm = this.getNumMoleculesInRecord();
        if (maindoc == null) {
            this.setMainDocumentInRecord(irec, null);
        } else {
            this.setMainDocumentInRecord(irec, maindoc);
            for (int im = 0; im < nm; ++im) {
                Molecule[] m;
                String key = this.fieldKeyFromMolCellIndex(im);
                int[] sel = this.docStorage.getSelectedAtoms(irec, key);
                MDocument doc = null;
                try {
                    doc = this.docStorage.getDoc(irec, key);
                }
                catch (MDocStorage.RecordUnavailableException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                Molecule[] moleculeArray = m = doc != null ? doc.getPrimaryMolecules() : null;
                if (m != null && sel != null) {
                    for (int j = 0; j < sel.length; ++j) {
                        int atom = sel[j];
                        for (int k = 0; k < m.length; ++k) {
                            if (atom < 0 || atom >= m[k].getAtomCount()) continue;
                            m[k].getAtom(atom).setSelected(true);
                        }
                    }
                }
                this.docStorage.setSelectedAtoms(irec, key, (int[])null);
                if (m == null) continue;
                this.doSetSetSeqs(m, irec, im);
            }
        }
    }

    @Override
    protected void setValueAt(Object val, int irec, String key) {
        if (key == null) {
            if (val == null || val instanceof MDocument) {
                MDocument doc = (MDocument)val;
                this.molLoaded(doc, irec);
                int col = -1;
                for (int i = 0; i < this.cellOptions.length; ++i) {
                    String k = this.cellOptions[i];
                    if (k != null || this.cellTypes[i] != CellType.MOLECULE) continue;
                    col = i;
                    break;
                }
                if (col >= 0) {
                    this.tableModel.setValueAt(val, irec, col);
                }
            }
        } else {
            int col = -1;
            for (int i = 0; i < this.cellOptions.length; ++i) {
                String k = this.cellOptions[i];
                if (k == null || !k.equals(key)) continue;
                col = i;
                break;
            }
            if (col >= 0) {
                this.tableModel.setValueAt(val, irec, col);
            }
        }
    }

    @Override
    public void setAtomSetSeq(int icell, int atom, int seq) {
        int nrec = this.getNumRecords();
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        int im = icell - irec * nm;
        String key = this.fieldKeyFromMolCellIndex(im);
        MDocument d = this.getCachedDocument(irec, im);
        if (d != null) {
            Molecule[] m = d.getPrimaryMolecules();
            for (int j = 0; j < m.length; ++j) {
                MolAtom a = m[j].getAtom(atom);
                a.setSetSeq(seq);
            }
            ViewCanvas canv = this.getCanvas(icell);
            if (canv != null) {
                canv.repaint();
            }
            return;
        }
        this.docStorage.setAtomSetSeq(irec, key, atom, seq);
    }

    @Override
    public void setBondSetSeq(int icell, int j1, int j2, int seq) {
        if (j2 < j1) {
            int t = j2;
            j2 = j1;
            j1 = t;
        }
        int nrec = this.getNumRecords();
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        int im = icell - irec * nm;
        String key = this.fieldKeyFromMolCellIndex(im);
        MDocument d = this.getCachedDocument(irec, im);
        if (d != null) {
            Molecule[] m = d.getPrimaryMolecules();
            for (int j = 0; j < m.length; ++j) {
                BondTable btab = m[j].getBondTable();
                MolBond b = m[j].getBond(btab.getBondIndex(j1, j2));
                b.setSetSeq(seq);
            }
            ViewCanvas canv = this.getCanvas(icell);
            if (canv != null) {
                canv.repaint();
            }
            return;
        }
        this.docStorage.setBondSetSeq(irec, key, j1, j2, seq);
    }

    @Override
    public void setBondSetSeqAll(int icell, int seq) {
        int nrec = this.getNumRecords();
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        int im = icell - irec * nm;
        String key = this.fieldKeyFromMolCellIndex(im);
        MDocument d = this.getCachedDocument(irec, im);
        if (d != null) {
            Molecule[] m = d.getAllNonEmptyMolecules();
            for (int j = 0; j < m.length; ++j) {
                for (int k = 0; k < m[j].getBondCount(); ++k) {
                    MolBond b = m[j].getBond(k);
                    b.setSetSeq(seq);
                }
            }
            ViewCanvas canv = this.getCanvas(icell);
            if (canv != null) {
                canv.repaint();
            }
            return;
        }
        this.docStorage.setBondSetSeqAll(irec, key, seq);
    }

    private void doSetSetSeqs(Molecule[] mols, int irec, int im) {
        String key = this.fieldKeyFromMolCellIndex(im);
        this.docStorage.doSetSetSeqs(mols, irec, key);
        MolPainter p = this.docStorage.getMolPainter(irec, key);
        Color bg = p != null ? p.getBackground() : this.viewPanel.getMolbg();
        for (int i = 0; i < mols.length; ++i) {
            this.viewPanel.painterCommon.fillUnsetSetPaletteInDoc(mols[i], bg);
        }
    }

    @Override
    protected void setWinScale(double sc) {
        this.defaultWinScale = sc;
    }

    @Override
    protected void setWinScale(int icell, double sc) {
        this.winScales.put(new Integer(icell), new Double(sc));
    }

    @Override
    protected void setDetachable(boolean b) {
        for (int i = 0; i < this.molComponentIndices.length; ++i) {
            int col = this.molComponentIndices[i];
            TableColumn tcol = this.theTable.getColumn(col);
            TableCellRenderer r = tcol.getCellRenderer();
            TableCellEditor e = tcol.getCellEditor();
            ((ViewCanvas)((Object)e)).getWindowAction().setEnabled(b);
        }
    }

    @Override
    protected void setWinmode(int mode, int icell) {
        int j = this.findViewFrame(icell);
        Window frame = j >= 0 ? this.molFrames.get(j) : null;
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        int im = icell - irec * nm;
        String key = this.fieldKeyFromMolCellIndex(im);
        MolPainter p = this.docStorage.getMolPainter(irec, key);
        if (mode == 1) {
            Object f;
            MDocument doc = this.getCachedDocument(irec, im);
            if (doc == null) {
                doc = new MDocument(new Molecule());
            }
            ViewCanvas canv = new ViewCanvas(this.viewPanel, doc, p, icell);
            canv.setCenter(this.docStorage.getMolCenter(irec, key));
            if (doc != null) {
                Double sc;
                if (frame == null) {
                    block18: {
                        f = null;
                        try {
                            Window parent = SwingUtilities.getWindowAncestor(this.viewPanel);
                            if (parent instanceof Dialog || parent instanceof Frame) {
                                Class parentClass = parent instanceof Dialog ? Dialog.class : Frame.class;
                                try {
                                    f = (CallbackIface)MarvinModule.load("view.swing.MViewFrame", new Class[]{parentClass}, new Object[]{parent}, this.viewPanel);
                                    break block18;
                                }
                                catch (ExceptionInInitializerError ex) {
                                    Throwable t = ex.getCause();
                                    if (t instanceof SecurityException) {
                                        throw (SecurityException)t;
                                    }
                                    throw ex;
                                }
                                catch (Throwable ex) {
                                    f = null;
                                    break block18;
                                }
                            }
                            f = (CallbackIface)MarvinModule.load("view.swing.MViewFrame", this.viewPanel);
                        }
                        catch (SecurityException sex) {
                            this.viewPanel.getErrorDisplay().firewallError(sex, null);
                        }
                    }
                    if (f != null) {
                        f.callback("setIndex", new Integer(icell));
                        f.callback("setViewPanel", this.viewPanel);
                        f.callback("init", null);
                        f.callback("setTitle", doc);
                    }
                    frame = (Window)f;
                    this.setFrame(icell, frame);
                }
                canv.setReqScale((sc = this.winScales.get(new Integer(icell))) != null ? sc : (this.defaultWinScale > 0.0 ? this.defaultWinScale : this.viewPanel.getWinScale()));
            }
            if (frame != null) {
                ViewCanvas origcanv;
                this.removeCellFromPanel(icell);
                f = this.viewPanel.getFont();
                ((Component)((RootPaneContainer)((Object)frame)).getContentPane()).setFont((Font)f);
                ((CallbackIface)((Object)frame)).callback("setViewCanvas", canv);
                frame.pack();
                Rectangle r = this.molFrameRectangles.get(new Integer(icell));
                if (r != null) {
                    frame.setLocation(r.x, r.y);
                    frame.setSize(new Dimension(r.width, r.height));
                }
                if ((origcanv = this.getCanvasInTable(icell)) != null) {
                    origcanv.setEnabled(false);
                }
                this.viewPanel.showWindow(frame);
                frame.requestFocus();
            }
        } else if (mode == 0 && frame != null) {
            Point loc = frame.getLocation();
            Dimension sz = frame.getSize();
            Rectangle r = new Rectangle(loc.x, loc.y, sz.width, sz.height);
            this.molFrameRectangles.put(new Integer(icell), r);
            ViewCanvas canv = SpreadsheetView.getViewCanvas(frame);
            this.addCanvasAgain(irec, im);
            canv.resetView();
            this.viewPanel.validate();
            if (frame != null) {
                this.viewPanel.unregWindow(frame);
                this.setFrame(icell, null);
            }
        }
        this.viewPanel.repaint();
    }

    @Override
    public void unsetWinmode(int i, MolPainter painter, double tabScale) {
        double x = tabScale > 0.0 ? tabScale : -1.0;
        painter.setScale(x);
    }

    @Override
    public Window getFrame(int icell) {
        int j = this.findViewFrame(icell);
        return j >= 0 ? this.molFrames.get(j) : null;
    }

    private void setFrame(int icell, Window f) {
        int j = this.findViewFrame(icell);
        if (j >= 0) {
            if (f != null) {
                this.molFrames.set(j, f);
            } else {
                this.molFrames.remove(j);
            }
        } else if (f != null) {
            this.molFrames.add(f);
        }
    }

    @Override
    protected void updateRecord(final int irec) {
        this.updateCellValuesArray(irec);
        if (EventQueue.isDispatchThread()) {
            this.updateRecord0(irec);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SpreadsheetView.this.updateRecord0(irec);
                }
            });
        }
    }

    private void updateRecord0(int irec) {
        if (this.tableModel.getRowCount() != this.numRecordsAtLastUpdateRecord && this.numRecordsAtLastUpdateRecord <= 1) {
            int nrec;
            this.numRecordsAtLastUpdateRecord = nrec = this.getNumRecords();
            this.tableModel.rowCount = nrec;
            this.tableModel.fireTableStructureChanged();
        } else {
            this.tableModel.fireTableRowsUpdated(irec, irec);
        }
        for (int i = 0; i < this.cellTypes.length; ++i) {
            this.updateCellRendererInColumn(i);
        }
    }

    private void updateCellRendererInColumn(int i) {
        if (this.isRightCellRendererInColumn(i)) {
            return;
        }
        TableColumn col = this.theTable.getColumn(i);
        TableCellRenderer oldtcr = col.getCellRenderer();
        TableCellEditor oldtce = col.getCellEditor();
        CellType t = this.cellTypes[i];
        if (t == CellType.MOLECULE) {
            this.destroyOldCellRendererAndEditor(col, oldtcr, oldtce);
            col.setCellRenderer(this.moleculeCellRenderer);
            MoleculeCellEditor mce = new MoleculeCellEditor(this.viewPanel, this.theTable);
            mce.getWindowAction().setEnabled(this.viewPanel.isDetachable());
            col.setCellEditor(mce);
        } else if (t == CellType.RECORD_NUMBER) {
            this.destroyOldCellRendererAndEditor(col, oldtcr, oldtce);
            TextCellRenderer cr = new TextCellRenderer(1, this, null);
            cr.setLineWrap(this.columnLineWrap[i]);
            col.setCellRenderer(cr);
        } else if (t == CellType.TEXT) {
            this.destroyOldCellRendererAndEditor(col, oldtcr, oldtce);
            String key = this.cellOptions[i];
            TextCellRenderer cr = new TextCellRenderer(0, null, new FindInfo(){

                @Override
                public String getWord() {
                    FindInfo f = (FindInfo)SpreadsheetView.this.viewPanel.getFindTextAsObject();
                    return f != null ? f.getWord() : null;
                }

                @Override
                public boolean getMatchCase() {
                    FindInfo f = (FindInfo)SpreadsheetView.this.viewPanel.getFindTextAsObject();
                    return f != null ? Boolean.valueOf(f.getMatchCase()) : null;
                }
            });
            if (MoleculeFieldAccessor.isSpecialKey(this.cellOptions[i])) {
                cr.setContentType("text/html");
            }
            cr.setLineWrap(this.columnLineWrap[i]);
            col.setCellRenderer(cr);
            TextCellEditor ce = new TextCellEditor(this.docStorage);
            ce.setLineWrap(this.columnLineWrap[i]);
            if (key != null) {
                Font f = this.viewPanel.getFieldFont(key);
                if (f == null) {
                    f = this.viewPanel.getFieldFont(null);
                }
                ce.setFont(f);
                cr.setFont(f);
            }
            int part = this.theTable.getPartIndex(i);
            final int start = this.theTable.getStartColumn(part);
            ce.setInfoProvider(new TextCellEditor.InfoProvider(){

                @Override
                public boolean isFieldEditableIn(int row, int col) {
                    CellType t = SpreadsheetView.this.cellTypes[col += start];
                    String key = SpreadsheetView.this.cellOptions[col];
                    MDocument maindoc = SpreadsheetView.this.docStorage.getCachedDoc(row, null);
                    if (maindoc == null) {
                        return false;
                    }
                    Molecule mainmol = (Molecule)maindoc.getMainMoleculeGraph();
                    MFieldAccessor fa = SpreadsheetView.this.docStorage.getFieldAccessor();
                    return key != null && t == CellType.TEXT && fa.isEditable(row, mainmol, key);
                }
            });
            col.setCellEditor(ce);
        }
    }

    private boolean isRightCellRendererInColumn(int i) {
        CellType t = this.cellTypes[i];
        TableColumn col = this.theTable.getColumn(i);
        TableCellRenderer oldtcr = col.getCellRenderer();
        TableCellEditor oldtce = col.getCellEditor();
        if (t == CellType.MOLECULE) {
            return oldtcr != null && oldtcr instanceof MoleculeCellRenderer && oldtce != null && oldtce instanceof MoleculeCellEditor;
        }
        if (t == CellType.RECORD_NUMBER) {
            return oldtcr != null && oldtcr instanceof TextCellRenderer && ((TextCellRenderer)oldtcr).getLineWrap() == this.columnLineWrap[i] && oldtce == null;
        }
        if (t == CellType.TEXT) {
            return oldtcr != null && oldtcr instanceof TextCellRenderer && ((TextCellRenderer)oldtcr).getLineWrap() == this.columnLineWrap[i] && oldtce != null && ((TextCellEditor)oldtce).getLineWrap() == this.columnLineWrap[i];
        }
        return false;
    }

    private void destroyOldCellRendererAndEditor(TableColumn col, TableCellRenderer oldtcr, TableCellEditor oldtce) {
        if (oldtcr != null && oldtcr instanceof ViewCanvas) {
            SpreadsheetView.destroyViewCanvas((ViewCanvas)((Object)oldtcr));
        }
        if (oldtce != null && oldtce instanceof ViewCanvas) {
            SpreadsheetView.destroyViewCanvas((ViewCanvas)((Object)oldtce));
        }
    }

    private void setLineWrapInColumn(int i, boolean v) {
        this.columnLineWrap[i] = v;
        TableColumn col = this.theTable.getColumn(i);
        TableCellRenderer tcr = col.getCellRenderer();
        TableCellEditor tce = col.getCellEditor();
        this.tableModel.fireTableStructureChanged();
        for (int j = 0; j < this.cellTypes.length; ++j) {
            this.updateCellRendererInColumn(j);
        }
    }

    private boolean updateCellValuesArray(int irec) {
        MDocument doc = this.docStorage.getCachedDoc(irec, null);
        if (doc == null) {
            for (int i = 0; i < this.cellTypes.length; ++i) {
                CellType t = this.cellTypes[i];
                this.cellValues[i] = t == CellType.RECORD_NUMBER ? this.docStorage.getDocLabel(irec, null) : null;
            }
            if (this.firstRowToUpdateLater < 0) {
                this.firstRowToUpdateLater = irec;
                this.lastRowToUpdateLater = irec;
            } else {
                if (irec < this.firstRowToUpdateLater) {
                    this.firstRowToUpdateLater = irec;
                }
                if (irec > this.lastRowToUpdateLater) {
                    this.lastRowToUpdateLater = irec;
                }
            }
            this.recordNumberOfCellValues = irec;
            return false;
        }
        this.recordFetcher.startPrereadIfNeeded();
        Molecule mol = doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
        this.recordNumberOfCellValues = irec;
        this.docStorage.getFieldAccessor().getFields(irec, mol, this.cellOptions, this.cellMProps);
        boolean cellTypeChanged = false;
        for (int i = 0; i < this.cellTypes.length; ++i) {
            String key = this.cellOptions[i];
            CellType t = this.cellTypes[i];
            MProp p = this.cellMProps[i];
            if (t == CellType.RECORD_NUMBER) {
                this.cellValues[i] = this.docStorage.getDocLabel(irec, doc);
                continue;
            }
            if (t == CellType.MOLECULE) {
                MDocument d = null;
                try {
                    d = irec < this.docStorage.getSize() ? this.docStorage.getDoc(irec, key) : null;
                }
                catch (MDocStorage.RecordUnavailableException ex) {
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                this.cellValues[i] = d != null ? d : new MDocument(new Molecule());
                continue;
            }
            if (p != null && p instanceof MMoleculeProp) {
                this.cellValues[i] = SpreadsheetView.getMDocumentFromMProp(p);
                this.cellTypes[i] = CellType.MOLECULE;
                cellTypeChanged = true;
                continue;
            }
            if (p == null) continue;
            try {
                this.cellValues[i] = MPropHandler.convertToString(p, null);
                continue;
            }
            catch (IllegalArgumentException ex) {
                this.cellValues[i] = "";
            }
        }
        if (cellTypeChanged) {
            this.updateMolComponentIndices();
            this.updateMolPaintersForCurrentRecord();
        }
        return true;
    }

    private void updateMolComponentIndices() {
        int n = this.cellTypes.length;
        int nc = 0;
        for (int col = 0; col < n; ++col) {
            if (this.cellTypes[col] != CellType.MOLECULE) continue;
            ++nc;
        }
        this.molComponentIndices = new int[nc];
        int ic = 0;
        for (int col = 0; col < n; ++col) {
            if (this.cellTypes[col] != CellType.MOLECULE) continue;
            this.molComponentIndices[ic++] = col;
        }
    }

    private void updateMolPaintersForCurrentRecord() {
        int irec = this.recordNumberOfCellValues;
        for (int im = 0; im < this.molComponentIndices.length; ++im) {
            int col = this.molComponentIndices[im];
            String key = this.fieldKeyFromMolCellIndex(im);
            MolPainter p = this.docStorage.getMolPainter(irec, key);
            MDocument d = SpreadsheetView.getMDocumentFromMProp(this.cellMProps[col]);
            if (p == null) {
                p = this.viewPanel.createMolPainter(d);
            }
            this.docStorage.setMolPainter(irec, key, p);
        }
    }

    private static MDocument getMDocumentFromMProp(MProp p) {
        if (p != null && p instanceof MMoleculeProp) {
            Molecule m = ((MMoleculeProp)p).getMolecule();
            MDocument d = m.getDocument();
            if (d == null) {
                d = new MDocument(m);
            }
            return d;
        }
        return null;
    }

    private int findCellL(String key) {
        for (int i = 0; i < this.cellTypes.length; ++i) {
            String k;
            if (this.cellTypes[i] != CellType.TEXT || (k = this.cellOptions[i]) == null || !k.equals(key)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setAnimated(int icell, boolean v) {
        this.moleculeCellRenderer.setAnimated(icell, v);
    }

    @Override
    public ViewCanvas getCanvas(int icell) {
        ViewCanvas canv = null;
        Window f = this.getFrame(icell);
        canv = f == null ? this.getCanvasInTable(icell) : SpreadsheetView.getViewCanvas(f);
        return canv;
    }

    private ViewCanvas getCanvasInTable(int icell) {
        MoleculeCellEditor mce;
        TableCellEditor tce;
        if (this.theTable.isEditing() && (tce = this.theTable.getCellEditor()) instanceof MoleculeCellEditor && (mce = (MoleculeCellEditor)tce).getCellIndex() == icell) {
            return mce;
        }
        return this.moleculeCellRenderer.getAnimatedCanvas(icell);
    }

    @Override
    public void updateVisibleCells(int x) {
    }

    @Override
    public int getVisibleRows() {
        int rowHeight = this.theTable.getRowHeight();
        int visHeight = this.scrollPane.getViewport().getSize().height;
        return visHeight / rowHeight;
    }

    @Override
    public int getVisibleCols() {
        return this.getNumMoleculesInRecord();
    }

    @Override
    protected void removeCellFromPanel(int icell) {
        ViewCanvas canv = this.getCanvasInTable(icell);
        if (canv != null) {
            canv.setEnabled(false);
        }
    }

    @Override
    protected void addCanvasAgain(int irec, int im) {
        int nm = this.getNumMoleculesInRecord();
        int icell = irec * nm + im;
        ViewCanvas canv = this.getCanvasInTable(icell);
        if (canv != null) {
            canv.setEnabled(true);
        }
    }

    @Override
    public boolean setSelectedCellIndex(int icell) {
        this.viewPanel.setAnimated(icell, this.viewPanel.getAnimLength(icell));
        return true;
    }

    @Override
    public void unselectMoleculeCell(int icell) {
        int nm = this.getNumMoleculesInRecord();
        int row = icell / nm;
        int col = icell - nm * row;
        TableModelEvent ev = new TableModelEvent(this.tableModel, row, row, col);
        this.tableModel.fireTableChanged(ev);
    }

    @Override
    public int molCellIndexFromCellIndex(int icell) {
        int irec = icell / this.cellTypes.length;
        int col = icell - irec * this.cellTypes.length;
        int im = -1;
        if (this.cellTypes[col] != CellType.MOLECULE) {
            return -1;
        }
        for (int i = 0; i <= col; ++i) {
            if (this.cellTypes[i] != CellType.MOLECULE) continue;
            ++im;
        }
        int nm = this.getNumMoleculesInRecord();
        return nm * irec + im;
    }

    @Override
    public int recordIndexFromCellIndex(int icell) {
        int ncols = this.getColumnCount();
        int irec = icell / ncols;
        return irec;
    }

    @Override
    public int recordIndexFromMolCellIndex(int icell) {
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        return irec;
    }

    @Override
    public String fieldKeyFromMolCellIndex(int icell) {
        int nm = this.getNumMoleculesInRecord();
        int irec = icell / nm;
        int im = icell - irec * nm;
        String key = im == 0 ? null : this.cellOptions[this.molComponentIndices[im]];
        return key;
    }

    @Override
    public int rowFromRecordIndex(int irec) {
        return irec;
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        if (ev.getSource() == this.scrollPane) {
            // empty if block
        }
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    @Override
    public void componentShown(ComponentEvent ev) {
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.handlePopupTrigger(ev, true);
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.handlePopupTrigger(ev, false);
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    protected void keyPressed(int key) {
        int selectedCellIndex = this.viewPanel.getSelectedCellIndex();
        if (selectedCellIndex >= 0 && this.viewPanel.isSelectable()) {
            int col = selectedCellIndex % this.cellTypes.length;
            int part = this.theTable.getPartIndex(col);
            this.theTable.getPart(part).requestFocus();
            this.theTable.cancelEditing();
        } else {
            JScrollBar vScrollBar;
            JScrollBar hScrollBar = this.scrollPane.getHorizontalScrollBar();
            if (hScrollBar != null) {
                int hscrOldV;
                int unit = this.theTable.getPreferredHorizontalScrollUnitIncrement();
                int hscrNewV = hscrOldV = hScrollBar.getValue();
                int hscrW = hScrollBar.getVisibleAmount();
                int hscrMax = hScrollBar.getMaximum() - hscrW;
                if (key == 39) {
                    hscrNewV = hscrOldV + unit;
                } else if (key == 37) {
                    hscrNewV = hscrOldV - unit;
                }
                if (hscrNewV > hscrMax) {
                    hscrNewV = hscrMax;
                }
                if (hscrNewV < 0) {
                    hscrNewV = 0;
                }
                if (hscrNewV != hscrOldV) {
                    hScrollBar.setValue(hscrNewV);
                }
            }
            if ((vScrollBar = this.scrollPane.getVerticalScrollBar()) != null) {
                int vscrOldV;
                int unit = vScrollBar.getUnitIncrement(1);
                int vscrNewV = vscrOldV = vScrollBar.getValue();
                int vscrH = vScrollBar.getVisibleAmount();
                int vscrMax = vScrollBar.getMaximum() - vscrH;
                if (key == 36) {
                    vscrNewV = 0;
                } else if (key == 35) {
                    if (vscrMax == vscrOldV) {
                        return;
                    }
                    vscrNewV = vscrMax;
                } else if (key == 40) {
                    vscrNewV = vscrOldV < vscrMax - unit ? vscrOldV + unit : vscrMax;
                } else if (key == 38) {
                    vscrNewV = vscrOldV > unit ? vscrOldV - unit : 0;
                } else if (key == 34) {
                    vscrNewV = vscrOldV < vscrMax - vscrH ? vscrOldV + vscrH : vscrMax;
                } else if (key == 33) {
                    int n = vscrNewV = vscrOldV > vscrH ? vscrOldV - vscrH : 0;
                }
                if (vscrNewV != vscrOldV) {
                    vScrollBar.setValue(vscrNewV);
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        block3: {
            String cmd;
            block4: {
                block2: {
                    cmd = ev.getActionCommand();
                    if (!cmd.equals("wrapLinesColumn")) break block2;
                    Object t = this.wrapLinesColumnAction.getCurrentTarget();
                    int col = (Integer)t;
                    this.setLineWrapInColumn(col, this.wrapLinesColumnAction.isSelected());
                    break block3;
                }
                if (!cmd.equals("wrapLinesAllOn")) break block4;
                for (int i = 0; i < this.cellTypes.length; ++i) {
                    this.setLineWrapInColumn(i, true);
                }
                break block3;
            }
            if (!cmd.equals("wrapLinesAllOff")) break block3;
            for (int i = 0; i < this.cellTypes.length; ++i) {
                this.setLineWrapInColumn(i, false);
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent ev) {
        int top = this.theTable.getTopRow();
        int bottom = this.theTable.getBottomRow();
        this.recordFetcher.enqueueFetching(this, top, bottom);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.handlePropertyChange(ev, this.viewPanel);
    }

    private void handlePopupTrigger(MouseEvent ev, boolean pressed) {
        if (ev.isPopupTrigger()) {
            for (int i = 0; i < this.theTable.getPartCount(); ++i) {
                this.handlePopupTrigger(ev, i, pressed);
            }
        }
    }

    private void handlePopupTrigger(MouseEvent ev, int part, boolean pressed) {
        Object src = ev.getSource();
        ResizableTable table = this.theTable.getPart(part);
        JTableHeader header = table.getTableHeader();
        Point p = ev.getPoint();
        if (src == table) {
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(col, col);
            table.editCellAt(row, col);
            if (!this.showPopup(ev, this.theTable.getStartColumn(part) + col)) {
                Rectangle r = table.getCellRect(row, col, false);
                TableCellEditor tce = table.getCellEditor(row, col);
                if (tce instanceof MoleculeCellEditor) {
                    MoleculeCellEditor mce = (MoleculeCellEditor)tce;
                    MouseEvent ev2 = new MouseEvent(mce, ev.getID(), ev.getWhen(), ev.getModifiers(), p.x - r.x, p.y - r.y, ev.getClickCount(), true);
                    if (pressed) {
                        mce.mousePressed(ev2);
                    } else {
                        mce.mouseReleased(ev2);
                    }
                }
            }
        } else if (src == header) {
            int col = this.theTable.getStartColumn(part) + header.columnAtPoint(p);
            this.showPopup(ev, col);
        }
    }

    private boolean showPopup(MouseEvent ev, int col) {
        int f = 44;
        JPopupMenu popup = new JPopupMenu();
        if (this.cellTypes[col] == CellType.TEXT) {
            JMenu menu = SwingUtil.createMenu(RESOURCES, "wrapLinesMenuLabel", false);
            popup.add(menu);
            this.wrapLinesColumnAction.setSelected(this.columnLineWrap[col]);
            this.wrapLinesColumnAction.addTo(menu, f, new Integer(col));
            menu.addSeparator();
            this.wrapLinesAllOnAction.addTo(menu, f, null);
            this.wrapLinesAllOffAction.addTo(menu, f, null);
        }
        if (popup.getComponentCount() != 0) {
            popup.show(ev.getComponent(), ev.getX(), ev.getY());
            this.currentPopup = popup;
            return true;
        }
        return false;
    }

    private void resizeRows() {
        int ncols = this.theTable.getColumnCount();
        if (ncols == 1) {
            this.theTable.setAutoResizeMode(4);
        } else {
            this.theTable.setAutoResizeMode(0);
            for (int col = 0; col < ncols; ++col) {
                TableColumn tc = this.theTable.getColumn(col);
                int w = this.theTable.getPreferredColumnWidth(col);
                tc.setPreferredWidth(w);
            }
        }
    }

    private int findViewFrame(int icell) {
        for (int i = 0; i < this.molFrames.size(); ++i) {
            ViewCanvas c = SpreadsheetView.getViewCanvas(this.molFrames.get(i));
            if (c.getCellIndex() != icell) continue;
            return i;
        }
        return -1;
    }

    private static ViewCanvas getViewCanvas(Window f) {
        RootPaneContainer rpc = (RootPaneContainer)((Object)f);
        Container pane = rpc.getContentPane();
        return (ViewCanvas)pane.getComponent(0);
    }

    private void initActions() {
        this.wrapLinesAllOnAction = new MAction("wrapLinesAllOn", RESOURCES.getString("wrapLinesAllOnLabel"));
        this.wrapLinesAllOnAction.addActionListener(this);
        this.wrapLinesAllOffAction = new MAction("wrapLinesAllOff", RESOURCES.getString("wrapLinesAllOffLabel"));
        this.wrapLinesAllOffAction.addActionListener(this);
        this.wrapLinesColumnAction = new ToggleButtonAction("wrapLinesColumn", RESOURCES.getString("wrapLinesColumnLabel"));
        this.wrapLinesColumnAction.addActionListener(this);
    }

    @Override
    public String getMultiPageSupportedPrintProviderClassName() {
        return "chemaxon.marvin.modules.print.SpreadsheetMPageTable";
    }

    @Override
    public boolean hasVerticalScrollbar() {
        return this.scrollPane.getVerticalScrollBar() != null && this.scrollPane.getVerticalScrollBar().isVisible();
    }

    private class MTableModel
    extends AbstractTableModel {
        int rowCount;

        MTableModel() {
            this.rowCount = SpreadsheetView.this.getNumRecords();
        }

        @Override
        public String getColumnName(int i) {
            String name = SpreadsheetView.this.cellOptions[i];
            if (name != null) {
                return name;
            }
            CellType t = SpreadsheetView.this.cellTypes[i];
            if (t == CellType.MOLECULE) {
                return "structure";
            }
            if (t == CellType.RECORD_NUMBER) {
                return "#";
            }
            return "*";
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public int getColumnCount() {
            return SpreadsheetView.this.cellTypes.length;
        }

        public Class getColumnClass(int i) {
            CellType c = SpreadsheetView.this.cellTypes[i];
            if (c == CellType.MOLECULE) {
                return Molecule[].class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row != SpreadsheetView.this.recordNumberOfCellValues) {
                Rectangle cell;
                Rectangle view;
                if (SpreadsheetView.this.scrollPane != null && !(view = SpreadsheetView.this.scrollPane.getViewport().getViewRect()).intersects(cell = SpreadsheetView.this.theTable.getCellRect(row, col, false))) {
                    return null;
                }
                SpreadsheetView.this.updateCellValuesArray(row);
            }
            return SpreadsheetView.this.cellValues[col];
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            MDocument maindoc;
            TableCellEditor tce = SpreadsheetView.this.theTable.getCellEditor();
            if (tce != null) {
                int edrow = SpreadsheetView.this.theTable.getEditingRow();
                int edcol = SpreadsheetView.this.theTable.getEditingColumn();
                if (row == edrow && col == edcol) {
                    tce.cancelCellEditing();
                }
            }
            super.setValueAt(val, row, col);
            if (row == SpreadsheetView.this.recordNumberOfCellValues) {
                ((SpreadsheetView)SpreadsheetView.this).cellValues[col] = val;
            }
            if ((maindoc = SpreadsheetView.this.docStorage.getCachedDoc(row, null)) == null) {
                return;
            }
            Molecule mainmol = (Molecule)maindoc.getMainMoleculeGraph();
            String key = SpreadsheetView.this.cellOptions[col];
            CellType t = SpreadsheetView.this.cellTypes[col];
            MFieldAccessor fa = SpreadsheetView.this.docStorage.getFieldAccessor();
            if (t != CellType.RECORD_NUMBER) {
                if (t == CellType.MOLECULE) {
                    int nm = SpreadsheetView.this.getNumMoleculesInRecord();
                    int im = 0;
                    for (int i = 0; i < col; ++i) {
                        if (SpreadsheetView.this.cellTypes[i] != CellType.MOLECULE) continue;
                        ++im;
                    }
                    MDocument doc = null;
                    if (val != null) {
                        if (val instanceof MDocument) {
                            doc = (MDocument)val;
                        } else {
                            throw new IllegalArgumentException("cannot assign " + val + " to molecule cell");
                        }
                    }
                    if (im == 0) {
                        SpreadsheetView.this.setMainDocumentInRecord(row, doc);
                    } else if (key != null && fa.isEditable(row, mainmol, key)) {
                        SpreadsheetView.this.docStorage.storeDoc(doc, row, key);
                    }
                } else if (t == CellType.TEXT) {
                    MProp p = MPropFactory.getMProp(val);
                    if (fa.isEditable(row, mainmol, key)) {
                        fa.setField(row, mainmol, key, p);
                    }
                }
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            CellType t = SpreadsheetView.this.cellTypes[col];
            return t == CellType.MOLECULE || t == CellType.TEXT;
        }

        @Override
        public void fireTableChanged(TableModelEvent ev) {
            SpreadsheetView.this.theTable.fireTableChanged(ev);
        }
    }
}

