/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.view.swing.modules;

import chemaxon.marvin.view.MDocStorage;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class TextCellEditor
extends JTextArea
implements TableCellEditor {
    private EventListenerList listenerList = new EventListenerList();
    private ChangeEvent changeEvent = new ChangeEvent(this);
    private InfoProvider infoProvider;
    private MDocStorage docStorage;
    private String origText;
    private int theRow;

    public TextCellEditor(MDocStorage ds) {
        this.docStorage = ds;
        this.origText = null;
        this.theRow = -1;
        this.setEditable(true);
    }

    public void setInfoProvider(InfoProvider p) {
        this.infoProvider = p;
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != CellEditorListener.class) continue;
            CellEditorListener listener = (CellEditorListener)listeners[i + 1];
            listener.editingCanceled(this.changeEvent);
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        if (!this.origText.equals(this.getText())) {
            this.docStorage.setFixed(this.theRow);
        }
        this.fireEditingStopped();
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() >= 2;
        }
        return false;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        String s;
        String string = s = value != null ? value.toString() : "";
        if (this.infoProvider != null) {
            col = table.getColumnModel().getColumn(col).getModelIndex();
            this.setEditable(this.infoProvider.isFieldEditableIn(row, col));
        }
        JScrollPane c = new JScrollPane(this);
        this.setText(s);
        this.origText = s;
        this.theRow = row;
        return c;
    }

    public static interface InfoProvider {
        public boolean isFieldEditableIn(int var1, int var2);
    }
}

