/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.math.discrete;

import java.util.NoSuchElementException;

public class CombinationIterator {
    private int the_n;
    private int[] nextCombination;

    public CombinationIterator(int n, int k) {
        this.the_n = n;
        if (n < k) {
            throw new IllegalArgumentException("Cannot create combination iterator, the total number of objects (" + n + ") is smaller than the objects to choose (" + k + ")");
        }
        if (k < 0) {
            throw new IllegalArgumentException("Cannot create combination iterator for negative number of objects (k=" + k + ")");
        }
        if (k > 0) {
            this.nextCombination = new int[k];
            for (int i = 0; i < k; ++i) {
                this.nextCombination[i] = i;
            }
        } else if (k == 0) {
            this.nextCombination = null;
        } else {
            throw new IllegalArgumentException("Cannot create combination iterator for negative number of objects (k=" + k + ")");
        }
    }

    public boolean hasNext() {
        return this.nextCombination != null;
    }

    public int[] next() {
        if (this.nextCombination != null) {
            int k = this.nextCombination.length;
            int[] ret = new int[k];
            System.arraycopy(this.nextCombination, 0, ret, 0, k);
            if (!CombinationIterator.next(this.nextCombination, this.the_n)) {
                this.nextCombination = null;
            }
            return ret;
        }
        throw new NoSuchElementException("No more combinations.");
    }

    private static boolean next(int[] arr, int n) {
        int k = arr.length;
        for (int i = k - 1; i >= 0; --i) {
            if (arr[i] >= n - (k - i)) continue;
            int n2 = i;
            arr[n2] = arr[n2] + 1;
            for (int j = i + 1; j < k; ++j) {
                arr[j] = arr[i] + j - i;
            }
            return true;
        }
        return false;
    }
}

