/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.modelling.util.ProgressMonitor;
import chemaxon.metabolizer.LibraryTester;
import chemaxon.metabolizer.MetabolizerCalculator;
import chemaxon.metabolizer.MetabolizerException;
import chemaxon.metabolizer.MetabolizerExporter;
import chemaxon.metabolizer.MetabolizerIOException;
import chemaxon.metabolizer.MetabolizerImporter;
import chemaxon.metabolizer.MetabolizerTemporaryFileStorage;
import chemaxon.metabolizer.MetabolizerTemporaryMemoryStorage;
import chemaxon.metabolizer.MetabolizerTemporaryStorage;
import chemaxon.metabolizer.MetabolizerUtilities;
import chemaxon.metabolizer.SynthesisIdSequencer;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.reaction.ReactionException;
import chemaxon.reaction.Reactor;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Metabolizer
implements Licensable {
    private static final String LICENSE_ENVIRONMENT_FOR_INTERNAL_REACTOR_USE = "MetabolizerLicenseEnvironmentForInternalUsages";
    private int levelCount;
    private Reactor[] reactors;
    private RxnMolecule[] reactions;
    private String termCondition = "";
    private int levelIterator;
    private int substrateIterator;
    private MetabolizerTemporaryStorage temporaryStorage;
    private MetabolizerExporter metabolitExporter;
    private MetabolizerImporter substrateImporter;
    private boolean runInMemory;
    private ChemJEP chemJEP;
    private MolContext molContext;
    private boolean generatingSubstrates = true;
    private Molecule substrate;
    private Molecule substrateReaction;
    private ProgressMonitor progressMonitor;
    private boolean isProgressMonitorSetForCalculation = false;
    private static final int PROGRESS_LENGTH = 100;
    private int progressLevelLength;
    private boolean calculateDominance = true;
    private float metabolicPathwayTolerance = 0.0f;
    private final Set<String> excludedMetaboliteSmiles = new LinkedHashSet<String>();
    private final Set<String> neededMetaboliteSmiles = new LinkedHashSet<String>();
    private boolean isExcludeNeeded = false;
    private boolean isValidating = false;
    private int reactionCount = 0;
    private String licenseEnviroment = "";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String COLUMN_SEPARATOR = "\t\t\t\t";
    private static final String HELP_TEXT = "Metabolizer" + LINE_SEPARATOR + "Usage:" + LINE_SEPARATOR + "metabolize [<substratefile>/<smiles>] -r <reactionlibrary> " + LINE_SEPARATOR + "[-x <terminationCondition>]" + LINE_SEPARATOR + "[-m <tolerance>] [-M <true/false runInMemory>] [-o <outputFile>] " + LINE_SEPARATOR + "[-t <reaction/product>] [-f <smiles/sdf/rdf/mrv>] [-n <levelcount>] [-g] " + LINE_SEPARATOR + "[-G <tolerance>] [-l <logfile>]" + LINE_SEPARATOR + LINE_SEPARATOR + "General Options:" + LINE_SEPARATOR + "-h, --help" + "\t\t\t" + "this help message" + LINE_SEPARATOR + "-r" + "\t\t\t\t" + "reaction library file" + LINE_SEPARATOR + "-x" + "\t\t\t\t" + "chemical terms expression (termination condition)" + LINE_SEPARATOR + "-X" + "\t\t\t\t" + "only generate metabolites/reaction (no tree dependent " + LINE_SEPARATOR + "\t\t\t\t" + "data generated). for large input files" + LINE_SEPARATOR + "-m" + "\t\t\t\t" + "major metabolite tolerance" + LINE_SEPARATOR + "-M" + "\t\t\t\t" + "run in memory true or false. default is true (in case " + LINE_SEPARATOR + "\t\t\t\t" + "of false temporary files will be used)" + LINE_SEPARATOR + "-o" + "\t\t\t\t" + "output file path (if not set, standard " + LINE_SEPARATOR + "\t\t\t\t" + "output will be used)" + LINE_SEPARATOR + "-t" + "\t\t\t\t" + "output type. reaction or product" + LINE_SEPARATOR + "-f" + "\t\t\t\t" + "output format (default is smiles)" + LINE_SEPARATOR + "-n" + "\t\t\t\t" + "levelcount, default is 1" + LINE_SEPARATOR + "-g" + "\t\t\t\t" + "don't generate substrates" + LINE_SEPARATOR + "-G" + "\t\t\t\t" + "metabolic pathway generation with the given tolerance" + LINE_SEPARATOR + "-l" + "\t\t\t\t" + "log file path" + LINE_SEPARATOR + LINE_SEPARATOR + "Examples: " + LINE_SEPARATOR + "metabolize Cc1ccccc1 -r reactionLibrary.mrv -n 3" + LINE_SEPARATOR + "metabolize Cc1ccccc1 -r reactionLibrary.mrv -n 3 " + LINE_SEPARATOR + "\t\t" + "-x \"(logD(7.4) < 1.5) || (atomCount < 6)\"" + LINE_SEPARATOR + "metabolize Cc1ccccc1 -r reactionLibrary.mrv -n 3 -m 0.1" + LINE_SEPARATOR + "metabolize Cc1ccccc1 -r reactionLibrary.mrv -n 3 -G 0.1" + LINE_SEPARATOR;

    public Metabolizer(int levelCount, RxnMolecule[] reactions, String termCondition, MetabolizerTemporaryStorage temporaryStorage, boolean generatingSubstrates) throws MetabolizerException {
        this.levelCount = levelCount;
        this.termCondition = termCondition;
        this.temporaryStorage = temporaryStorage;
        this.generatingSubstrates = generatingSubstrates;
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, String termCondition, MetabolizerTemporaryStorage temporaryStorage, boolean generatingSubstrates, ProgressMonitor progressMonitor) throws MetabolizerException {
        this.levelCount = levelCount;
        this.termCondition = termCondition;
        this.temporaryStorage = temporaryStorage;
        this.generatingSubstrates = generatingSubstrates;
        this.progressMonitor = progressMonitor;
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, boolean runInMemory, boolean generatingSubstrates) throws MetabolizerException {
        this.levelCount = levelCount;
        this.generatingSubstrates = generatingSubstrates;
        this.setRunInMemory(runInMemory);
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, boolean runInMemory, boolean generatingSubstrates, ProgressMonitor progressMonitor) throws MetabolizerException {
        this.levelCount = levelCount;
        this.generatingSubstrates = generatingSubstrates;
        this.progressMonitor = progressMonitor;
        this.setRunInMemory(runInMemory);
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, String termCondition, MetabolizerTemporaryStorage temporaryStorage) throws MetabolizerException {
        this.levelCount = levelCount;
        this.termCondition = termCondition;
        this.temporaryStorage = temporaryStorage;
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, String termCondition, MetabolizerTemporaryStorage temporaryStorage, ProgressMonitor progressMonitor) throws MetabolizerException {
        this.levelCount = levelCount;
        this.termCondition = termCondition;
        this.temporaryStorage = temporaryStorage;
        this.progressMonitor = progressMonitor;
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, MetabolizerTemporaryStorage temporaryStorage) throws MetabolizerException {
        this.levelCount = levelCount;
        this.temporaryStorage = temporaryStorage;
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, MetabolizerTemporaryStorage temporaryStorage, ProgressMonitor progressMonitor) throws MetabolizerException {
        this.levelCount = levelCount;
        this.temporaryStorage = temporaryStorage;
        this.progressMonitor = progressMonitor;
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, String termCondition, boolean runInMemory) throws MetabolizerException {
        this.levelCount = levelCount;
        this.termCondition = termCondition;
        this.setRunInMemory(runInMemory);
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, String termCondition, boolean runInMemory, ProgressMonitor progressMonitor) throws MetabolizerException {
        this.levelCount = levelCount;
        this.termCondition = termCondition;
        this.progressMonitor = progressMonitor;
        this.setReactions(reactions);
        this.setRunInMemory(runInMemory);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, boolean runInMemory) throws MetabolizerException {
        this.levelCount = levelCount;
        this.setRunInMemory(runInMemory);
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, RxnMolecule[] reactions, boolean runInMemory, ProgressMonitor progressMonitor) throws MetabolizerException {
        this.levelCount = levelCount;
        this.progressMonitor = progressMonitor;
        this.setRunInMemory(runInMemory);
        this.setReactions(reactions);
        this.initialize();
    }

    public Metabolizer(int levelCount, boolean runInMemory) {
        this.levelCount = levelCount;
        this.setRunInMemory(runInMemory);
    }

    public Metabolizer(int levelCount, boolean runInMemory, ProgressMonitor progressMonitor) {
        this.levelCount = levelCount;
        this.progressMonitor = progressMonitor;
        this.setRunInMemory(runInMemory);
    }

    public Metabolizer(boolean runInMemory, ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.setRunInMemory(runInMemory);
    }

    public Metabolizer(boolean runInMemory) {
        this.setRunInMemory(runInMemory);
    }

    private void initialize() throws MetabolizerException {
        if (this.temporaryStorage != null) {
            this.initializeTemporaryStorage();
        }
        if (this.termCondition != null && !this.termCondition.equalsIgnoreCase("")) {
            try {
                Evaluator evaluator = new Evaluator();
                evaluator.setLicenseEnvironment(LICENSE_ENVIRONMENT_FOR_INTERNAL_REACTOR_USE);
                this.chemJEP = evaluator.compile(this.termCondition, MolContext.class);
            }
            catch (ParseException exception) {
                throw new MetabolizerException(exception);
            }
            this.molContext = new MolContext();
        }
    }

    private void initializeTemporaryStorage() throws MetabolizerException {
        try {
            this.substrateImporter = this.temporaryStorage.getImporter();
            this.metabolitExporter = this.temporaryStorage.getExporter();
        }
        catch (MetabolizerIOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.isProgressMonitorSetForCalculation = false;
        this.progressMonitor = progressMonitor;
    }

    public boolean hasMoreLevel() {
        return this.levelIterator != this.levelCount + 1;
    }

    public boolean isCurrentLevelEnded() {
        boolean currentLevelEnded;
        if (this.isValidating && (this.neededMetaboliteSmiles.isEmpty() || this.reactionCount > 10000)) {
            return true;
        }
        try {
            currentLevelEnded = !this.substrateImporter.hasNext();
        }
        catch (MetabolizerIOException exception) {
            currentLevelEnded = true;
        }
        return currentLevelEnded;
    }

    public Molecule[] next() throws MetabolizerException {
        this.verifyTemporaryStorage();
        return this.calculate();
    }

    private void verifyTemporaryStorage() throws MetabolizerException {
        if (this.substrateImporter == null || this.metabolitExporter == null || this.temporaryStorage == null) {
            throw new MetabolizerException("No MetabolizerTemporaryStorage has been set, or storage is incorrect");
        }
    }

    private Molecule[] calculate() throws MetabolizerException {
        try {
            this.checkLicense();
        }
        catch (LicenseException exception) {
            throw new MetabolizerException(exception);
        }
        if (this.progressMonitor != null && !this.isProgressMonitorSetForCalculation) {
            this.isProgressMonitorSetForCalculation = true;
            this.progressMonitor.init(100);
            this.progressLevelLength = (int)(100.0f / (this.generatingSubstrates ? (float)(this.levelCount + 1) : (float)this.levelCount));
        }
        Molecule[] results = null;
        ArrayList<Molecule> resultList = new ArrayList<Molecule>();
        try {
            if (this.levelIterator == 0 && !this.generatingSubstrates) {
                this.skipLevel();
            }
            while (results == null && !this.isCurrentLevelEnded()) {
                this.substrateReaction = this.readSubstrate();
                if (this.isValidating) {
                    if (this.substrateReaction instanceof RxnMolecule) {
                        int i;
                        for (i = 0; i < ((RxnMolecule)this.substrateReaction).getProductCount(); ++i) {
                            this.neededMetaboliteSmiles.remove(((RxnMolecule)this.substrateReaction).getProduct(i).toFormat("smiles:u"));
                        }
                        for (i = 0; i < ((RxnMolecule)this.substrateReaction).getReactantCount(); ++i) {
                            this.neededMetaboliteSmiles.remove(((RxnMolecule)this.substrateReaction).getReactant(i).toFormat("smiles:u"));
                        }
                    } else {
                        this.neededMetaboliteSmiles.remove(this.substrateReaction.toFormat("smiles:u"));
                    }
                }
                if (this.levelIterator == this.levelCount) {
                    results = new Molecule[]{this.substrateReaction};
                } else {
                    this.calculateMetabolites(resultList);
                    results = new Molecule[]{this.substrateReaction};
                }
                if (this.progressMonitor == null) continue;
                this.setProgressValue();
            }
            if (!this.hasMoreLevel() && this.isCurrentLevelEnded() && this.progressMonitor != null) {
                this.progressMonitor.close();
            }
        }
        catch (MetabolizerIOException exception) {
            results = null;
            throw new MetabolizerException(exception);
        }
        return results;
    }

    private Molecule readSubstrate() throws MetabolizerIOException {
        this.substrateReaction = this.substrateImporter.next();
        if (this.substrateReaction instanceof RxnMolecule) {
            this.substrate = ((RxnMolecule)this.substrateReaction).getProduct(0);
            String[] keys = this.substrateReaction.properties().getKeys();
            for (int i = 0; i < keys.length; ++i) {
                this.substrate.setProperty(keys[i], this.substrateReaction.getProperty(keys[i]));
            }
        } else {
            this.substrate = this.substrateReaction;
        }
        this.substrate.getSSSR();
        ++this.substrateIterator;
        return this.substrateReaction;
    }

    private void skipLevel() throws MetabolizerException, MetabolizerIOException {
        ArrayList<Molecule> resultList = new ArrayList<Molecule>();
        while (this.substrateImporter.hasNext()) {
            this.readSubstrate();
            this.calculateMetabolites(resultList);
        }
        this.nextLevel();
    }

    private void calculateMetabolites(List<Molecule> resultList) throws MetabolizerException, MetabolizerIOException {
        boolean excluded = false;
        if (this.metabolicPathwayTolerance == 0.0f || this.substrate.getProperty("IGNORED") == null) {
            String parents = this.substrate.getProperty("PARENTS");
            String substrateSmiles = this.substrate.toFormat("smiles:u");
            List<Object> parentList = parents == null ? new ArrayList() : Arrays.asList(parents.split("\\|"));
            for (int reactorIterator = 0; reactorIterator < this.reactors.length; ++reactorIterator) {
                try {
                    Molecule[] products;
                    this.reactors[reactorIterator].setReactant(this.substrate);
                    int izomerCount = 1;
                    while ((products = this.reactors[reactorIterator].react()) != null) {
                        ++this.reactionCount;
                        boolean newIzomer = false;
                        for (int i = 0; i < products.length; ++i) {
                            if (this.molContext != null) {
                                this.molContext.setMolecule(products[i]);
                                try {
                                    excluded = this.chemJEP.evaluate_boolean(this.molContext);
                                }
                                catch (ParseException exception) {
                                    throw new MetabolizerException(exception);
                                }
                            }
                            products[i].implicitizeHydrogens(2047);
                            String productSmiles = products[i].toFormat("smiles:u");
                            if (this.isExcludeNeeded) {
                                boolean bl = excluded = excluded || this.excludedMetaboliteSmiles.contains(productSmiles);
                            }
                            if (excluded || parentList.contains(productSmiles)) continue;
                            newIzomer = true;
                            RxnMolecule reaction = new RxnMolecule();
                            reaction.addComponent(this.substrate, 0);
                            reaction.addComponent(products[i], 1);
                            String parentCode = this.substrate.getProperty("Synthesis Code");
                            String reactionCode = this.reactions[reactorIterator].getProperty("Synthesis Code");
                            if (reactionCode != null && !reactionCode.equalsIgnoreCase("")) {
                                reaction.setProperty("Synthesis Code", reactionCode + "(" + parentCode + ")" + ":" + izomerCount + "/" + (i + 1));
                            } else {
                                reaction.setProperty("Synthesis Code", "rxn" + (reactorIterator + 1) + "(" + parentCode + ")" + ":" + izomerCount + "/" + (i + 1));
                            }
                            reaction.setProperty("METABOLIZER_PARENTSYNTHESISCODE", parentCode);
                            reaction.setProperty("METABOLIZER_SYNTHESISLEVEL", this.substrate.getProperty("METABOLIZER_SYNTHESISLEVEL") == null ? String.valueOf(this.levelIterator) : String.valueOf(Integer.valueOf(this.substrate.getProperty("METABOLIZER_SYNTHESISLEVEL")) + 1));
                            reaction.setProperty("SPEED_CATEGORY", this.reactions[reactorIterator].getProperty("SPEED_CATEGORY") == null ? "0" : this.reactions[reactorIterator].getProperty("SPEED_CATEGORY"));
                            reaction.setProperty("METABOLIC_TREE_COUNT", this.substrate.getProperty("METABOLIC_TREE_COUNT"));
                            String reactionParents = parents == null ? substrateSmiles + "|" : parents.concat(substrateSmiles + "|");
                            reaction.setProperty("PARENTS", reactionParents);
                            reaction.clean(2, null);
                            resultList.add(reaction);
                        }
                        if (!newIzomer) continue;
                        ++izomerCount;
                    }
                    continue;
                }
                catch (ReactionException exception) {
                    throw new MetabolizerException("Error while executing reaction #" + reactorIterator + (this.reactions[reactorIterator].getProperty("NAME") == null ? "" : " name: " + this.reactions[reactorIterator].getProperty("NAME")), exception);
                }
                catch (LicenseException licenseException) {
                    throw new MetabolizerException("Error while executing reaction #" + reactorIterator + (this.reactions[reactorIterator].getProperty("NAME") == null ? "" : " name: " + this.reactions[reactorIterator].getProperty("NAME")), licenseException);
                }
            }
            if (!this.isValidating && resultList.size() > 0 && this.calculateDominance) {
                MetabolizerCalculator.getInstance().calculateDominance(this.substrateReaction, resultList.toArray(new Molecule[resultList.size()]));
                if (this.metabolicPathwayTolerance > 0.0f) {
                    float maxProduction = 0.0f;
                    for (Molecule molecule : resultList) {
                        String prod = molecule.getProperty("PRODUCTION");
                        float f = prod == null ? 0.0f : Float.parseFloat(prod);
                        float currentProduction = f;
                        if (!(maxProduction < currentProduction)) continue;
                        maxProduction = currentProduction;
                    }
                    float tolerance = maxProduction * this.metabolicPathwayTolerance;
                    for (Molecule molecule : resultList) {
                        String prod = molecule.getProperty("PRODUCTION");
                        float f = prod == null ? 0.0f : Float.parseFloat(prod);
                        float currentProduction = f;
                        if (!(maxProduction - currentProduction > tolerance)) continue;
                        molecule.setProperty("IGNORED", "TRUE");
                    }
                    MetabolizerCalculator.getInstance().calculateDominance(this.substrateReaction, resultList.toArray(new Molecule[resultList.size()]));
                }
            }
            Iterator<Molecule> iterator = resultList.iterator();
            while (iterator.hasNext()) {
                this.metabolitExporter.export(iterator.next());
            }
        }
    }

    private void setProgressValue() throws MetabolizerException {
        try {
            this.progressMonitor.set(this.progressLevelLength * (this.generatingSubstrates ? this.levelIterator : this.levelIterator - 1) + (int)((float)this.substrateIterator * (float)this.reactions.length / ((float)this.substrateImporter.getMoleculeCount() * (float)this.reactions.length) * (float)this.progressLevelLength));
        }
        catch (MetabolizerIOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void nextLevel() throws MetabolizerException {
        this.reset();
        ++this.levelIterator;
    }

    private void reset() throws MetabolizerException {
        this.verifyTemporaryStorage();
        try {
            this.substrateImporter.close();
            this.metabolitExporter.close();
            this.temporaryStorage.newIteration();
            this.substrateImporter = this.temporaryStorage.getImporter();
            this.metabolitExporter = this.temporaryStorage.getExporter();
            this.substrate = null;
            this.substrateIterator = 0;
        }
        catch (MetabolizerIOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public void setReactions(RxnMolecule[] reactions) throws MetabolizerException {
        LibraryTester libraryTester;
        int status;
        if (this.progressMonitor != null) {
            this.isProgressMonitorSetForCalculation = false;
            this.progressMonitor.init(reactions.length);
        }
        this.reactors = new Reactor[reactions.length];
        this.reactions = new RxnMolecule[reactions.length];
        for (int i = 0; i < reactions.length; ++i) {
            this.reactions[i] = (RxnMolecule)reactions[i].cloneMolecule();
            this.reactions[i].getSSSR();
            this.reactors[i] = new Reactor();
            this.reactors[i].setLicenseEnvironment(LICENSE_ENVIRONMENT_FOR_INTERNAL_REACTOR_USE);
            try {
                this.reactors[i].setReaction(this.reactions[i]);
            }
            catch (ReactionException reactionException) {
                this.reactors = null;
                throw new MetabolizerException("Error while initilaize reaction #" + i + (reactions[i].getProperty("NAME") == null ? "" : " name: " + reactions[i].getProperty("NAME")), reactionException);
            }
            if (this.progressMonitor == null) continue;
            this.progressMonitor.set(i);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.close();
        }
        if ((status = (libraryTester = new LibraryTester()).testLibrary(reactions)) == 2) {
            this.reactors = null;
            throw new MetabolizerException("Error while initialize reactions.\n" + libraryTester.getMessage());
        }
        if (status == 1) {
            this.calculateDominance = false;
        } else if (status == 0) {
            this.calculateDominance = true;
        }
    }

    public void setSubstrates(Molecule[] substrates) throws MetabolizerException {
        if (this.progressMonitor != null) {
            this.isProgressMonitorSetForCalculation = false;
            this.progressMonitor.init(substrates.length);
        }
        this.reactionCount = 0;
        this.levelIterator = 0;
        this.reset();
        try {
            for (int i = 0; i < substrates.length; ++i) {
                if (substrates[i].getProperty("Synthesis Code") == null) {
                    substrates[i].setProperty("Synthesis Code", "substrate" + SynthesisIdSequencer.getInstance().getNextIndex(1));
                }
                if (substrates[i].getProperty("METABOLIZER_SYNTHESISLEVEL") == null) {
                    substrates[i].setProperty("METABOLIZER_SYNTHESISLEVEL", String.valueOf(0));
                }
                if (substrates[i].getProperty("METABOLIC_TREE_COUNT") == null) {
                    substrates[i].setProperty("METABOLIC_TREE_COUNT", substrates[i].getProperty("Synthesis Code"));
                }
                substrates[i].implicitizeHydrogens(2047);
                substrates[i].clean(2, null);
                this.metabolitExporter.export(substrates[i]);
                if (this.progressMonitor == null) continue;
                this.progressMonitor.set(i);
            }
            if (this.progressMonitor != null) {
                this.progressMonitor.close();
            }
        }
        catch (MetabolizerIOException exception) {
            throw new MetabolizerException("Error while setting substrates.", exception);
        }
        this.reset();
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    public int getLevelCounter() {
        return this.levelIterator;
    }

    public int getSubstrateCounter() {
        return this.substrateIterator;
    }

    public void setLevelCount(int levelCount) {
        this.levelCount = levelCount;
        this.levelIterator = 0;
    }

    public String getTermCondition() {
        return this.termCondition;
    }

    public void setTermCondition(String termCondition) throws MetabolizerException {
        if (termCondition == null || termCondition.equals("")) {
            this.molContext = null;
            this.chemJEP = null;
        } else {
            try {
                Evaluator evaluator = new Evaluator();
                evaluator.setLicenseEnvironment(LICENSE_ENVIRONMENT_FOR_INTERNAL_REACTOR_USE);
                this.chemJEP = evaluator.compile(termCondition, MolContext.class);
            }
            catch (ParseException exception) {
                throw new MetabolizerException(exception);
            }
            this.molContext = new MolContext();
        }
        this.termCondition = termCondition;
    }

    public void setRunInMemory(boolean runInMemory) {
        if (this.runInMemory != runInMemory) {
            this.runInMemory = runInMemory;
            if (runInMemory) {
                try {
                    this.temporaryStorage = new MetabolizerTemporaryMemoryStorage();
                    this.substrateImporter = this.temporaryStorage.getImporter();
                    this.metabolitExporter = this.temporaryStorage.getExporter();
                }
                catch (MetabolizerIOException exception) {
                    this.substrateImporter = null;
                    this.metabolitExporter = null;
                }
            }
        }
    }

    public boolean isGeneratingSubstrates() {
        return this.generatingSubstrates;
    }

    public void setGeneratingSubstrates(boolean generatingSubstrates) {
        this.generatingSubstrates = generatingSubstrates;
    }

    public void setTemporaryStorage(MetabolizerTemporaryStorage temporaryStorage) throws MetabolizerException {
        this.temporaryStorage = temporaryStorage;
        this.initializeTemporaryStorage();
    }

    public void closeTemporaryStorage() throws MetabolizerException {
        if (this.temporaryStorage != null) {
            try {
                this.temporaryStorage.close();
            }
            catch (MetabolizerIOException exception) {
                throw new MetabolizerException(exception);
            }
        }
    }

    public long getCurrentLevelLength() throws MetabolizerException {
        this.verifyTemporaryStorage();
        try {
            return this.substrateImporter.getMoleculeCount();
        }
        catch (MetabolizerIOException exception) {
            throw new MetabolizerException(exception);
        }
    }

    public float getMetabolicPathwayTolerance() {
        return this.metabolicPathwayTolerance;
    }

    public void setMetabolicPathwayTolerance(float metabolicPathwayTolerance) {
        this.metabolicPathwayTolerance = metabolicPathwayTolerance;
    }

    public void setExcludedMetabolites(Molecule[] molecules) {
        this.excludedMetaboliteSmiles.clear();
        if (molecules != null && molecules.length != 0) {
            this.isExcludeNeeded = true;
            for (int i = 0; i < molecules.length; ++i) {
                this.excludedMetaboliteSmiles.add(molecules[i].toFormat("smiles:u"));
            }
        } else {
            this.isExcludeNeeded = false;
        }
    }

    public void setNeededMetabolites(Molecule[] molecules) {
        this.neededMetaboliteSmiles.clear();
        if (molecules != null) {
            this.isValidating = true;
            for (int i = 0; i < molecules.length; ++i) {
                if (molecules[i] instanceof RxnMolecule) {
                    int j;
                    RxnMolecule reaction = (RxnMolecule)molecules[i];
                    for (j = 0; j < reaction.getReactantCount(); ++j) {
                        this.neededMetaboliteSmiles.add(reaction.getProduct(j).toFormat("smiles:u"));
                    }
                    for (j = 0; j < reaction.getProductCount(); ++j) {
                        this.neededMetaboliteSmiles.add(reaction.getProduct(j).toFormat("smiles:u"));
                    }
                    continue;
                }
                try {
                    this.neededMetaboliteSmiles.add(molecules[i].toFormat("smiles:u"));
                    continue;
                }
                catch (Exception exception) {
                    this.isValidating = false;
                    return;
                }
            }
            this.ignoreSelectivity();
        } else {
            this.isValidating = false;
        }
    }

    public void ignoreSelectivity() {
        for (int i = 0; i < this.reactors.length; ++i) {
            this.reactors[i].setIgnoreRules(2);
        }
    }

    public Set<String> getNeededMetaboliteSmiles() {
        return this.neededMetaboliteSmiles;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            Metabolizer.printHelp();
            return;
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-")) continue;
            if (!Metabolizer.isSwitchCorrect(args[i])) {
                Metabolizer.printHelp();
                return;
            }
            set.add(args[i]);
        }
        if (args.length > 0 && !Metabolizer.containsAllNeededSwitch(set)) {
            Metabolizer.printHelp();
            return;
        }
        int levelCount = 1;
        RxnMolecule[] reactions = null;
        OutputStream outputStream = System.out;
        InputStream inputStream = System.in;
        String outputType = "reaction";
        String outputFormat = "smiles:qTSynthesis Code:METABOLIZER_SYNTHESISLEVEL:METABOLIZER_PARENTSYNTHESISCODE:SPEED_CATEGORY:CHILDDEPTH:PRODUCTION:ACCUMULATION:TRANSMISSIVITY:STABILITY:PARENTS:METABOLIC_TREE_COUNT";
        OutputStream logStream = System.err;
        boolean generatingSubstrates = true;
        boolean runInMemory = true;
        boolean generateMajorMetabolites = false;
        boolean generateChildDepth = true;
        float metabolicPathTolerance = 0.0f;
        float tolerance = 0.0f;
        String terminationCondition = null;
        String excludedMoleculesFilePath = null;
        String neededMoleculesFilePath = null;
        String reactionFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-r")) {
                File library = new File(args[i + 1]);
                if (!library.exists()) {
                    System.err.println("Error: reaction library file does not exists");
                    return;
                }
                try {
                    List<Molecule> list = Metabolizer.readMoleculesToList(new FileInputStream(args[i + 1]));
                    reactions = list.toArray(new RxnMolecule[list.size()]);
                }
                catch (IOException exception) {
                    System.err.println("Error: can't read reaction library file");
                    exception.printStackTrace(System.err);
                    return;
                }
                ++i;
                continue;
            }
            if (args[i].equals("-n")) {
                levelCount = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-o")) {
                try {
                    outputStream = new FileOutputStream(args[i + 1]);
                }
                catch (FileNotFoundException exception) {
                    System.err.println("Error: can't open output file");
                    System.exit(0);
                }
                ++i;
                continue;
            }
            if (args[i].equals("-t")) {
                outputType = args[i + 1].equals("product") ? "product" : "reaction";
                ++i;
                continue;
            }
            if (args[i].equals("-f")) {
                outputFormat = args[i + 1].equals("smiles") ? "smiles:qTSynthesis Code:METABOLIZER_SYNTHESISLEVEL:METABOLIZER_PARENTSYNTHESISCODE:SPEED_CATEGORY:CHILDDEPTH:PRODUCTION:ACCUMULATION:TRANSMISSIVITY:STABILITY:PARENTS:METABOLIC_TREE_COUNT" : args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-l")) {
                try {
                    logStream = new FileOutputStream(args[i + 1]);
                }
                catch (FileNotFoundException exception) {
                    System.err.println("Warning: Could not write log file.");
                    logStream = System.err;
                }
                ++i;
                continue;
            }
            if (args[i].equals("-g")) {
                generatingSubstrates = false;
                continue;
            }
            if (args[i].equals("-G")) {
                metabolicPathTolerance = Float.parseFloat(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-M")) {
                runInMemory = Boolean.valueOf(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-m")) {
                generateMajorMetabolites = true;
                tolerance = Float.parseFloat(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("-x")) {
                terminationCondition = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-X")) {
                generateChildDepth = false;
                continue;
            }
            if (args[i].equals("-E")) {
                excludedMoleculesFilePath = args[++i];
                continue;
            }
            if (args[i].equals("-N")) {
                neededMoleculesFilePath = args[++i];
                continue;
            }
            if (args[i].equals("-R")) {
                reactionFile = args[++i];
                continue;
            }
            File substrateFile = new File(args[i]);
            if (substrateFile.exists()) {
                try {
                    inputStream = new FileInputStream(substrateFile);
                    continue;
                }
                catch (FileNotFoundException exception) {
                    System.err.println("Error: can't read input file");
                    exception.printStackTrace(System.err);
                    return;
                }
            }
            inputStream = new ByteArrayInputStream(args[i].getBytes());
        }
        PrintWriter logWriter = new PrintWriter(logStream);
        MolImporter importer = null;
        MolExporter exporter = null;
        try {
            for (int j = 0; j < reactions.length; ++j) {
                reactions[j].setProperty("SELECTIVITY", null);
            }
            Metabolizer metabolizer = runInMemory ? new Metabolizer(levelCount, reactions, runInMemory) : new Metabolizer(levelCount, reactions, new MetabolizerTemporaryFileStorage());
            metabolizer.setGeneratingSubstrates(generatingSubstrates);
            metabolizer.setMetabolicPathwayTolerance(metabolicPathTolerance);
            if (terminationCondition != null) {
                metabolizer.setTermCondition(terminationCondition);
            }
            MetabolizerUtilities metabolizerUtilities = new MetabolizerUtilities();
            if (excludedMoleculesFilePath != null) {
                metabolizer.setExcludedMetabolites(Metabolizer.readMoleculesToArray(new FileInputStream(excludedMoleculesFilePath)));
            }
            if (reactionFile != null) {
                metabolizer.ignoreSelectivity();
                FileOutputStream missingMetabolitesOutput = new FileOutputStream(reactionFile + ".missing.metabolites.smiles");
                PrintWriter outputWriter = new PrintWriter(missingMetabolitesOutput);
                metabolizer.setLevelCount(1);
                Molecule[] molecules = Metabolizer.readMoleculesToArray(new FileInputStream(reactionFile));
                for (int i = 0; i < molecules.length; ++i) {
                    RxnMolecule reaction = RxnMolecule.getReaction(molecules[i]);
                    if (reaction == null) continue;
                    Molecule substrate = reaction.getReactant(0);
                    String metbolite = reaction.getProduct(0).toFormat("smiles:u");
                    metabolizer.setSubstrates(new Molecule[]{substrate});
                    MetabolizerCalculator.getInstance().clear();
                    boolean found = false;
                    while (metabolizer.hasMoreLevel()) {
                        while (!metabolizer.isCurrentLevelEnded()) {
                            Molecule[] metabolites = metabolizer.next();
                            for (int j = 0; j < metabolites.length; ++j) {
                                if (!metabolites[j].toFormat("smiles:u").contains(metbolite)) continue;
                                found = true;
                            }
                        }
                        metabolizer.nextLevel();
                    }
                    if (found) continue;
                    outputWriter.println(reaction.toFormat("smiles:u"));
                }
                outputWriter.flush();
                outputWriter.close();
                missingMetabolitesOutput.flush();
                ((OutputStream)missingMetabolitesOutput).close();
            } else if (neededMoleculesFilePath != null) {
                File input = new File(neededMoleculesFilePath);
                File[] inputFiles = input.isDirectory() ? input.listFiles() : new File[]{input};
                for (int i = 0; i < inputFiles.length; ++i) {
                    Molecule[] molecules = Metabolizer.readMoleculesToArray(new FileInputStream(inputFiles[i]));
                    metabolizer.setNeededMetabolites(molecules);
                    if (metabolizer.isValidating) {
                        metabolizer.setSubstrates(new Molecule[]{molecules[0]});
                        metabolizerUtilities.generateMetabolites(metabolizer, new File(inputFiles[i].getAbsoluteFile() + ".tree.smiles"), outputFormat, outputType);
                        FileOutputStream missingMetabolitesOutput = new FileOutputStream(inputFiles[i].getAbsoluteFile() + "missing.metabolites.output.smiles");
                        PrintWriter writer = new PrintWriter(missingMetabolitesOutput);
                        for (String remainingMetaboliteSmiles : metabolizer.getNeededMetaboliteSmiles()) {
                            writer.write(remainingMetaboliteSmiles + "\n");
                        }
                        writer.flush();
                        ((OutputStream)missingMetabolitesOutput).close();
                        continue;
                    }
                    new FileOutputStream(inputFiles[i].getAbsoluteFile() + ".error").close();
                }
            } else {
                Molecule substrate = null;
                Molecule tempMol = null;
                boolean hasNext = true;
                try {
                    importer = new MolImporter(inputStream);
                }
                catch (IOException exception) {
                    System.err.println("Error: can't read input molecules");
                    exception.printStackTrace(logWriter);
                    return;
                }
                try {
                    if (generateMajorMetabolites || generateChildDepth) {
                        exporter = new MolExporter(outputStream, outputFormat);
                    }
                }
                catch (IOException exception) {
                    System.err.println("Error: can't write output");
                    exception.printStackTrace(logWriter);
                    return;
                }
                while (substrate == null && hasNext) {
                    try {
                        tempMol = importer.read();
                        hasNext = tempMol != null;
                    }
                    catch (IOException exception) {
                        exception.printStackTrace(logWriter);
                        substrate = null;
                    }
                    substrate = tempMol;
                }
                while (substrate != null) {
                    metabolizer.setSubstrates(new Molecule[]{substrate});
                    MetabolizerCalculator.getInstance().clear();
                    if (!generateMajorMetabolites) {
                        if (generateChildDepth) {
                            metabolizerUtilities.generateMetabolitesWithChildDepth(metabolizer, exporter, outputFormat, outputType);
                        } else {
                            metabolizerUtilities.generateMetabolites(metabolizer, outputStream, outputFormat, outputType);
                        }
                    } else {
                        metabolizerUtilities.generateMajorMetabolites(metabolizer, exporter, outputFormat, outputType, tolerance);
                    }
                    try {
                        substrate = importer.read();
                    }
                    catch (IOException exception) {
                        exception.printStackTrace(logWriter);
                        substrate = null;
                    }
                }
            }
            metabolizer.closeTemporaryStorage();
        }
        catch (MetabolizerException exception) {
            exception.printStackTrace(logWriter);
        }
        logWriter.close();
        try {
            importer.close();
            if (exporter != null) {
                exporter.close();
            }
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
            inputStream.close();
        }
        catch (IOException exception) {
            // empty catch block
        }
    }

    private static Molecule[] readMoleculesToArray(InputStream inputStream) throws IOException {
        List<Molecule> list = Metabolizer.readMoleculesToList(inputStream);
        return list.toArray(new Molecule[list.size()]);
    }

    private static List<Molecule> readMoleculesToList(InputStream inputStream) throws IOException, MolFormatException {
        Molecule tempMol;
        ArrayList<Molecule> list = new ArrayList<Molecule>();
        MolImporter importer = new MolImporter(inputStream);
        while ((tempMol = importer.read()) != null) {
            list.add(tempMol);
        }
        return list;
    }

    private static void printHelp() {
        System.out.println(HELP_TEXT);
    }

    private static boolean isSwitchCorrect(String switchString) {
        return switchString.equals("-r") || switchString.equals("-n") || switchString.equals("-o") || switchString.equals("-t") || switchString.equals("-f") || switchString.equals("-l") || switchString.equals("-g") || switchString.equals("-G") || switchString.equals("-M") || switchString.equals("-m") || switchString.equals("-x") || switchString.equals("-X") || switchString.equals("-E") || switchString.equals("-N") || switchString.equals("-F") || switchString.equals("-R");
    }

    private static boolean containsAllNeededSwitch(Set<String> set) {
        return set.contains("-r");
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Metabolizer", this.licenseEnviroment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnviroment = env;
    }

    private void checkLicense() throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Metabolizer", this.licenseEnviroment);
    }
}

