/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.metabolizer.Executor;
import chemaxon.metabolizer.RegistryService;
import chemaxon.util.DotfileUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class MetabolizerExecutor
implements Remote,
Executor {
    private PrintStream logStream;
    private String serverName;
    private List<Remote> jobs = new LinkedList<Remote>();

    public MetabolizerExecutor() {
        this.initialize();
    }

    public void startService() {
        try {
            RegistryService.getInstance().createRegistry(1099);
        }
        catch (RemoteException e) {
            this.logStream.println("Could not load properties file. Working with default configuration");
            e.printStackTrace(this.logStream);
        }
        MetabolizerExecutor executor = new MetabolizerExecutor();
        try {
            RemoteStub executorStub = UnicastRemoteObject.exportObject(executor);
            LocateRegistry.getRegistry(1099).rebind(this.serverName, executorStub);
        }
        catch (RemoteException e) {
            this.logStream.println("Error: Could not register server, exiting...");
            e.printStackTrace(this.logStream);
        }
    }

    public static void main(String[] args) {
        MetabolizerExecutor executor = new MetabolizerExecutor();
        executor.startService();
    }

    private void initialize() {
        Properties properties = new Properties();
        try {
            FileInputStream inputStream = new FileInputStream(DotfileUtil.getDotFile("metabolizerExecutor.properties"));
            properties.load(inputStream);
            this.logStream = properties.contains("logFilePath") ? new PrintStream(new FileOutputStream(properties.getProperty("logFilePath"), true), true) : System.out;
            this.serverName = properties.contains("serverName") ? properties.getProperty("serverName") : "Server";
        }
        catch (IOException e) {
            System.out.println("Could not load properties file. Working with default configuration");
            e.printStackTrace(System.out);
            this.useDefaults();
        }
    }

    private void useDefaults() {
        this.logStream = System.out;
    }

    @Override
    public void registerJob(Remote remoteJob) {
        this.jobs.add(remoteJob);
        System.out.println(this.jobs.size());
    }

    @Override
    public void unregisterJob(Remote remoteJob) {
        if (this.jobs.contains(remoteJob)) {
            this.jobs.remove(remoteJob);
        }
        System.out.println(this.jobs.size());
    }
}

