/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.metabolizer;

import chemaxon.metabolizer.MetabolizerExporter;
import chemaxon.metabolizer.MetabolizerFileExporter;
import chemaxon.metabolizer.MetabolizerFileImporter;
import chemaxon.metabolizer.MetabolizerIOException;
import chemaxon.metabolizer.MetabolizerImporter;
import chemaxon.metabolizer.MetabolizerTemporaryStorage;
import java.io.File;
import java.io.IOException;

public class MetabolizerTemporaryFileStorage
implements MetabolizerTemporaryStorage {
    File input;
    File output;
    MetabolizerImporter substrateImporter;
    MetabolizerExporter metabolitExporter;
    boolean inputIsTempFile;

    public MetabolizerTemporaryFileStorage(File substrates) throws MetabolizerIOException {
        try {
            this.input = substrates;
            this.inputIsTempFile = false;
            this.output = File.createTempFile("metabolizerOutput", ".tmp");
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }

    public MetabolizerTemporaryFileStorage(String path) throws MetabolizerIOException {
        try {
            this.input = new File(path);
            this.inputIsTempFile = false;
            this.output = File.createTempFile("metabolizerOutput", ".tmp");
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }

    public MetabolizerTemporaryFileStorage() throws MetabolizerIOException {
        try {
            this.input = File.createTempFile("metabolizerInput", ".tmp");
            this.inputIsTempFile = true;
            this.output = File.createTempFile("metabolizerOutput", ".tmp");
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }

    @Override
    public MetabolizerExporter getExporter() throws MetabolizerIOException {
        this.metabolitExporter = new MetabolizerFileExporter(this.output, "smiles:qTSynthesis Code:METABOLIZER_SYNTHESISLEVEL:METABOLIZER_PARENTSYNTHESISCODE:SPEED_CATEGORY:CHILDDEPTH:PRODUCTION:ACCUMULATION:TRANSMISSIVITY:STABILITY:PARENTS:METABOLIC_TREE_COUNT:IGNORED");
        return this.metabolitExporter;
    }

    @Override
    public MetabolizerImporter getImporter() throws MetabolizerIOException {
        this.substrateImporter = new MetabolizerFileImporter(this.input);
        return this.substrateImporter;
    }

    @Override
    public void newIteration() throws MetabolizerIOException {
        try {
            if (this.inputIsTempFile) {
                this.input.delete();
            }
            this.input = this.output;
            this.inputIsTempFile = true;
            this.output = File.createTempFile("metabolizerOutput", ".tmp");
        }
        catch (IOException exception) {
            throw new MetabolizerIOException(exception);
        }
    }

    @Override
    public void close() throws MetabolizerIOException {
        if (this.substrateImporter != null) {
            this.substrateImporter.close();
        }
        if (this.metabolitExporter != null) {
            this.metabolitExporter.close();
        }
        if (this.inputIsTempFile) {
            this.input.delete();
        }
        this.output.delete();
    }
}

