/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming;

import chemaxon.formats.MolImporter;
import chemaxon.util.IO;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class DocumentToStructure {
    public static final String SOURCE_TEXT = "text";
    public static final String DOCUMENT = "document";
    public static final String PAGE = "page";
    public static final String CHARACTER = "character";
    public static final String BYTE = "byte";
    public static final String CONFIDENCE = "confidence";
    public static final String TYPE = "type";
    public static final String TYPE_SYSTEMATIC = "systematic";
    public static final String TYPE_COMMON = "common";
    public static final String TYPE_GENERIC = "generic";
    public static final String TYPE_SMILES = "smiles";
    public static final String TYPE_INCHI = "InChI";
    public static final String TYPE_CAS = "CAS#";
    public static final String TYPE_CDX = "cdx";
    public static final String TYPE_MRV = "mrv";
    public static final String TYPE_SYMYX = "symyx";
    public static final String TYPE_OSR = "OSR";

    public static MolImporter process(String text) {
        return DocumentToStructure.process(text, null);
    }

    public static MolImporter process(String text, String options) {
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes(IO.UTF8));
        String format2 = "d2s";
        if (options != null) {
            format2 = format2 + ":" + options;
        }
        try {
            return new MolImporter(in, format2, IO.UTF8.name());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

