/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming;

import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class NameToStruct {
    static final String newline = System.getProperty("line.separator");

    public static void main(String[] args) throws IOException {
        String line;
        String format2;
        if (args.length != 3) {
            System.err.println("java chemaxon.naming.NameToStruct -smiles input.txt output.txt");
            System.exit(1);
        }
        if ((format2 = args[0]).startsWith("-")) {
            format2 = format2.substring(1);
        }
        String inName = args[1];
        String outName = args[2];
        BufferedReader in = new BufferedReader(new FileReader(inName));
        BufferedWriter out = new BufferedWriter(new FileWriter(outName));
        while ((line = in.readLine()) != null) {
            try {
                Molecule m = MolImporter.importMol(line, "name");
                String smiles = m.toFormat(format2);
                out.append(line + "\t" + smiles + newline);
            }
            catch (Exception e) {
                out.append(line + "\t" + e + newline);
            }
        }
        in.close();
        out.close();
    }
}

