/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.license.Base64;
import chemaxon.naming.DocumentExtractor;
import chemaxon.naming.document.Extractor;
import chemaxon.naming.n2s.Standardize;
import chemaxon.struc.Molecule;
import chemaxon.util.IO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SGMLAnnotator {
    private static final boolean check = false;
    private static final boolean generateHTML = true;
    boolean deannotate = false;
    String filename;
    LinkedHashMap<String, Molecule> structures = new LinkedHashMap(1000);
    BufferedWriter html;
    static final String lineSeparator = System.getProperty("line.separator");
    static final DecimalFormat massFormat = new DecimalFormat("#.###");

    public static void main(String[] args) throws IOException {
        new SGMLAnnotator().run(args);
    }

    public void run(String[] args) throws IOException {
        this.filename = args[0];
        String basename = this.filename.substring(0, this.filename.lastIndexOf(46));
        String extension = this.filename.substring(this.filename.lastIndexOf(46) + 1);
        this.html = IO.bufferedFileWriter(new File(this.filename + ".html"), IO.UTF8);
        this.html.append("<html><head><META http-equiv='Content-Type' content='text/html; charset=UTF-8'>");
        this.html.append("<title>").append(this.filename).append("</title></head><body>");
        this.deannotate = args.length > 1 && args[1].equals("-d");
        BufferedReader r = SGMLAnnotator.reader(this.filename);
        String wholeText = SGMLAnnotator.readAll(r);
        this.analyze(wholeText);
        String annotatedText = this.deannotate ? this.deannotate(wholeText) : this.annotate(wholeText);
        BufferedWriter out = new BufferedWriter(new FileWriter(basename + "_annot." + extension));
        out.append(annotatedText);
        out.close();
        if (this.html != null) {
            this.html.append("\n</body>\n</html>\n");
            this.html.close();
        }
        if (this.structures != null) {
            MolExporter sdf = new MolExporter(basename + ".sdf", "sdf");
            for (Map.Entry<String, Molecule> entry : this.structures.entrySet()) {
                try {
                    sdf.write(entry.getValue());
                }
                catch (Exception e) {}
            }
            sdf.close();
        }
    }

    protected void analyze(String sourceText) {
    }

    public String deannotate(String wholeText) {
        int hit;
        StringBuilder res = new StringBuilder(10000);
        String openTag = "<" + this.getTagName();
        String closeTag = "</" + this.getTagName() + ">";
        int pos = 0;
        while ((hit = wholeText.indexOf(openTag, pos)) != -1) {
            res.append(wholeText.substring(pos, hit));
            pos = hit + openTag.length();
            while (wholeText.charAt(pos) != '>') {
                ++pos;
            }
            int end = wholeText.indexOf(closeTag, ++pos);
            String name = wholeText.substring(pos, end);
            res.append(name);
            name = this.removeTags(Standardize.decodeHTML(name));
            name = name.replace("\n", "");
            try {
                MolImporter.importMol(name, "name:ocr");
            }
            catch (MolFormatException e) {
                name = Extractor.trimWord(name);
                if (name.endsWith("s")) {
                    name = name.substring(0, name.length() - 1);
                }
                try {
                    MolImporter.importMol(name, "name:ocr");
                }
                catch (MolFormatException e1) {
                    throw new RuntimeException(name, e1);
                }
            }
            pos = end + closeTag.length();
        }
        res.append(wholeText.substring(pos));
        return res.toString();
    }

    private String removeTags(String text) {
        int hit;
        StringBuilder res = new StringBuilder();
        String openTag = "<";
        int pos = 0;
        while ((hit = text.indexOf(openTag, pos)) != -1) {
            res.append(text.substring(pos, hit));
            pos = hit + openTag.length();
            while (text.charAt(pos) != '>') {
                ++pos;
            }
            ++pos;
            res.append(' ');
        }
        res.append(text.substring(pos));
        return res.toString();
    }

    public String annotate(String wholeText) {
        StringReader r = new StringReader(wholeText);
        DocumentExtractor x = new DocumentExtractor(r);
        this.configure(x);
        try {
            x.processHTML();
            List<DocumentExtractor.Hit> hits = x.getHits();
            return this.annotate(wholeText, hits);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void configure(DocumentExtractor x) {
    }

    public boolean ignore(DocumentExtractor.Hit hit) {
        return false;
    }

    private String annotate(String sourceText, List<DocumentExtractor.Hit> hits) throws IOException {
        StringBuilder out = new StringBuilder(10000);
        int done = 0;
        for (DocumentExtractor.Hit hit : hits) {
            int open;
            int close;
            if (this.ignore(hit)) continue;
            int pos = hit.position - 1;
            String name = sourceText.substring(pos, pos + hit.text.length());
            if (name.startsWith("&hyphen;")) {
                int skip = "&hyphen;".length();
                pos += skip;
                name = name.substring(skip);
            }
            if (sourceText.substring(done, pos).endsWith("<I>") && (close = name.indexOf("</I>")) != -1 && ((open = name.indexOf("<I>")) == -1 || open > close)) {
                pos -= "<I>".length();
                name = "<I>" + name;
            }
            if (sourceText.substring(done, pos).endsWith("<i>") && (close = name.indexOf("</i>")) != -1 && ((open = name.indexOf("<i>")) == -1 || open > close)) {
                pos -= "<i>".length();
                name = "<i>" + name;
            }
            if (this.closeUnopenedTag(name)) continue;
            this.outputPlain(out, sourceText.substring(done, pos));
            String annotated = this.annotate(hit, name);
            out.append(annotated);
            if (this.html != null) {
                this.html.append(this.annotateHTML(hit, name));
            }
            this.addHit(hit);
            done = pos + name.length();
        }
        this.outputPlain(out, sourceText.substring(done));
        return out.toString();
    }

    private boolean closeUnopenedTag(String name) {
        String lastTag = null;
        int pos = 0;
        while ((pos = name.indexOf(60, pos)) != -1) {
            char c;
            boolean closing;
            boolean bl = closing = name.charAt(pos + 1) == '/';
            if (closing) {
                ++pos;
            }
            int end = pos;
            while ((c = name.charAt(++end)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            }
            String tag = name.substring(pos + 1, end);
            pos = end;
            if (closing) {
                if (tag.equals(lastTag)) continue;
                return true;
            }
            lastTag = tag;
        }
        return false;
    }

    private void outputPlain(StringBuilder out, String text) throws IOException {
        out.append(text);
        if (this.html != null) {
            this.html.append(text);
        }
    }

    private String standardize(String name) {
        name = Standardize.get(name);
        name = Standardize.normalize(name);
        return name;
    }

    void addProperties(Molecule m) {
    }

    private void addHit(DocumentExtractor.Hit hit) {
        String newName = hit.structure.getName();
        newName = this.standardize(newName);
        newName = newName + lineSeparator;
        String key = this.getKey(hit.structure);
        Molecule m = this.structures.get(key);
        if (m == null) {
            m = hit.structure;
            m.setName(newName.trim());
            this.structures.put(key, m);
            m.setProperty("Names", newName);
            m.setProperty("InChIKey", key);
            this.addProperties(m);
        } else {
            String names = m.getProperty("Names");
            if (!names.contains(newName)) {
                names = names + newName;
                m.setProperty("Names", names);
            }
        }
    }

    String getKey(Molecule structure) {
        return null;
    }

    private String annotate(DocumentExtractor.Hit hit, String originalText) {
        String res = "<" + this.getTagName();
        String attr = this.getAttributes(hit);
        if (attr != null) {
            res = res + " " + attr;
        }
        res = res + ">" + originalText + "</" + this.getTagName() + ">";
        return res;
    }

    private String annotateHTML(DocumentExtractor.Hit hit, String originalText) {
        StringBuilder res = new StringBuilder();
        res.append("<table style='display:inline-table'><tr><td>");
        byte[] imageData = hit.structure.toBinFormat("png");
        String base64 = Base64.encodeToString(imageData);
        res.append("<img src='data:image/png;base64,").append(base64).append("'>");
        res.append("<tr><td align='center'>");
        res.append(Standardize.decodeHTML(originalText));
        res.append("</table>");
        return res.toString();
    }

    protected String getTagName() {
        return "chemical-structure";
    }

    protected String getAttributes(DocumentExtractor.Hit hit) {
        return null;
    }

    private static BufferedReader reader(String filename) throws FileNotFoundException {
        Charset charset = Charset.defaultCharset();
        if (charset.name().equals("US-ASCII")) {
            charset = Charset.forName("UTF-8");
        }
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), charset));
    }

    private static String readAll(BufferedReader r) throws IOException {
        String line;
        StringBuilder res = new StringBuilder(10000);
        while ((line = r.readLine()) != null) {
            res.append(line).append('\n');
        }
        return res.toString();
    }
}

