/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.document;

import chemaxon.formats.MolInputStream;
import chemaxon.license.LicenseHandler;
import chemaxon.naming.DocumentToStructure;
import chemaxon.naming.document.TikaParser;
import chemaxon.struc.Molecule;
import chemaxon.util.IO;
import chemaxon.util.LoggingUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import org.apache.tika.metadata.Metadata;

public class D2S
implements Iterator<Molecule> {
    private Thread thread;
    private BlockingQueue<Molecule> hits = new ArrayBlockingQueue<Molecule>(100);
    private Molecule next;
    private static final Logger log = LoggingUtil.getLogger(DocumentToStructure.class);

    public D2S(InputStream document) {
        this(document, new Options());
    }

    public D2S(InputStream document, Options options) {
        this(document, new Metadata(), options);
    }

    public D2S(String text) {
        this(text, new Options());
    }

    public D2S(String text, Options options) {
        this(new ByteArrayInputStream(text.getBytes(IO.UTF8)), D2S.utf8(new Metadata()), options);
    }

    private static Metadata utf8(Metadata metadata) {
        metadata.set("Content-Encoding", IO.UTF8.name());
        return metadata;
    }

    private D2S(InputStream document, Metadata metadata, Options options) {
        MolInputStream mis;
        String path;
        if (document instanceof MolInputStream && (path = (mis = (MolInputStream)document).getPath()) != null) {
            metadata.add("resourceName", path);
        }
        this.thread = new Thread(new TikaParser(document, metadata, this.hits, options));
        this.thread.start();
        LicenseHandler.getInstance().checkLicense("Document to Structure");
    }

    @Override
    public boolean hasNext() {
        if (this.next == TikaParser.endOfDocument) {
            return false;
        }
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.hits.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return this.next != TikaParser.endOfDocument;
    }

    @Override
    public Molecule next() {
        if (this.hasNext()) {
            Molecule res = this.next;
            this.next = null;
            return res;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(args[0]);
        D2S d2s = new D2S(in);
        while (d2s.hasNext()) {
            System.out.print(d2s.next().toFormat("cxsmiles:T*"));
        }
        System.out.println("THE END");
    }

    public static class Options {
        private boolean enableCAS = false;
        public boolean enableSmiles = true;
        public boolean enableInChI = true;
        public boolean enableOSRA = true;
        public chemaxon.naming.n2s.Options n2sOptions = new chemaxon.naming.n2s.Options(null, false, true, false, true, 5, false, false);
        private String insideTag = null;

        public Options enableCAS(boolean enable) {
            this.enableCAS = enable;
            return this;
        }

        public boolean isCASEnabled() {
            return this.enableCAS;
        }

        public void insideTag(String tag) {
            this.insideTag = tag;
        }

        public Object getInsideTag() {
            return this.insideTag;
        }
    }
}

