/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.document;

import chemaxon.naming.document.ExtendedLocator;
import chemaxon.naming.document.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TrivialXMLParser
extends AbstractParser
implements ExtendedLocator {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"xml"))));
    private static final int MAX = 1024;
    private char[] text = new char[1024];
    private int length = 0;
    private int position = 0;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        handler.setDocumentLocator(this);
        handler.startDocument();
        this.process(stream, handler);
        handler.endDocument();
    }

    private void process(InputStream stream, ContentHandler handler) throws IOException, SAXException {
        int c;
        XmlReader r = new XmlReader(stream);
        this.position = 0;
        this.length = 0;
        while ((c = r.read()) != -1) {
            ++this.position;
            if (c == 60) {
                if (this.length > 0) {
                    handler.characters(this.text, 0, this.length);
                    this.length = 0;
                }
                do {
                    c = r.read();
                    ++this.position;
                } while (c != 62);
                continue;
            }
            if (this.length == 1024) {
                handler.characters(this.text, 0, this.length);
                this.length = 0;
            }
            this.text[this.length++] = (char)c;
        }
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public int getCharacterOffset() {
        return this.position;
    }
}

