/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.document;

import chemaxon.naming.DocumentExtractor;
import java.io.IOException;
import java.io.Reader;

public class WordReader {
    private Reader in;
    private int charPos = 0;
    private int wordStart = -1;
    private int linePos = 1;
    private int lineStart = 1;
    protected boolean newSentence = false;
    public static final String newSentenceMarker = new String();

    public WordReader(Reader in) {
        this.in = in;
    }

    public int getCharacterPosition() {
        return this.charPos;
    }

    public int getWordStart() {
        return this.wordStart;
    }

    public int getLine() {
        return this.lineStart;
    }

    int read() throws IOException {
        ++this.charPos;
        int res = this.in.read();
        if (res == 65533) {
            DocumentExtractor.printEncodingError();
        }
        return res;
    }

    private String signalNewSentence() {
        this.newSentence = false;
        return newSentenceMarker;
    }

    public String readWord() throws IOException {
        StringBuffer res;
        block6: {
            if (this.newSentence) {
                return this.signalNewSentence();
            }
            res = null;
            while (true) {
                int c;
                if (!this.isSeparator(c = this.read())) {
                    if (res == null) {
                        res = new StringBuffer();
                        this.wordStart = this.charPos;
                        this.lineStart = this.linePos;
                    }
                    res.append((char)c);
                    continue;
                }
                if (c == 10) {
                    ++this.linePos;
                }
                if (res != null) break block6;
                if (c == -1) {
                    return null;
                }
                if (this.newSentence) break;
            }
            return this.signalNewSentence();
        }
        return res.toString();
    }

    boolean isSeparator(int c) {
        return c == -1 || c == 32 || c == 13 || c == 10 || c == 9 || c == 12;
    }

    public static class InvalidCharacterException
    extends IOException {
        InvalidCharacterException() {
            super("The charset used to read the document is wrong");
        }
    }
}

