/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.document;

import chemaxon.naming.document.ExtendedLocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.TextContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XMLStaxParser
extends AbstractParser {
    private static final long serialVersionUID = -6028836725280212837L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"xml"), MediaType.image((String)"svg+xml"))));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputStream in, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (metadata.get("Content-Type") == null) {
            metadata.set("Content-Type", "application/xml");
        }
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader parser = factory.createXMLStreamReader(in);
            System.out.println("At " + parser.getLocation().getCharacterOffset());
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.setDocumentLocator((org.xml.sax.Locator)new Locator(parser));
            xhtml.startDocument();
            xhtml.startElement("p");
            block7: while (true) {
                System.out.println("At " + parser.getLocation().getCharacterOffset());
                int event = parser.next();
                System.out.println("Event: " + XMLStaxParser.getEventTypeString(event) + " at " + parser.getLocation().getCharacterOffset());
                switch (event) {
                    case 8: {
                        parser.close();
                        break block7;
                    }
                    case 1: {
                        xhtml.startElement(parser.getLocalName());
                        break;
                    }
                    case 2: {
                        xhtml.endElement(parser.getLocalName());
                    }
                }
            }
            xhtml.endElement("p");
            xhtml.endDocument();
            return;
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public static final String getEventTypeString(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE , " + eventType;
    }

    protected ContentHandler getContentHandler(ContentHandler handler, Metadata metadata, ParseContext context) {
        return new TextContentHandler(handler);
    }

    static class Locator
    implements ExtendedLocator {
        XMLStreamReader parser;

        public Locator(XMLStreamReader parser) {
            this.parser = parser;
        }

        @Override
        public String getPublicId() {
            return this.parser.getLocation().getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.parser.getLocation().getSystemId();
        }

        @Override
        public int getLineNumber() {
            return this.parser.getLocation().getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.parser.getLocation().getColumnNumber();
        }

        @Override
        public int getCharacterOffset() {
            return this.parser.getLocation().getCharacterOffset();
        }
    }
}

