/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.naming.n2s.N2S;
import java.util.ArrayList;
import java.util.List;

public class Ambiguity {
    String name;
    public static final Ambiguity missingLocant = new Ambiguity("missing_locant");
    public static final Ambiguity defaultLocant = new Ambiguity("default_locant");
    public static final Ambiguity stereochemistry = new Ambiguity("stereochemistry");

    Ambiguity(String name) {
        this.name = name;
    }

    public boolean allow() {
        boolean allow = N2S.getOptions().ambiguitySettings.allowed.contains(this.name);
        if (allow) {
            N2S.getState().ambiguous = true;
        }
        return allow;
    }

    static class Settings {
        List<String> allowed = new ArrayList<String>();

        Settings(int ambiguous) {
            if (ambiguous == 0) {
                return;
            }
            this.allowed.add(Ambiguity.stereochemistry.name);
            this.allowed.add(Ambiguity.defaultLocant.name);
            if (ambiguous > 5) {
                this.allowed.add(Ambiguity.missingLocant.name);
            }
        }
    }
}

