/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.formats.name.util.CachedMap;
import chemaxon.naming.NameConverter;
import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.UtilLegacy;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import java.io.File;
import java.io.IOException;

public class CASNumberConverter
implements NameConverter {
    private static final CachedMap.CachedStringMap CAScache;

    @Override
    public Molecule convert(String name) {
        if (N2S.getOptions().dataMining) {
            return null;
        }
        return CASNumberConverter.convertCasNumber(name);
    }

    public static Molecule convertCasNumber(String name) {
        if (!CASNumberConverter.isCASNumber(name)) {
            return null;
        }
        if (CAScache == null) {
            return null;
        }
        Molecule res = CASNumberConverter.getStructure((String)CAScache.get(name));
        if (res != null) {
            return res;
        }
        return null;
    }

    public static boolean isCASNumber(String name) {
        int len = name.length();
        if (len < 6) {
            return false;
        }
        int i = len;
        while (--i >= 0) {
            char c = name.charAt(i);
            if (!(i == len - 2 || i == len - 5 ? c != '-' : c < '0' || c > '9')) continue;
            return false;
        }
        return true;
    }

    static String getSmiles(String casNumber) throws IOException {
        String res = UtilLegacy.readURL("http://cactus.nci.nih.gov/chemical/structure/" + casNumber + "/smiles");
        if (res != null) {
            res = res.trim();
        }
        return res;
    }

    private static Molecule getStructure(String smiles) {
        try {
            return MolImporter.importMol(smiles, "smiles");
        }
        catch (MolFormatException e) {
            return null;
        }
    }

    @Override
    public boolean setPrefixMode(boolean prefixMode) {
        return true;
    }

    static {
        File cacheFile = null;
        try {
            cacheFile = DotfileUtil.getDotFileWithEnsuredPath("naming/cas.cache");
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        CAScache = cacheFile == null ? null : new CachedMap.CachedStringMap(cacheFile){

            @Override
            public String compute(String casNumber) throws IOException {
                return CASNumberConverter.getSmiles(casNumber);
            }
        };
    }
}

