/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.naming.NameConverter;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;

public class IonConverter
implements NameConverter {
    @Override
    public Molecule convert(String name) throws NameFormatException {
        if (name.length() < 2) {
            return null;
        }
        String atom = Character.isLowerCase(name.charAt(1)) ? name.substring(0, 2) : name.substring(0, 1);
        int atno = PeriodicSystem.getAtomicNumber(atom);
        if (atno == -1) {
            return null;
        }
        int charge = this.getCharge(name.substring(atom.length()));
        if (charge == 0) {
            return null;
        }
        if (!N2S.getOptions().convertIons) {
            throw new NameFormatException.FilteredCase("Ion '" + name + "' not converted as required by configuration");
        }
        Molecule res = Util.newMolecule();
        MolAtom a = new MolAtom(atno);
        a.setCharge(charge);
        res.add(a);
        return res;
    }

    private int getCharge(String text) {
        if (text.startsWith("(") && text.endsWith(")")) {
            text = text.substring(1, text.length() - 1);
        }
        if (text.equals("+")) {
            return 1;
        }
        if (text.equals("-")) {
            return -1;
        }
        if (text.length() == 2) {
            char c1 = text.charAt(0);
            char c2 = text.charAt(1);
            if (Character.isDigit(c1)) {
                int num = Integer.parseInt("" + c1);
                if (c2 == '+') {
                    return num;
                }
                if (c2 == '-') {
                    return -num;
                }
            }
        }
        return 0;
    }

    @Override
    public boolean setPrefixMode(boolean prefixMode) {
        return true;
    }
}

