/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.formats.name.nameimport.IUPACNameReader;
import chemaxon.marvin.io.formats.name.util.TextUtils;
import chemaxon.naming.Bridge;
import chemaxon.naming.NameConverter;
import chemaxon.naming.NameConverters;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.NamePrefixException;
import chemaxon.naming.n2s.CASNumberConverter;
import chemaxon.naming.n2s.Dictionary;
import chemaxon.naming.n2s.ElementConverter;
import chemaxon.naming.n2s.IonConverter;
import chemaxon.naming.n2s.OcrCorrector;
import chemaxon.naming.n2s.Options;
import chemaxon.naming.n2s.Standardize;
import chemaxon.naming.n2s.SystematicNameConverter;
import chemaxon.naming.n2s.Util;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class N2S {
    public static final boolean fixSpelling = true;
    private static final ThreadLocal<State> state = new ThreadLocal();
    private static SystematicNameConverter systematicNameConverter = new SystematicNameConverter();
    private static chemaxon.marvin.io.formats.name.nameimport.SystematicNameConverter vieuxCon = IUPACNameReader.systematicNameConverter;
    private static IonConverter ionConverter = new IonConverter();
    private static ElementConverter elementConverter = new ElementConverter();

    public static final State getState() {
        State res = state.get();
        if (res != null) {
            return res;
        }
        res = new State(new Options());
        state.set(res);
        return res;
    }

    public static final Options getOptions() {
        return N2S.getState().options;
    }

    public static Molecule importName(String name, Options options, String licenseEnvironment) throws NameFormatException, LicenseException {
        N2S.checkLicense(licenseEnvironment);
        state.set(new State(options));
        N2S.getState().optimizingPrefixes = N2S.setDataMiningMode(options.dataMining);
        name = Standardize.decodeHTML(name);
        if (!N2S.getOptions().ocrCorrection) {
            return N2S.importName(name);
        }
        Molecule res = N2S.importWithOcrCorrection(name);
        return res;
    }

    private static Molecule importWithOcrCorrection(String name) throws NameFormatException {
        name = OcrCorrector.correctOCRerrors(name);
        try {
            return N2S.importName(name);
        }
        catch (NameFormatException e) {
            String corrected;
            NameFormatException error = e;
            String corrected2 = OcrCorrector.correctOCRerrorsStage2(name);
            if (!corrected2.equals(name)) {
                name = corrected2;
                try {
                    return N2S.importName(name);
                }
                catch (NameFormatException e2) {
                    error = e2;
                }
            }
            if (!(corrected = OcrCorrector.correctOCRerrorsStage3(name)).equals(name)) {
                return N2S.importName(corrected);
            }
            throw error;
        }
    }

    private static Molecule importName(String name) throws NameFormatException {
        String[] names = TextUtils.split(name, ';');
        Molecule mol = Util.newMolecule();
        mol.setName(name);
        for (int i = 0; i < names.length; ++i) {
            try {
                String singleName = names[i].trim();
                if (singleName.equals("")) continue;
                mol.fuse(N2S.importSingleName(singleName));
                continue;
            }
            catch (RuntimeException e) {
                throw new NameFormatException(e);
            }
        }
        String approx = N2S.state.get().approximation;
        if (approx != null) {
            mol.setProperty("Approximate", approx);
        }
        if (N2S.state.get().ambiguous) {
            mol.setProperty("Ambiguous", "ambiguous");
        }
        if (N2S.state.get().generic) {
            mol.setProperty("type", "generic");
        } else if (N2S.state.get().systematic) {
            mol.setProperty("type", "systematic");
        } else if (N2S.state.get().common) {
            mol.setProperty("type", "common");
        }
        mol.setProperty("ValenceCheck", null);
        return mol;
    }

    static Molecule importSingleName(String name) throws NameFormatException {
        ArrayList<NameConverter> converters;
        Options options = N2S.getOptions();
        name = Standardize.get(name, false);
        NameFormatException mostInformativeFailure = null;
        if (options.systematic == Boolean.TRUE) {
            converters = new ArrayList();
            if (options.nextGen) {
                converters.add(systematicNameConverter);
            }
            if (options.vieuxCon) {
                converters.add(vieuxCon);
            }
        } else {
            converters = Bridge.getNameConverters(true);
        }
        for (NameConverter converter : converters) {
            if (options.systematic == Boolean.FALSE && (converter == systematicNameConverter || converter == vieuxCon) || !options.nextGen && converter == systematicNameConverter || !options.vieuxCon && converter == vieuxCon) continue;
            try {
                Molecule res = converter.convert(name);
                if (res == null) continue;
                return res;
            }
            catch (NameFormatException e) {
                if (e instanceof NameFormatException.FilteredCase) {
                    throw e;
                }
                mostInformativeFailure = N2S.mostInformativeFailure(mostInformativeFailure, e);
            }
        }
        if (mostInformativeFailure != null) {
            throw mostInformativeFailure;
        }
        throw new NameFormatException("Name could not be converted to structure: " + name);
    }

    private static NameFormatException mostInformativeFailure(NameFormatException current, NameFormatException challenger) {
        if (current == null) {
            return challenger;
        }
        if (challenger instanceof NamePrefixException) {
            if (!(current instanceof NamePrefixException)) {
                return challenger;
            }
            NamePrefixException p1 = (NamePrefixException)current;
            NamePrefixException p2 = (NamePrefixException)challenger;
            if (p2.getParsed().length() > p1.getParsed().length()) {
                return p2;
            }
            return p1;
        }
        return current;
    }

    public static void setUserDefineDictionary(String path) {
        Dictionary.getUserDict(path);
    }

    public static void resetUserDefineDictionaryPath() {
        Dictionary.getUserDict(Dictionary.USER_PATH);
    }

    public static void reloadUserDefineDictionary() {
        Dictionary.getUserDict().reloadDict();
    }

    static void checkLicense(String licenseEnvironment) throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Name to Structure", licenseEnvironment);
    }

    private static boolean setDataMiningMode(boolean dataMining) {
        boolean allOK = true;
        for (NameConverter conv : Bridge.getNameConverters(true)) {
            allOK &= conv.setPrefixMode(dataMining);
        }
        return allOK;
    }

    public static void main(String[] args) throws NameFormatException, LicenseException {
        String name = args.length > 0 ? args[0] : "DNS";
        System.out.println(N2S.importName(name, new Options(), ""));
    }

    static {
        NameConverters.add(Dictionary.getUserDict(), -100, true);
        NameConverters.add(new CASNumberConverter(), -150, true);
        NameConverters.add(elementConverter, -160, true);
        NameConverters.add(Dictionary.getTraditionalDict(), -200, true);
        NameConverters.add(systematicNameConverter, -300, true);
        NameConverters.add(vieuxCon, -301, true);
        NameConverters.add(ionConverter, -400, true);
    }

    public static class State {
        public boolean rel = false;
        public boolean structureMatches;
        public final Options options;
        public boolean optimizingPrefixes;
        String approximation = null;
        public boolean ambiguous;
        public boolean generic;
        public boolean systematic;
        public boolean common;

        public State(Options options) {
            this.options = options;
        }

        public void warnApproximation(String message) {
            this.approximation = this.approximation == null ? message : this.approximation + "; " + message;
        }
    }
}

