/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.name.NameImport;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.naming.n2s.Standardize;
import chemaxon.naming.n2s.SystematicNameConverter;
import chemaxon.naming.n2s.lex.NameLexer;
import chemaxon.naming.n2s.lex.data.BracketToken;
import chemaxon.naming.n2s.lex.data.Dearomatizer;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.RevolutionParser;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class NameImportDebugger {
    private static String[] getTokenInfo(Token token) {
        String[] info = new String[4];
        info[0] = token.getName();
        info[1] = token.getClass().toString();
        int index = info[1].lastIndexOf(46);
        info[1] = info[1].substring(index + 1);
        info[2] = token.getValue();
        info[3] = token.getTypeInString();
        return info;
    }

    private static void test(String name) {
        try {
            System.out.println(new NameImport().importName(name).toFormat("mrv"));
        }
        catch (MolFormatException e) {
            System.out.println(e.toString());
            e.printStackTrace(System.out);
        }
    }

    public static void main(String[] args) throws MolFormatException {
        Molecule res;
        Object s;
        boolean dataMining = false;
        String name = args.length == 1 ? args[0] : NameImportDebugger.readDebuggingInstructions();
        System.out.println("Name: " + name);
        System.out.println();
        name = Standardize.get(name);
        try {
            ArrayList<Token> list = NameLexer.parse(name, dataMining);
            NameImportDebugger.printTokens(list);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        String oldSmiles = null;
        try {
            System.out.println("\nREVOLUTION");
            IUPACParserCore.revolution = true;
            IUPACParserCore.debug = true;
            ArrayList<chemaxon.marvin.io.formats.name.nameimport.lex.data.Token> tokens = chemaxon.marvin.io.formats.name.nameimport.lex.NameLexer.parse(name, dataMining);
            s = IUPACParserCore.parseTokens(tokens);
            System.out.println();
            res = ((Structure)s).getMolecule();
            oldSmiles = NameImportDebugger.displayMolecule(res);
            System.out.println(oldSmiles);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        try {
            String fixedSmiles;
            String newSmiles;
            System.out.println("\nREVOLUTION 2");
            RevolutionParser.debug = true;
            Dearomatizer.dbg = true;
            ArrayList<Token> list = NameLexer.parse(name, dataMining);
            s = new RevolutionParser().parse(list, dataMining);
            System.out.println();
            res = ((Str)s).getCompleteStructureClear();
            try {
                newSmiles = res.toFormat("cxsmiles");
            }
            catch (Exception e) {
                newSmiles = NameImportDebugger.displayMolecule(res);
            }
            System.out.println(newSmiles);
            SystematicNameConverter.check(res);
            try {
                fixedSmiles = res.toFormat("cxsmiles");
            }
            catch (Exception e) {
                fixedSmiles = NameImportDebugger.displayMolecule(res);
            }
            if (!fixedSmiles.equals(newSmiles)) {
                System.out.println("Fixed to: " + fixedSmiles);
                newSmiles = fixedSmiles;
            }
            if (!newSmiles.equals(oldSmiles)) {
                System.out.println(oldSmiles + " !=");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    private static String readDebuggingInstructions() {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(NameImportDebugger.class.getResourceAsStream("/chemaxon/naming/n2s/debug")));
            return r.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String displayMolecule(Molecule molecule) {
        String res = Util.getDictionarySmiles(molecule);
        if (molecule.hasValenceError()) {
            res = res + " [valence error]";
        }
        return res;
    }

    private static void printTokens(ArrayList<Token> list) {
        NameImportDebugger.printTokens(list, 0);
        System.out.println();
    }

    private static void printTokens(ArrayList<Token> list, int depth) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < depth; ++j) {
                System.out.print('\t');
            }
            Token token = list.get(i);
            String[] info = NameImportDebugger.getTokenInfo(token);
            for (int j = 0; j < info.length; ++j) {
                System.out.print(info[j] + "\t");
                if (info[j].length() >= 8) continue;
                System.out.print("\t");
            }
            System.out.println();
            if (!(token instanceof BracketToken)) continue;
            NameImportDebugger.printTokens(((BracketToken)token).getInside(), depth + 1);
        }
    }
}

