/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.checkers.ValenceErrorChecker;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.naming.Bridge;
import chemaxon.naming.NameConverter;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.NamePrefixException;
import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.NameLexer;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.RevolutionParser;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class SystematicNameConverter
implements NameConverter {
    private boolean prefixMode;

    @Override
    public Molecule convert(String name) throws NameFormatException {
        if (SystematicNameConverter.blackListed(name)) {
            return null;
        }
        ArrayList<Token> tokens = NameLexer.parse(name, this.prefixMode || N2S.getOptions().ocrCorrection);
        try {
            Str root = new RevolutionParser().parse(tokens, this.prefixMode);
            Molecule mol = root.getCompleteStructureClear();
            SystematicNameConverter.check(mol);
            N2S.getState().systematic = true;
            return mol;
        }
        catch (RuntimeException e) {
            NameFormatException nfe = N2S.getOptions().dataMining ? new NamePrefixException(name) : (e.getMessage() == null && e.getStackTrace().length > 0 ? new NameFormatException("NPE: " + e.getStackTrace()[0].toString()) : new NameFormatException(e));
            if (tokens != null) {
                Bridge.setTokens(nfe, tokens);
            }
            throw nfe;
        }
    }

    static void check(Molecule mol) {
        ValenceErrorChecker checker = new ValenceErrorChecker();
        StructureCheckerResult result = checker.check(mol);
        if (result != null && !SystematicNameConverter.valenceFixes(result)) {
            throw new RuntimeException("Valence error");
        }
        if (Util.hasValenceError(mol)) {
            throw new RuntimeException("Valence error (special check)");
        }
    }

    private static boolean valenceFixes(StructureCheckerResult result) {
        for (MolAtom a : result.getAtoms()) {
            if (SystematicNameConverter.fixValence(a)) continue;
            return false;
        }
        return true;
    }

    private static boolean fixValence(MolAtom a) {
        long grinv = a.getParent().getGrinvCC();
        if (a.getValenceProp() != -1) {
            a.setValenceProp(-1);
            a.getParent().incGrinvCCOnly();
        }
        int val = a.getValence();
        int h = a.getImplicitHcount();
        int charge = a.getCharge();
        int radical = a.getRadical();
        switch (a.getAtno()) {
            case 16: {
                if (val != 3 || h != 0 || charge != 0 || radical != 0) break;
                MolAtom Ominus = SystematicNameConverter.getNeighbour(a, 1, 8, -1);
                if (Ominus != null) {
                    Ominus.setCharge(0);
                    a.getBondTo(Ominus).setType(2);
                    break;
                }
                a.setRadical(1);
            }
        }
        if (a.getParent().getGrinvCC() == grinv) {
            return false;
        }
        a.valenceCheck();
        return !a.hasValenceError();
    }

    private static MolAtom getNeighbour(MolAtom a, int bondType, int atno, int charge) {
        for (MolAtom b : a.getLigands()) {
            MolBond bond;
            if (b.getAtno() != atno || b.getCharge() != charge || (bond = a.getBondTo(b)).getType() != bondType) continue;
            return b;
        }
        return null;
    }

    @Override
    public boolean setPrefixMode(boolean prefixMode) {
        this.prefixMode = prefixMode;
        return true;
    }

    private static boolean blackListed(String name) {
        if ((name = name.toLowerCase()).endsWith(" but")) {
            return true;
        }
        return name.equals("tell") || name.equals("formal") || name.equals("germ") || name.equals("voltage");
    }
}

