/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.lex.data.BracketToken;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.HeteroAtomStr;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class UtilLegacy {
    public static final int PRIME = 1000000;
    public static final int LETTER = 100;
    public static final int ALPHA = 0x7FFFFFFC;
    public static final int BETA = 0x7FFFFFFD;
    public static final int GAMMA = 0x7FFFFFFE;
    public static final int OMEGA = Integer.MAX_VALUE;

    public static boolean isGreekLetter(int numbering) {
        return numbering == 0x7FFFFFFC || numbering == 0x7FFFFFFD || numbering == 0x7FFFFFFE || numbering == Integer.MAX_VALUE;
    }

    public static int greekLetterToNumbering(int greekLetter) {
        switch (greekLetter) {
            case 0x7FFFFFFC: {
                return 1;
            }
            case 0x7FFFFFFD: {
                return 2;
            }
            case 0x7FFFFFFE: {
                return 3;
            }
        }
        return -1;
    }

    public static int stringToLocant(String locant) {
        try {
            return Integer.parseInt(locant);
        }
        catch (NumberFormatException e) {
            if (locant.equals("alpha")) {
                return 0x7FFFFFFC;
            }
            if (locant.equals("beta")) {
                return 0x7FFFFFFD;
            }
            if (locant.equals("gamma")) {
                return 0x7FFFFFFE;
            }
            int value = 0;
            char[] chloc = locant.toCharArray();
            for (int i = 0; i < chloc.length; ++i) {
                char asc;
                if (Character.isDigit(chloc[i])) {
                    value *= 10;
                    value += Character.getNumericValue(chloc[i]);
                    continue;
                }
                if (Character.isLowerCase(chloc[i])) {
                    if (value == 0) {
                        return -1;
                    }
                    value *= 100;
                    asc = chloc[i];
                    value += asc - 96;
                    continue;
                }
                if (Character.isUpperCase(chloc[i])) {
                    value *= 100;
                    asc = chloc[i];
                    value += 30 + asc - 65;
                    continue;
                }
                if (chloc[i] == '\'') {
                    value += 1000000;
                    continue;
                }
                if (chloc[i] != '\"') continue;
                value += 2000000;
            }
            return Math.max(value, 1);
        }
    }

    public static String basicSmiles(String cxsmiles) {
        String res = cxsmiles;
        if (res == null) {
            return "";
        }
        int start = res.indexOf(" |");
        if (start != -1) {
            res = res.substring(0, start);
        }
        if ((start = res.indexOf("{")) != -1) {
            res = res.substring(0, start);
        }
        return res;
    }

    public static boolean isChain(String cxsmiles) {
        if (cxsmiles.endsWith("Chain}")) {
            return true;
        }
        String smiles = UtilLegacy.basicSmiles(cxsmiles);
        return smiles.replaceAll("[C=#]", "").length() == 0;
    }

    public static boolean isChainEnding(String suffix) {
        return suffix.equals(".") || suffix.equals("=.") || suffix.equals("#.") || suffix.equals("|.") || suffix.equals("|=.") || suffix.equals("|#.");
    }

    public static boolean isNumbering(Token token) {
        if (token instanceof LocantList) {
            return true;
        }
        if (!(token instanceof BracketToken)) {
            return false;
        }
        BracketToken bracket = (BracketToken)token;
        if (bracket.getInsideLength() != 1) {
            return false;
        }
        return bracket.getInside().get(0) instanceof LocantList;
    }

    public static boolean isIonNumbering(Token token) {
        if (!UtilLegacy.isNumbering(token)) {
            return false;
        }
        return ((BracketToken)token).getInside().get(0).getType() == 4;
    }

    public static int matchCount(String str, String pattern) {
        int count = -1;
        int index = 0;
        while (index > -1 && index != (index = str.indexOf(pattern, index + 1))) {
            ++count;
        }
        return count;
    }

    public static int atomCount(String smiles) {
        if (smiles.equals("[HWE]")) {
            return 0;
        }
        if (smiles.indexOf("{") > 0) {
            smiles = smiles.substring(0, smiles.indexOf("{"));
        }
        int counter = 0;
        char[] charsmiles = smiles.toCharArray();
        for (int i = 0; i < charsmiles.length; ++i) {
            if (!Character.isLetter(charsmiles[i]) || charsmiles[i] == 'H' && (i >= charsmiles.length - 1 || !Character.isLowerCase(charsmiles[i + 1])) || charsmiles[i] == 'h' || !Character.isUpperCase(charsmiles[i]) && charsmiles[i] != 'c' && (i <= 0 || Character.isUpperCase(charsmiles[i - 1])) && i != 0) continue;
            ++counter;
        }
        return counter;
    }

    public static boolean isAtom(MolAtom atom, int atno) {
        if (atom == null) {
            return false;
        }
        return atom.getAtno() == atno;
    }

    public static boolean isOxygen(MolAtom atom) {
        return UtilLegacy.isAtom(atom, 8);
    }

    public static boolean isOxygenOrAnalog(MolAtom atom) {
        return UtilLegacy.isAtom(atom, 8) || UtilLegacy.isAtom(atom, 16) || UtilLegacy.isAtom(atom, 34) || UtilLegacy.isAtom(atom, 52);
    }

    public static boolean isNitrogen(MolAtom atom) {
        return UtilLegacy.isAtom(atom, 7);
    }

    public static boolean isRGroup(MolAtom atom) {
        return UtilLegacy.isAtom(atom, 134);
    }

    public static boolean isHetero(Str struc) {
        return struc instanceof HeteroAtomStr;
    }

    public static void addBond(Molecule mol, MolAtom atom1, MolAtom atom2, int type) {
        if (atom1.equals(atom2) || atom1.isBoundTo(atom2)) {
            throw new NameImportException("Error during building the molecule.");
        }
        boolean isRelative = (type & 0x200) != 0;
        MolBond b = new MolBond(atom1, atom2, type &= 0xFFFFFDFF);
        mol.add(b);
        if ((type & 0x30) != 0) {
            if (isRelative) {
                atom1.setStereoGroupType(2);
                atom1.setStereoGroupNumber(1);
            }
            if (mol.getDim() == 0) {
                Cleaner.clean(mol, 2, null);
                b.setFlags(type);
            }
        }
    }

    public static int getLastIndexOfElement(String smiles, int position) {
        int tmppos = smiles.indexOf(":" + Integer.toString(position) + "]");
        int bracketCounter = 0;
        if (tmppos > -1) {
            int j;
            String tmp = smiles.substring(tmppos + Integer.toString(position).length() + 2);
            for (j = 0; j < tmp.length() && (bracketCounter != 0 || tmp.charAt(j) != '[' && tmp.charAt(j) != ')'); ++j) {
                if (tmp.charAt(j) == '(') {
                    ++bracketCounter;
                }
                if (tmp.charAt(j) != ')') continue;
                --bracketCounter;
            }
            return tmppos + smiles.substring(tmppos).indexOf(93) + j;
        }
        char[] charsmiles = smiles.toCharArray();
        if (position <= 0) {
            position = 1;
        }
        if (position > charsmiles.length) {
            return charsmiles.length;
        }
        int counter = 0;
        int i = -1;
        while (counter <= position && i < charsmiles.length - 1) {
            ++i;
            if (bracketCounter == 0) {
                if (Character.isLetter(charsmiles[i]) && (Character.isUpperCase(charsmiles[i]) || charsmiles[i] == 'c' || i > 0 && !Character.isUpperCase(charsmiles[i - 1]) || i == 0)) {
                    ++counter;
                } else if (counter == position && charsmiles[i] == '[') break;
            }
            if (charsmiles[i] == '[') {
                if (bracketCounter == 0) {
                    ++counter;
                }
                ++bracketCounter;
            }
            if (charsmiles[i] != ']') continue;
            --bracketCounter;
        }
        if (i > 0 && (charsmiles[i - 1] == '#' || charsmiles[i - 1] == '=')) {
            --i;
        }
        if (i == 0 || i == charsmiles.length - 1 && counter <= position) {
            return i;
        }
        return i - 1;
    }

    public static int getFirstIndexOfElement(String smiles, int position) {
        String seps = "()";
        int tmppos = smiles.indexOf(":" + Integer.toString(position) + "]");
        if (tmppos > -1) {
            String tmp = smiles.substring(0, tmppos);
            return tmp.lastIndexOf("[");
        }
        if (position <= 1) {
            return 0;
        }
        int pos = UtilLegacy.getLastIndexOfElement(smiles, position - 1) + 1;
        while (seps.indexOf(smiles.charAt(pos)) > -1) {
            ++pos;
        }
        return pos;
    }

    public static boolean isName(String name, String key) {
        if (key.equals(name)) {
            return true;
        }
        return key.endsWith("e") && key.substring(0, key.length() - 1).equals(name);
    }

    public static String readURL(String url) throws IOException {
        return UtilLegacy.readURL(url, null);
    }

    public static String readURL(String url, String referer) throws IOException {
        try {
            String line;
            URLConnection conn = new URL(url).openConnection();
            if (referer != null) {
                conn.setRequestProperty("REFERER", referer);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuilder res = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                res.append(line).append('\n');
            }
            return res.toString();
        }
        catch (MalformedURLException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static boolean isRingAtom(MolAtom a) {
        try {
            int i = a.getBondCount();
            while (--i >= 0) {
                if (!a.getParent().isRingBond(a.getParent().indexOf(a.getBond(i)))) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

