/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex;

import chemaxon.naming.n2s.lex.data.BracketToken;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.Separator;
import chemaxon.naming.n2s.lex.data.Token;
import java.util.ArrayList;
import java.util.List;

public class CASRewriter {
    private final boolean dataMining;
    private final ArrayList<Token> tokens;
    private final ArrayList<Token> res;
    int pos;
    boolean firstFragment;
    public static boolean dbg = false;

    public CASRewriter(ArrayList<Token> tokens, boolean dataMining) {
        this.tokens = tokens;
        this.dataMining = dataMining;
        this.res = new ArrayList(tokens.size());
    }

    public ArrayList<Token> reorder() {
        if (dbg) {
            System.out.println("CAS input : " + this.tokens);
        }
        while (this.copyStereoAtEnd()) {
        }
        int endParent = this.nextComma(false);
        List<Token> parent = this.tokens.subList(0, endParent);
        int i = this.tokens.size();
        while (--i >= endParent) {
            Token token = this.tokens.get(i);
            if (!(token instanceof BracketToken)) continue;
            BracketToken bracket = (BracketToken)token;
            if (bracket.closed) continue;
            bracket.inside.addAll(this.res);
            this.res.clear();
            bracket.inside.addAll(parent);
            parent = null;
            break;
        }
        if (parent != null) {
            this.res.addAll(parent);
        }
        if (dbg) {
            System.out.println("CAS parent: " + this.res);
        }
        this.firstFragment = true;
        int endFragment = endParent;
        while (endFragment != this.tokens.size()) {
            this.pos = endFragment + 1;
            endFragment = this.nextComma(true);
            List<Token> fragment = this.tokens.subList(this.pos, endFragment);
            this.handleFragment(fragment);
            this.firstFragment = false;
        }
        if (this.res.get(0).is("\u200b")) {
            this.res.remove(0);
        }
        if (this.res.get(this.res.size() - 1).is("\u200b")) {
            this.res.remove(this.res.size() - 1);
        }
        if (this.res.get(this.res.size() - 1).is(" ")) {
            this.res.remove(this.res.size() - 1);
        }
        if (dbg) {
            System.out.println("CAS output: " + this.res);
        }
        this.removeSpaceAroundDash(this.res);
        return this.res;
    }

    private void handleFragment(List<Token> fragment) {
        if (fragment.isEmpty()) {
            return;
        }
        Token first = fragment.get(0);
        if (first.is("ester with")) {
            int start = 0;
            while (fragment.get(start + 1).is(" ")) {
                ++start;
            }
            this.res.add(0, Separator.space());
            this.res.add(0, first);
            this.res.add(0, Separator.space());
            int i = fragment.size();
            while (--i > start) {
                this.res.add(0, fragment.get(i));
            }
            return;
        }
        Token last = fragment.get(fragment.size() - 1);
        if (last.is("ane") || last.is("ene") || last.is("yne")) {
            throw new RuntimeException("Invalid CAS name");
        }
        if (!(!this.dataMining || last.is("-") || last.endsWith("ester") || last.endsWith("acid") || last.endsWith("alcohol") || last.endsWith("acetate") || last.endsWith("ether") || last.endsWith("hydroxide") || last.endsWith("o") || last.endsWith(")"))) {
            throw new RuntimeException("Invalid CAS name, fragment ends with: " + last);
        }
        if (last.is("ide") || last.endsWith("ide")) {
            if (!this.res.isEmpty()) {
                this.res.add(Separator.space());
            }
            this.res.addAll(fragment);
        } else {
            if (last.is("ester") || last.endsWith("ate")) {
                this.res.add(0, Separator.space());
            }
            this.res.add(0, new Separator('\u200b'));
            int end = fragment.size();
            if (this.firstFragment && fragment.get(end - 1).is("-") && fragment.get(end - 2) instanceof BracketToken) {
                --end;
            }
            int i = end;
            while (--i >= 0) {
                this.res.add(0, fragment.get(i));
            }
        }
    }

    private void removeSpaceAroundDash(ArrayList<Token> tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            Token t = tokens.get(i);
            if (t instanceof BracketToken) {
                this.removeSpaceAroundDash(((BracketToken)t).inside);
                continue;
            }
            if (i == 0 || !t.is("-")) continue;
            while (i > 0 && tokens.get(i - 1).is(" ")) {
                tokens.remove(--i);
            }
            while (i < tokens.size() - 1 && tokens.get(i + 1).is(" ")) {
                tokens.remove(i + 1);
            }
        }
    }

    private boolean copyStereoAtEnd() {
        if (this.tokens.size() <= 2) {
            return false;
        }
        int start = this.tokens.size() - 1;
        Token last = this.tokens.get(start);
        if (last.is("-")) {
            start = this.tokens.size() - 2;
            last = this.tokens.get(start);
        }
        if (!(last instanceof LocantList)) {
            return false;
        }
        LocantList locants = (LocantList)last;
        if (!locants.isStereo() && !locants.isAllNumGreek()) {
            return false;
        }
        if (this.tokens.get(start - 1).is(",") || this.tokens.get(start - 1).is(" ")) {
            this.tokens.remove(--start);
        }
        if (!this.tokens.get(this.tokens.size() - 1).is("-")) {
            this.res.add(0, Separator.dash());
        }
        int i = this.tokens.size();
        while (--i >= start) {
            this.res.add(0, this.tokens.remove(i));
        }
        return true;
    }

    int nextComma(boolean dashSpace) {
        int cur;
        for (cur = this.pos; cur < this.tokens.size(); ++cur) {
            Token t = this.tokens.get(cur);
            if ((!dashSpace || !t.is("-") || !this.hasSpaceIde(this.tokens, cur + 1)) && t != Separator.comma) continue;
            if (cur == this.tokens.size() - 1) break;
            Token next = this.tokens.get(cur + 1);
            if (next.is(" ")) {
                this.tokens.remove(cur + 1);
                break;
            }
            if (next instanceof BracketToken) break;
        }
        return cur;
    }

    private boolean hasSpaceIde(ArrayList<Token> tokens, int cur) {
        if (cur == tokens.size()) {
            return false;
        }
        if (!tokens.get(cur).is(" ")) {
            return false;
        }
        while (++cur < tokens.size()) {
            Token t = tokens.get(cur);
            if (t.is("ide")) {
                return true;
            }
            if (!t.is(",")) continue;
            return false;
        }
        return false;
    }
}

