/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex;

import chemaxon.naming.NamePrefixException;
import chemaxon.naming.n2s.lex.StructureLexer;
import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.BondNumber;
import chemaxon.naming.n2s.lex.data.BracketToken;
import chemaxon.naming.n2s.lex.data.EndingToken;
import chemaxon.naming.n2s.lex.data.Hydro;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.Separator;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.StereoNumber;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.lex.data.Token;
import java.util.ArrayList;

public class PostLexer {
    /*
     * Enabled aggressive block sorting
     */
    static ArrayList<Token> fix(ArrayList<Token> tokens) {
        Token last;
        Token prev = null;
        for (int i = 0; i < tokens.size(); ++i) {
            LocantList locants2;
            LocantList locants1;
            Token t;
            block23: {
                t = tokens.get(i);
                if (t instanceof BracketToken) {
                    PostLexer.fix(((BracketToken)t).inside);
                }
                if (t.getValue().endsWith("IGNORE]")) {
                    tokens.remove(i--);
                }
                if (t.is("rac") && tokens.get(i + 1).is("-")) {
                    tokens.remove(i);
                    tokens.remove(i);
                    --i;
                    continue;
                }
                if (t instanceof LocantList && ((LocantList)t).getType() == 12 && i + 2 < tokens.size()) {
                    Token next1 = tokens.get(i + 1);
                    Token next2 = tokens.get(i + 2);
                    if (!next1.is("-") && !next1.is(",")) {
                        if (next1.is(" ")) {
                            if (next2.is("-")) {
                                tokens.remove(i + 1);
                                break block23;
                            } else {
                                if (next2 instanceof LocantList && ((LocantList)t).getType() == ((LocantList)next2).getType() && ((LocantList)t).isStereo() == ((LocantList)next2).isStereo()) {
                                    locants1 = (LocantList)t;
                                    locants2 = (LocantList)next2;
                                    locants1.tryAddLocant(locants2);
                                    tokens.remove(i + 2);
                                    tokens.remove(i + 1);
                                    --i;
                                    continue;
                                }
                                tokens.set(i + 1, new Separator('-'));
                                continue;
                            }
                        }
                        if (next1 instanceof Str) {
                            tokens.add(i + 1, new Separator('-'));
                            continue;
                        }
                    }
                }
            }
            if (t instanceof Hydro && prev instanceof LocantList) {
                tokens.set(i - 1, t);
                tokens.set(i, prev);
                Token next = tokens.get(i + 1);
                if (!(next.is("-") || next.is(",") || next.is(" ") || next instanceof Hydro)) {
                    tokens.add(++i, new Separator('-'));
                }
                prev = t;
                --i;
                continue;
            }
            if (t.is(",") && prev instanceof LocantList) {
                int nextIndex = i + 1;
                Token next = tokens.get(nextIndex);
                if (next.is(" ")) {
                    next = tokens.get(++nextIndex);
                }
                if (next instanceof LocantList) {
                    locants1 = (LocantList)prev;
                    locants2 = (LocantList)next;
                    locants1.tryAddLocant(locants2);
                    tokens.remove(nextIndex);
                    tokens.remove(i);
                    i -= 2;
                    prev = null;
                    continue;
                }
            }
            if (t instanceof BracketToken && prev instanceof LocantList && prev.getType() != 5) {
                tokens.add(i++, new Separator('-'));
            }
            if ("[ANNULENE]".equals(t.getValue()) && i >= 4 && tokens.get(i - 4).getName().equals("benz")) {
                tokens.set(i - 4, StructureToken.create("benzo", (String)StructureLexer.getDict().get("benzo")));
            }
            if (t instanceof LocantList && prev instanceof LocantList) {
                AtomLocant al;
                LocantList l1 = (LocantList)prev;
                LocantList l2 = (LocantList)t;
                Locant ll1 = l1.getLocant(l1.size() - 1);
                if (ll1 instanceof AtomLocant && (al = (AtomLocant)ll1).setLocantIndex(l2)) {
                    tokens.remove(i);
                    --i;
                    continue;
                }
                if (l2.hasLocant() && l2.getLocant(0) instanceof StereoNumber) {
                    tokens.remove(i);
                    tokens.add(i - 1, l2);
                    tokens.add(i, new Separator('-'));
                    ++i;
                    continue;
                }
                Locant ll2 = l2.getSingleLocant();
                if (ll2 != null && ll1 instanceof SimpleLocant) {
                    SimpleLocant bondNumberStart = (SimpleLocant)ll1;
                    BondNumber bond = new BondNumber(bondNumberStart, (SimpleLocant)ll2);
                    l1.changeLastLocant(bond);
                    tokens.remove(i);
                    --i;
                    continue;
                }
            }
            prev = t;
        }
        Token token = last = tokens.isEmpty() ? null : tokens.get(tokens.size() - 1);
        if (tokens.size() > 1 && PostLexer.isIonNumbering(last)) {
            tokens.add(new Separator(' '));
            tokens.add(new EndingToken("ion", "[ION]"));
        }
        return tokens;
    }

    static boolean canBeValidName(ArrayList<Token> tokenList, boolean dataMining) throws NamePrefixException {
        if (tokenList.isEmpty()) {
            return false;
        }
        Token lastToken = tokenList.get(tokenList.size() - 1);
        String name = lastToken.getName();
        String value = (String)StructureLexer.getDict().get(name + "a");
        return value == null || !value.endsWith("*");
    }

    private static boolean isIonNumbering(Token token) {
        LocantList numbering = null;
        if (token instanceof LocantList) {
            numbering = (LocantList)token;
        }
        if (token instanceof BracketToken) {
            numbering = ((BracketToken)token).toNumbering();
        }
        return numbering != null && numbering.getType() == 4;
    }
}

