/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex;

import chemaxon.naming.n2s.lex.TextSource;
import java.io.CharArrayReader;
import java.io.Reader;

public class StringSource
implements TextSource {
    private final String name;
    private final int len;
    private final char[] chars;
    protected int index = 0;

    StringSource(String name) {
        this.name = name;
        this.len = name.length();
        this.chars = name.toCharArray();
    }

    @Override
    public boolean hasMore() {
        return this.index < this.len;
    }

    @Override
    public char read() {
        if (this.index >= this.len) {
            return '\u0000';
        }
        return this.chars[this.index++];
    }

    @Override
    public char peek(int offset) {
        int location = this.index + offset;
        if (location < 0 || location >= this.len) {
            return '\u0000';
        }
        return this.chars[location];
    }

    @Override
    public void move(int offset) {
        this.index += offset;
    }

    @Override
    public boolean peek(String prefix) {
        return this.name.substring(this.index).startsWith(prefix);
    }

    @Override
    public boolean read(String prefix) {
        if (!this.peek(prefix)) {
            return false;
        }
        this.move(prefix.length());
        return true;
    }

    @Override
    public boolean read(String prefix, String ... allowedContinuations) {
        if (!this.name.substring(this.index).startsWith(prefix)) {
            return false;
        }
        String continuation = this.name.substring(this.index + prefix.length());
        for (String candidate : allowedContinuations) {
            if (!continuation.startsWith(candidate)) continue;
            this.index += prefix.length();
            return true;
        }
        return false;
    }

    @Override
    public boolean readToEnd(String text) {
        if (!this.name.substring(this.index).equals(text)) {
            return false;
        }
        this.index += text.length();
        return true;
    }

    @Override
    public boolean read(char c) {
        if (this.peek(0) != c) {
            return false;
        }
        ++this.index;
        return true;
    }

    @Override
    public int remaining() {
        return this.name.length() - this.index;
    }

    @Override
    public String remainder() {
        return this.name.substring(this.index);
    }

    @Override
    public String remainder(int len) {
        return this.name.substring(this.index, this.index + len);
    }

    @Override
    public Reader getReader() {
        return new CharArrayReader(this.chars, this.index, this.chars.length - this.index);
    }

    @Override
    public Reader getReader(int skip) {
        return new CharArrayReader(this.chars, this.index + skip, this.chars.length - this.index - skip);
    }

    public String toString() {
        return "StringSource { remaining: " + this.remainder() + " }";
    }

    @Override
    public String getReadText() {
        return this.name.substring(0, this.index);
    }
}

