/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.ComplexLocant;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class Anhydro
extends Str {
    public Anhydro() {
        this.name = "anhydro";
    }

    @Override
    public Str cloneMe() {
        return this;
    }

    @Override
    public Molecule createParentMolecule() {
        return null;
    }

    @Override
    public boolean consume(LocantList locants, int mul) {
        if (this.locantsBefore.hasLocant()) {
            return false;
        }
        this.locantsBefore = locants;
        return true;
    }

    @Override
    protected void connectToParent(Str parent) {
        if (!this.locantsBefore.hasLocant()) {
            throw new RuntimeException("Missing locants for anhydro");
        }
        if (this.locantsBefore.getType() == 3) {
            for (Locant l : this.locantsBefore.getLocantsList()) {
                ComplexLocant cl = (ComplexLocant)l;
                this.merge(cl.getFirstLocant(), cl.getSecondLocant());
            }
            return;
        }
        if (this.locantsBefore.size() != 2) {
            throw new RuntimeException("Expecting 2 locants for anhydro");
        }
        Locant l0 = this.locantsBefore.getLocant(0);
        Locant l1 = this.locantsBefore.getLocant(1);
        this.merge(l0, l1);
    }

    private void merge(Locant l0, Locant l1) {
        l0 = new AtomLocant(l0, 8);
        l1 = new AtomLocant(l1, 8);
        MolAtom o0 = this.parent.getAtom(l0);
        MolAtom o1 = this.parent.getAtom(l1);
        if (o0.getBond(0).getType() == 2) {
            o0.getBond(0).setType(1);
        }
        if (o1.getBond(0).getType() == 2) {
            o1.getBond(0).setType(1);
        }
        this.parent.mergeAtoms(o0, o1);
    }
}

