/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.Util;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class Anhyride
extends Str {
    public Anhyride() {
        this.name = "anhydride";
    }

    @Override
    public Str cloneMe() {
        return this.clone();
    }

    @Override
    public Molecule createParentMolecule() {
        return Util.newMolecule();
    }

    @Override
    public void generate() {
        if (this.substituents.size() != 1) {
            throw new RuntimeException();
        }
        Str acid = (Str)this.substituents.get(0);
        this.substituents = null;
        Molecule acidM = acid.getMol();
        this.setMol(acidM);
        acid.getLocantMap();
        MolAtom o1 = null;
        MolAtom o2 = null;
        for (MolAtom a : acidM.getAtomArray()) {
            if (!Anhyride.hasKeyword(a, "ester")) continue;
            if (o1 == null) {
                o1 = a;
                continue;
            }
            if (o2 == null) {
                o2 = a;
                continue;
            }
            throw new RuntimeException("Too many acids in anhydride");
        }
        if (o2 != null) {
            this.mergeAtoms(o1, o2);
            return;
        }
        String key = "anhydride pivot";
        this.addLocant(o1, key);
        acidM.fuse(acidM.cloneMolecule());
        for (MolAtom a : acidM.getAtomArray()) {
            if (!Anhyride.hasKeyword(a, key) || a == o1) continue;
            this.mergeAtoms(a, o1);
            return;
        }
    }
}

