/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;

public class HydrazoneStr
extends StructureToken {
    public static boolean isHydrazoneClass(String name) {
        return name.equals("hydrazone") || name.equals("semicarbazone") || name.equals("carbohydrazone");
    }

    public HydrazoneStr(String name, String struc) {
        super(name, struc);
    }

    @Override
    public void connect(Str substituent) {
        if (this.specialConnect(substituent)) {
            return;
        }
        super.connect(substituent);
    }

    private boolean specialConnect(Str substituent) {
        if (!substituent.isSpaceSeparated()) {
            return false;
        }
        Molecule subM = substituent.getMol();
        MolAtom al = this.getAldehydeOrOne(substituent);
        this.getMol().fuse(subM);
        MolAtom hydrazone2 = this.getMol().getAtom(0);
        this.mergeAtoms(al, hydrazone2);
        return true;
    }

    private MolAtom getAldehydeOrOne(Str substituent) {
        Suffix aldehyde = substituent.getSuffix("al");
        if (aldehyde == null) {
            aldehyde = substituent.getSuffix("aldehyde");
        }
        if (aldehyde != null) {
            return aldehyde.getMol().getAtom(1);
        }
        Suffix one = substituent.getSuffix("one");
        if (one != null) {
            return one.getMol().getAtom(0);
        }
        if (substituent.getName().endsWith("aldehyde")) {
            for (MolAtom c : substituent.getMol().getAtomArray()) {
                if (c.getAtno() != 6) continue;
                for (MolAtom o : c.getLigands()) {
                    if (o.getAtno() != 8 || c.getBondTo(o).getType() != 2) continue;
                    return o;
                }
            }
        }
        MolAtom res = null;
        for (MolAtom a : substituent.getParentMol().getAtomArray()) {
            if (a.getAtno() != 8 || a.getBondCount() != 1 || a.getBond(0).getType() != 2) continue;
            if (res == null) {
                res = a;
                continue;
            }
            res = null;
            break;
        }
        return res;
    }
}

