/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.LocantLexer;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.Token;
import chemaxon.naming.n2s.parse.Modifier;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import java.util.ArrayList;

public class Hydro
extends Token
implements Modifier<Str> {
    public static final int HYDRO = 0;
    public static final int DEHYDRO = 1;
    private int type;
    private LocantList locants;

    public Hydro(LocantList locants) {
        this.locants = locants;
        this.name = "H";
    }

    public Hydro(int locant) {
        this(locant, 0);
    }

    public Hydro(int locant, int parent) {
        this.locants = LocantList.simpleList(new SimpleLocant(locant, parent));
        this.name = "H";
    }

    public Hydro(String name, String hydroString) {
        if (name.equalsIgnoreCase("hydro")) {
            this.name = name;
            this.type = 0;
            this.locants = null;
        } else if (name.equalsIgnoreCase("dehydro")) {
            this.name = name;
            this.type = 1;
            this.locants = null;
        } else if (hydroString.endsWith("h") || hydroString.endsWith("H")) {
            this.name = "H";
            this.type = 0;
            String locant = hydroString.substring(0, hydroString.length() - 1);
            this.locants = LocantList.simpleList(LocantLexer.parseSimpleLocant(locant));
        }
    }

    public LocantList getLocants() {
        return this.locants;
    }

    public void setLocants(LocantList locants) {
        this.locants = locants;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(boolean isHydro) {
        this.type = isHydro ? 0 : 1;
    }

    @Override
    public String toString() {
        if (this.locants == null) {
            return this.name;
        }
        String loc = this.locants.toString();
        return loc.equals("0") ? this.name : loc + this.name;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public String getTypeInString() {
        switch (this.type) {
            case 0: {
                return "HYDRO";
            }
            case 1: {
                return "DEHYDRO";
            }
        }
        return "ERROR " + this.type;
    }

    public Hydro cloneToken() {
        Hydro h = new Hydro(this.name, "H");
        h.locants = this.locants;
        h.type = this.type;
        return h;
    }

    public SimpleLocant getLocant() {
        throw new RuntimeException();
    }

    public void setLocant(SimpleLocant locant) {
        throw new RuntimeException();
    }

    @Override
    public boolean apply(Str parent) {
        if (this.locants == null) {
            return false;
        }
        if (this.getType() == 1) {
            ArrayList<Locant> locants = this.getLocants().getLocantsList();
            if (locants.size() % 2 != 0) {
                throw new RuntimeException("Even locant list expected: " + this);
            }
            for (int i = 0; i < locants.size(); i += 2) {
                MolAtom a2;
                MolAtom a1 = parent.getAtom(locants.get(i));
                MolBond b = a1.getBondTo(a2 = parent.getAtom(locants.get(i + 1)));
                if (b.getType() != 1) {
                    throw new RuntimeException("Single bond expected: " + this);
                }
                b.setType(2);
            }
        } else {
            MolAtom[] atoms = parent.getAllAtoms(this.locants);
            this.hydrogenize(atoms, parent);
        }
        return true;
    }

    @Override
    public int priority() {
        return 0;
    }

    private void hydrogenize(MolAtom[] atoms, Str parent) {
        MolBond b;
        if (atoms.length == 2 && (b = atoms[0].getBondTo(atoms[1])) != null && b.getType() == 2) {
            b.setType(1);
            return;
        }
        for (MolAtom a : atoms) {
            parent.hydrogenize(a, 1);
        }
    }
}

