/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.StereoNumber;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.struc.MolAtom;

public abstract class Locant
implements Cloneable {
    protected int value = 0;
    protected int primes = 0;
    public static final Locant One = new SimpleLocant(1);
    public static final Locant OnePrime = new SimpleLocant(1, 1);
    public static final Locant Two = new SimpleLocant(2);
    public static final Locant N = AtomLocant.create('N');
    public static final Locant O = AtomLocant.create('O');
    public static final Locant S = AtomLocant.create('S');
    public static final Locant Beta = new SimpleLocant(0x7FFFFFFD);
    public static final Locant Per = new SimpleLocant(0){

        @Override
        public String toString() {
            return "per";
        }
    };
    public static final LocantList Pers = LocantList.simpleList(Per);

    public Locant clone() {
        try {
            return (Locant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    protected int getSortOrder() {
        throw new RuntimeException("Sorting not handled for this kind of locant");
    }

    public int getParent() {
        return this.primes;
    }

    public int getPrimes() {
        return this.primes;
    }

    public void setParent(int parent) {
        this.primes = parent;
    }

    public boolean isGreekLetter() {
        return false;
    }

    protected static int stringToInt(String string) {
        int value = 0;
        char[] chArr = string.toCharArray();
        for (int i = 0; i < chArr.length; ++i) {
            if (Character.isDigit(chArr[i])) {
                value *= 10;
                value += Character.getNumericValue(chArr[i]);
                continue;
            }
            if (!Character.isLowerCase(chArr[i])) continue;
            value *= 100;
            return value += chArr[i] - 97 + 1;
        }
        return value;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Locant oo = (Locant)o;
        return this.getValue() == oo.getValue() && this.getParent() == oo.getParent();
    }

    public int hashCode() {
        return 100 * this.value + this.primes;
    }

    public boolean isSimpleNumber() {
        return false;
    }

    boolean isCis() {
        return false;
    }

    boolean isTrans() {
        return false;
    }

    public boolean isOne() {
        return false;
    }

    public boolean isOrthoMetaPara() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isNumGreekLocant() {
        return false;
    }

    public int getSimpleValue() {
        if (!(this instanceof SimpleLocant)) {
            return -1;
        }
        return this.getValue();
    }

    public void removePrimes() {
        this.setParent(0);
    }

    public Locant getBasicLocant() {
        return this;
    }

    public String getBasicLocantString() {
        return this.getBasicLocant().toString();
    }

    public MolAtom getAtom(Str str) {
        return str.getLocantMap().get(this.getBasicLocantString());
    }

    public boolean applyToParent(Str str) {
        return false;
    }

    public void applyTo(MolAtom a) {
    }

    public int getUnmatchedAtno() {
        return -1;
    }

    public StereoNumber toStereoNumber() {
        return null;
    }
}

