/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.NameImportException;
import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.BondNumber;
import chemaxon.naming.n2s.lex.data.ComplexLocant;
import chemaxon.naming.n2s.lex.data.FusedLocant;
import chemaxon.naming.n2s.lex.data.IonNumber;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.RingNumber;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.SpecialLocant;
import chemaxon.naming.n2s.lex.data.StereoNumber;
import chemaxon.naming.n2s.lex.data.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LocantList
extends Token {
    public static final int NOT_SET = -1;
    public static final int RING_NUMBERING = 0;
    public static final int BOND_NUMBERING = 1;
    public static final int SIMPLE_LOCANTS = 12;
    public static final int COMPLEX_LOCANTS = 3;
    public static final int ION_NUMBERING = 4;
    public static final int FUSED_LOCANTS = 5;
    private int type = -1;
    private ArrayList<Locant> locantList = new ArrayList();
    boolean isOrthoMetaPara = false;

    public boolean isStereo() {
        return this.getLocant(0) instanceof StereoNumber;
    }

    public boolean isStereoDL() {
        return this.isStereo() && ((StereoNumber)this.getLocant(0)).isDLconfiguration();
    }

    public boolean isGreek() {
        SimpleLocant l = this.getSimpleLocant();
        return l != null && l.isGreekLetter();
    }

    public boolean isOrthoMetaPara() {
        return this.isOrthoMetaPara;
    }

    public LocantList expandOMP(int expectedSize) {
        if (expectedSize != 2) {
            return this;
        }
        if (this.isOrthoMetaPara() && this.size() == 1) {
            LocantList res = this.clone();
            res.locantList.add(0, new SimpleLocant(1));
            return res;
        }
        return this;
    }

    public LocantList() {
        super("[LocantList]");
    }

    @Override
    public LocantList clone() {
        LocantList res = new LocantList();
        res.tryAddLocant(this);
        return res;
    }

    public boolean hasLocant() {
        return this.locantList.size() > 0;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public ArrayList<Locant> getLocantsList() {
        return this.locantList;
    }

    public Locant getLocant(int index) {
        if (this.locantList.size() > index) {
            return this.locantList.get(index);
        }
        return null;
    }

    public Locant removeLocant(int index) {
        if (this.locantList.size() > index) {
            if (this.locantList.size() == 1) {
                this.type = -1;
            }
            return this.locantList.remove(index);
        }
        return null;
    }

    public void addLocant(Locant locant) {
        StereoNumber sn;
        this.setOrthoMetaPara(locant);
        if (this.getType() == 1 && locant instanceof SimpleLocant) {
            locant = new BondNumber((SimpleLocant)locant);
        }
        if (this.getType() == 12 && locant instanceof BondNumber) {
            this.type = 1;
            ArrayList<Locant> oldList = this.locantList;
            this.locantList = new ArrayList();
            for (Locant old : oldList) {
                this.locantList.add(new BondNumber((SimpleLocant)old));
            }
        }
        if (this.getType() == 12 && this.isStereo() && (sn = locant.toStereoNumber()) != null) {
            locant = sn;
        }
        if (this.locantList.size() == 1 && locant instanceof StereoNumber && this.locantList.get(0) instanceof SimpleLocant) {
            StereoNumber stereo = (StereoNumber)locant;
            SimpleLocant prev = (SimpleLocant)this.locantList.get(0);
            ComplexLocant complex = new ComplexLocant(prev, (SimpleLocant)stereo.getLocant());
            this.locantList.clear();
            if (stereo.getStereoData() == 1 || stereo.getStereoData() == 2) {
                throw new RuntimeException("Unsupported endo/exo case");
            }
            locant = new StereoNumber(complex, stereo.getStereoData());
        }
        if (!this.tryAddLocant(locant)) {
            throw new NameImportException("Invalid locant: " + locant);
        }
    }

    public boolean tryAddLocant(Locant locant) {
        int type = LocantList.getLocantType(locant);
        this.setOrthoMetaPara(locant);
        if (this.type == -1) {
            this.type = type;
        }
        if (this.type == -1 || this.type != type) {
            return false;
        }
        this.locantList.add(locant);
        return true;
    }

    public boolean tryAddLocant(LocantList list) {
        if (list == null) {
            return true;
        }
        if (this.locantList.isEmpty()) {
            this.isOrthoMetaPara = list.isOrthoMetaPara;
        }
        if (this.type == -1) {
            this.type = list.type;
        }
        if (this.type != list.type) {
            return false;
        }
        this.locantList.addAll(list.locantList);
        return true;
    }

    public void addFirstLocant(Locant locant) {
        this.locantList.add(0, locant);
    }

    private void setOrthoMetaPara(Locant locant) {
        if (this.locantList.isEmpty() && locant instanceof SimpleLocant) {
            this.isOrthoMetaPara = ((SimpleLocant)locant).isOrthoMetaPara();
        }
    }

    public void setParentIndex(int parentIndex) {
        for (int i = 0; i < this.locantList.size(); ++i) {
            this.locantList.get(i).setParent(parentIndex);
        }
    }

    private static int getLocantType(Locant locant) {
        if (locant.getClass() == FusedLocant.class) {
            return 5;
        }
        if (locant.getClass() == RingNumber.class) {
            return 0;
        }
        if (locant.getClass() == BondNumber.class) {
            return 1;
        }
        if (locant instanceof SimpleLocant || locant instanceof AtomLocant || locant instanceof SpecialLocant || locant instanceof StereoNumber) {
            return 12;
        }
        if (locant.getClass() == ComplexLocant.class) {
            return 3;
        }
        if (locant.getClass() == IonNumber.class) {
            return 4;
        }
        return -1;
    }

    public int size() {
        return this.locantList == null ? 0 : this.locantList.size();
    }

    @Override
    public String toString() {
        String stringValue = "";
        char separator = ',';
        switch (this.type) {
            case -1: {
                return "";
            }
            case 0: {
                separator = '.';
                break;
            }
            case 1: 
            case 12: {
                separator = ',';
                break;
            }
            case 3: {
                separator = ':';
            }
        }
        for (int i = 0; i < this.locantList.size(); ++i) {
            if (i > 0) {
                stringValue = stringValue + separator;
            }
            stringValue = stringValue + this.locantList.get(i).toString();
        }
        if (separator == '.') {
            stringValue = "[" + stringValue + "]";
        }
        if (this.size() > 0 && this.getLocant(0) instanceof StereoNumber) {
            stringValue = "(" + stringValue + ")";
        }
        return stringValue;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public String getTypeInString() {
        switch (this.type) {
            case -1: {
                return "NOT_SET";
            }
            case 0: {
                return "RING_NUMBERING";
            }
            case 1: {
                return "BOND_NUMBERING";
            }
            case 12: {
                return "SIMPLE_LOCANTS";
            }
            case 3: {
                return "COMPLEX_LOCANTS";
            }
            case 4: {
                return "ION_NUMBERING";
            }
            case 5: {
                return "FUSED_LOCANTS";
            }
        }
        return "ERROR " + this.type;
    }

    public boolean contains(Locant locant) {
        return this.locantList.contains(locant);
    }

    public boolean containsAll(LocantList locantList) {
        return this.locantList.containsAll(locantList.locantList);
    }

    public boolean isBeta() {
        if (this.type != 12 || this.size() != 1) {
            return false;
        }
        return this.getLocant(0).getValue() == 0x7FFFFFFD;
    }

    public boolean hasCis() {
        for (Locant l : this.locantList) {
            if (!l.isCis()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTrans() {
        for (Locant l : this.locantList) {
            if (!l.isTrans()) continue;
            return true;
        }
        return false;
    }

    public boolean isSingleLocant() {
        return this.locantList.size() == 1 && !this.isOrthoMetaPara;
    }

    public int getSimpleLocantValue() {
        SimpleLocant l = this.getSimpleLocant();
        if (l != null) {
            return l.getValue();
        }
        return -42;
    }

    public Locant getSingleLocant() {
        if (this.locantList.size() != 1) {
            return null;
        }
        Locant l = this.locantList.get(0);
        return l;
    }

    public SimpleLocant getSimpleLocant() {
        Locant l = this.getSingleLocant();
        if (l instanceof SimpleLocant) {
            return (SimpleLocant)l;
        }
        return null;
    }

    public static LocantList create(Locant ... locants) {
        LocantList res = new LocantList();
        for (Locant locant : locants) {
            res.tryAddLocant(locant);
        }
        return res;
    }

    public static LocantList simpleList(int ... locants) {
        LocantList res = new LocantList();
        for (int locant : locants) {
            res.tryAddLocant(new SimpleLocant(locant));
        }
        return res;
    }

    public static LocantList simpleList(Locant l) {
        LocantList res = new LocantList();
        res.tryAddLocant(l);
        return res;
    }

    public boolean isAllNumGreek() {
        for (Locant l : this.locantList) {
            if (l.isNumGreekLocant()) continue;
            return false;
        }
        return true;
    }

    public static void sort(ArrayList<Locant> locants) {
        Collections.sort(locants, new Comparator<Locant>(){

            @Override
            public int compare(Locant o1, Locant o2) {
                int res = o1.getSortOrder() - o2.getSortOrder();
                return res;
            }
        });
    }

    public boolean is(Locant l) {
        return l.equals(this.getSingleLocant());
    }

    public void changeLastLocant(Locant locant) {
        this.locantList.set(this.locantList.size() - 1, locant);
    }

    public boolean addLocantsToStereo(LocantList locants) {
        if (locants.size() != this.size()) {
            return false;
        }
        for (Locant l : this.getLocantsList()) {
            if (((StereoNumber)l).isEmpty()) continue;
            return false;
        }
        for (Locant l : locants.getLocantsList()) {
            if (l instanceof SimpleLocant) continue;
            return false;
        }
        int i = this.size();
        while (--i >= 0) {
            StereoNumber s = (StereoNumber)this.getLocant(i);
            this.locantList.set(i, s.withLocant((SimpleLocant)locants.getLocant(i)));
        }
        return true;
    }
}

