/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.struc.MolAtom;
import java.util.HashSet;

public class MarkushStr
extends StructureToken {
    private static final HashSet<String> markushNames = new HashSet();
    private LocantList rangeLocants = new LocantList();
    static final String TEXTNOTES = "TEXTNOTES";

    public static boolean isMarkush(String name) {
        return markushNames.contains(name);
    }

    public MarkushStr(String name, String struc) {
        super(name, struc);
        markushNames.add(name);
        N2S.getState().generic = true;
    }

    @Override
    public boolean isMarkush() {
        return true;
    }

    @Override
    public boolean consume(LocantList locants, int mul) {
        if (mul != -1) {
            return false;
        }
        for (Locant l : locants.getLocantsList()) {
            if (!(l instanceof AtomLocant)) {
                return false;
            }
            AtomLocant al = (AtomLocant)l;
            if (al.getAtno() != 6) {
                return false;
            }
            if (al.getLocantIndex() > 0) continue;
            return false;
        }
        this.rangeLocants.tryAddLocant(locants);
        return true;
    }

    @Override
    public void generate() {
        super.generate();
        if (this.rangeLocants.size() == 0) {
            return;
        }
        if (this.rangeLocants.size() == 2) {
            AtomLocant l0 = (AtomLocant)this.rangeLocants.getLocant(0);
            AtomLocant l1 = (AtomLocant)this.rangeLocants.getLocant(1);
            MolAtom a = this.getMol().getAtom(0);
            a.putProperty(TEXTNOTES, "C" + l1.getLocantIndex() + "-" + l0.getLocantIndex());
            return;
        }
        throw new RuntimeException("Unexpected number of range locants in " + this);
    }

    @Override
    public String toString() {
        if (this.rangeLocants.hasLocant()) {
            return "[" + this.rangeLocants + "]" + super.toString();
        }
        return super.toString();
    }
}

