/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.naming.n2s.lex.data;

import chemaxon.naming.n2s.lex.data.AtomLocant;
import chemaxon.naming.n2s.lex.data.Locant;
import chemaxon.naming.n2s.lex.data.LocantList;
import chemaxon.naming.n2s.lex.data.SimpleLocant;
import chemaxon.naming.n2s.lex.data.Str;
import chemaxon.naming.n2s.lex.data.StructureToken;
import chemaxon.naming.n2s.parse.Suffix;
import chemaxon.struc.MolAtom;
import java.util.ArrayList;

public class Nucleoside
extends StructureToken {
    Nucleoside(String name, String struc) {
        super(name, struc);
    }

    @Override
    public void generate() {
        this.addHydroxyGroups();
        super.generate();
    }

    protected void addHydroxyGroups() {
        String structureOH = "O |$1$|";
        if (!this.is("thymidine")) {
            StructureToken oxy1 = new StructureToken("hydroxy", "O |$1$|");
            oxy1.setLocantInParent(new SimpleLocant(2, 1));
            this.addHydroxyGroup(oxy1);
        }
        StructureToken oxy2 = new StructureToken("hydroxy", "O |$1$|");
        oxy2.setLocantInParent(new SimpleLocant(3, 1));
        this.addHydroxyGroup(oxy2);
        StructureToken oxy3 = new StructureToken("hydroxy", "O |$1$|");
        oxy3.setLocantInParent(new SimpleLocant(5, 1));
        this.addHydroxyGroup(oxy3);
    }

    protected void addHydroxyGroup(StructureToken oxy) {
        if (this.ignoredBySuffix(oxy)) {
            return;
        }
        ArrayList<Str> addToOxy = new ArrayList<Str>();
        Locant locant = oxy.locantInParent.getLocant(0);
        for (int i = 0; i < this.substituentCount(); ++i) {
            Str s = (Str)this.substituents.get(i);
            if (!this.refersTo(s.getLocantInParent(), locant)) continue;
            if (s.is("deoxy")) {
                if (s.substituents != null) {
                    throw new RuntimeException("TODO: use general deoxy");
                }
                this.removeSubstituent(i);
                return;
            }
            addToOxy.add(s);
        }
        while (!addToOxy.isEmpty()) {
            Str s = (Str)addToOxy.remove(0);
            if (s.isAcetate()) {
                this.setOxyToAttach(s);
            }
            oxy.addSubstituent(Locant.One, s);
            this.removeSubstituent(s);
        }
        this.addSubstituent(null, oxy, true);
    }

    private boolean refersTo(LocantList locant, Locant to) {
        AtomLocant al;
        if (locant == null || locant.size() != 1) {
            return false;
        }
        Locant l = locant.getLocant(0);
        if (l instanceof SimpleLocant && l.getParent() == to.getParent() && l.getValue() == to.getValue()) {
            return true;
        }
        return l instanceof AtomLocant && (al = (AtomLocant)l).getLocantIndex() == to.getValue() && al.getParent() == to.getParent();
    }

    protected boolean ignoredBySuffix(StructureToken oxy) {
        Locant locant = oxy.locantInParent.getLocant(0);
        for (int i = 0; i < this.suffixCount(); ++i) {
            Locant l;
            Suffix s = this.getSuffix(i);
            if (!s.hasLocant() || !((l = s.getLocant().getLocant(0)) instanceof SimpleLocant) || l.getParent() != locant.getParent() || l.getValue() != locant.getValue()) continue;
            if (s.getType() == 4) {
                return true;
            }
            if (s.getType() != 2 || !this.isSubstituent()) continue;
            return true;
        }
        return false;
    }

    private void setOxyToAttach(Str s) {
        MolAtom a = s.getEsterificationPoint();
        if (a == null || s.spaceSeparated) {
            return;
        }
        s.removeEsterificationPoint(a);
        s.getParentMol().removeAtom(a);
    }
}

